/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.air;

import com.adobe.air.ADTOutputStream;
import com.adobe.air.AIROutputStream;
import com.adobe.air.AIRPackager;
import com.adobe.air.ApplicationDescriptor;
import com.adobe.air.InvalidInputException;
import com.adobe.air.Utils;
import com.adobe.pki.Base64;
import com.adobe.ucf.ISigner;
import com.adobe.ucf.UCF;
import com.adobe.ucf.UCFSigner;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.text.MessageFormat;
import java.util.Date;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class AIRMigrationSigner
implements ISigner {
    private static String Adobe_patent_P851 = "AdobePatentId=\"P851\"";
    private static final int GRACE_PERIOD_DAYS = 365;
    private Certificate m_cert;
    private Certificate[] m_certChain;
    private File m_input;
    private File m_output;
    private ADTOutputStream m_stream = new AIROutputStream();
    private UCFSigner m_codeSigner = new UCFSigner();
    private PrivateKey m_key;
    private String m_timeStampURL;

    public void setInput(File input) {
        this.m_input = input;
    }

    public void setOutput(File output) {
        this.m_output = output;
    }

    public void setPrivateKey(PrivateKey key) {
        this.m_key = key;
        this.m_codeSigner.setPrivateKey(key);
        this.setTimestampURL("https://timestamp.geotrust.com/tsa");
    }

    public void setCertificateChain(Certificate[] certchain) throws CertificateException {
        this.m_certChain = certchain;
    }

    public void setSignerCertificate(Certificate cert) throws CertificateException {
        this.m_cert = cert;
    }

    public void setAlsoIncludeOldStyleTimestamp() {
        throw new UnsupportedOperationException("setAlsoIncludeOldStyleTimestamp() not supported");
    }

    public void setTimestampURL(String url) {
        this.m_timeStampURL = url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sign(ApplicationDescriptor.ValidationParams validationParams) throws IOException, InvalidInputException, GeneralSecurityException {
        if (this.m_input == null) {
            throw new IllegalStateException("input not set");
        }
        if (this.m_output == null) {
            throw new IllegalStateException("output not set");
        }
        File tmp = File.createTempFile("air", null, this.m_output.getAbsoluteFile().getParentFile());
        try {
            this.m_stream.setValidationParams(validationParams);
            this.m_stream.setOutput(tmp);
            String mimetype = Utils.getMimetype(this.m_input);
            if (mimetype == null) {
                throw new InvalidInputException("File " + this.m_input.getPath() + " is invalid");
            }
            if (!mimetype.equals("application/vnd.adobe.air-application-installer-package+zip") && !mimetype.equals("application/vnd.adobe.air-native-application-installer-package+zip")) {
                throw new InvalidInputException("File " + this.m_input.getPath() + " has an invalid mimetype for migration: " + mimetype);
            }
            this.m_stream.addMimeTypeFile(mimetype, true);
            ZipFile iz = new ZipFile(this.m_input);
            this.m_stream.addAIRFile(iz, mimetype);
            InputStream is = iz.getInputStream(this.m_stream.getSignatureEntry());
            if (this.m_stream.getApplicationDescriptor().migrationGracePeriodInEffect()) {
                this.m_codeSigner.setGracePeriodDays(365);
            }
            this.m_codeSigner.setSignerCertificate(this.m_cert);
            this.m_codeSigner.setCertificateChain(this.m_certChain);
            this.processPackageSignature(this.m_stream.getSignatureEntry(), is);
            is.close();
            iz.close();
            this.m_stream.close();
            boolean deleted = !this.m_output.exists() || this.m_output.delete();
            boolean renamed = tmp.renameTo(this.m_output);
            if (!deleted || !renamed) {
                throw new IOException("Temp File " + tmp.getPath() + " could not be renamed as " + this.m_output.getPath());
            }
        }
        finally {
            if (tmp.exists()) {
                tmp.delete();
            }
        }
    }

    public void sign() throws IOException, InvalidInputException, GeneralSecurityException {
        this.sign(AIRPackager.AIR_VALIDATION_PARAMS);
    }

    private void processPackageSignature(ZipEntry entry, InputStream is) throws IOException, InvalidInputException, GeneralSecurityException {
        if (this.m_key == null) {
            throw new IllegalStateException("private key must be set before calling sign()");
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Document signatures = null;
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder builder = documentBuilderFactory.newDocumentBuilder();
            signatures = builder.parse(is);
        }
        catch (Exception ex) {
            throw new InvalidInputException("could not parse signatures.xml");
        }
        NodeList signatureElements = signatures.getElementsByTagName("Signature");
        Element packageSignatureElement = null;
        Node packageSignatureValue = null;
        for (int i2 = 0; i2 < signatureElements.getLength(); ++i2) {
            Element signature = (Element)signatureElements.item(i2);
            if (signature.getAttribute("Id").equals("PackageSignature")) {
                packageSignatureElement = signature;
                packageSignatureValue = (Element)signature.getElementsByTagName("SignatureValue").item(0);
            }
            if (!signature.getAttribute("Id").equals("MigrationSignature")) continue;
            throw new InvalidInputException("input already has a MigrationSignature");
        }
        if (packageSignatureValue == null) {
            throw new InvalidInputException("PackageSignature not found");
        }
        NamedNodeMap attrs = packageSignatureValue.getAttributes();
        if (attrs.getLength() != 1) {
            throw new InvalidInputException("package signature value has unexpected attributes");
        }
        NodeList nodes = packageSignatureValue.getChildNodes();
        String psvContent = null;
        for (int i3 = 0; i3 < nodes.getLength(); ++i3) {
            if (nodes.item(i3).getNodeType() != 3) continue;
            psvContent = nodes.item(i3).getNodeValue();
            break;
        }
        if (psvContent == null) {
            throw new InvalidInputException("package signature value is empty");
        }
        MessageFormat psvMF = new MessageFormat("<SignatureValue xmlns=\"http://www.w3.org/2000/09/xmldsig#\" Id=\"PackageSignatureValue\">{0}</SignatureValue>");
        String cnPSV = psvMF.format(new Object[]{psvContent});
        MessageDigest digest = MessageDigest.getInstance("SHA-256");
        byte[] psvDigest = digest.digest(cnPSV.getBytes("UTF-8"));
        String signedInfoTemplate = UCF.stringFromInputStream(this.getClass().getResourceAsStream("MigrationSignedInfo.template"));
        String signedInfo = new MessageFormat(signedInfoTemplate).format(new Object[]{Base64.encodeBytes(psvDigest)});
        Signature signature = Signature.getInstance("SHA1withRSA");
        signature.initSign(this.m_key);
        signature.update(signedInfo.getBytes("UTF-8"));
        byte[] manifestSignatureValue = signature.sign();
        String timeStamp = null;
        if (this.m_timeStampURL != null) {
            String canonicalMigrationSV = "<SignatureValue xmlns=\"http://www.w3.org/2000/09/xmldsig#\" Id=\"MigrationSignatureValue\">" + Base64.encodeBytes(manifestSignatureValue) + "</SignatureValue>";
            byte[] rawTimeStamp = this.m_codeSigner.getTimeStampFromURL(canonicalMigrationSV.getBytes("UTF-8"), this.m_timeStampURL);
            String timeStampTemplate = UCF.stringFromInputStream(this.m_codeSigner.getClass().getResourceAsStream("timestamp.template"));
            Object[] substitutions = new Object[]{"#MigrationSignatureValue", Base64.encodeBytes(rawTimeStamp)};
            timeStamp = new MessageFormat(timeStampTemplate).format(substitutions);
        }
        String template = UCF.stringFromInputStream(this.getClass().getResourceAsStream("MigrationSignature.template"));
        String migrationSignature = new MessageFormat(template).format(new Object[]{Base64.encodeBytes(psvDigest), Base64.encodeBytes(manifestSignatureValue), this.m_codeSigner.getXMLKeyInfo(), timeStamp == null ? "" : timeStamp});
        try {
            Transformer t2 = TransformerFactory.newInstance().newTransformer();
            t2.setOutputProperty("omit-xml-declaration", "yes");
            t2.setOutputProperty("indent", "yes");
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder builder = documentBuilderFactory.newDocumentBuilder();
            Document migrationSignatureDocument = builder.parse(new InputSource(new StringReader(migrationSignature)));
            signatures.getDocumentElement().insertBefore(signatures.importNode(migrationSignatureDocument.getDocumentElement(), true), packageSignatureElement);
            t2.transform(new DOMSource(signatures), new StreamResult(baos));
        }
        catch (Exception ex) {
            throw new IOException(ex.getMessage());
        }
        this.m_stream.addData(baos.toByteArray(), "META-INF/signatures.xml", new Date(), false, true);
    }
}

