/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.air;

import com.adobe.air.ADTDeviceOperations;
import com.adobe.air.ADTException;
import com.adobe.air.ADTPackager;
import com.adobe.air.AIRMigrationSigner;
import com.adobe.air.AIRNPackager;
import com.adobe.air.AIRPackager;
import com.adobe.air.ANEPackager;
import com.adobe.air.ApplicationPackager;
import com.adobe.air.CertificateCreationException;
import com.adobe.air.CertificateCreator;
import com.adobe.air.InvalidInputException;
import com.adobe.air.SDK;
import com.adobe.air.SDKDamagedException;
import com.adobe.air.Utils;
import com.adobe.air.android.AndroidDeviceOperations;
import com.adobe.air.android.AndroidDeviceSDK;
import com.adobe.air.apk.APKPackager;
import com.adobe.air.ios.IOSDeviceOperations;
import com.adobe.air.ios.IOSSimulatorOperations;
import com.adobe.air.ipa.IPAPackager;
import com.adobe.air.nai.AppBundlePackager;
import com.adobe.air.nai.DEBPackager;
import com.adobe.air.nai.DMGPackager;
import com.adobe.air.nai.EXEPackager;
import com.adobe.air.nai.NativePackager;
import com.adobe.air.nai.RPMPackager;
import com.adobe.air.nai.WinBundlePackager;
import com.adobe.air.validator.DescriptorValidationException;
import com.adobe.argv.Arguments;
import com.adobe.argv.UsageError;
import com.adobe.pki.TimestampException;
import com.adobe.ucf.ISigner;
import com.adobe.ucf.UCF;
import com.adobe.ucf.Utils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class ADT
extends UCF {
    public static final String DEFAULT_TSA_URL = "https://timestamp.geotrust.com/tsa";
    public static final String MIMETYPE_AIR = "application/vnd.adobe.air-application-installer-package+zip";
    public static final String MIMETYPE_AIRI = "application/vnd.adobe.air-application-intermediate-package+zip";
    public static final String MIMETYPE_ANE = "application/vnd.adobe.air-native-extension-package+zip";
    public static final String MIMETYPE_AIRN = "application/vnd.adobe.air-native-application-installer-package+zip";
    public static final String PATH_APP_DESCRIPTOR = "META-INF/AIR/application.xml";
    public static final String PATH_HASH = "META-INF/AIR/hash";
    public static final String PATH_DEBUG = "META-INF/AIR/debug";
    public static final String PATH_AIR = "META-INF/AIR";
    public static final String PATH_ANE = "META-INF/ANE";
    public static final String PATH_EXTENSION_DESCRIPTOR = "META-INF/ANE/extension.xml";
    public static final String ARG_PLATFORM_SDK = "-platformsdk";
    public static final String ARG_PLATFORM_OPTIONS = "-platformoptions";
    private static final String ARG_PACKAGE = "-package";
    private static final String ARG_TARGET = "-target";
    private static final String ARG_VERSION = "-version";
    private static final String ARG_CONNECT = "-connect";
    private static final String ARG_EXTDIR = "-extdir";
    private static final String ARG_PLATFORM = "-platform";
    private static final String ARG_SWC = "-swc";
    public static final int ERROR_UNKNOWN = 5;
    public static final int ERROR_TIMESTAMP_GEN = 10;
    public static final int ERROR_CERTIFICATE_GEN = 11;
    public static final int ERROR_INVALID_INPUT = 12;
    public static final int ERROR_MISSING_DEVICE_SDK = 13;
    public static final int ERROR_DEVICE_ERROR = 14;
    public static final int ERROR_NO_DEVICES = 15;
    public static final int ERROR_MISSING_GPL_COMPONENTS = 16;
    public static final int ERROR_DEVICE_PACKAGING_TOOL_FAILED = 17;
    private static final String COPYRIGHT_VERSION_STRING = "Version {0}";
    private static final String FILE_EXT_AIR = "air";
    private static final String FILE_EXT_AIRI = "airi";
    private static final String FILE_EXT_AIRN = "airn";
    private static final String FILE_EXT_EXE = "exe";
    private static final String FILE_EXT_DMG = "dmg";
    private static final String FILE_EXT_RPM = "rpm";
    private static final String FILE_EXT_DEB = "deb";
    private static final String FILE_EXT_APK = "apk";
    private static final String FILE_EXT_ANE = "ane";
    private static final String FILE_EXT_IPA = "ipa";
    private static final String FILE_EXT_APP = "app";
    private static final String FILE_EXT_NONE = "";
    private static final String ARG_PREPARE = "-prepare";
    private static final String ARG_SIGN = "-sign";
    private static final String ARG_MIGRATE = "-migrate";
    private static final String ARG_CERT = "-certificate";
    private static final String ARG_CHECK_PASS = "-checkstore";
    private static final String ARG_NO_VALIDATE = "-Xnovalidate";
    private static final String ARG_NO_ANE_VALIDATE = "-XnoAneValidate";
    private static final String ARG_RUNTIME = "-Xruntime";
    private static final String ARG_ARCH = "-arch";
    private static final String ARG_LISTEN = "-listen";
    private static final String ARG_NATIVE = "native";
    private static final String ARG_BUNDLE = "bundle";
    private static final String ARG_SHELL = "-Xshell";
    private static final String ARG_AIR_DOWNLOAD_URL = "-airDownloadURL";
    private static final String ARG_SAMPLER = "-sampler";
    private static final String ARG_HIDE_ANE_SYMBOLS = "-hideAneLibSymbols";
    private static final String ARG_USE_LEGACY_AOT = "-useLegacyAOT";
    private static final String ARG_VALUE_YES = "yes";
    private static final String ARG_VALUE_NO = "no";
    public static final String ARG_INSTALLAPP = "-installApp";
    public static final String ARG_INSTALLRUNTIME = "-installRuntime";
    public static final String ARG_UNINSTALLAPP = "-uninstallApp";
    public static final String ARG_UNINSTALLRUNTIME = "-uninstallRuntime";
    public static final String ARG_LAUNCHAPP = "-launchApp";
    public static final String ARG_APPVERSION = "-appVersion";
    public static final String ARG_RUNTIMEVERSION = "-runtimeVersion";
    public static final String ARG_DEVICE = "-device";
    public static final String ARG_LISTDEVICES = "-devices";
    public static final String ARG_APPID = "-appid";
    public static final String ARG_PORT = "-debuggerPort";
    private static final String ARG_OPT_0 = "-XO0";
    private static final String ARG_OPT_1 = "-XO1";
    private static final String ARG_OPT_2 = "-XO2";
    private static final String ARG_OPT_3 = "-XO3";
    private static final String ARG_INLINE = "-Xinline";
    private static final String ARG_COMPRESSSWF = "-XcompressSWF";
    private static final String ARG_VERBOSE = "-Xverbose";
    private static final String ARG_NOSTRIP = "-Xnostrip";
    private static final String ARG_DEBUG_RUNTIME = "-Xdebugruntime";
    private static final String ARG_DEBUG_BUILTINS = "-Xdebugbuiltins";
    private static final String ARG_USE_INTERPRETER = "-Xuseinterpreter";
    private static final String ARG_AOT_SDK = "-Xsdk";
    private static final String ARG_AOT_SDKLOC = "-Xsdklocation";
    private static final String ARG_DRY_RUN = "-Xdryrun";
    private static final String ARG_RENDERING_DIAG = "-renderingdiagnostics";
    private static final String ARG_OUTPUT_DIR = "-Xoutput";
    public static final String ARG_LINKER = "-Xlinker";
    private static final String ARG_TIMEOUT = "-Xtimeout";
    private static final String ARG_DEBUG = "-Xdebug";
    private static final String ARG_ENABLE_SSC = "-XenableSSC";
    private static final String ARG_SPLITLIMIT = "-Xmodulesplitlimit";
    private static final String ARG_POOLSIZE = "-Xpoolsize";
    private static final String ARG_32 = "-X32";
    private static final String ARG_AOT_XSS = "-XstackSize";
    private static final String ARG_AOT_PERFLOG = "-Xaotperflog";
    private static final String ARG_GENERATE_DSYM = "-XgenDSYM";
    private static final String ARG_XPLATFORM_SDK = "-Xplatformsdk";
    private static final String ARG_PROVISIONING_PROFILE = "-provisioning-profile";
    private static String Adobe_patent_P817 = "AdobePatentId=\"P817\"";
    private static String Adobe_patent_P851 = "AdobePatentId=\"P851\"";
    private Target m_target;
    private String m_arch = "armv7";
    private String m_targetValue;
    private boolean m_NEApp = false;
    private CertificateCreator m_creator;
    private boolean m_signingApp = false;
    private int m_exitCode = 0;
    private boolean m_debug;
    private ADTPackager m_packager;
    private String[] m_argv;
    private String m_targetSDK = null;
    private File m_output = new File(".");

    private void relaunchForIPAIfNecessary(String[] args) {
        boolean needXmsFlag = true;
        boolean needXmxFlag = true;
        boolean need32BitFlag = false;
        boolean force32Bit = false;
        boolean is64BitJVM = System.getProperty("java.vm.name").contains("64");
        if (is64BitJVM) {
            for (int i2 = 0; i2 < args.length; ++i2) {
                if (!args[i2].equals(ARG_32)) continue;
                force32Bit = true;
                break;
            }
            if (force32Bit) {
                if (System.getProperty("os.name").indexOf("Mac") != -1) {
                    need32BitFlag = true;
                } else {
                    System.err.println("ADT does not support -X32 flag for this JVM");
                    System.exit(5);
                }
            }
        }
        for (String vmArg : ManagementFactory.getRuntimeMXBean().getInputArguments()) {
            if (vmArg.startsWith("-Xms")) {
                needXmsFlag = false;
            }
            if (!vmArg.startsWith("-Xmx")) continue;
            needXmxFlag = false;
        }
        if (needXmsFlag || needXmxFlag || need32BitFlag) {
            ArrayList<String> newArgs = new ArrayList<String>();
            newArgs.add("java");
            if (this.getIPAPackager().getVerbose() > 1) {
                newArgs.add("-ea");
            }
            long minHeap = 32L;
            long maxHeap = 32L;
            if (needXmxFlag) {
                if (!need32BitFlag && is64BitJVM) {
                    maxHeap = 1024L;
                }
            } else {
                maxHeap = Runtime.getRuntime().maxMemory();
                maxHeap /= 0x100000L;
            }
            if (need32BitFlag) {
                newArgs.add("-d32");
            }
            if (maxHeap < minHeap) {
                maxHeap = minHeap;
            }
            if (this.getIPAPackager().getVerbose() > 0) {
                System.out.println("min, max heap = " + minHeap + " , " + maxHeap);
            }
            newArgs.addAll(Arrays.asList("-Xms" + minHeap + "m", "-Xmx" + maxHeap + "m", "-jar"));
            try {
                String jarFile = Utils.getJarFile().getAbsolutePath();
                if (!jarFile.endsWith("jar")) {
                    String errorText = "Unable to locate ADT.jar, must relaunch with -Xms32m -Xmx32m";
                    System.err.println(errorText);
                    System.exit(5);
                }
                newArgs.add(jarFile);
            }
            catch (IOException e2) {
                System.err.println("Error while reinvoking");
                e2.printStackTrace();
                System.exit(5);
            }
            newArgs.addAll(Arrays.asList(args));
            try {
                Process child = Utils.execSafely(null, newArgs);
                new Utils.OutputEater(child.getInputStream(), new PasswordScanningOutputStream(System.out, child.getOutputStream())).start();
                new Utils.OutputEater(child.getErrorStream(), System.err).start();
                try {
                    child.waitFor();
                }
                catch (InterruptedException e3) {
                    System.err.println("Error while reinvoking");
                    e3.printStackTrace();
                    System.exit(5);
                }
                System.exit(child.exitValue());
            }
            catch (IOException e4) {
                System.err.println("Error while reinvoking");
                e4.printStackTrace();
                System.exit(5);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int run(String[] argv) {
        this.m_argv = argv;
        this.args = new Arguments(argv);
        try {
            this.parseArgsAndGo();
        }
        catch (UsageError e2) {
            System.err.println(e2.getMessage());
            this.printUsage();
            this.m_exitCode = e2.getExitCode();
        }
        catch (CertificateNotYetValidException e3) {
            System.err.println(e3.getMessage());
            this.m_exitCode = 8;
        }
        catch (CertificateExpiredException e4) {
            System.err.println(e4.getMessage());
            this.m_exitCode = 8;
        }
        catch (GeneralSecurityException e5) {
            System.err.println(e5.getMessage());
            this.m_exitCode = 9;
        }
        catch (TimestampException e6) {
            System.err.println(e6.getMessage());
            this.m_exitCode = 10;
        }
        catch (CertificateCreationException e7) {
            System.err.println(e7.getMessage());
            this.m_exitCode = 11;
        }
        catch (SDKDamagedException e8) {
            System.err.println(e8.getMessage());
            this.m_exitCode = e8.getExitCode();
        }
        catch (DescriptorValidationException e9) {
            System.out.println(e9.getMessage());
            this.m_exitCode = 12;
        }
        catch (InvalidInputException e10) {
            System.err.println(e10.getMessage());
            this.m_exitCode = 12;
        }
        catch (ADTException e11) {
            System.err.println(e11.getMessage());
            this.m_exitCode = e11.getExitCode();
        }
        catch (Exception e12) {
            System.err.println("unexpected failure: " + e12.getMessage());
            e12.printStackTrace();
            this.m_exitCode = 5;
        }
        finally {
            if (this.m_packager != null) {
                this.m_packager.close();
            }
        }
        return this.m_exitCode;
    }

    public static void main(String[] args) {
        ADT adt = new ADT();
        int result = adt.run(args);
        System.exit(result);
    }

    public String getExecutableName() {
        return "adt";
    }

    protected void printUsage() {
        System.err.println("usage:");
        System.err.println("  adt -checkstore SIGNING_OPTIONS");
        System.err.println("  adt -certificate -cn <name> ( -ou <org-unit> )? ( -o <org-name> )? ( -c <country> )? ( -validityPeriod <years> )? 2048-RSA <pfx-file> <password>");
        System.err.println("  adt -help");
        System.err.println("  adt -migrate SIGNING_OPTIONS ( <air-file-in> | <airn-file-in> ) <output-file>");
        System.err.println("  adt -package SIGNING_OPTIONS ( -target air )? <output-package> ( <app-desc> FILE_OPTIONS | <input-package> )");
        System.err.println("  adt -package SIGNING_OPTIONS -target airn <output-package> ( <app-desc> FILE-AND-PATH-OPTIONS | <input-package> )");
        System.err.println("  adt -package -target ( apk | apk-debug | apk-emulator | apk-captive-runtime ) ( CONNECT_OPTIONS? | LISTEN_OPTIONS? ) ( -airDownloadURL <url> )? ( ARCH_OPTIONS )? SIGNING_OPTIONS <output-package> ( <app-desc> PLATFORM-SDK-OPTION? FILE-AND-PATH-OPTIONS | <input-package> PLATFORM-SDK-OPTION? )");
        System.err.println("  adt -package -target ( ipa-test | ipa-debug | ipa-app-store | ipa-ad-hoc | ipa-test-interpreter | ipa-debug-interpreter | ipa-test-interpreter-simulator | ipa-debug-interpreter-simulator ) ( CONNECT_OPTIONS? | LISTEN_OPTIONS? ) ( -sampler )? ANE_LINK_OPTIONS? AOT_MODE_OPTIONS? SIGNING_OPTIONS <output-package> ( <app-desc> PLATFORM-SDK-OPTION? FILE-AND-PATH-OPTIONS | <input-package> PLATFORM-SDK-OPTION? )");
        System.err.println("  adt -package SIGNING_OPTIONS? -target native SIGNING_OPTIONS? <output-package> ( <app-desc> FILE-AND-PATH-OPTIONS | <input-package> )");
        System.err.println("  adt -package SIGNING_OPTIONS? -migrate SIGNING_OPTIONS -target native SIGNING_OPTIONS? <output-package> <app-desc> FILE_OPTIONS PATH-OPTION");
        System.err.println("  adt -package SIGNING_OPTIONS? -target bundle SIGNING_OPTIONS? <output-package> ( <app-desc> FILE-AND-PATH-OPTIONS | <input-package> )");
        System.err.println("  adt -package SIGNING_OPTIONS? -target ane <output-package> <ext-desc> ANE_OPTIONS");
        System.err.println("  adt -prepare <airi-file> <app-desc> FILE_AND_PATH_OPTIONS");
        System.err.println("  adt -sign SIGNING_OPTIONS ( -target ( air | airn | ane ) )? ( <airi-file> | <unsigned-ane-file> ) <output-file>");
        System.err.println("  adt -devices          PLATFORM-OPTION PLATFORM-SDK-OPTION? ");
        System.err.println("  adt -installRuntime   PLATFORM-OPTION PLATFORM-SDK-OPTION? DEVICE-OPTION? ( -package <apk-file> )?");
        System.err.println("  adt -installApp       PLATFORM-OPTION PLATFORM-SDK-OPTION? DEVICE-OPTION? -package <apk-file | ipa-file>");
        System.err.println("  adt -uninstallRuntime PLATFORM-OPTION PLATFORM-SDK-OPTION? DEVICE-OPTION?");
        System.err.println("  adt -uninstallApp     PLATFORM-OPTION PLATFORM-SDK-OPTION? DEVICE-OPTION? -appid <app-id>");
        System.err.println("  adt -launchApp        { PLATFORM-OPTION PLATFORM-SDK-OPTION? DEVICE-OPTION? ( -debuggerPort port )? -appid <app-id> }");
        System.err.println("  adt -runtimeVersion   PLATFORM-OPTION PLATFORM-SDK-OPTION? DEVICE-OPTION?");
        System.err.println("  adt -appVersion       PLATFORM-OPTION PLATFORM-SDK-OPTION? DEVICE-OPTION? -appid <app-id>");
        System.err.println("  adt -version");
        System.err.println();
        System.err.println("SIGNING_OPTIONS      : -storetype <type> ( -keystore <store> )? ( -storepass <pass> )? ( -alias <aliasName> )? ( -keypass <pass> )? ( -providerName <name> )? ( -tsa <url> )? ( -provisioning-profile <profile> )?");
        System.err.println("FILE_OPTIONS         : <fileOrDir>* ( ( -C <dir> <fileOrDir>+ ) | ( -e <file> <path> ) )*");
        System.err.println("ARCH_OPTIONS      \t  : -arch (armv7 | x86)");
        System.err.println("CONNECT_OPTIONS      : -connect <host>");
        System.err.println("LISTEN_OPTIONS       : -listen <port>");
        System.err.println("ANE_LINK_OPTIONS     : -hideAneLibSymbols ( yes | no )");
        System.err.println("ANE_OPTIONS          : -swc <swc> ( -platform <name> (-platformoptions <file>)? <fileOrDir>* ( -C <dir> <fileOrDir>+ )* )*");
        System.err.println("FILE-AND-PATH-OPTIONS: ( PATH-OPTION | FILE-OPTIONS ) FILE-AND-PATH-OPTIONS?");
        System.err.println("PATH-OPTION          : -extdir <dir>");
        System.err.println("PLATFORM-OPTION      : -platform (android | ios)");
        System.err.println("PLATFORM-SDK-OPTION  : -platformsdk <platform-sdk-home-dir>");
        System.err.println("DEVICE-OPTION        : -device ( deviceID | ios-simulator )");
        System.err.println("AOT_MODE_OPTIONS     : -useLegacyAOT ( yes | no )");
    }

    private void printCopyrightNotice() {
        MessageFormat mf = new MessageFormat(COPYRIGHT_VERSION_STRING);
        String version = mf.format(new Object[]{SDK.getVersion()});
        System.err.println("Adobe (R) AIR (R) Developer Tool (ADT)");
        System.err.println(version);
        System.err.println("Copyright (c) 2008-2015 Adobe Systems Incorporated. All rights reserved.\n");
    }

    private void parseVersion() throws UsageError {
        this.args.accept(ARG_VERSION);
        System.out.println(SDK.getVersion());
    }

    private void parseArgsAndGo() throws InvalidInputException, UsageError, GeneralSecurityException, IOException, SDKDamagedException {
        if (!this.args.peek()) {
            this.printCopyrightNotice();
            throw new UsageError("No arguments were found");
        }
        if (this.args.peek("-help")) {
            this.parseUsage();
        } else if (this.args.peek(ARG_PACKAGE)) {
            this.parsePackage();
            this.getPackager().createPackage();
        } else if (this.args.peek(ARG_VERSION)) {
            this.parseVersion();
        } else if (this.args.peek(ARG_PREPARE)) {
            this.parsePrepare();
            this.getPackager().createIntermediate();
        } else if (this.args.peek(ARG_SIGN)) {
            this.parseSign();
            this.getPackager().createPackage();
        } else if (this.args.peek(ARG_MIGRATE)) {
            this.parseMigrate();
        } else if (this.args.peek(ARG_CHECK_PASS)) {
            this.parseCheckPass();
        } else if (this.args.peek(ARG_CERT)) {
            this.m_creator = new CertificateCreator();
            this.parseCertificate();
            this.m_creator.create();
        } else if (this.args.acceptEquals(ARG_SHELL)) {
            this.m_target = Target.IPA;
            this.relaunchForIPAIfNecessary(this.m_argv);
            while (this.parseUndocumentedParam()) {
            }
            this.parseAOTModeOption();
            while (this.args.peek()) {
                this.getIPAPackager().addExtraABC(this.args.accept());
            }
            try {
                this.getIPAPackager().setPackageConfiguration("ipa-test");
                this.getIPAPackager().setOutput(this.m_output);
                this.getIPAPackager().compileShellApp();
            }
            catch (Exception e2) {
                System.err.println("compile failure: " + e2.getMessage());
                e2.printStackTrace();
            }
        } else if (!this.parsePlatformOperationArgs()) {
            throw new UsageError("unexpected argument " + this.args.accept());
        }
    }

    private void parseOutput(ISigner p2, String fileExtension) throws UsageError {
        try {
            p2.setOutput(Utils.getFileWithExtension(this.args.accept(), fileExtension));
        }
        catch (FileNotFoundException ex) {
            throw new UsageError("output directory is not writable", 6);
        }
        catch (IOException ex) {
            throw new UsageError("output file is not writable", 6);
        }
    }

    private void parsePackage() throws UsageError {
        this.m_target = Target.AIR;
        this.detectTarget();
        this.detectNEApp();
        this.args.accept(ARG_PACKAGE);
        this.parseUndocumentedParams();
        this.parseAppSigningOptions();
        this.parseNEAppMigrateOptions();
        this.parseTarget();
        boolean isConnect = this.parseConnectOptions();
        boolean isListen = this.parseListenOptions();
        this.parseSamplerEnabled();
        this.parseAneLinkOptions();
        this.parseAOTModeOption();
        this.parseAIRDownloadURLOption();
        if (isConnect && isListen) {
            throw new UsageError("-connect and -listen can't be used together.");
        }
        this.parseArchOptions();
        this.parseNativeSigningOptions();
        this.parseOutput(this.getPackager(), this.m_target.getFileExtension());
        this.parseInput();
    }

    private void detectTarget() throws UsageError {
        if (this.args.seek(ARG_TARGET)) {
            this.args.accept(ARG_TARGET);
            this.m_targetValue = this.args.accept();
            if ("apk-emulator".equals(this.m_targetValue)) {
                this.m_targetValue = FILE_EXT_APK;
            }
            this.m_target = Target.getTargetFromArg(this.m_targetValue);
            this.detectArch();
            if (this.m_target == Target.IPA) {
                this.relaunchForIPAIfNecessary(this.m_argv);
            }
            if (this.m_target == null || this.m_target == Target.AIRI) {
                throw new UsageError("Unknown package target " + this.m_targetValue);
            }
            if (this.m_target == Target.APK || this.m_target == Target.IPA) {
                this.getAppPackager().setPackageConfiguration(this.m_targetValue);
            }
            if (this.m_targetValue.equals("ipa-test-interpreter") || this.m_targetValue.equals("ipa-debug-interpreter") || this.m_targetValue.equals("ipa-test-interpreter-simulator") || this.m_targetValue.equals("ipa-debug-interpreter-simulator")) {
                this.getIPAPackager().setUseInterpreter(true);
            }
            if (this.m_targetValue.equals("ipa-test-interpreter-simulator") || this.m_targetValue.equals("ipa-debug-interpreter-simulator")) {
                this.getIPAPackager().setTarget("x86-simulator-air");
            }
        }
        this.args.reset();
    }

    private void detectNEApp() {
        this.m_NEApp = this.args.seek(ARG_EXTDIR);
        this.args.reset();
    }

    private boolean isXcodeVersionLessThanFive() {
        try {
            Process p2 = Runtime.getRuntime().exec("xcodebuild -version");
            p2.waitFor();
            BufferedReader reader = new BufferedReader(new InputStreamReader(p2.getInputStream()));
            String line = FILE_EXT_NONE;
            boolean flag = false;
            while ((line = reader.readLine()) != null) {
                if (!line.contains("Xcode")) continue;
                flag = true;
                break;
            }
            reader.close();
            if (flag) {
                Pattern versionPattern = Pattern.compile("\\d+\\.\\d+(\\.\\d+)?");
                Matcher m2 = versionPattern.matcher(line);
                if (m2.find()) {
                    String xcodeVersion = m2.group();
                    String[] majorVersion = xcodeVersion.split("\\.");
                    int xcodeMajorVersion = Integer.parseInt(majorVersion[0]);
                    return xcodeMajorVersion < 5;
                }
                return false;
            }
            return false;
        }
        catch (Exception e2) {
            return false;
        }
    }

    private boolean parsePlatformOperationArgs() throws InvalidInputException, UsageError, ADTException, FileNotFoundException, IOException, SDKDamagedException {
        File fpkg;
        if (!this.args.peek()) {
            return false;
        }
        String operation = this.args.next();
        if (!(operation.equals(ARG_INSTALLAPP) || operation.equals(ARG_INSTALLRUNTIME) || operation.equals(ARG_UNINSTALLAPP) || operation.equals(ARG_UNINSTALLRUNTIME) || operation.equals(ARG_LAUNCHAPP) || operation.equals(ARG_LISTDEVICES) || operation.equals(ARG_APPVERSION) || operation.equals(ARG_RUNTIMEVERSION))) {
            return false;
        }
        operation = this.args.accept();
        String deviceID = null;
        String appid = null;
        String pkg = null;
        String platform = null;
        File sdk = null;
        int portID = -1;
        while (this.args.peek()) {
            if (platform == null && this.args.peek(ARG_PLATFORM)) {
                this.args.accept(ARG_PLATFORM);
                platform = this.args.accept();
                continue;
            }
            if (deviceID == null && this.args.peek(ARG_DEVICE)) {
                this.args.accept(ARG_DEVICE);
                deviceID = this.args.accept();
                continue;
            }
            if (appid == null && this.args.peek(ARG_APPID)) {
                if (!(operation.equals(ARG_UNINSTALLAPP) || operation.equals(ARG_LAUNCHAPP) || operation.equals(ARG_APPVERSION))) {
                    throw new UsageError("Invalid Parameter: -appid");
                }
                this.args.accept(ARG_APPID);
                appid = this.args.accept();
                continue;
            }
            if (pkg == null && this.args.peek(ARG_PACKAGE)) {
                if (!operation.equals(ARG_INSTALLRUNTIME) && !operation.equals(ARG_INSTALLAPP)) {
                    throw new UsageError("Invalid Parameter: -package");
                }
                this.args.accept(ARG_PACKAGE);
                pkg = this.args.accept();
                continue;
            }
            if (sdk == null && this.args.peek(ARG_PLATFORM_SDK)) {
                this.args.accept(ARG_PLATFORM_SDK);
                sdk = new File(this.args.accept());
                continue;
            }
            if (operation.equals(ARG_LAUNCHAPP) && portID == -1 && this.args.peek(ARG_PORT)) {
                this.args.accept(ARG_PORT);
                portID = this.parseAndValidatePort();
                continue;
            }
            throw new UsageError("Invalid argument: " + this.args.accept());
        }
        if (platform == null || !platform.equalsIgnoreCase("android") && !platform.equalsIgnoreCase("ios")) {
            throw new UsageError("Unsupported / Missing <platform>");
        }
        if (appid == null && (operation.equals(ARG_UNINSTALLAPP) || operation.equals(ARG_LAUNCHAPP) || operation.equals(ARG_APPVERSION))) {
            throw new UsageError("<app-id> required");
        }
        ADTDeviceOperations platOp = null;
        if (platform.equalsIgnoreCase("android")) {
            File adbLocation;
            block40: {
                adbLocation = null;
                try {
                    AndroidDeviceSDK androidSDK = new AndroidDeviceSDK(sdk);
                    adbLocation = androidSDK.getADBLocation();
                }
                catch (Exception e2) {
                    if (sdk == null) break block40;
                    throw new UsageError("-platformsdk does not point to a valid Android SDK");
                }
            }
            if (adbLocation == null) {
                String adbPath = null;
                adbPath = System.getProperty("os.name").indexOf("Windows") != -1 ? Utils.getSDKLibDir() + File.separator + "android" + File.separator + "bin" + File.separator + "adb.exe" : Utils.getSDKLibDir() + File.separator + "android" + File.separator + "bin" + File.separator + "adb";
                adbLocation = new File(adbPath);
            }
            AndroidDeviceOperations androidOp = new AndroidDeviceOperations();
            androidOp.setDeviceID(deviceID);
            androidOp.setADBLocation(adbLocation);
            platOp = androidOp;
        } else if (platform.equalsIgnoreCase("ios")) {
            if (deviceID != null && deviceID.equalsIgnoreCase("ios-simulator")) {
                String isbPath;
                if (!System.getProperty("os.name").startsWith("Mac")) {
                    throw new UsageError("Simulator operations are only supported on mac.");
                }
                IOSSimulatorOperations iosSimOp = new IOSSimulatorOperations();
                if (this.isXcodeVersionLessThanFive()) {
                    isbPath = Utils.getSDKLibDir() + "/aot/bin/isb/isb-old";
                } else {
                    isbPath = Utils.getSDKLibDir() + "/aot/bin/isb/isb";
                    iosSimOp.setIOSSimulatorDeviceType(System.getenv("AIR_IOS_SIMULATOR_DEVICE"));
                }
                iosSimOp.setSimulatorBridgePath(isbPath);
                iosSimOp.setIOSSimulatorSDK(sdk);
                platOp = iosSimOp;
            } else {
                String idbPath = null;
                idbPath = System.getProperty("os.name").indexOf("Windows") != -1 ? Utils.getSDKLibDir() + File.separator + "aot" + File.separator + "bin" + File.separator + "iOSBin" + File.separator + "idb.exe" : Utils.getSDKLibDir() + File.separator + "aot" + File.separator + "bin" + File.separator + "iOSBin" + File.separator + "idb";
                IOSDeviceOperations iosDevOp = new IOSDeviceOperations();
                iosDevOp.setIDBtoolPath(idbPath);
                iosDevOp.setDeviceID(deviceID);
                platOp = iosDevOp;
            }
        }
        if (platOp == null) {
            throw new UsageError("Unsupported platform.");
        }
        File file = fpkg = pkg != null ? new File(pkg) : null;
        if (operation.equals(ARG_LISTDEVICES)) {
            platOp.listDevices();
        } else if (operation.equals(ARG_INSTALLAPP)) {
            platOp.installApplication(fpkg);
        } else if (operation.equals(ARG_UNINSTALLAPP)) {
            platOp.uninstallApplication(appid);
        } else if (operation.equals(ARG_LAUNCHAPP)) {
            platOp.launchApplication(appid, portID);
        } else if (operation.equals(ARG_APPVERSION)) {
            System.out.println(platOp.getApplicationVersion(appid));
        } else if (operation.equals(ARG_INSTALLRUNTIME)) {
            platOp.installRuntime(fpkg);
        } else if (operation.equals(ARG_UNINSTALLRUNTIME)) {
            platOp.uninstallRuntime();
        } else if (operation.equals(ARG_RUNTIMEVERSION)) {
            System.out.println(platOp.getRuntimeVersion());
        }
        return true;
    }

    private void parseInput() throws UsageError {
        if (this.m_target == Target.ANE) {
            this.parseANEInput();
        } else {
            File firstFile = new File(this.args.accept()).getAbsoluteFile();
            if (this.args.peek(ARG_PLATFORM_SDK)) {
                this.args.accept();
                try {
                    this.getAppPackager().setDeviceSDKDirectory(new File(this.args.accept()));
                }
                catch (InvalidInputException e2) {
                    throw new UsageError(e2.getLocalizedMessage(), 12);
                }
            }
            if (this.args.peek()) {
                this.parseDescriptorAndFileset(firstFile);
            } else {
                if (!firstFile.exists()) {
                    throw new UsageError("File " + firstFile.getPath() + " does not exist");
                }
                String mimetype = Utils.getMimetype(firstFile);
                if (MIMETYPE_AIR.equals(mimetype)) {
                    this.parseAIRFile(firstFile);
                } else if (MIMETYPE_AIRI.equals(mimetype)) {
                    this.parseAIRIFile(firstFile);
                } else {
                    throw new UsageError("File " + firstFile.getPath() + " is not a valid AIRI or AIR file", 12);
                }
            }
        }
    }

    private void parseANEInput() throws UsageError {
        try {
            boolean seenSWC = false;
            HashSet<String> platforms = new HashSet<String>();
            ANEPackager packager = this.getANEPackager();
            String extDescString = this.args.accept();
            File extDesc = new File(extDescString).getAbsoluteFile();
            if (!extDesc.exists()) {
                throw new UsageError("Invalid extension descriptor: " + extDescString);
            }
            packager.setExtensionDescriptor(extDesc);
            while (this.args.peek(ARG_SWC)) {
                if (seenSWC) {
                    throw new UsageError("-swc parameter can only appear once.");
                }
                seenSWC = true;
                this.args.accept(ARG_SWC);
                packager.setSWC(new File(this.args.accept()).getAbsoluteFile());
            }
            while (this.args.peek(ARG_PLATFORM)) {
                this.args.accept();
                String platform = this.args.accept();
                if (!packager.isSupportedPlatform(platform)) {
                    throw new UsageError("Unsupported platform: '-platform " + platform + "'. Must be one of " + packager.supportedPlatforms());
                }
                if (platforms.contains(platform)) {
                    throw new UsageError("Duplicate option '-platform " + platform + "'. Each platform should only appear once.");
                }
                platforms.add(platform);
                File rootDir = this.cwd;
                boolean seenPlatformOptions = false;
                while (this.args.peek() && !this.args.peek(ARG_PLATFORM) && !this.args.peek(ARG_SWC)) {
                    if (this.args.peek(ARG_PLATFORM_OPTIONS)) {
                        if (seenPlatformOptions) {
                            throw new UsageError("-platformoptions parameter can only appear once per platform");
                        }
                        this.args.accept();
                        packager.setPlatformExtensionDescriptor(new File(this.args.accept()), platform);
                        seenPlatformOptions = true;
                        continue;
                    }
                    if (this.args.peek("-C")) {
                        this.args.accept();
                        rootDir = new File(this.args.accept()).getAbsoluteFile();
                        if (rootDir.exists() && rootDir.isDirectory()) continue;
                        throw new UsageError("No such directory: " + rootDir.getAbsolutePath());
                    }
                    if (this.args.peek("-e")) {
                        this.args.accept();
                        packager.addExtensionFileWithPath(new File(this.args.accept()), platform, this.args.accept());
                        continue;
                    }
                    packager.addExtensionFileOrDir(new File(this.args.accept()), rootDir, platform);
                }
                if (!this.args.peek(ARG_SWC)) continue;
                if (seenSWC) {
                    throw new UsageError("-swc parameter can only appear once.");
                }
                seenSWC = true;
                this.args.accept(ARG_SWC);
                packager.setSWC(new File(this.args.accept()).getAbsoluteFile());
            }
        }
        catch (IllegalArgumentException e2) {
            throw new UsageError(e2.getLocalizedMessage());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean parseUndocumentedIPAParam() throws UsageError {
        if (this.args.acceptEquals(ARG_OPT_0)) {
            this.getIPAPackager().setOptimizeLevel(0);
            return true;
        }
        if (this.args.acceptEquals(ARG_OPT_1)) {
            this.getIPAPackager().setOptimizeLevel(1);
            return true;
        }
        if (this.args.acceptEquals(ARG_OPT_2)) {
            this.getIPAPackager().setOptimizeLevel(2);
            return true;
        }
        if (this.args.acceptEquals(ARG_OPT_3)) {
            this.getIPAPackager().setOptimizeLevel(3);
            return true;
        }
        if (this.args.acceptEquals(ARG_INLINE)) {
            String inlineLevel = this.args.next();
            try {
                this.getIPAPackager().setInlineLevel(Integer.parseInt(inlineLevel));
                this.args.accept();
                return true;
            }
            catch (NumberFormatException e2) {
                throw new UsageError("Invalid inlining level: " + inlineLevel);
            }
        }
        if (this.args.acceptEquals(ARG_COMPRESSSWF)) {
            this.getIPAPackager().setCompressSWF(true);
            return true;
        }
        if (this.args.acceptEquals(ARG_VERBOSE)) {
            String verbLevel = this.args.next();
            try {
                this.getIPAPackager().setVerbose(Integer.parseInt(verbLevel));
                this.args.accept();
                return true;
            }
            catch (NumberFormatException e3) {
                this.getIPAPackager().setVerbose(1);
            }
            return true;
        }
        if (this.args.acceptEquals(ARG_NOSTRIP)) {
            this.getIPAPackager().setNoStrip(true);
            return true;
        }
        if (this.args.acceptEquals(ARG_DEBUG_RUNTIME)) {
            this.getIPAPackager().setDebugRuntime(true);
            return true;
        }
        if (this.args.acceptEquals(ARG_DEBUG_BUILTINS)) {
            this.getIPAPackager().setDebugBuiltins(true);
            return true;
        }
        if (this.args.acceptEquals(ARG_USE_INTERPRETER)) {
            this.getIPAPackager().setUseInterpreter(true);
            return true;
        }
        if (this.args.acceptEquals(ARG_DRY_RUN)) {
            this.getIPAPackager().setDryRun(true);
            return true;
        }
        if (this.args.acceptEquals(ARG_RENDERING_DIAG)) {
            throw new UsageError("The -renderingdiagnostics flag is no longer supported");
        }
        if (this.args.acceptEquals(ARG_OUTPUT_DIR)) {
            this.m_output = new File(new File(this.args.accept()), ".");
            return true;
        }
        if (this.args.acceptEquals(ARG_LINKER)) {
            this.getIPAPackager().addLinkerOption(this.args.accept());
            return true;
        }
        if (this.args.acceptEquals(ARG_TIMEOUT)) {
            this.getIPAPackager().setTimeout(Integer.parseInt(this.args.accept()));
            return true;
        }
        if (this.args.acceptEquals(ARG_AOT_SDK)) {
            this.m_targetSDK = this.args.accept();
            this.getIPAPackager().setTarget(this.m_targetSDK);
            if (!this.m_targetSDK.endsWith("shell")) return true;
            this.getIPAPackager().setValidate(false);
            return true;
        }
        if (this.args.acceptEquals(ARG_AOT_SDKLOC)) {
            this.getIPAPackager().setSDKLocation(this.args.accept());
            return true;
        }
        if (this.args.acceptEquals(ARG_ENABLE_SSC)) {
            this.getIPAPackager().setEnableSSC(true);
            return true;
        }
        if (this.args.acceptEquals(ARG_SPLITLIMIT)) {
            String limit = this.args.next();
            try {
                this.getIPAPackager().setModuleSplitLimit(Integer.parseInt(limit));
                this.args.accept();
                return true;
            }
            catch (NumberFormatException e4) {
                this.getIPAPackager().setModuleSplitLimit(0);
            }
            return true;
        }
        if (this.args.acceptEquals(ARG_POOLSIZE)) {
            String poolsize = this.args.next();
            try {
                this.getIPAPackager().setPoolSize(Integer.parseInt(poolsize));
                this.args.accept();
                return true;
            }
            catch (NumberFormatException e5) {
                this.getIPAPackager().setPoolSize(0);
            }
            return true;
        }
        if (this.args.acceptEquals(ARG_32)) {
            this.getIPAPackager().setForce32Bit(true);
            return true;
        }
        if (this.args.acceptEquals(ARG_AOT_XSS)) {
            this.getIPAPackager().setStackSize(this.args.accept());
            return true;
        }
        if (this.args.acceptEquals(ARG_AOT_PERFLOG)) {
            this.getIPAPackager().setLogAOTPerf(true);
            return true;
        }
        if (this.args.acceptEquals(ARG_GENERATE_DSYM)) {
            boolean hostIsMac;
            boolean bl2 = hostIsMac = System.getProperty("os.name").indexOf("Mac") != -1;
            if (!hostIsMac) {
                throw new UsageError("Option -XgenDSYM can only be used with IPA targets on Mac");
            }
            this.getIPAPackager().setGenerateDSYM(true);
            return true;
        }
        if (!this.args.acceptEquals(ARG_XPLATFORM_SDK)) return false;
        String platformsdk = this.args.accept();
        if (this.m_targetSDK == null || !this.m_targetSDK.endsWith("shell")) throw new UsageError("-Xplatformsdk is supported for shell app only");
        try {
            this.getIPAPackager().setDeviceSDKDirectory(new File(platformsdk));
            return true;
        }
        catch (InvalidInputException e6) {
            throw new UsageError("Invalid platform directory: " + platformsdk);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean parseUndocumentedParam() throws UsageError {
        if (this.args.peek(ARG_NO_VALIDATE)) {
            this.args.accept(ARG_NO_VALIDATE);
            if (!this.m_target.isAIR() && this.m_target != Target.ANE) throw new UsageError("-Xnovalidate not supported for this target");
            this.getPackager().setValidate(false);
            return true;
        } else if (this.args.peek(ARG_NO_ANE_VALIDATE)) {
            this.args.accept(ARG_NO_ANE_VALIDATE);
            this.getPackager().setValidateExtensions(false);
            return true;
        } else if (this.args.peek(ARG_RUNTIME)) {
            this.args.accept(ARG_RUNTIME);
            this.getAppPackager().setRuntimeDir(new File(this.args.accept()));
            return true;
        } else if (this.args.peek(ARG_DEBUG)) {
            this.args.accept(ARG_DEBUG);
            this.getAppPackager().setDebug(true);
            this.m_debug = true;
            return true;
        } else {
            if (this.m_target != Target.IPA) return false;
            return this.parseUndocumentedIPAParam();
        }
    }

    private boolean parseConnectOptions() throws UsageError {
        if (this.args.peek(ARG_CONNECT)) {
            if (!Target.supportsConnect(this.m_targetValue).booleanValue()) {
                throw new UsageError(Target.getConnectUsageErrorString());
            }
            this.args.accept(ARG_CONNECT);
            String host = this.args.next();
            if (host.length() == 0 || host.charAt(0) == '-') {
                InetAddress localHost;
                try {
                    localHost = InetAddress.getLocalHost();
                }
                catch (UnknownHostException e2) {
                    throw new UsageError("Unable to determine local host");
                }
                host = localHost.getCanonicalHostName();
            } else {
                this.args.accept();
            }
            try {
                this.getAppPackager().setForOutgoingDebuggingConnection(host, -1);
            }
            catch (Exception e3) {
                return false;
            }
            return true;
        }
        return false;
    }

    private int parseAndValidatePort() throws UsageError {
        String arg = this.args.next();
        int port = -1;
        int DEFAULT_LISTEN_PORT = 7936;
        if (arg.length() > 0 && arg.charAt(0) != '-') {
            try {
                port = Integer.parseInt(arg);
                if (port <= 0 || port >= 65536) {
                    throw new UsageError("Incorrect port number specified. Valid port numbers are 1 to 65535.");
                }
            }
            catch (NumberFormatException e2) {
                throw new UsageError("Incorrect port number specified. Expected an integer.");
            }
            this.args.accept();
        } else {
            port = DEFAULT_LISTEN_PORT;
        }
        return port;
    }

    private void detectArch() throws UsageError {
        if (this.args.seek(ARG_ARCH)) {
            Target target = Target.getTargetFromArg(this.m_targetValue);
            if (target != Target.APK) {
                throw new UsageError("Option -arch can be only used with -target apk, apk-debug, apk-emulator, apk-captive-runtime");
            }
            this.args.accept(ARG_ARCH);
            String arg = this.args.next();
            if (!arg.equals("armv7") && !arg.equals("x86")) {
                throw new UsageError("-arch must be followed by (armv7 | x86) ");
            }
            this.m_arch = arg;
            this.args.accept();
        }
    }

    private void parseArchOptions() throws UsageError {
        if (this.args.peek(ARG_ARCH)) {
            this.args.accept(ARG_ARCH);
            this.args.accept();
        }
        if (this.m_target == Target.APK) {
            this.getAppPackager().setArch(this.m_arch);
        }
    }

    private boolean parseListenOptions() throws UsageError {
        if (this.args.peek(ARG_LISTEN)) {
            if (!(this.m_targetValue.equals("apk-debug") || this.m_targetValue.equals("ipa-debug") || this.m_targetValue.equals("ipa-debug-interpreter"))) {
                throw new UsageError("Option -listen can be only used with -target apk-debug, -target ipa-debug or -target ipa-debug-interpreter");
            }
            this.args.accept(ARG_LISTEN);
            int port = this.parseAndValidatePort();
            if (port != -1) {
                try {
                    this.getAppPackager().setForIncomingDebuggerConnection(port);
                }
                catch (IOException e2) {
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    private void parseAIRDownloadURLOption() throws UsageError {
        if (this.args.peek(ARG_AIR_DOWNLOAD_URL)) {
            if (this.m_target != Target.APK || !this.getAPKPackager().allowAIRDownloadURL()) {
                throw new UsageError("Option -airDownloadURL can be only used with -target apk, -target apk-debug or -target apk-emulator");
            }
            this.args.accept(ARG_AIR_DOWNLOAD_URL);
            String arg = this.args.next();
            if (arg.length() > 0 && arg.charAt(0) != '-') {
                this.args.accept();
                this.getAppPackager().setAIRDownloadURL(arg);
            } else {
                throw new UsageError("Option -airDownloadURL requires a URL to be specified");
            }
        }
    }

    private void parseSamplerEnabled() throws UsageError {
        if (this.args.peek(ARG_SAMPLER)) {
            if (this.m_target != Target.IPA) {
                throw new UsageError("Option -sampler can be only used with IPA targets");
            }
            this.args.accept(ARG_SAMPLER);
            this.getIPAPackager().setSamplerEnabled(true);
        }
    }

    private void parseAneLinkOptions() throws UsageError {
        if (this.args.peek(ARG_HIDE_ANE_SYMBOLS)) {
            if (this.m_target != Target.IPA) {
                throw new UsageError("Option -hideAneLibSymbols can be only used with IPA targets");
            }
            this.args.accept(ARG_HIDE_ANE_SYMBOLS);
            String value = this.args.next();
            if (value.equalsIgnoreCase(ARG_VALUE_YES)) {
                this.getIPAPackager().setHideAneSymbols(true);
            } else if (value.equalsIgnoreCase(ARG_VALUE_NO)) {
                this.getIPAPackager().setHideAneSymbols(false);
            } else {
                throw new UsageError("Option -hideAneLibSymbols should be followed by a 'yes' or a 'no' ");
            }
            this.args.accept();
        }
    }

    private void parseAOTModeOption() throws UsageError {
        if (this.args.peek(ARG_USE_LEGACY_AOT)) {
            if (this.m_target != Target.IPA) {
                throw new UsageError("Option -useLegacyAOT can be used only with IPA targets");
            }
            if (this.getIPAPackager().getUseInterpreter()) {
                throw new UsageError("Option -useLegacyAOT can not be used with interpreter targets");
            }
            this.args.accept(ARG_USE_LEGACY_AOT);
            String value = this.args.next();
            if (!value.equalsIgnoreCase(ARG_VALUE_YES) && !value.equalsIgnoreCase(ARG_VALUE_NO)) {
                throw new UsageError("Option -useLegacyAOT should be followed by a 'yes' or a 'no' ");
            }
            this.getIPAPackager().setUseHalfmoonAOT(true);
            this.args.accept();
        }
    }

    protected boolean signingOptionNext(Arguments args) {
        if (this.m_target == Target.IPA) {
            return args.peek(ARG_PROVISIONING_PROFILE) || super.signingOptionNext(args);
        }
        return super.signingOptionNext(args);
    }

    private void parseAppSigningOptions() throws UsageError {
        if (this.signingOptionNext(this.args)) {
            this.m_signingApp = true;
        }
        if (this.m_target != Target.APK && this.m_target != Target.IPA) {
            if (this.signingOptionNext(this.args)) {
                this.parseSigningOptions(this.getPackager());
            } else if (this.m_signingApp) {
                throw new UsageError("Found misplaced signing options");
            }
        }
    }

    private void parseNEAppMigrateOptions() throws UsageError {
        if (this.args.peek(ARG_MIGRATE)) {
            AIRMigrationSigner migrateSigner = null;
            if (!this.m_NEApp || this.m_target != Target.DMG && this.m_target != Target.EXE) {
                throw new UsageError("Migration certificate can only be applied to desktop native installers with native extensions.  Target: " + this.m_targetValue);
            }
            this.args.accept(ARG_MIGRATE);
            migrateSigner = new AIRMigrationSigner();
            this.parseSigningOptions(migrateSigner);
            this.getPackager().setMigrationSigner(migrateSigner);
        }
    }

    private void parseTarget() throws UsageError {
        if (this.args.peek(ARG_TARGET)) {
            this.args.accept(ARG_TARGET);
            this.args.accept();
        }
    }

    protected boolean cacheSigningOption(UCF.SigningOptions options) throws UsageError {
        if (this.m_target != null && !this.m_target.supportsTimestamps().booleanValue() && this.args.peek("-tsa")) {
            throw new UsageError("-tsa option not supported");
        }
        if (this.m_target == Target.IPA && this.args.peek(ARG_PROVISIONING_PROFILE)) {
            this.args.accept(ARG_PROVISIONING_PROFILE);
            try {
                this.getIPAPackager().setMobileProvisioningProfile(new File(this.args.accept()).getCanonicalFile());
                return true;
            }
            catch (IOException ie) {
                throw new UsageError("Error accessing mobile provisioning profile: " + ie.getMessage());
            }
        }
        return super.cacheSigningOption(options);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void parseNativeSigningOptions() throws UsageError {
        if (this.signingOptionNext(this.args)) {
            if (this.m_target == Target.EXE || this.m_target == Target.WIN_BUNDLE) {
                UCF.SigningOptions nativeSigningOptions = this.cacheSigningOptions();
                if (!new File(nativeSigningOptions.keyStoreFile).exists()) {
                    throw new UsageError("Keystore file does not exist: " + nativeSigningOptions.keyStoreFile);
                }
                this.getNativePackager().setNativeSigningOptions(nativeSigningOptions);
                return;
            }
            if (this.m_target == Target.APK) {
                this.parseSigningOptions(this.getPackager());
                return;
            }
            if (this.m_target != Target.IPA) {
                if (this.m_target == Target.DMG) throw new UsageError("Native signing not supported on mac");
                if (this.m_target != Target.APP_BUNDLE) throw new UsageError("Found misplaced signing arguments");
                throw new UsageError("Native signing not supported on mac");
            }
            if (!this.m_targetValue.equals("ipa-test-interpreter-simulator") && !this.m_targetValue.equals("ipa-debug-interpreter-simulator")) {
                this.parseSigningOptions(this.getPackager());
                return;
            }
            UCF.SigningOptions options = new UCF.SigningOptions(this);
            while (this.cacheSigningOption(options)) {
            }
            return;
        }
        if (this.m_target == Target.APK) {
            throw new UsageError("Signing options required to package APK");
        }
        if (this.m_target != Target.IPA) return;
        throw new UsageError("Signing options required to package IPA");
    }

    private void parseUndocumentedParams() throws UsageError {
        while (this.parseUndocumentedParam()) {
        }
    }

    private void parseFileAndPathArguments() throws UsageError {
        try {
            if (!this.args.peek()) {
                throw new UsageError("at least one file is required");
            }
            while (this.args.peek()) {
                if (this.args.peek("-C")) {
                    this.args.accept();
                    this.cwd = new File(this.args.accept());
                    continue;
                }
                if (this.args.peek(ARG_PLATFORM_SDK)) {
                    this.args.accept();
                    try {
                        this.getAppPackager().setDeviceSDKDirectory(new File(this.args.accept()));
                        continue;
                    }
                    catch (InvalidInputException e2) {
                        throw new UsageError(e2.getLocalizedMessage(), 12);
                    }
                }
                if (this.args.peek("-e")) {
                    this.args.accept();
                    this.getPackager().addSourceWithPath(new File(this.args.accept()), this.args.accept());
                    continue;
                }
                if (this.args.peek(ARG_EXTDIR)) {
                    this.args.accept();
                    this.getAppPackager().addExtensionDir(new File(this.args.accept()).getAbsoluteFile());
                    continue;
                }
                this.getPackager().addSourceFileOrDir(new File(this.args.accept()), this.cwd);
            }
        }
        catch (InvalidInputException e3) {
            throw new UsageError(e3.getLocalizedMessage());
        }
        catch (IllegalArgumentException e4) {
            throw new UsageError(e4.getLocalizedMessage());
        }
    }

    private void parseDescriptorAndFileset(File appXml) throws UsageError {
        if (this.m_target != Target.APK && this.m_target != Target.IPA && this.m_target != Target.AIRI && !this.m_signingApp) {
            throw new UsageError("Signing options required to package from descriptor and fileset");
        }
        if (this.m_target == Target.IPA) {
            this.getIPAPackager().setApplicationDescriptor(appXml);
            if (this.args.next().startsWith("http://")) {
                this.getIPAPackager().setRemoteContentURI(this.args.accept());
            }
        } else {
            this.getAppPackager().setApplicationDescriptor(appXml);
        }
        this.parseFileAndPathArguments();
    }

    private void parseAIRFile(File airFile) throws UsageError {
        if (this.m_target == Target.AIR) {
            throw new UsageError("Found an AIR file as input. Expected an AIRI file or descriptor and some content");
        }
        if (this.m_target == Target.AIRI) {
            throw new UsageError("Found an AIR file as input. Cannot package an AIR file as AIRI");
        }
        if (this.m_signingApp) {
            throw new UsageError("Found signing arguments and an AIR file as input. AIR files are already signed");
        }
        if (this.m_debug) {
            throw new UsageError("-Xdebug not supported with an AIR file as input. Repackage your AIR file with -Xdebug and use that instead");
        }
        this.getAppPackager().setAIRFile(airFile);
    }

    private void parseAIRIFile(File airiFile) throws UsageError {
        if (!this.m_signingApp && this.m_target != Target.APK && this.m_target != Target.IPA) {
            throw new UsageError("An AIRI file was specified without signing arguments. AIRI files must be signed to be processed further");
        }
        this.getAppPackager().setAIRIFile(airiFile);
    }

    private void parsePrepare() throws UsageError {
        this.args.accept(ARG_PREPARE);
        this.m_target = this.args.next().endsWith(".ane") ? Target.ANE : Target.AIRI;
        this.parseUndocumentedParams();
        this.parseOutput(this.getPackager(), this.m_target.getFileExtension());
        this.parseInput();
    }

    private void parseSign() throws UsageError {
        File intermediateFile;
        this.m_target = Target.AIR;
        this.detectTarget();
        if (this.m_target != Target.AIR && this.m_target != Target.AIRN && this.m_target != Target.ANE) {
            throw new UsageError("Invalid target for -sign " + this.m_target.getFileExtension());
        }
        this.args.accept(ARG_SIGN);
        this.parseSigningOptions(this.getPackager());
        if (this.args.peek(ARG_TARGET)) {
            this.args.accept(ARG_TARGET);
            this.args.accept();
        }
        if (!(intermediateFile = new File(this.args.accept())).exists()) {
            throw new UsageError("no such file " + intermediateFile.getPath());
        }
        this.getPackager().setIntermediateFile(intermediateFile);
        this.parseOutput(this.getPackager(), this.m_target.getFileExtension());
    }

    private void parseMigrate() throws UsageError {
        this.args.accept(ARG_MIGRATE);
        AIRMigrationSigner signer = new AIRMigrationSigner();
        this.parseSigningOptions(signer);
        File input = new File(this.args.accept());
        if (!input.exists()) {
            throw new UsageError("no such file " + input.getPath());
        }
        signer.setInput(input);
        this.parseOutput(signer, FILE_EXT_AIR);
        try {
            signer.sign();
        }
        catch (CertificateExpiredException ex) {
            throw new UsageError("certificate has expired", 8);
        }
        catch (CertificateNotYetValidException ex) {
            throw new UsageError("certificate is not yet valid", 8);
        }
        catch (CertificateException ex) {
            throw new UsageError("not an X509 code-signing certificate", 8);
        }
        catch (GeneralSecurityException ex) {
            throw new UsageError(ex.getMessage(), 9);
        }
        catch (InvalidInputException ex) {
            throw new UsageError(ex.getMessage(), 12);
        }
        catch (IOException ex) {
            throw new UsageError(ex.getMessage(), 6);
        }
    }

    private void parseCheckPass() throws UsageError {
        this.args.accept(ARG_CHECK_PASS);
        this.parseSigningOptions(null);
        System.err.println("valid password");
    }

    private void parseCertificate() throws UsageError {
        String cn = null;
        String ou = null;
        String o2 = null;
        String c2 = null;
        String validityPeriod = null;
        this.args.accept(ARG_CERT);
        while (true) {
            if (this.args.peek("-cn")) {
                if (cn != null) {
                    throw new UsageError("-cn already specified");
                }
                this.args.accept("-cn");
                cn = this.args.accept();
                continue;
            }
            if (this.args.peek("-ou")) {
                if (ou != null) {
                    throw new UsageError("-ou already specified");
                }
                this.args.accept("-ou");
                ou = this.args.accept();
                continue;
            }
            if (this.args.peek("-o")) {
                if (o2 != null) {
                    throw new UsageError("-o already specified");
                }
                this.args.accept("-o");
                o2 = this.args.accept();
                continue;
            }
            if (this.args.peek("-c")) {
                if (c2 != null) {
                    throw new UsageError("-c already specified");
                }
                this.args.accept("-c");
                c2 = this.args.accept();
                continue;
            }
            if (!this.args.peek("-validityPeriod")) break;
            if (validityPeriod != null) {
                throw new UsageError("-validityPeriod already specified");
            }
            this.args.accept("-validityPeriod");
            validityPeriod = this.args.accept();
        }
        if (cn == null) {
            throw new UsageError("-cn is required");
        }
        String keyType = this.args.accept();
        try {
            this.m_creator.setKeyType(keyType);
        }
        catch (IllegalArgumentException e2) {
            throw new UsageError("key type not recognized: " + keyType + " -- valid type is 2048-RSA");
        }
        this.m_creator.setOutput(new File(this.args.accept()));
        this.m_creator.setPassword(this.args.accept());
        this.m_creator.setName(cn);
        if (ou != null) {
            this.m_creator.setOrganizationalUnit(ou);
        }
        if (o2 != null) {
            this.m_creator.setOrganizationName(o2);
        }
        try {
            if (validityPeriod != null) {
                this.m_creator.setValidity(validityPeriod);
            }
            if (c2 != null) {
                this.m_creator.setCountry(c2);
            }
        }
        catch (IllegalArgumentException e3) {
            throw new UsageError(e3.getMessage());
        }
    }

    private AIRPackager getAIRPackager() {
        return (AIRPackager)this.getPackager();
    }

    private IPAPackager getIPAPackager() {
        return (IPAPackager)this.getPackager();
    }

    private ANEPackager getANEPackager() {
        return (ANEPackager)this.getPackager();
    }

    private NativePackager getNativePackager() {
        return (NativePackager)this.getPackager();
    }

    private ADTPackager newPackager() {
        assert (this.m_target != null);
        return this.m_target.newPackager(this.m_arch);
    }

    protected ADTPackager getPackager() {
        if (this.m_packager == null) {
            this.m_packager = this.newPackager();
        }
        return this.m_packager;
    }

    private ApplicationPackager getAppPackager() {
        return (ApplicationPackager)this.getPackager();
    }

    private APKPackager getAPKPackager() {
        return (APKPackager)this.getPackager();
    }

    private class PasswordScanningOutputStream
    extends OutputStream {
        private String _lastPartialLine;
        private OutputStream _out;
        private OutputStream _passwordReturn;

        public PasswordScanningOutputStream(OutputStream out, OutputStream passwordReturn) throws UnsupportedEncodingException {
            this._out = out;
            this._passwordReturn = passwordReturn;
            this._lastPartialLine = ADT.FILE_EXT_NONE;
        }

        public void write(byte[] b3, int off, int len) throws IOException {
            this._out.write(b3, off, len);
            String joinedString = this._lastPartialLine + new String(b3, off, len, "UTF-8");
            if (joinedString.endsWith("password: ")) {
                try {
                    this._passwordReturn.write((ADT.this.readPassword(ADT.FILE_EXT_NONE) + System.getProperty("line.separator")).getBytes("UTF-8"));
                    this._passwordReturn.flush();
                    this._lastPartialLine = ADT.FILE_EXT_NONE;
                }
                catch (UsageError e2) {
                    System.err.println(e2.getMessage());
                    ADT.this.printUsage();
                    System.exit(e2.getExitCode());
                }
            } else {
                String[] lines = joinedString.split("\n");
                this._lastPartialLine = lines[lines.length - 1];
            }
        }

        public void write(int b3) throws IOException {
            throw new UnsupportedOperationException();
        }
    }

    static class Target {
        public static final Target AIR = new Target("air", true);
        public static final Target AIRI = new Target("airi", true);
        public static final Target AIRN = new Target("airn", true);
        public static final Target EXE = new Target("exe", false);
        public static final Target DMG = new Target("dmg", false);
        public static final Target RPM = new Target("rpm", false);
        public static final Target DEB = new Target("deb", false);
        public static final Target APK = new Target("apk", false);
        public static final Target ANE = new Target("ane", false);
        public static final Target IPA = new Target("ipa", false);
        public static final Target APP_BUNDLE = new Target("app", false);
        public static final Target WIN_BUNDLE = new Target("", false);
        private static final String[] CONNECT_TARGETS = new String[]{"apk-debug", "ipa-debug", "ipa-debug-interpreter", "ipa-debug-interpreter-simulator"};
        private String m_fileExtension;
        private boolean m_isAIR;

        private static Target getLinuxTarget() {
            int dpkgStatus;
            int rpmStatus;
            try {
                Process rpmChecker = new ProcessBuilder(ADT.FILE_EXT_RPM, "-q", ADT.FILE_EXT_RPM).start();
                Utils.consumeOutput(rpmChecker);
                rpmStatus = rpmChecker.waitFor();
            }
            catch (IOException e2) {
                rpmStatus = 1;
            }
            catch (InterruptedException e3) {
                rpmStatus = 1;
            }
            try {
                Process dpkgChecker = new ProcessBuilder("dpkg", "-l", "dpkg").start();
                Utils.consumeOutput(dpkgChecker);
                dpkgStatus = dpkgChecker.waitFor();
            }
            catch (IOException e4) {
                dpkgStatus = 1;
            }
            catch (InterruptedException e5) {
                dpkgStatus = 1;
            }
            if (rpmStatus == 0) {
                return RPM;
            }
            if (dpkgStatus == 0) {
                return DEB;
            }
            return null;
        }

        public static Target getTargetFromArg(String arg) throws UsageError {
            if (ADT.FILE_EXT_AIR.equals(arg)) {
                return AIR;
            }
            if (ADT.FILE_EXT_AIRI.equals(arg)) {
                return AIRI;
            }
            if (ADT.FILE_EXT_AIRN.equals(arg)) {
                return AIRN;
            }
            if ("apk-debug".equals(arg) || ADT.FILE_EXT_APK.equals(arg) || "apk-emulator".equals(arg) || "apk-captive-runtime".equals(arg)) {
                return APK;
            }
            if ("ipa-test".equals(arg) || "ipa-debug".equals(arg) || "ipa-ad-hoc".equals(arg) || "ipa-app-store".equals(arg) || "ipa-test-interpreter".equals(arg) || "ipa-debug-interpreter".equals(arg) || "ipa-test-interpreter-simulator".equals(arg) || "ipa-debug-interpreter-simulator".equals(arg)) {
                return IPA;
            }
            if (ADT.FILE_EXT_ANE.equals(arg)) {
                return ANE;
            }
            if (ADT.ARG_NATIVE.equals(arg)) {
                if (System.getProperty("os.name").indexOf("Windows") != -1) {
                    return EXE;
                }
                if (System.getProperty("os.name").indexOf("Mac") != -1) {
                    return DMG;
                }
                if (System.getProperty("os.name").indexOf("Linux") != -1) {
                    return Target.getLinuxTarget();
                }
            }
            if (ADT.ARG_BUNDLE.equals(arg)) {
                if (System.getProperty("os.name").indexOf("Mac") != -1) {
                    return APP_BUNDLE;
                }
                if (System.getProperty("os.name").indexOf("Windows") != -1) {
                    return WIN_BUNDLE;
                }
                if (System.getProperty("os.name").indexOf("Linux") != -1) {
                    throw new UsageError("-target bundle is not supported on this platform");
                }
            }
            return null;
        }

        public Boolean supportsTimestamps() {
            return !this.m_fileExtension.equals(ADT.FILE_EXT_APK) && !this.m_fileExtension.equals(ADT.FILE_EXT_IPA);
        }

        public static Boolean supportsConnect(String target) {
            return Arrays.asList(CONNECT_TARGETS).contains(target);
        }

        public static String getConnectUsageErrorString() {
            String error = ADT.FILE_EXT_NONE;
            for (String target : CONNECT_TARGETS) {
                if (error.length() != 0) {
                    error = error + " and ";
                }
                error = error + target;
            }
            error = " Option -connect can be used only with -target " + error;
            return error;
        }

        public String getFileExtension() {
            if (this.m_fileExtension.length() == 0) {
                return ADT.FILE_EXT_NONE;
            }
            return "." + this.m_fileExtension;
        }

        public boolean isAIR() {
            return this.m_isAIR;
        }

        public ADTPackager newPackager(String arch) {
            String platform = null;
            if (arch.equals("armv7")) {
                platform = "Android-ARM";
            } else if (arch.equals("x86")) {
                platform = "Android-x86";
            }
            if (this == AIR || this == AIRI) {
                return new AIRPackager();
            }
            if (this == AIRN) {
                return new AIRNPackager();
            }
            if (this == DMG) {
                return new DMGPackager();
            }
            if (this == EXE) {
                return new EXEPackager();
            }
            if (this == RPM) {
                return new RPMPackager();
            }
            if (this == DEB) {
                return new DEBPackager();
            }
            if (this == APK) {
                return new APKPackager(platform);
            }
            if (this == ANE) {
                return new ANEPackager();
            }
            if (this == IPA) {
                return new IPAPackager();
            }
            if (this == APP_BUNDLE) {
                return new AppBundlePackager();
            }
            if (this == WIN_BUNDLE) {
                return new WinBundlePackager();
            }
            assert (false);
            return null;
        }

        private Target(String extension, boolean isAIR) {
            this.m_fileExtension = extension;
            this.m_isAIR = isAIR;
        }
    }
}

