/*
 * Decompiled with CFR 0.152.
 */
package adobe.util;

import java.lang.reflect.Array;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.RandomAccess;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GapBufferList<E>
extends AbstractList<E>
implements List<E>,
RandomAccess,
Cloneable {
    private static final EqualsNull g_equalsNull = new EqualsNull();
    private static final int g_defaultInitialCapacity = 8;
    private int m_capacity;
    private int m_size = 0;
    private int m_gap = 0;
    private Object[] m_data;

    public GapBufferList() {
        this(8);
    }

    public GapBufferList(Collection<? extends E> c2) {
        this(Math.max(8, c2.size()));
        this.addAll(c2);
    }

    public GapBufferList(int initialCapacity) {
        this.m_capacity = initialCapacity;
        this.m_data = new Object[this.m_capacity];
    }

    private void insertAt(int pos, E e2) {
        this.moveGap(pos, 1);
        this.m_data[pos] = e2;
        ++this.m_gap;
        ++this.m_size;
    }

    @Override
    public boolean add(E e2) {
        this.insertAt(this.m_size, e2);
        return true;
    }

    @Override
    public void add(int pos, E e2) {
        this.insertAt(pos, e2);
    }

    @Override
    public boolean addAll(Collection<? extends E> c2) {
        this.moveGap(this.m_size, c2.size());
        return super.addAll(c2);
    }

    @Override
    public void clear() {
        Arrays.fill(this.m_data, 0, this.m_gap, null);
        Arrays.fill(this.m_data, this.m_gap + this.gapSize(), this.m_capacity, null);
        this.m_size = 0;
        this.m_gap = 0;
    }

    @Override
    public E remove(int pos) {
        this.moveGap(pos + 1, 0);
        E e2 = this.get(pos);
        this.m_data[pos] = null;
        --this.m_size;
        --this.m_gap;
        return e2;
    }

    @Override
    public boolean contains(Object obj) {
        int i2;
        if (obj == null) {
            obj = g_equalsNull;
        }
        for (i2 = 0; i2 < this.m_gap; ++i2) {
            if (!obj.equals(this.m_data[i2])) continue;
            return true;
        }
        for (i2 = this.m_gap + this.gapSize(); i2 < this.m_capacity; ++i2) {
            if (!obj.equals(this.m_data[i2])) continue;
            return true;
        }
        return false;
    }

    @Override
    public E get(int pos) {
        int i2 = pos;
        if (pos >= this.m_gap) {
            i2 += this.gapSize();
        }
        Object res = this.m_data[i2];
        return (E)res;
    }

    @Override
    public E set(int pos, E e2) {
        int i2 = pos;
        if (pos >= this.m_gap) {
            i2 += this.gapSize();
        }
        Object res = this.m_data[i2];
        this.m_data[i2] = e2;
        return (E)res;
    }

    @Override
    public int indexOf(Object obj) {
        int i2;
        if (obj == null) {
            obj = g_equalsNull;
        }
        for (i2 = 0; i2 < this.m_gap; ++i2) {
            if (!obj.equals(this.m_data[i2])) continue;
            return i2;
        }
        for (i2 = this.m_gap + this.gapSize(); i2 < this.m_capacity; ++i2) {
            if (!obj.equals(this.m_data[i2])) continue;
            return i2 - this.gapSize();
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object obj) {
        int i2;
        if (obj == null) {
            obj = g_equalsNull;
        }
        for (i2 = this.m_capacity - 1; i2 >= this.m_gap + this.gapSize(); --i2) {
            if (!obj.equals(this.m_data[i2])) continue;
            return i2 - this.gapSize();
        }
        for (i2 = this.m_gap - 1; i2 >= 0; --i2) {
            if (!obj.equals(this.m_data[i2])) continue;
            return i2;
        }
        return -1;
    }

    public Object clone() {
        try {
            GapBufferList res = (GapBufferList)super.clone();
            res.m_data = (Object[])Array.newInstance(this.m_data.getClass(), this.m_capacity);
            System.arraycopy(this.m_data, 0, res.m_data, 0, this.m_capacity);
            return res;
        }
        catch (CloneNotSupportedException e2) {
            throw new IllegalStateException(e2);
        }
    }

    @Override
    public Object[] toArray() {
        Object[] res = (Object[])Array.newInstance(Object.class, this.m_size);
        System.arraycopy(this.m_data, 0, res, 0, this.m_gap);
        System.arraycopy(this.m_data, this.m_gap + this.gapSize(), res, this.m_gap, this.m_size - this.m_gap);
        return res;
    }

    @Override
    public <T> T[] toArray(T[] res) {
        if (res.length < this.m_size) {
            res = (Object[])Array.newInstance(res.getClass(), this.m_size);
        }
        System.arraycopy(this.m_data, 0, res, 0, this.m_gap);
        System.arraycopy(this.m_data, this.m_gap + this.gapSize(), res, this.m_gap, this.m_size - this.m_gap);
        if (res.length > this.m_size) {
            res[this.m_size] = null;
        }
        return res;
    }

    @Override
    public boolean isEmpty() {
        return this.m_size == 0;
    }

    @Override
    public int size() {
        return this.m_size;
    }

    private int gapSize() {
        return this.m_capacity - this.m_size;
    }

    public void ensureCapacity(int minCapacity) {
        this.growBuf(this.m_gap, minCapacity);
    }

    private void moveGap(int pos, int minGap) {
        if (pos < 0 || pos > this.m_size) {
            throw new IndexOutOfBoundsException();
        }
        if (minGap > this.gapSize()) {
            this.growBuf(pos, this.m_size + minGap);
            return;
        }
        if (pos == this.m_gap) {
            return;
        }
        if (pos < this.m_gap) {
            int itemsToMove = this.m_gap - pos;
            int fromPos = pos;
            int toPos = pos + this.gapSize();
            System.arraycopy(this.m_data, fromPos, this.m_data, toPos, itemsToMove);
            int endClear = fromPos + itemsToMove;
            if (endClear > toPos) {
                endClear = toPos;
            }
            Arrays.fill(this.m_data, fromPos, endClear, null);
        } else {
            int itemsToMove = pos - this.m_gap;
            int fromPos = this.m_gap + this.gapSize();
            int toPos = this.m_gap;
            System.arraycopy(this.m_data, fromPos, this.m_data, toPos, itemsToMove);
            int clearFrom = fromPos;
            if (clearFrom < this.m_gap + itemsToMove) {
                clearFrom = this.m_gap + itemsToMove;
            }
            int endClear = fromPos + itemsToMove;
            Arrays.fill(this.m_data, clearFrom, endClear, null);
        }
        this.m_gap = pos;
    }

    private void growBuf(int pos, int minCapacity) {
        int newCapacity = this.m_capacity + (this.m_capacity >> 1);
        if (newCapacity < minCapacity) {
            newCapacity = minCapacity;
        }
        Object[] newData = new Object[newCapacity];
        int grewBy = newCapacity - this.m_capacity;
        int endGap = this.m_gap + this.gapSize();
        int newEndGap = pos + this.gapSize() + grewBy;
        if (pos < this.m_gap) {
            int newChunk3 = newEndGap + (this.m_gap - pos);
            System.arraycopy(this.m_data, 0, newData, 0, pos);
            System.arraycopy(this.m_data, pos, newData, newEndGap, this.m_gap - pos);
            System.arraycopy(this.m_data, endGap, newData, newChunk3, this.m_capacity - endGap);
        } else {
            int endChunk2 = endGap + (pos - this.m_gap);
            System.arraycopy(this.m_data, 0, newData, 0, this.m_gap);
            System.arraycopy(this.m_data, endGap, newData, this.m_gap, pos - this.m_gap);
            System.arraycopy(this.m_data, endChunk2, newData, newEndGap, this.m_capacity - endChunk2);
        }
        this.m_gap = pos;
        this.m_capacity = newCapacity;
        this.m_data = newData;
    }

    private static class EqualsNull {
        private EqualsNull() {
        }

        public boolean equals(Object obj) {
            return obj == null;
        }
    }
}

