/*
 * Decompiled with CFR 0.152.
 */
package adobe.abc;

import adobe.abc.LLVMStubTypes;
import adobe.abc.Pair;
import adobe.abc.TamarinSlotLayout;
import adobe.abc.Type;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import llvm.Constant;
import llvm.ConstantInt;
import llvm.IntegerType;
import llvm.LLVMContext;
import llvm.PointerType;
import llvm.StructType;
import llvm.Type_vector;
import llvm.Value;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LLVMTamarinSlotLayout
extends TamarinSlotLayout {
    private final StructType m_struct;
    private final PointerType m_structPointerType;
    private final Map<Integer, Pair<List<Value>, TamarinSlotLayout.SlotStorageType>> m_slotIdToGEPIndexes;

    public LLVMTamarinSlotLayout(LLVMTamarinSlotLayout base, Type t2, StructType struct, PointerType structPointerType) {
        super(base, t2);
        this.m_struct = struct;
        this.m_structPointerType = structPointerType;
        this.m_slotIdToGEPIndexes = new HashMap<Integer, Pair<List<Value>, TamarinSlotLayout.SlotStorageType>>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LLVMTamarinSlotLayout(LLVMContext ctx, LLVMTamarinSlotLayout base, Type t2, LLVMStubTypes llvmTypes) {
        super(base, t2);
        this.m_slotIdToGEPIndexes = new HashMap<Integer, Pair<List<Value>, TamarinSlotLayout.SlotStorageType>>();
        TamarinSlotLayout.SlotStorageTypeAndLocalStructIndex[] slots = this.slotsSortedByStructIndex();
        if (slots != null) {
            Type_vector typeVectorForLocalSlots = new Type_vector();
            try {
                for (TamarinSlotLayout.SlotStorageTypeAndLocalStructIndex s2 : slots) {
                    llvm.Type slotLLVMType = this.llvmType(s2.sst, llvmTypes);
                    typeVectorForLocalSlots.add(slotLLVMType);
                }
                StructType structForSlots = StructType.get(ctx, typeVectorForLocalSlots);
                Type_vector typeVectorForStruct = new Type_vector();
                try {
                    if (base.m_struct != null) {
                        typeVectorForStruct.add(base.m_struct);
                    }
                    typeVectorForStruct.add(structForSlots);
                    this.m_struct = StructType.get(ctx, typeVectorForStruct);
                    this.m_structPointerType = PointerType.get(this.m_struct, 0L);
                    Object var13_13 = null;
                    typeVectorForStruct.delete();
                }
                catch (Throwable throwable) {
                    Object var13_14 = null;
                    typeVectorForStruct.delete();
                    throw throwable;
                }
                Object var15_16 = null;
                typeVectorForLocalSlots.delete();
            }
            catch (Throwable throwable) {
                Object var15_17 = null;
                typeVectorForLocalSlots.delete();
                throw throwable;
            }
        }
        this.m_struct = base != null ? base.m_struct : null;
        this.m_structPointerType = base != null ? base.m_structPointerType : null;
    }

    private llvm.Type llvmType(TamarinSlotLayout.SlotStorageType sst, LLVMStubTypes llvmTypes) {
        if (sst == TamarinSlotLayout.SlotStorageType.Int) {
            return llvmTypes.intTy;
        }
        if (sst == TamarinSlotLayout.SlotStorageType.UInt) {
            return llvmTypes.uintTy;
        }
        if (sst == TamarinSlotLayout.SlotStorageType.Boolean) {
            return llvmTypes.BooleanTy;
        }
        if (sst == TamarinSlotLayout.SlotStorageType.Number) {
            return llvmTypes.NumberTy;
        }
        if (sst == TamarinSlotLayout.SlotStorageType.Atom) {
            return llvmTypes.AtomWBTy;
        }
        if (sst == TamarinSlotLayout.SlotStorageType.String) {
            return llvmTypes.StringWBTy;
        }
        if (sst == TamarinSlotLayout.SlotStorageType.Namespace) {
            return llvmTypes.NamespaceWBTy;
        }
        assert (sst == TamarinSlotLayout.SlotStorageType.ScriptObjectPointer);
        return llvmTypes.ScriptObjectWBTy;
    }

    public StructType structType() {
        return this.m_struct;
    }

    public PointerType structPointerType() {
        return this.m_structPointerType;
    }

    public Pair<List<Value>, TamarinSlotLayout.SlotStorageType> getGEPIndexes(LLVMContext ctx, int slotId) {
        assert (slotId <= this.m_type.slotCount);
        Pair<List<Value>, TamarinSlotLayout.SlotStorageType> result = this.m_slotIdToGEPIndexes.get(slotId);
        if (result != null) {
            return result;
        }
        LLVMTamarinSlotLayout tsl = this;
        ArrayList<Constant> indexes = new ArrayList<Constant>();
        IntegerType int32Ty = IntegerType.getInt32Ty(ctx);
        Constant zero = ConstantInt.getNullValue(int32Ty);
        indexes.add(zero);
        while (tsl.base() != null && tsl.base().m_type.slotCount >= slotId) {
            tsl = tsl.base();
            indexes.add(zero);
        }
        assert (slotId <= tsl.m_type.slotCount);
        assert (tsl.m_struct.getNumContainedTypes() >= 2L);
        Constant indexForSlotsStruct = ConstantInt.get((llvm.Type)int32Ty, BigInteger.valueOf(tsl.m_struct.getNumContainedTypes() - 1L));
        indexes.add(indexForSlotsStruct);
        TamarinSlotLayout.SlotStorageTypeAndLocalStructIndex sstAndLSI = tsl.sstAndLocalStructIndex(slotId);
        Constant indexForSlot = ConstantInt.get((llvm.Type)int32Ty, BigInteger.valueOf(sstAndLSI.structIndex));
        indexes.add(indexForSlot);
        if (sstAndLSI.sst.isPointerSlot()) {
            indexes.add(zero);
        }
        result = new Pair(indexes, sstAndLSI.sst);
        this.m_slotIdToGEPIndexes.put(slotId, result);
        return result;
    }

    private LLVMTamarinSlotLayout base() {
        return (LLVMTamarinSlotLayout)this.m_base;
    }
}

