/*
 * Decompiled with CFR 0.152.
 */
package adobe.abc;

import adobe.abc.Algorithms;
import adobe.abc.Edge;
import adobe.abc.Expr;
import adobe.abc.Method;
import adobe.abc.OptimizerConstants;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Block
implements Iterable<Expr>,
Comparable<Block> {
    public Algorithms.Deque<Expr> exprs = new Algorithms.GapBufferDeque<Expr>();
    private Set<Expr> live_out = new HashSet<Expr>();
    public int id;
    public int postorder;
    public Edge[] xsucc = OptimizerConstants.noedges;
    boolean must_isolate_block = false;
    boolean is_backwards_branch_target = false;
    int pos;

    public Block(Method m2, int pos) {
        this.id = m2.getNextBlockId();
        this.pos = pos;
    }

    public boolean hasExpr(Expr e2) {
        return this.exprs.contains(e2);
    }

    private void assertExprNotInBlock(Expr e2) {
        if (this.hasExpr(e2)) {
            throw new IllegalArgumentException("duplicate expr");
        }
    }

    public void appendExpr(Expr e2) {
        this.assertExprNotInBlock(e2);
        if (this.exprs.size() > 0 && this.exprs.peekLast().succ != null) {
            Expr last = this.exprs.removeLast();
            this.exprs.add(e2);
            this.exprs.add(last);
        } else {
            this.exprs.add(e2);
        }
    }

    public void insertExprs(Expr before, Iterable<Expr> i2) {
        assert (this.exprs.indexOf(before) != -1);
        int pos = this.exprs.indexOf(before);
        assert (pos != -1);
        for (Expr e2 : i2) {
            this.exprs.add(pos++, e2);
        }
    }

    public void insertExpr(Expr before, Expr e2) {
        int pos = this.exprs.indexOf(before);
        assert (pos != -1);
        this.exprs.add(pos, e2);
    }

    public void insertExprAfter(Expr after, Expr e2) {
        int pos = this.exprs.indexOf(after);
        assert (pos != -1);
        this.exprs.add(pos + 1, e2);
    }

    public void killRegister(Method m2, int regnum) {
        this.appendExpr(new Expr(m2, 8, -1, regnum));
    }

    public String toString() {
        return 'B' + String.valueOf(this.id);
    }

    public Expr first() {
        return this.exprs.peekFirst();
    }

    public Expr firstNonPhi() {
        for (Expr e2 : this) {
            if (e2.op == 257) continue;
            return e2;
        }
        return null;
    }

    public Expr last() {
        return this.exprs.peekLast();
    }

    public Edge[] succ() {
        if (this.last().succ != null) {
            return this.last().succ;
        }
        return OptimizerConstants.noedges;
    }

    @Override
    public Iterator<Expr> iterator() {
        return this.exprs.iterator();
    }

    public void add(Expr e2) {
        this.exprs.add(e2);
    }

    void addAll(Block b3) {
        this.exprs.addAll(b3.exprs);
    }

    public boolean isEmpty() {
        return this.exprs.isEmpty();
    }

    public int size() {
        return this.exprs.size();
    }

    public void remove(Expr e2) {
        this.exprs.remove(e2);
    }

    @Override
    public int compareTo(Block b3) {
        return this.id - b3.id;
    }

    public void addLiveOut(Expr e2) {
        assert (this.exprs.contains(e2));
        this.live_out.add(e2);
    }

    public Set<Expr> getLiveOut() {
        return this.live_out;
    }
}

