/*
 * Decompiled with CFR 0.152.
 */
package adobe.abc;

import adobe.abc.Block;
import adobe.abc.Edge;
import adobe.abc.Expr;
import adobe.abc.Method;
import adobe.util.GapBufferList;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Algorithms {
    public static Set<Integer> foreach(BitSet x2) {
        TreeSet<Integer> result = new TreeSet<Integer>();
        for (int i2 = 0; i2 < x2.length(); ++i2) {
            if (!x2.get(i2)) continue;
            result.add(i2);
        }
        return result;
    }

    public static Map<Block, Block> idoms(Deque<Block> all, SetMap<Block, Edge> pred) {
        boolean changed;
        Block entry = all.peekFirst();
        Block[] doms = new Block[entry.postorder + 1];
        doms[entry.postorder] = entry;
        do {
            changed = false;
            for (Block b3 : all) {
                Block p2;
                Edge e2;
                if (b3 == entry) continue;
                Block new_idom = null;
                Iterator i$ = pred.get(b3).iterator();
                while (i$.hasNext()) {
                    e2 = (Edge)i$.next();
                    p2 = e2.from;
                    if (doms[p2.postorder] == null) continue;
                    new_idom = p2;
                    break;
                }
                i$ = pred.get(b3).iterator();
                while (i$.hasNext()) {
                    e2 = (Edge)i$.next();
                    p2 = e2.from;
                    if (p2 == new_idom || doms[p2.postorder] == null) continue;
                    new_idom = Algorithms.intersect(p2, new_idom, doms);
                }
                if (doms[b3.postorder] == new_idom) continue;
                doms[b3.postorder] = new_idom;
                changed = true;
            }
        } while (changed);
        TreeMap<Block, Block> map = new TreeMap<Block, Block>();
        for (Block b4 : all) {
            if (b4 == entry) continue;
            map.put(b4, doms[b4.postorder]);
        }
        return map;
    }

    public static Block intersect(Block b12, Block b22, Block[] doms) {
        while (b12 != b22) {
            while (b12.postorder < b22.postorder) {
                b12 = doms[b12.postorder];
            }
            while (b22.postorder < b12.postorder) {
                b22 = doms[b22.postorder];
            }
        }
        return b12;
    }

    public static boolean dominates(Block p2, Block s2, Map<Block, Block> idom) {
        Block b3 = s2;
        while (b3 != null) {
            if (b3 == p2) {
                return true;
            }
            b3 = idom.get(b3);
        }
        return false;
    }

    public static SetMap<Block, Edge> preds(Deque<Block> code) {
        SetMap<Block, Edge> pred = new SetMap<Block, Edge>();
        for (Block b3 : code) {
            for (Edge s2 : b3.succ()) {
                pred.get(s2.to).add(s2);
            }
        }
        return pred;
    }

    static void checkPredecessors(SetMap<Block, Edge> pred, Deque<Block> code) {
        block0: for (Block b3 : code) {
            for (Expr e2 : b3) {
                if (e2.op != 257) continue block0;
                TreeSet<Edge> phi_in = new TreeSet<Edge>();
                for (Edge p2 : e2.pred) {
                    phi_in.add(p2);
                }
                Object blk_in = pred.get(b3);
                assert (((Object)phi_in).equals(blk_in));
            }
        }
    }

    static SetMap<Block, Edge> allpreds(Deque<Block> code) {
        SetMap<Block, Edge> pred = new SetMap<Block, Edge>();
        for (Block b3 : code) {
            for (Edge s2 : b3.succ()) {
                pred.get(s2.to).add(s2);
            }
            for (Edge x2 : b3.xsucc) {
                pred.get(x2.to).add(x2);
            }
        }
        return pred;
    }

    public static void addUses(Expr e2, EdgeMap<Expr> uses) {
        for (Expr a : e2.args) {
            uses.get(a).add(e2);
        }
        for (Expr a : e2.locals) {
            uses.get(a).add(e2);
        }
        for (Expr a : e2.scopes) {
            uses.get(a).add(e2);
        }
    }

    public static void removeUses(Expr e2, EdgeMap<Expr> uses) {
        for (Expr a : e2.args) {
            uses.get(a).remove(e2);
        }
        for (Expr a : e2.locals) {
            uses.get(a).remove(e2);
        }
        for (Expr a : e2.scopes) {
            uses.get(a).remove(e2);
        }
    }

    public static EdgeMap<Expr> findUses(Deque<Block> code) {
        EdgeMap<Expr> uses = new EdgeMap<Expr>();
        for (Block b3 : code) {
            for (Expr e2 : b3) {
                Algorithms.addUses(e2, uses);
            }
        }
        return uses;
    }

    private static void dfs_visit_el(Edge[] el, BitSet visited, Deque<Block> list) {
        for (int i2 = el.length - 1; i2 >= 0; --i2) {
            Algorithms.dfs_visit(el[i2].to, visited, list);
        }
    }

    private static Deque<Block> dfs_visit(Block b3, BitSet visited, Deque<Block> list) {
        if (!visited.get(b3.id)) {
            visited.set(b3.id);
            Algorithms.dfs_visit_el(b3.xsucc, visited, list);
            Algorithms.dfs_visit_el(b3.succ(), visited, list);
            b3.postorder = list.size();
            list.addFirst(b3);
        }
        return list;
    }

    public static Deque<Block> dfs(Block entry) {
        return Algorithms.dfs_visit(entry, new BitSet(), new LinkedDeque<Block>());
    }

    public static Block getBlock(Set<Block> work) {
        Iterator<Block> i2 = work.iterator();
        Block b3 = i2.next();
        i2.remove();
        return b3;
    }

    public static Expr getExpr(ExprWorkQueue work) {
        return work.remove();
    }

    public static Edge getEdge(Set<Edge> work) {
        Iterator<Edge> i2 = work.iterator();
        Edge e2 = i2.next();
        i2.remove();
        return e2;
    }

    public static Method getMethod(List<Method> list) {
        return list.remove(list.size() - 1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TopologicalSort<T> {
        public List<T> toplogicalSort(List<T> unsorted, DependencyChecker<T> checker) {
            HashMap dep = new HashMap(unsorted.size());
            for (T x2 : unsorted) {
                HashSet<T> parents = new HashSet<T>();
                dep.put(x2, parents);
                for (T y2 : unsorted) {
                    if (x2 == y2 || !checker.depends(x2, y2)) continue;
                    if (checker.depends(y2, x2)) {
                        throw new IllegalArgumentException("Cyclical graphs can't be topologically sorted.");
                    }
                    parents.add(y2);
                }
            }
            ArrayList sorted = new ArrayList(unsorted.size());
            while (dep.size() > 0) {
                boolean found_sorted_element = false;
                for (Object x3 : dep.keySet()) {
                    if (0 != ((Set)dep.get(x3)).size()) continue;
                    sorted.add(x3);
                    found_sorted_element = true;
                    for (T y3 : unsorted) {
                        if (!dep.containsKey(y3)) continue;
                        ((Set)dep.get(y3)).remove(x3);
                    }
                    dep.remove(x3);
                    break;
                }
                if (found_sorted_element) continue;
                throw new IllegalArgumentException("Cyclical graphs can't be topologically sorted.");
            }
            return sorted;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static interface DependencyChecker<T> {
            public boolean depends(T var1, T var2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ExprWorkQueue {
        private Map<Expr, Link> m_links = new HashMap<Expr, Link>();
        private Link m_head = new Link(null);
        private Link m_tail = new Link(null);
        private EdgeMap<Expr> m_uses;

        public ExprWorkQueue(EdgeMap<Expr> uses) {
            this.m_uses = uses;
            this.m_head.m_next = this.m_tail;
            this.m_tail.m_prev = this.m_head;
        }

        public void add(Expr e2) {
            if (!this.m_links.containsKey(e2)) {
                Link newLink = new Link(e2);
                HashSet<Expr> uses = new HashSet<Expr>();
                Iterator i$ = this.m_uses.get(e2).iterator();
                while (i$.hasNext()) {
                    Expr a = (Expr)i$.next();
                    if (!this.m_links.containsKey(a)) continue;
                    uses.add(a);
                }
                this.m_links.put(e2, newLink);
                if (uses.size() == 1) {
                    Link user = this.m_links.get(uses.iterator().next());
                    newLink.insert(user);
                } else {
                    Link l2 = this.m_tail;
                    while (!uses.isEmpty()) {
                        l2 = l2.m_prev;
                        uses.remove(l2.m_e);
                    }
                    assert (l2 != this.m_head);
                    newLink.insert(l2);
                }
            }
        }

        public void addAll(Collection<Expr> c2) {
            for (Expr e2 : c2) {
                this.add(e2);
            }
        }

        public Expr remove() {
            Link l2 = this.m_head.m_next;
            assert (l2 != this.m_tail);
            assert (l2.m_e != null);
            l2.remove();
            this.m_links.remove(l2.m_e);
            return l2.m_e;
        }

        public boolean isEmpty() {
            return this.m_links.size() == 0;
        }

        static class Link {
            public Expr m_e;
            public Link m_next;
            public Link m_prev;

            public Link(Expr e2) {
                this.m_e = e2;
            }

            public void insert(Link before) {
                this.m_next = before;
                this.m_prev = before.m_prev;
                before.m_prev.m_next = this;
                before.m_prev = this;
            }

            public void remove() {
                this.m_prev.m_next = this.m_next;
                this.m_next.m_prev = this.m_prev;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Pool<T extends Comparable<?>> {
        private final Map<T, Integer> refs = new HashMap<T, Integer>();
        private ArrayList<T> m_values;
        int countFrom;
        private final Policy<T> m_policy;
        private final Comparator<T> m_comparator;

        private Comparator<T> defaultComparator() {
            return new Comparator<T>(){

                @Override
                public int compare(T a, T b3) {
                    return (Integer)Pool.this.refs.get(a) - (Integer)Pool.this.refs.get(b3);
                }
            };
        }

        public static <T extends Comparable<?>> Policy<T> defaultPolicy(Class<T> unused) {
            return new Policy<T>(){

                @Override
                public boolean isValueForId0(T value) {
                    return value == null;
                }
            };
        }

        Pool(int countFrom, Comparator<T> comparator, Policy<T> policy) {
            this.countFrom = countFrom;
            this.m_comparator = comparator;
            this.m_policy = policy;
        }

        Pool(int countFrom) {
            this.countFrom = countFrom;
            this.m_comparator = this.defaultComparator();
            this.m_policy = Pool.defaultPolicy(null);
        }

        Pool(int countFrom, Comparator<T> comparator) {
            this.countFrom = countFrom;
            this.m_comparator = comparator;
            this.m_policy = Pool.defaultPolicy(null);
        }

        Pool(int countFrom, Policy<T> policy) {
            this(countFrom, null, policy);
        }

        int add(T e2) {
            if (this.m_policy.isValueForId0(e2)) {
                return 0;
            }
            int n2 = !this.refs.containsKey(e2) ? 1 : this.refs.get(e2) + 1;
            this.refs.put(e2, n2);
            return n2;
        }

        void sort() {
            this.m_values = new ArrayList();
            if (!this.refs.isEmpty()) {
                Set<Comparable> keySet = this.refs.keySet();
                Object[] keySetArray = keySet.toArray();
                Comparable[] emptyArray = (Comparable[])Array.newInstance(keySetArray[0].getClass(), 0);
                Comparable[] valuesArray = keySet.toArray(emptyArray);
                Arrays.sort(valuesArray, this.m_comparator);
                int i2 = this.countFrom;
                for (Comparable item : valuesArray) {
                    this.m_values.add(item);
                    this.refs.put(item, i2++);
                }
            }
        }

        int id(T e2) {
            if (this.m_policy.isValueForId0(e2)) {
                return 0;
            }
            assert (this.refs.containsKey(e2));
            assert (this.refs.get(e2) < this.size());
            return this.refs.get(e2);
        }

        public String toString() {
            return String.valueOf(this.refs);
        }

        int size() {
            return this.countFrom + this.refs.size();
        }

        List<T> values() {
            return Collections.unmodifiableList(this.m_values);
        }

        String refsString() {
            return this.refs.toString();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class Ranker<T>
        implements Comparable<Ranker<T>> {
            T value;
            int rank;

            Ranker(T value, int rank) {
                this.value = value;
                this.rank = rank;
            }

            @Override
            public int compareTo(Ranker<T> o2) {
                return o2.rank - this.rank;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static interface Policy<T extends Comparable<?>> {
            public boolean isValueForId0(T var1);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class LinkedDeque<E>
    extends LinkedList<E>
    implements Deque<E> {
        public static final long serialVersionUID = 0L;

        @Override
        public E peekFirst() {
            return this.isEmpty() ? null : (E)this.getFirst();
        }

        @Override
        public E peekLast() {
            return this.isEmpty() ? null : (E)this.getLast();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class GapBufferDeque<E>
    extends GapBufferList<E>
    implements Deque<E> {
        public static final long serialVersionUID = 0L;

        public GapBufferDeque() {
        }

        public GapBufferDeque(Collection<E> c2) {
            this.addAll(c2);
        }

        @Override
        public void addFirst(E e2) {
            this.add(0, e2);
        }

        @Override
        public E removeFirst() {
            return this.remove(0);
        }

        @Override
        public E peekFirst() {
            return this.isEmpty() ? null : (E)this.get(0);
        }

        @Override
        public E removeLast() {
            return this.remove(this.size() - 1);
        }

        @Override
        public E peekLast() {
            return this.isEmpty() ? null : (E)this.get(this.size() - 1);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Deque<E>
    extends List<E> {
        @Override
        public E removeFirst();

        public E peekFirst();

        @Override
        public E removeLast();

        public E peekLast();

        @Override
        public void addFirst(E var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EdgeMap<E>
    extends SetMap<E, E> {
        static final long serialVersionUID = 0L;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SetMap<K, V>
    extends HashMap<K, Set<V>> {
        static final long serialVersionUID = 0L;

        @Override
        public Set<V> get(Object e2) {
            HashSet s2 = (HashSet)super.get(e2);
            if (s2 == null) {
                s2 = new HashSet();
                this.put(e2, s2);
            }
            return s2;
        }
    }
}

