/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.serializer;

import java.io.IOException;
import java.io.Writer;
import org.apache.xml.serializer.SerializerTrace;

public class SerializerTraceWriter
extends Writer {
    private final Writer m_writer;
    private final SerializerTrace m_tracer;
    private int buf_length;
    private byte[] buf;
    private int count;

    private void setBufferSize(int size) {
        this.buf = new byte[size + 3];
        this.buf_length = size;
        this.count = 0;
    }

    public SerializerTraceWriter(Writer out, SerializerTrace tracer) {
        this.m_writer = out;
        this.m_tracer = tracer;
        this.setBufferSize(1024);
    }

    private void flushBuffer() throws IOException {
        if (this.count > 0) {
            char[] chars = new char[this.count];
            int i = 0;
            while (i < this.count) {
                chars[i] = (char)this.buf[i];
                ++i;
            }
            if (this.m_tracer != null) {
                this.m_tracer.fireGenerateEvent(12, chars, 0, chars.length);
            }
            this.count = 0;
        }
    }

    public void flush() throws IOException {
        if (this.m_writer != null) {
            this.m_writer.flush();
        }
        this.flushBuffer();
    }

    public void close() throws IOException {
        if (this.m_writer != null) {
            this.m_writer.close();
        }
        this.flushBuffer();
    }

    public void write(int c2) throws IOException {
        if (this.m_writer != null) {
            this.m_writer.write(c2);
        }
        if (this.count >= this.buf_length) {
            this.flushBuffer();
        }
        if (c2 < 128) {
            this.buf[this.count++] = (byte)c2;
        } else if (c2 < 2048) {
            this.buf[this.count++] = (byte)(192 + (c2 >> 6));
            this.buf[this.count++] = (byte)(128 + (c2 & 0x3F));
        } else {
            this.buf[this.count++] = (byte)(224 + (c2 >> 12));
            this.buf[this.count++] = (byte)(128 + (c2 >> 6 & 0x3F));
            this.buf[this.count++] = (byte)(128 + (c2 & 0x3F));
        }
    }

    public void write(char[] chars, int start, int length) throws IOException {
        int lengthx3;
        if (this.m_writer != null) {
            this.m_writer.write(chars, start, length);
        }
        if ((lengthx3 = (length << 1) + length) >= this.buf_length) {
            this.flushBuffer();
            this.setBufferSize(2 * lengthx3);
        }
        if (lengthx3 > this.buf_length - this.count) {
            this.flushBuffer();
        }
        int n = length + start;
        int i = start;
        while (i < n) {
            char c2 = chars[i];
            if (c2 < '\u0080') {
                this.buf[this.count++] = (byte)c2;
            } else if (c2 < '\u0800') {
                this.buf[this.count++] = (byte)(192 + (c2 >> 6));
                this.buf[this.count++] = (byte)(128 + (c2 & 0x3F));
            } else {
                this.buf[this.count++] = (byte)(224 + (c2 >> 12));
                this.buf[this.count++] = (byte)(128 + (c2 >> 6 & 0x3F));
                this.buf[this.count++] = (byte)(128 + (c2 & 0x3F));
            }
            ++i;
        }
    }

    public void write(String s) throws IOException {
        int length;
        int lengthx3;
        if (this.m_writer != null) {
            this.m_writer.write(s);
        }
        if ((lengthx3 = ((length = s.length()) << 1) + length) >= this.buf_length) {
            this.flushBuffer();
            this.setBufferSize(2 * lengthx3);
        }
        if (lengthx3 > this.buf_length - this.count) {
            this.flushBuffer();
        }
        int i = 0;
        while (i < length) {
            char c2 = s.charAt(i);
            if (c2 < '\u0080') {
                this.buf[this.count++] = (byte)c2;
            } else if (c2 < '\u0800') {
                this.buf[this.count++] = (byte)(192 + (c2 >> 6));
                this.buf[this.count++] = (byte)(128 + (c2 & 0x3F));
            } else {
                this.buf[this.count++] = (byte)(224 + (c2 >> 12));
                this.buf[this.count++] = (byte)(128 + (c2 >> 6 & 0x3F));
                this.buf[this.count++] = (byte)(128 + (c2 & 0x3F));
            }
            ++i;
        }
    }
}

