/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.xsltc.cmdline.getopt;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.apache.xalan.xsltc.cmdline.getopt.IllegalArgumentException;
import org.apache.xalan.xsltc.cmdline.getopt.MissingOptArgException;
import org.apache.xalan.xsltc.compiler.util.ErrorMsg;

public class GetOpt {
    private Option theCurrentOption = null;
    private ListIterator theOptionsIterator;
    private List theOptions = new ArrayList();
    private List theCmdArgs = null;
    private OptionMatcher theOptionMatcher = null;

    public GetOpt(String[] args, String optString) {
        int currOptIndex = 0;
        this.theCmdArgs = new ArrayList();
        this.theOptionMatcher = new OptionMatcher(optString);
        int i = 0;
        while (i < args.length) {
            String token = args[i];
            int tokenLength = token.length();
            if (token.equals("--")) {
                currOptIndex = i + 1;
                break;
            }
            if (token.startsWith("-") && tokenLength == 2) {
                this.theOptions.add(new Option(token.charAt(1)));
            } else if (token.startsWith("-") && tokenLength > 2) {
                int j = 1;
                while (j < tokenLength) {
                    this.theOptions.add(new Option(token.charAt(j)));
                    ++j;
                }
            } else if (!token.startsWith("-")) {
                if (this.theOptions.size() == 0) {
                    currOptIndex = i;
                    break;
                }
                int indexoflast = 0;
                indexoflast = this.theOptions.size() - 1;
                Option op = (Option)this.theOptions.get(indexoflast);
                char opLetter = op.getArgLetter();
                if (!op.hasArg() && this.theOptionMatcher.hasArg(opLetter)) {
                    op.setArg(token);
                } else {
                    currOptIndex = i;
                    break;
                }
            }
            ++i;
        }
        this.theOptionsIterator = this.theOptions.listIterator();
        int i2 = currOptIndex;
        while (i2 < args.length) {
            String token = args[i2];
            this.theCmdArgs.add(token);
            ++i2;
        }
    }

    public void printOptions() {
        ListIterator it = this.theOptions.listIterator();
        while (it.hasNext()) {
            Option opt = (Option)it.next();
            System.out.print("OPT =" + opt.getArgLetter());
            String arg = opt.getArgument();
            if (arg != null) {
                System.out.print(" " + arg);
            }
            System.out.println();
        }
    }

    public int getNextOption() throws IllegalArgumentException, MissingOptArgException {
        int retval = -1;
        if (this.theOptionsIterator.hasNext()) {
            this.theCurrentOption = (Option)this.theOptionsIterator.next();
            char c2 = this.theCurrentOption.getArgLetter();
            boolean shouldHaveArg = this.theOptionMatcher.hasArg(c2);
            String arg = this.theCurrentOption.getArgument();
            if (!this.theOptionMatcher.match(c2)) {
                ErrorMsg msg = new ErrorMsg("ILLEGAL_CMDLINE_OPTION_ERR", new Character(c2));
                throw new IllegalArgumentException(msg.toString());
            }
            if (shouldHaveArg && arg == null) {
                ErrorMsg msg = new ErrorMsg("CMDLINE_OPT_MISSING_ARG_ERR", new Character(c2));
                throw new MissingOptArgException(msg.toString());
            }
            retval = c2;
        }
        return retval;
    }

    public String getOptionArg() {
        String retval = null;
        String tmp = this.theCurrentOption.getArgument();
        char c2 = this.theCurrentOption.getArgLetter();
        if (this.theOptionMatcher.hasArg(c2)) {
            retval = tmp;
        }
        return retval;
    }

    public String[] getCmdArgs() {
        String[] retval = new String[this.theCmdArgs.size()];
        int i = 0;
        ListIterator it = this.theCmdArgs.listIterator();
        while (it.hasNext()) {
            retval[i++] = (String)it.next();
        }
        return retval;
    }

    class OptionMatcher {
        private String theOptString = null;

        public OptionMatcher(String optString) {
            this.theOptString = optString;
        }

        public boolean match(char c2) {
            boolean retval = false;
            if (this.theOptString.indexOf(c2) != -1) {
                retval = true;
            }
            return retval;
        }

        public boolean hasArg(char c2) {
            boolean retval = false;
            int index = this.theOptString.indexOf(c2) + 1;
            if (index == this.theOptString.length()) {
                retval = false;
            } else if (this.theOptString.charAt(index) == ':') {
                retval = true;
            }
            return retval;
        }
    }

    class Option {
        private char theArgLetter;
        private String theArgument = null;

        public Option(char argLetter) {
            this.theArgLetter = argLetter;
        }

        public void setArg(String arg) {
            this.theArgument = arg;
        }

        public boolean hasArg() {
            return this.theArgument != null;
        }

        public char getArgLetter() {
            return this.theArgLetter;
        }

        public String getArgument() {
            return this.theArgument;
        }
    }
}

