/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.util.introspection;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.velocity.util.introspection.ClassMap;

public class IntrospectorBase {
    protected Map classMethodMaps = new HashMap();
    protected Set cachedClassNames = new HashSet();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Method getMethod(Class c2, String name, Object[] params) throws Exception {
        if (c2 == null) {
            throw new Exception("Introspector.getMethod(): Class method key was null: " + name);
        }
        ClassMap classMap = null;
        Map map = this.classMethodMaps;
        synchronized (map) {
            classMap = (ClassMap)this.classMethodMaps.get(c2);
            if (classMap == null) {
                if (this.cachedClassNames.contains(c2.getName())) {
                    this.clearCache();
                }
                classMap = this.createClassMap(c2);
            }
        }
        return classMap.findMethod(name, params);
    }

    protected ClassMap createClassMap(Class c2) {
        ClassMap classMap = new ClassMap(c2);
        this.classMethodMaps.put(c2, classMap);
        this.cachedClassNames.add(c2.getName());
        return classMap;
    }

    protected void clearCache() {
        this.classMethodMaps.clear();
        this.cachedClassNames = new HashSet();
    }
}

