/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.util.introspection;

import java.lang.reflect.Method;
import org.apache.velocity.runtime.RuntimeLogger;
import org.apache.velocity.util.introspection.IntrospectorBase;
import org.apache.velocity.util.introspection.MethodMap;

public class Introspector
extends IntrospectorBase {
    public static final String CACHEDUMP_MSG = "Introspector : detected classloader change. Dumping cache.";
    private RuntimeLogger rlog = null;

    public Introspector(RuntimeLogger logger) {
        this.rlog = logger;
    }

    public Method getMethod(Class c2, String name, Object[] params) throws Exception {
        try {
            return super.getMethod(c2, name, params);
        }
        catch (MethodMap.AmbiguousException ae) {
            String msg = "Introspection Error : Ambiguous method invocation " + name + "( ";
            for (int i = 0; i < params.length; ++i) {
                if (i > 0) {
                    msg = msg + ", ";
                }
                msg = msg + params[i].getClass().getName();
            }
            msg = msg + ") for class " + c2;
            this.rlog.error(msg);
            return null;
        }
    }

    protected void clearCache() {
        super.clearCache();
        this.rlog.info(CACHEDUMP_MSG);
    }
}

