/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.test;

import java.io.StringWriter;
import java.io.Writer;
import junit.framework.Test;
import junit.framework.TestCase;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.MethodInvocationException;

public class MethodInvocationExceptionTest
extends TestCase {
    public MethodInvocationExceptionTest() {
        super("MethodInvocationExceptionTest");
        try {
            Velocity.init();
        }
        catch (Exception e2) {
            System.err.println("Cannot setup MethodInvocationExceptionTest : " + e2);
            System.exit(1);
        }
    }

    public static Test suite() {
        return new MethodInvocationExceptionTest();
    }

    public void runTest() {
        Throwable t;
        String template = "$woogie.doException() boing!";
        VelocityContext vc = new VelocityContext();
        vc.put("woogie", (Object)this);
        StringWriter w = new StringWriter();
        try {
            Velocity.evaluate((Context)vc, (Writer)w, "test", template);
            MethodInvocationExceptionTest.fail((String)"No exception thrown");
        }
        catch (MethodInvocationException mie) {
            System.out.println("Caught MIE (good!) :");
            System.out.println("  reference = " + mie.getReferenceName());
            System.out.println("  method    = " + mie.getMethodName());
            t = mie.getWrappedThrowable();
            System.out.println("  throwable = " + t);
            if (t instanceof Exception) {
                System.out.println("  exception = " + ((Exception)t).getMessage());
            }
        }
        catch (Exception e2) {
            MethodInvocationExceptionTest.fail((String)("Wrong exception thrown, first test." + e2));
            e2.printStackTrace();
        }
        template = "$woogie.foo boing!";
        try {
            Velocity.evaluate((Context)vc, (Writer)w, "test", template);
            MethodInvocationExceptionTest.fail((String)"No exception thrown, second test.");
        }
        catch (MethodInvocationException mie) {
            System.out.println("Caught MIE (good!) :");
            System.out.println("  reference = " + mie.getReferenceName());
            System.out.println("  method    = " + mie.getMethodName());
            t = mie.getWrappedThrowable();
            System.out.println("  throwable = " + t);
            if (t instanceof Exception) {
                System.out.println("  exception = " + ((Exception)t).getMessage());
            }
        }
        catch (Exception e3) {
            MethodInvocationExceptionTest.fail((String)"Wrong exception thrown, second test");
        }
        template = "$woogie.Foo boing!";
        try {
            Velocity.evaluate((Context)vc, (Writer)w, "test", template);
            MethodInvocationExceptionTest.fail((String)"No exception thrown, third test.");
        }
        catch (MethodInvocationException mie) {
            System.out.println("Caught MIE (good!) :");
            System.out.println("  reference = " + mie.getReferenceName());
            System.out.println("  method    = " + mie.getMethodName());
            t = mie.getWrappedThrowable();
            System.out.println("  throwable = " + t);
            if (t instanceof Exception) {
                System.out.println("  exception = " + ((Exception)t).getMessage());
            }
        }
        catch (Exception e4) {
            MethodInvocationExceptionTest.fail((String)"Wrong exception thrown, third test");
        }
        template = "#set($woogie.foo = 'lala') boing!";
        try {
            Velocity.evaluate((Context)vc, (Writer)w, "test", template);
            MethodInvocationExceptionTest.fail((String)"No exception thrown, set test.");
        }
        catch (MethodInvocationException mie) {
            System.out.println("Caught MIE (good!) :");
            System.out.println("  reference = " + mie.getReferenceName());
            System.out.println("  method    = " + mie.getMethodName());
            t = mie.getWrappedThrowable();
            System.out.println("  throwable = " + t);
            if (t instanceof Exception) {
                System.out.println("  exception = " + ((Exception)t).getMessage());
            }
        }
        catch (Exception e5) {
            MethodInvocationExceptionTest.fail((String)"Wrong exception thrown, set test");
        }
    }

    public void doException() throws Exception {
        throw new NullPointerException();
    }

    public void getFoo() throws Exception {
        throw new Exception("Hello from getFoo()");
    }

    public void setFoo(String foo) throws Exception {
        throw new Exception("Hello from setFoo()");
    }
}

