/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.test;

import java.io.FileWriter;
import java.util.Iterator;
import java.util.Vector;
import junit.framework.Test;
import org.apache.commons.collections.ExtendedProperties;
import org.apache.velocity.test.BaseTestCase;

public class CommonsExtPropTestCase
extends BaseTestCase {
    private static final String COMPARE_DIR = "../test/configuration/compare";
    private static final String RESULTS_DIR = "../test/configuration/results";
    private static final String TEST_CONFIG = "../test/configuration/test.config";

    public CommonsExtPropTestCase() {
        super("CommonsExtPropTestCase");
    }

    public static Test suite() {
        return new CommonsExtPropTestCase();
    }

    public void runTest() {
        try {
            CommonsExtPropTestCase.assureResultsDirectoryExists(RESULTS_DIR);
            ExtendedProperties c2 = new ExtendedProperties(TEST_CONFIG);
            FileWriter result = new FileWriter(CommonsExtPropTestCase.getFileName(RESULTS_DIR, "output", "res"));
            this.message(result, "Testing order of keys ...");
            this.showIterator(result, c2.getKeys());
            this.message(result, "Testing retrieval of CSV values ...");
            this.showVector(result, c2.getVector("resource.loader"));
            this.message(result, "Testing subset(prefix).getKeys() ...");
            ExtendedProperties subset = c2.subset("file.resource.loader");
            this.showIterator(result, subset.getKeys());
            this.message(result, "Testing getVector(prefix) ...");
            this.showVector(result, subset.getVector("path"));
            this.message(result, "Testing getString(key) ...");
            result.write(c2.getString("config.string.value"));
            result.write("\n\n");
            this.message(result, "Testing getBoolean(key) ...");
            result.write(new Boolean(c2.getBoolean("config.boolean.value")).toString());
            result.write("\n\n");
            this.message(result, "Testing getByte(key) ...");
            result.write(new Byte(c2.getByte("config.byte.value")).toString());
            result.write("\n\n");
            this.message(result, "Testing getShort(key) ...");
            result.write(new Short(c2.getShort("config.short.value")).toString());
            result.write("\n\n");
            this.message(result, "Testing getInt(key) ...");
            result.write(new Integer(c2.getInt("config.int.value")).toString());
            result.write("\n\n");
            this.message(result, "Testing getLong(key) ...");
            result.write(new Long(c2.getLong("config.long.value")).toString());
            result.write("\n\n");
            this.message(result, "Testing getFloat(key) ...");
            result.write(new Float(c2.getFloat("config.float.value")).toString());
            result.write("\n\n");
            this.message(result, "Testing getDouble(key) ...");
            result.write(new Double(c2.getDouble("config.double.value")).toString());
            result.write("\n\n");
            this.message(result, "Testing escaped-comma scalar...");
            result.write(c2.getString("escape.comma1"));
            result.write("\n\n");
            this.message(result, "Testing escaped-comma vector...");
            this.showVector(result, c2.getVector("escape.comma2"));
            result.write("\n\n");
            result.flush();
            result.close();
            if (!this.isMatch(RESULTS_DIR, COMPARE_DIR, "output", "res", "cmp")) {
                CommonsExtPropTestCase.fail((String)"Output incorrect.");
            }
        }
        catch (Exception e2) {
            System.err.println("Cannot setup CommonsExtPropTestCase!");
            e2.printStackTrace();
            System.exit(1);
        }
    }

    private void showIterator(FileWriter result, Iterator i) throws Exception {
        while (i.hasNext()) {
            result.write((String)i.next());
            result.write("\n");
        }
        result.write("\n");
    }

    private void showVector(FileWriter result, Vector v) throws Exception {
        for (int j = 0; j < v.size(); ++j) {
            result.write((String)v.get(j));
            result.write("\n");
        }
        result.write("\n");
    }

    private void message(FileWriter result, String message) throws Exception {
        result.write("--------------------------------------------------\n");
        result.write(message + "\n");
        result.write("--------------------------------------------------\n");
        result.write("\n");
    }
}

