/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.runtime;

import java.util.Hashtable;
import org.apache.velocity.runtime.RuntimeServices;
import org.apache.velocity.runtime.directive.VelocimacroProxy;
import org.apache.velocity.runtime.parser.node.Node;

public class VelocimacroManager {
    private RuntimeServices rsvc = null;
    private static String GLOBAL_NAMESPACE = "";
    private boolean registerFromLib = false;
    private Hashtable namespaceHash = new Hashtable();
    private Hashtable libraryMap = new Hashtable();
    private boolean namespacesOn = true;
    private boolean inlineLocalMode = false;

    VelocimacroManager(RuntimeServices rs) {
        this.rsvc = rs;
        this.addNamespace(GLOBAL_NAMESPACE);
    }

    public boolean addVM(String vmName, Node macroBody, String[] argArray, String namespace) {
        MacroEntry me = new MacroEntry(this, vmName, macroBody, argArray, namespace);
        me.setFromLibrary(this.registerFromLib);
        boolean isLib = true;
        if (this.registerFromLib) {
            this.libraryMap.put(namespace, namespace);
        } else {
            isLib = this.libraryMap.containsKey(namespace);
        }
        if (!isLib && this.usingNamespaces(namespace)) {
            Hashtable local = this.getNamespace(namespace, true);
            local.put(vmName, me);
            return true;
        }
        MacroEntry exist = (MacroEntry)this.getNamespace(GLOBAL_NAMESPACE).get(vmName);
        if (exist != null) {
            me.setFromLibrary(exist.getFromLibrary());
        }
        this.getNamespace(GLOBAL_NAMESPACE).put(vmName, me);
        return true;
    }

    public VelocimacroProxy get(String vmName, String namespace) {
        MacroEntry me;
        Hashtable local;
        if (this.usingNamespaces(namespace) && (local = this.getNamespace(namespace, false)) != null && (me = (MacroEntry)local.get(vmName)) != null) {
            return me.createVelocimacro(namespace);
        }
        MacroEntry me2 = (MacroEntry)this.getNamespace(GLOBAL_NAMESPACE).get(vmName);
        if (me2 != null) {
            return me2.createVelocimacro(namespace);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean dumpNamespace(String namespace) {
        VelocimacroManager velocimacroManager = this;
        synchronized (velocimacroManager) {
            if (this.usingNamespaces(namespace)) {
                Hashtable h2 = (Hashtable)this.namespaceHash.remove(namespace);
                if (h2 == null) {
                    return false;
                }
                h2.clear();
                return true;
            }
            return false;
        }
    }

    public void setNamespaceUsage(boolean b2) {
        this.namespacesOn = b2;
    }

    public void setRegisterFromLib(boolean b2) {
        this.registerFromLib = b2;
    }

    public void setTemplateLocalInlineVM(boolean b2) {
        this.inlineLocalMode = b2;
    }

    private Hashtable getNamespace(String namespace) {
        return this.getNamespace(namespace, false);
    }

    private Hashtable getNamespace(String namespace, boolean addIfNew) {
        Hashtable h2 = (Hashtable)this.namespaceHash.get(namespace);
        if (h2 == null && addIfNew) {
            h2 = this.addNamespace(namespace);
        }
        return h2;
    }

    private Hashtable addNamespace(String namespace) {
        Hashtable h2 = new Hashtable();
        Hashtable oh = this.namespaceHash.put(namespace, h2);
        if (oh != null) {
            this.namespaceHash.put(namespace, oh);
            return null;
        }
        return h2;
    }

    private boolean usingNamespaces(String namespace) {
        if (!this.namespacesOn) {
            return false;
        }
        return this.inlineLocalMode;
    }

    public String getLibraryName(String vmName, String namespace) {
        MacroEntry me;
        Hashtable local;
        if (this.usingNamespaces(namespace) && (local = this.getNamespace(namespace, false)) != null && (me = (MacroEntry)local.get(vmName)) != null) {
            return null;
        }
        MacroEntry me2 = (MacroEntry)this.getNamespace(GLOBAL_NAMESPACE).get(vmName);
        if (me2 != null) {
            return me2.getSourceTemplate();
        }
        return null;
    }

    protected class MacroEntry {
        String macroname;
        String[] argarray;
        String sourcetemplate;
        Node nodeTree;
        VelocimacroManager manager = null;
        boolean fromLibrary = false;

        MacroEntry(VelocimacroManager vmm, String vmName, Node nodeTree, String[] argArray, String sourceTemplate) {
            this.macroname = vmName;
            this.argarray = argArray;
            this.nodeTree = nodeTree;
            this.sourcetemplate = sourceTemplate;
            this.manager = vmm;
        }

        public void setFromLibrary(boolean b2) {
            this.fromLibrary = b2;
        }

        public boolean getFromLibrary() {
            return this.fromLibrary;
        }

        public Node getNodeTree() {
            return this.nodeTree;
        }

        public String getSourceTemplate() {
            return this.sourcetemplate;
        }

        VelocimacroProxy createVelocimacro(String namespace) {
            VelocimacroProxy vp = new VelocimacroProxy();
            vp.setName(this.macroname);
            vp.setArgArray(this.argarray);
            vp.setNodeTree(this.nodeTree);
            vp.setNamespace(namespace);
            return vp;
        }
    }
}

