/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;
import org.apache.velocity.context.InternalContextAdapterImpl;
import org.apache.velocity.exception.MethodInvocationException;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.runtime.parser.ParseException;
import org.apache.velocity.runtime.parser.node.SimpleNode;
import org.apache.velocity.runtime.resource.Resource;

public class Template
extends Resource {
    private boolean initialized = false;
    private Exception errorCondition = null;

    public boolean process() throws ResourceNotFoundException, ParseErrorException, Exception {
        this.data = null;
        InputStream is = null;
        this.errorCondition = null;
        try {
            is = this.resourceLoader.getResourceStream(this.name);
        }
        catch (ResourceNotFoundException rnfe) {
            this.errorCondition = rnfe;
            throw rnfe;
        }
        if (is != null) {
            try {
                BufferedReader br = new BufferedReader(new InputStreamReader(is, this.encoding));
                this.data = this.rsvc.parse(br, this.name);
                this.initDocument();
                boolean bl = true;
                return bl;
            }
            catch (UnsupportedEncodingException uce) {
                String msg = "Template.process : Unsupported input encoding : " + this.encoding + " for template " + this.name;
                this.errorCondition = new ParseErrorException(msg);
                throw this.errorCondition;
            }
            catch (ParseException pex) {
                this.errorCondition = new ParseErrorException(pex.getMessage());
                throw this.errorCondition;
            }
            catch (Exception e2) {
                this.errorCondition = e2;
                throw e2;
            }
            finally {
                is.close();
            }
        }
        this.errorCondition = new ResourceNotFoundException("Unknown resource error for resource " + this.name);
        throw this.errorCondition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initDocument() throws Exception {
        InternalContextAdapterImpl ica = new InternalContextAdapterImpl(new VelocityContext());
        try {
            ica.pushCurrentTemplateName(this.name);
            ((SimpleNode)this.data).init(ica, this.rsvc);
        }
        finally {
            ica.popCurrentTemplateName();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void merge(Context context, Writer writer) throws ResourceNotFoundException, ParseErrorException, MethodInvocationException, Exception {
        if (this.errorCondition != null) {
            throw this.errorCondition;
        }
        if (this.data != null) {
            InternalContextAdapterImpl ica = new InternalContextAdapterImpl(context);
            try {
                ica.pushCurrentTemplateName(this.name);
                ica.setCurrentResource(this);
                ((SimpleNode)this.data).render(ica, writer);
            }
            finally {
                ica.popCurrentTemplateName();
                ica.setCurrentResource(null);
            }
        } else {
            String msg = "Template.merge() failure. The document is null, most likely due to parsing error.";
            this.rsvc.error(msg);
            throw new Exception(msg);
        }
    }
}

