/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oro.text.regex;

import java.util.HashMap;
import org.apache.oro.text.regex.CharStringPointer;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.OpCode;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.PatternCompiler;
import org.apache.oro.text.regex.Perl5Pattern;

public final class Perl5Compiler
implements PatternCompiler {
    private static final int __WORSTCASE = 0;
    private static final int __NONNULL = 1;
    private static final int __SIMPLE = 2;
    private static final int __SPSTART = 4;
    private static final int __TRYAGAIN = 8;
    private static final char __CASE_INSENSITIVE = '\u0001';
    private static final char __GLOBAL = '\u0002';
    private static final char __KEEP = '\u0004';
    private static final char __MULTILINE = '\b';
    private static final char __SINGLELINE = '\u0010';
    private static final char __EXTENDED = ' ';
    private static final char __READ_ONLY = '\u8000';
    private static final String __META_CHARS = "^$.[()|?+*\\";
    private static final String __HEX_DIGIT = "0123456789abcdef0123456789ABCDEFx";
    private CharStringPointer __input;
    private boolean __sawBackreference;
    private char[] __modifierFlags = new char[1];
    private int __numParentheses;
    private int __programSize;
    private int __cost;
    private char[] __program;
    private static final HashMap __hashPOSIX = new HashMap();
    public static final int DEFAULT_MASK = 0;
    public static final int CASE_INSENSITIVE_MASK = 1;
    public static final int MULTILINE_MASK = 8;
    public static final int SINGLELINE_MASK = 16;
    public static final int EXTENDED_MASK = 32;
    public static final int READ_ONLY_MASK = 32768;

    static {
        __hashPOSIX.put("alnum", new Character('2'));
        __hashPOSIX.put("word", new Character('\u0012'));
        __hashPOSIX.put("alpha", new Character('&'));
        __hashPOSIX.put("blank", new Character('\''));
        __hashPOSIX.put("cntrl", new Character('('));
        __hashPOSIX.put("digit", new Character('\u0018'));
        __hashPOSIX.put("graph", new Character(')'));
        __hashPOSIX.put("lower", new Character('*'));
        __hashPOSIX.put("print", new Character('+'));
        __hashPOSIX.put("punct", new Character(','));
        __hashPOSIX.put("space", new Character('\u0016'));
        __hashPOSIX.put("upper", new Character('-'));
        __hashPOSIX.put("xdigit", new Character('.'));
        __hashPOSIX.put("ascii", new Character('3'));
    }

    private int __emitArgNode(char c2, char c3) {
        int n = this.__programSize;
        if (this.__program == null) {
            this.__programSize += 3;
        } else {
            this.__program[this.__programSize++] = c2;
            this.__program[this.__programSize++] = '\u0000';
            this.__program[this.__programSize++] = c3;
        }
        return n;
    }

    private void __emitCode(char c2) {
        if (this.__program != null) {
            this.__program[this.__programSize] = c2;
        }
        ++this.__programSize;
    }

    private int __emitNode(char c2) {
        int n = this.__programSize;
        if (this.__program == null) {
            this.__programSize += 2;
        } else {
            this.__program[this.__programSize++] = c2;
            this.__program[this.__programSize++] = '\u0000';
        }
        return n;
    }

    private char __getNextChar() {
        char c2 = this.__input._postIncrement();
        while (true) {
            char c3;
            if ((c3 = this.__input._getValue()) == '(' && this.__input._getValueRelative(1) == '?' && this.__input._getValueRelative(2) == '#') {
                while (c3 != '\uffff' && c3 != ')') {
                    c3 = this.__input._increment();
                }
                this.__input._increment();
                continue;
            }
            if ((this.__modifierFlags[0] & 0x20) == 0) break;
            if (Character.isWhitespace(c3)) {
                this.__input._increment();
                continue;
            }
            if (c3 != '#') break;
            while (c3 != '\uffff' && c3 != '\n') {
                c3 = this.__input._increment();
            }
            this.__input._increment();
        }
        return c2;
    }

    private static boolean __isComplexRepetitionOp(char[] cArray, int n) {
        if (n < cArray.length && n >= 0) {
            return cArray[n] == '*' || cArray[n] == '+' || cArray[n] == '?' || cArray[n] == '{' && Perl5Compiler.__parseRepetition(cArray, n);
        }
        return false;
    }

    private static boolean __isSimpleRepetitionOp(char c2) {
        return c2 == '*' || c2 == '+' || c2 == '?';
    }

    private int __parseAlternation(int[] nArray) throws MalformedPatternException {
        int n = 0;
        nArray[0] = 0;
        int n2 = this.__emitNode('\f');
        int n3 = -1;
        if (this.__input._getOffset() == 0) {
            this.__input._setOffset(-1);
            this.__getNextChar();
        } else {
            this.__input._decrement();
            this.__getNextChar();
        }
        char c2 = this.__input._getValue();
        while (c2 != '\uffff' && c2 != '|' && c2 != ')') {
            n &= 0xFFFFFFF7;
            int n4 = this.__parseBranch(nArray);
            if (n4 == -1) {
                if ((n & 8) != 0) {
                    c2 = this.__input._getValue();
                    continue;
                }
                return -1;
            }
            nArray[0] = nArray[0] | n & 1;
            if (n3 == -1) {
                nArray[0] = nArray[0] | n & 4;
            } else {
                ++this.__cost;
                this.__programAddTail(n3, n4);
            }
            n3 = n4;
            c2 = this.__input._getValue();
        }
        if (n3 == -1) {
            this.__emitNode('\u000f');
        }
        return n2;
    }

    /*
     * Unable to fully structure code
     */
    private int __parseAtom(int[] var1_1) throws MalformedPatternException {
        block80: {
            var5_2 = new int[1];
            var1_1[0] = 0;
            var2_3 = false;
            var4_4 = -1;
            block50: while (true) {
                var3_5 = this.__input._getValue();
                switch (var3_5) {
                    case '^': {
                        this.__getNextChar();
                        if ((this.__modifierFlags[0] & 8) != 0) {
                            var4_4 = this.__emitNode('\u0002');
                            break block50;
                        }
                        if ((this.__modifierFlags[0] & 16) != 0) {
                            var4_4 = this.__emitNode('\u0003');
                            break block50;
                        }
                        var4_4 = this.__emitNode('\u0001');
                        break block50;
                    }
                    case '$': {
                        this.__getNextChar();
                        if ((this.__modifierFlags[0] & 8) != 0) {
                            var4_4 = this.__emitNode('\u0005');
                            break block50;
                        }
                        if ((this.__modifierFlags[0] & 16) != 0) {
                            var4_4 = this.__emitNode('\u0006');
                            break block50;
                        }
                        var4_4 = this.__emitNode('\u0004');
                        break block50;
                    }
                    case '.': {
                        this.__getNextChar();
                        var4_4 = (this.__modifierFlags[0] & 16) != 0 ? this.__emitNode('\b') : this.__emitNode('\u0007');
                        ++this.__cost;
                        var1_1[0] = var1_1[0] | 3;
                        break block50;
                    }
                    case '[': {
                        this.__input._increment();
                        var4_4 = this.__parseUnicodeClass();
                        var1_1[0] = var1_1[0] | 3;
                        break block50;
                    }
                    case '(': {
                        this.__getNextChar();
                        var4_4 = this.__parseExpression(true, var5_2);
                        if (var4_4 == -1) {
                            if ((var5_2[0] & 8) != 0) continue block50;
                            return -1;
                        }
                        var1_1[0] = var1_1[0] | var5_2[0] & 5;
                        break block50;
                    }
                    case ')': 
                    case '|': {
                        if ((var5_2[0] & 8) != 0) {
                            var1_1[0] = var1_1[0] | 8;
                            return -1;
                        }
                        throw new MalformedPatternException("Error in expression at " + this.__input._toString(this.__input._getOffset()));
                    }
                    case '*': 
                    case '+': 
                    case '?': {
                        throw new MalformedPatternException("?+* follows nothing in expression");
                    }
                    case '\\': {
                        var3_5 = this.__input._increment();
                        switch (var3_5) {
                            case 'A': {
                                var4_4 = this.__emitNode('\u0003');
                                var1_1[0] = var1_1[0] | 2;
                                this.__getNextChar();
                                break block50;
                            }
                            case 'G': {
                                var4_4 = this.__emitNode('\u001e');
                                var1_1[0] = var1_1[0] | 2;
                                this.__getNextChar();
                                break block50;
                            }
                            case 'Z': {
                                var4_4 = this.__emitNode('\u0006');
                                var1_1[0] = var1_1[0] | 2;
                                this.__getNextChar();
                                break block50;
                            }
                            case 'w': {
                                var4_4 = this.__emitNode('\u0012');
                                var1_1[0] = var1_1[0] | 3;
                                this.__getNextChar();
                                break block50;
                            }
                            case 'W': {
                                var4_4 = this.__emitNode('\u0013');
                                var1_1[0] = var1_1[0] | 3;
                                this.__getNextChar();
                                break block50;
                            }
                            case 'b': {
                                var4_4 = this.__emitNode('\u0014');
                                var1_1[0] = var1_1[0] | 2;
                                this.__getNextChar();
                                break block50;
                            }
                            case 'B': {
                                var4_4 = this.__emitNode('\u0015');
                                var1_1[0] = var1_1[0] | 2;
                                this.__getNextChar();
                                break block50;
                            }
                            case 's': {
                                var4_4 = this.__emitNode('\u0016');
                                var1_1[0] = var1_1[0] | 3;
                                this.__getNextChar();
                                break block50;
                            }
                            case 'S': {
                                var4_4 = this.__emitNode('\u0017');
                                var1_1[0] = var1_1[0] | 3;
                                this.__getNextChar();
                                break block50;
                            }
                            case 'd': {
                                var4_4 = this.__emitNode('\u0018');
                                var1_1[0] = var1_1[0] | 3;
                                this.__getNextChar();
                                break block50;
                            }
                            case 'D': {
                                var4_4 = this.__emitNode('\u0019');
                                var1_1[0] = var1_1[0] | 3;
                                this.__getNextChar();
                                break block50;
                            }
                            case '0': 
                            case 'a': 
                            case 'c': 
                            case 'e': 
                            case 'f': 
                            case 'n': 
                            case 'r': 
                            case 't': 
                            case 'x': {
                                var2_3 = true;
                                break block50;
                            }
                            case '1': 
                            case '2': 
                            case '3': 
                            case '4': 
                            case '5': 
                            case '6': 
                            case '7': 
                            case '8': 
                            case '9': {
                                var7_6 = new StringBuffer(10);
                                var6_8 = '\u0000';
                                var3_5 = this.__input._getValueRelative(var6_8);
                                while (Character.isDigit(var3_5)) {
                                    var7_6.append(var3_5);
                                    var3_5 = this.__input._getValueRelative(++var6_8);
                                }
                                try {
                                    var6_8 = Integer.parseInt(var7_6.toString());
                                }
                                catch (NumberFormatException var8_9) {
                                    throw new MalformedPatternException("Unexpected number format exception.  Please report this bug.NumberFormatException message: " + var8_9.getMessage());
                                }
                                if (var6_8 > '\t' && var6_8 >= this.__numParentheses) {
                                    var2_3 = true;
                                    break block50;
                                }
                                if (var6_8 >= this.__numParentheses) {
                                    throw new MalformedPatternException("Invalid backreference: \\" + var6_8);
                                }
                                this.__sawBackreference = true;
                                var4_4 = this.__emitArgNode('\u001a', var6_8);
                                var1_1[0] = var1_1[0] | 1;
                                var3_5 = this.__input._getValue();
                                while (Character.isDigit(var3_5)) {
                                    var3_5 = this.__input._increment();
                                }
                                this.__input._decrement();
                                this.__getNextChar();
                                break block50;
                            }
                            case '\u0000': 
                            case '\uffff': {
                                if (!this.__input._isAtEnd()) break;
                                throw new MalformedPatternException("Trailing \\ in expression.");
                            }
                        }
                        var2_3 = true;
                        break block50;
                    }
                    case '#': {
                        if ((this.__modifierFlags[0] & 32) != 0) {
                            while (!this.__input._isAtEnd() && this.__input._getValue() != '\n') {
                                this.__input._increment();
                            }
                            if (this.__input._isAtEnd()) ** break;
                            continue block50;
                        }
                    }
                    default: {
                        this.__input._increment();
                        var2_3 = true;
                        break block50;
                    }
                }
                break;
            }
            if (!var2_3) break block80;
            var4_4 = this.__emitNode('\u000e');
            this.__emitCode('\uffff');
            var7_7 = 0;
            var8_10 = this.__input._getOffset() - 1;
            var9_11 = this.__input._getLength();
            block54: while (var7_7 < 127 && var8_10 < var9_11) {
                var10_12 = var8_10;
                var3_5 = this.__input._getValue(var8_10);
                switch (var3_5) {
                    case '\\': {
                        var3_5 = this.__input._getValue(++var8_10);
                        switch (var3_5) {
                            case 'A': 
                            case 'B': 
                            case 'D': 
                            case 'G': 
                            case 'S': 
                            case 'W': 
                            case 'Z': 
                            case 'b': 
                            case 'd': 
                            case 's': 
                            case 'w': {
                                --var8_10;
                                break block54;
                            }
                            case 'n': {
                                var6_8 = '\n';
                                ++var8_10;
                                break;
                            }
                            case 'r': {
                                var6_8 = '\r';
                                ++var8_10;
                                break;
                            }
                            case 't': {
                                var6_8 = '\t';
                                ++var8_10;
                                break;
                            }
                            case 'f': {
                                var6_8 = '\f';
                                ++var8_10;
                                break;
                            }
                            case 'e': {
                                var6_8 = '\u001b';
                                ++var8_10;
                                break;
                            }
                            case 'a': {
                                var6_8 = '\u0007';
                                ++var8_10;
                                break;
                            }
                            case 'x': {
                                var11_13 = new int[1];
                                var6_8 = (char)Perl5Compiler.__parseHex(this.__input._array, ++var8_10, 2, var11_13);
                                var8_10 += var11_13[0];
                                break;
                            }
                            case 'c': {
                                v0 = ++var8_10;
                                ++var8_10;
                                var6_8 = this.__input._getValue(v0);
                                if (Character.isLowerCase(var6_8)) {
                                    var6_8 = Character.toUpperCase(var6_8);
                                }
                                var6_8 = (char)(var6_8 ^ 64);
                                break;
                            }
                            case '0': 
                            case '1': 
                            case '2': 
                            case '3': 
                            case '4': 
                            case '5': 
                            case '6': 
                            case '7': 
                            case '8': 
                            case '9': {
                                var12_14 = false;
                                var3_5 = this.__input._getValue(var8_10);
                                if (var3_5 == '0') {
                                    var12_14 = true;
                                }
                                if (Character.isDigit(var3_5 = this.__input._getValue(var8_10 + 1))) {
                                    var14_16 = new StringBuffer(10);
                                    var13_15 = var8_10;
                                    var3_5 = this.__input._getValue(var13_15);
                                    while (Character.isDigit(var3_5)) {
                                        var14_16.append(var3_5);
                                        var3_5 = this.__input._getValue(++var13_15);
                                    }
                                    try {
                                        var13_15 = Integer.parseInt(var14_16.toString());
                                    }
                                    catch (NumberFormatException var15_17) {
                                        throw new MalformedPatternException("Unexpected number format exception.  Please report this bug.NumberFormatException message: " + var15_17.getMessage());
                                    }
                                    if (!var12_14) {
                                        v1 = var12_14 = var13_15 >= this.__numParentheses;
                                    }
                                }
                                if (var12_14) {
                                    var11_13 = new int[1];
                                    var6_8 = (char)Perl5Compiler.__parseOctal(this.__input._array, var8_10, 3, var11_13);
                                    var8_10 += var11_13[0];
                                    break;
                                }
                                --var8_10;
                                break block54;
                            }
                            case '\u0000': 
                            case '\uffff': {
                                if (var8_10 >= var9_11) {
                                    throw new MalformedPatternException("Trailing \\ in expression.");
                                }
                            }
                            default: {
                                var6_8 = this.__input._getValue(var8_10++);
                                break;
                            }
                        }
                        ** GOTO lbl280
                    }
                    case '#': {
                        if ((this.__modifierFlags[0] & 32) != 0) {
                            while (var8_10 < var9_11 && this.__input._getValue(var8_10) != '\n') {
                                ++var8_10;
                            }
                        }
                    }
                    case '\t': 
                    case '\n': 
                    case '\u000b': 
                    case '\f': 
                    case '\r': 
                    case ' ': {
                        if ((this.__modifierFlags[0] & 32) == 0) ** GOTO lbl278
                        ++var8_10;
                        --var7_7;
                        ** GOTO lbl290
                    }
lbl278:
                    // 2 sources

                    default: {
                        var6_8 = this.__input._getValue(var8_10++);
lbl280:
                        // 2 sources

                        if ((this.__modifierFlags[0] & '\u0001') != 0 && Character.isUpperCase(var6_8)) {
                            var6_8 = Character.toLowerCase(var6_8);
                        }
                        if (var8_10 < var9_11 && Perl5Compiler.__isComplexRepetitionOp(this.__input._array, var8_10)) {
                            if (var7_7 > 0) {
                                var8_10 = var10_12;
                                break block54;
                            }
                            ++var7_7;
                            this.__emitCode(var6_8);
                            break block54;
                        }
                        this.__emitCode(var6_8);
lbl290:
                        // 2 sources

                        ++var7_7;
                        continue block54;
                    }
                    case '$': 
                    case '(': 
                    case ')': 
                    case '.': 
                    case '[': 
                    case '^': 
                    case '|': {
                        break block54;
                    }
                }
            }
            this.__input._setOffset(var8_10 - 1);
            this.__getNextChar();
            if (var7_7 < 0) {
                throw new MalformedPatternException("Unexpected compilation failure.  Please report this bug!");
            }
            if (var7_7 > 0) {
                var1_1[0] = var1_1[0] | 1;
            }
            if (var7_7 == 1) {
                var1_1[0] = var1_1[0] | 2;
            }
            if (this.__program != null) {
                this.__program[OpCode._getOperand((int)var4_4)] = (char)var7_7;
            }
            this.__emitCode('\uffff');
        }
        return var4_4;
    }

    private int __parseBranch(int[] nArray) throws MalformedPatternException {
        boolean bl = false;
        boolean bl2 = false;
        int[] nArray2 = new int[1];
        int n = 0;
        int n2 = 65535;
        int n3 = this.__parseAtom(nArray2);
        if (n3 == -1) {
            if ((nArray2[0] & 8) != 0) {
                nArray[0] = nArray[0] | 8;
            }
            return -1;
        }
        char c2 = this.__input._getValue();
        if (c2 == '(' && this.__input._getValueRelative(1) == '?' && this.__input._getValueRelative(2) == '#') {
            while (c2 != '\uffff' && c2 != ')') {
                c2 = this.__input._increment();
            }
            if (c2 != '\uffff') {
                this.__getNextChar();
                c2 = this.__input._getValue();
            }
        }
        if (c2 == '{' && Perl5Compiler.__parseRepetition(this.__input._array, this.__input._getOffset())) {
            int n4;
            int n5 = this.__input._getOffset() + 1;
            int n6 = n4 = this.__input._getLength();
            char c3 = this.__input._getValue(n5);
            while (Character.isDigit(c3) || c3 == ',') {
                if (c3 == ',') {
                    if (n6 != n4) break;
                    n6 = n5;
                }
                c3 = this.__input._getValue(++n5);
            }
            if (c3 == '}') {
                StringBuffer stringBuffer = new StringBuffer(10);
                if (n6 == n4) {
                    n6 = n5;
                }
                this.__input._increment();
                int n7 = this.__input._getOffset();
                c3 = this.__input._getValue(n7);
                while (Character.isDigit(c3)) {
                    stringBuffer.append(c3);
                    c3 = this.__input._getValue(++n7);
                }
                try {
                    n = Integer.parseInt(stringBuffer.toString());
                }
                catch (NumberFormatException numberFormatException) {
                    throw new MalformedPatternException("Unexpected number format exception.  Please report this bug.NumberFormatException message: " + numberFormatException.getMessage());
                }
                c3 = this.__input._getValue(n6);
                n6 = c3 == ',' ? ++n6 : this.__input._getOffset();
                n7 = n6;
                stringBuffer = new StringBuffer(10);
                c3 = this.__input._getValue(n7);
                while (Character.isDigit(c3)) {
                    stringBuffer.append(c3);
                    c3 = this.__input._getValue(++n7);
                }
                try {
                    if (n7 != n6) {
                        n2 = Integer.parseInt(stringBuffer.toString());
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    throw new MalformedPatternException("Unexpected number format exception.  Please report this bug.NumberFormatException message: " + numberFormatException.getMessage());
                }
                if (n2 == 0 && this.__input._getValue(n6) != '0') {
                    n2 = 65535;
                }
                this.__input._setOffset(n5);
                this.__getNextChar();
                bl = true;
                bl2 = true;
            }
        }
        if (!bl) {
            bl2 = false;
            if (!Perl5Compiler.__isSimpleRepetitionOp(c2)) {
                nArray[0] = nArray2[0];
                return n3;
            }
            this.__getNextChar();
            int n8 = nArray[0] = c2 != '+' ? 4 : 1;
            if (c2 == '*' && (nArray2[0] & 2) != 0) {
                this.__programInsertOperator('\u0010', n3);
                this.__cost += 4;
            } else if (c2 == '*') {
                n = 0;
                bl2 = true;
            } else if (c2 == '+' && (nArray2[0] & 2) != 0) {
                this.__programInsertOperator('\u0011', n3);
                this.__cost += 3;
            } else if (c2 == '+') {
                n = 1;
                bl2 = true;
            } else if (c2 == '?') {
                n = 0;
                n2 = 1;
                bl2 = true;
            }
        }
        if (bl2) {
            if ((nArray2[0] & 2) != 0) {
                this.__cost += (2 + this.__cost) / 2;
                this.__programInsertOperator('\n', n3);
            } else {
                this.__cost += 4 + this.__cost;
                this.__programAddTail(n3, this.__emitNode('\"'));
                this.__programInsertOperator('\u000b', n3);
                this.__programAddTail(n3, this.__emitNode('\u000f'));
            }
            if (n > 0) {
                nArray[0] = 1;
            }
            if (n2 != 0 && n2 < n) {
                throw new MalformedPatternException("Invalid interval {" + n + "," + n2 + "}");
            }
            if (this.__program != null) {
                this.__program[n3 + 2] = (char)n;
                this.__program[n3 + 3] = (char)n2;
            }
        }
        if (this.__input._getValue() == '?') {
            this.__getNextChar();
            this.__programInsertOperator('\u001d', n3);
            this.__programAddTail(n3, n3 + 2);
        }
        if (Perl5Compiler.__isComplexRepetitionOp(this.__input._array, this.__input._getOffset())) {
            throw new MalformedPatternException("Nested repetitions *?+ in expression");
        }
        return n3;
    }

    /*
     * Unable to fully structure code
     */
    private int __parseCharacterClass() throws MalformedPatternException {
        block39: {
            var1_1 = false;
            var5_2 = '\uffff';
            var8_3 = new int[1];
            var6_4 = this.__emitNode('\t');
            if (this.__input._getValue() == '^') {
                ++this.__cost;
                this.__input._increment();
                var4_5 = '\u0000';
            } else {
                var4_5 = '\uffff';
            }
            var7_6 = this.__programSize;
            var3_7 = '\u0000';
            while (var3_7 < '\u0010') {
                this.__emitCode(var4_5);
                var3_7 = (char)(var3_7 + 1);
            }
            var3_7 = this.__input._getValue();
            if (var3_7 != ']' && var3_7 != 45) break block39;
            var2_8 = true;
            ** GOTO lbl143
        }
        var2_8 = false;
        if (true) ** GOTO lbl143
        while (true) {
            var2_8 = false;
            this.__input._increment();
            if (var3_7 != 92) ** GOTO lbl-1000
            var3_7 = this.__input._postIncrement();
            switch (var3_7) {
                case 'w': {
                    var3_7 = '\u0000';
                    while (var3_7 < '\u0100') {
                        if (OpCode._isWordCharacter(var3_7)) {
                            this.__setCharacterClassBits(this.__program, var7_6, var4_5, var3_7);
                        }
                        var3_7 = (char)(var3_7 + '\u0001');
                    }
                    var5_2 = '\uffff';
                    break;
                }
                case 'W': {
                    var3_7 = '\u0000';
                    while (var3_7 < '\u0100') {
                        if (!OpCode._isWordCharacter(var3_7)) {
                            this.__setCharacterClassBits(this.__program, var7_6, var4_5, var3_7);
                        }
                        var3_7 = (char)(var3_7 + '\u0001');
                    }
                    var5_2 = '\uffff';
                    break;
                }
                case 's': {
                    var3_7 = '\u0000';
                    while (var3_7 < '\u0100') {
                        if (Character.isWhitespace(var3_7)) {
                            this.__setCharacterClassBits(this.__program, var7_6, var4_5, var3_7);
                        }
                        var3_7 = (char)(var3_7 + '\u0001');
                    }
                    var5_2 = '\uffff';
                    break;
                }
                case 'S': {
                    var3_7 = '\u0000';
                    while (var3_7 < '\u0100') {
                        if (!Character.isWhitespace(var3_7)) {
                            this.__setCharacterClassBits(this.__program, var7_6, var4_5, var3_7);
                        }
                        var3_7 = (char)(var3_7 + '\u0001');
                    }
                    var5_2 = '\uffff';
                    break;
                }
                case 'd': {
                    var3_7 = '0';
                    while (var3_7 <= '9') {
                        this.__setCharacterClassBits(this.__program, var7_6, var4_5, var3_7);
                        var3_7 = (char)(var3_7 + '\u0001');
                    }
                    var5_2 = '\uffff';
                    break;
                }
                case 'D': {
                    var3_7 = '\u0000';
                    while (var3_7 < '0') {
                        this.__setCharacterClassBits(this.__program, var7_6, var4_5, var3_7);
                        var3_7 = (char)(var3_7 + '\u0001');
                    }
                    var3_7 = ':';
                    while (var3_7 < '\u0100') {
                        this.__setCharacterClassBits(this.__program, var7_6, var4_5, var3_7);
                        var3_7 = (char)(var3_7 + '\u0001');
                    }
                    var5_2 = '\uffff';
                    break;
                }
                case 'n': {
                    var3_7 = '\n';
                    ** GOTO lbl125
                }
                case 'r': {
                    var3_7 = '\r';
                    ** GOTO lbl125
                }
                case 't': {
                    var3_7 = '\t';
                    ** GOTO lbl125
                }
                case 'f': {
                    var3_7 = '\f';
                    ** GOTO lbl125
                }
                case 'b': {
                    var3_7 = '\b';
                    ** GOTO lbl125
                }
                case 'e': {
                    var3_7 = '\u001b';
                    ** GOTO lbl125
                }
                case 'a': {
                    var3_7 = '\u0007';
                    ** GOTO lbl125
                }
                case 'x': {
                    var3_7 = (char)Perl5Compiler.__parseHex(this.__input._array, this.__input._getOffset(), 2, var8_3);
                    this.__input._increment(var8_3[0]);
                    ** GOTO lbl125
                }
                case 'c': {
                    var3_7 = this.__input._postIncrement();
                    if (Character.isLowerCase(var3_7)) {
                        var3_7 = Character.toUpperCase(var3_7);
                    }
                    var3_7 = (char)(var3_7 ^ 64);
                    ** GOTO lbl125
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    var3_7 = (char)Perl5Compiler.__parseOctal(this.__input._array, this.__input._getOffset() - 1, 3, var8_3);
                    this.__input._increment(var8_3[0] - 1);
                }
lbl125:
                // 11 sources

                default: lbl-1000:
                // 2 sources

                {
                    if (!var1_1) ** GOTO lbl131
                    if (var5_2 > var3_7) {
                        throw new MalformedPatternException("Invalid [] range in expression.");
                    }
                    var1_1 = false;
                    ** GOTO lbl141
lbl131:
                    // 1 sources

                    var5_2 = var3_7;
                    if (this.__input._getValue() != '-' || this.__input._getOffset() + 1 >= this.__input._getLength() || this.__input._getValueRelative(1) == ']') ** GOTO lbl141
                    this.__input._increment();
                    var1_1 = true;
                    break;
lbl-1000:
                    // 1 sources

                    {
                        this.__setCharacterClassBits(this.__program, var7_6, var4_5, var5_2);
                        if ((this.__modifierFlags[0] & '\u0001') != 0 && Character.isUpperCase(var5_2)) {
                            this.__setCharacterClassBits(this.__program, var7_6, var4_5, Character.toLowerCase(var5_2));
                        }
                        var5_2 = (char)(var5_2 + '\u0001');
lbl141:
                        // 3 sources

                        ** while (var5_2 <= var3_7)
                    }
lbl142:
                    // 1 sources

                    var5_2 = var3_7;
                }
            }
lbl143:
            // 10 sources

            if (!this.__input._isAtEnd()) {
                v0 = this.__input._getValue();
                var3_7 = v0;
                if (v0 != ']') continue;
            }
            if (!var2_8) break;
        }
        if (this.__input._getValue() != ']') {
            throw new MalformedPatternException("Unmatched [] in expression.");
        }
        this.__getNextChar();
        return var6_4;
    }

    /*
     * Recovered potentially malformed switches.  Disable with '--allowmalformedswitch false'
     * Unable to fully structure code
     * Enabled aggressive block sorting
     */
    private int __parseExpression(boolean var1_1, int[] var2_2) throws MalformedPatternException {
        var5_3 = -1;
        var6_4 = 0;
        var9_5 = new int[1];
        var10_6 = "iogmsx";
        var2_2[0] = 1;
        if (!var1_1) ** GOTO lbl43
        var4_7 = '\u0001';
        if (this.__input._getValue() != '?') ** GOTO lbl40
        this.__input._increment();
        var4_7 = var3_8 = this.__input._postIncrement();
        switch (var3_8) {
            case '#': {
                var3_8 = this.__input._getValue();
                while (true) {
                    if (var3_8 == '\uffff' || var3_8 == ')') {
                        if (var3_8 == ')') break;
                        throw new MalformedPatternException("Sequence (?#... not terminated");
                    }
                    var3_8 = this.__input._increment();
                }
                this.__getNextChar();
                var2_2[0] = 8;
                return -1;
            }
            default: {
                this.__input._decrement();
                var3_8 = this.__input._getValue();
                while (true) {
                    if (var3_8 == '\uffff' || var10_6.indexOf(var3_8) == -1) {
                        if (var3_8 == ')') break;
                        throw new MalformedPatternException("Sequence (?" + var3_8 + "...) not recognized");
                    }
                    Perl5Compiler.__setModifierFlag(this.__modifierFlags, var3_8);
                    var3_8 = this.__input._increment();
                }
                this.__getNextChar();
                var2_2[0] = 8;
                return -1;
            }
lbl40:
            // 1 sources

            var6_4 = this.__numParentheses++;
            var5_3 = this.__emitArgNode('\u001b', (char)var6_4);
            break;
lbl43:
            // 1 sources

            var4_7 = '\u0000';
            break;
            case '!': 
            case ':': 
            case '=': 
        }
        var7_9 = this.__parseAlternation(var9_5);
        if (var7_9 == -1) {
            return -1;
        }
        if (var5_3 != -1) {
            this.__programAddTail(var5_3, var7_9);
        } else {
            var5_3 = var7_9;
        }
        if ((var9_5[0] & 1) == 0) {
            var2_2[0] = var2_2[0] & -2;
        }
        var2_2[0] = var2_2[0] | var9_5[0] & 4;
        while (this.__input._getValue() == '|') {
            this.__getNextChar();
            var7_9 = this.__parseAlternation(var9_5);
            if (var7_9 == -1) {
                return -1;
            }
            this.__programAddTail(var5_3, var7_9);
            if ((var9_5[0] & 1) == 0) {
                var2_2[0] = var2_2[0] & -2;
            }
            var2_2[0] = var2_2[0] | var9_5[0] & 4;
        }
        switch (var4_7) {
            case ':': {
                var8_10 = this.__emitNode('\u000f');
                break;
            }
            case '\u0001': {
                var8_10 = this.__emitArgNode('\u001c', (char)var6_4);
                break;
            }
            case '!': 
            case '=': {
                var8_10 = this.__emitNode('!');
                var2_2[0] = var2_2[0] & -2;
                break;
            }
            default: {
                var8_10 = this.__emitNode('\u0000');
            }
        }
        this.__programAddTail(var5_3, var8_10);
        var7_9 = var5_3;
        while (var7_9 != -1) {
            this.__programAddOperatorTail(var7_9, var8_10);
            var7_9 = OpCode._getNext(this.__program, var7_9);
        }
        if (var4_7 == '=') {
            this.__programInsertOperator('\u001f', var5_3);
            this.__programAddTail(var5_3, this.__emitNode('\u000f'));
        } else if (var4_7 == '!') {
            this.__programInsertOperator(' ', var5_3);
            this.__programAddTail(var5_3, this.__emitNode('\u000f'));
        }
        if (var4_7 != '\u0000' && (this.__input._isAtEnd() || this.__getNextChar() != ')')) {
            throw new MalformedPatternException("Unmatched parentheses.");
        }
        if (var4_7 == '\u0000' && !this.__input._isAtEnd()) {
            if (this.__input._getValue() == ')') {
                throw new MalformedPatternException("Unmatched parentheses.");
            }
            throw new MalformedPatternException("Unreached characters at end of expression.  Please report this bug!");
        }
        return var5_3;
    }

    private static int __parseHex(char[] cArray, int n, int n2, int[] nArray) {
        int n3;
        int n4 = 0;
        nArray[0] = 0;
        while (n < cArray.length && n2-- > 0 && (n3 = __HEX_DIGIT.indexOf(cArray[n])) != -1) {
            n4 <<= 4;
            n4 |= n3 & 0xF;
            ++n;
            nArray[0] = nArray[0] + 1;
        }
        return n4;
    }

    private static int __parseOctal(char[] cArray, int n, int n2, int[] nArray) {
        int n3 = 0;
        nArray[0] = 0;
        while (n < cArray.length && n2 > 0 && cArray[n] >= '0' && cArray[n] <= '7') {
            n3 <<= 3;
            n3 |= cArray[n] - 48;
            --n2;
            ++n;
            nArray[0] = nArray[0] + 1;
        }
        return n3;
    }

    private char __parsePOSIX(boolean[] blArray) throws MalformedPatternException {
        char c2;
        int n = this.__input._getOffset();
        int n2 = this.__input._getLength();
        int n3 = n;
        if ((c2 = this.__input._getValue(n3++)) != ':') {
            return '\u0000';
        }
        if (this.__input._getValue(n3) == '^') {
            blArray[0] = true;
            ++n3;
        } else {
            blArray[0] = false;
        }
        StringBuffer stringBuffer = new StringBuffer();
        try {
            while ((c2 = this.__input._getValue(n3++)) != ':' && n3 < n2) {
                stringBuffer.append(c2);
            }
        }
        catch (Exception exception) {
            return '\u0000';
        }
        if (this.__input._getValue(n3++) != ']') {
            return '\u0000';
        }
        Object v = __hashPOSIX.get(stringBuffer.toString());
        if (v == null) {
            return '\u0000';
        }
        this.__input._setOffset(n3);
        return ((Character)v).charValue();
    }

    /*
     * Unable to fully structure code
     */
    private static boolean __parseRepetition(char[] var0, int var1_1) {
        if (var0[var1_1] != '{') {
            return false;
        }
        if (++var1_1 < var0.length && Character.isDigit(var0[var1_1])) ** GOTO lbl6
        return false;
lbl-1000:
        // 1 sources

        {
            ++var1_1;
lbl6:
            // 2 sources

            ** while (var1_1 < var0.length && Character.isDigit((char)var0[var1_1]))
        }
lbl7:
        // 1 sources

        if (var1_1 < var0.length && var0[var1_1] == ',') {
            ++var1_1;
        }
        while (var1_1 < var0.length && Character.isDigit(var0[var1_1])) {
            ++var1_1;
        }
        return var1_1 < var0.length && var0[var1_1] == '}';
    }

    private int __parseUnicodeClass() throws MalformedPatternException {
        int n;
        boolean bl = false;
        char c2 = '\uffff';
        int[] nArray = new int[1];
        boolean[] blArray = new boolean[1];
        if (this.__input._getValue() == '^') {
            n = this.__emitNode('$');
            this.__input._increment();
        } else {
            n = this.__emitNode('#');
        }
        char c3 = this.__input._getValue();
        boolean bl2 = c3 == ']' || c3 == '-';
        while (!this.__input._isAtEnd() && (c3 = this.__input._getValue()) != ']' || bl2) {
            bl2 = false;
            boolean bl3 = false;
            this.__input._increment();
            if (c3 == '\\' || c3 == '[') {
                if (c3 == '\\') {
                    c3 = this.__input._postIncrement();
                } else {
                    char c4 = this.__parsePOSIX(blArray);
                    if (c4 != '\u0000') {
                        bl3 = true;
                        c3 = c4;
                    }
                }
                if (!bl3) {
                    switch (c3) {
                        case 'w': {
                            bl3 = true;
                            c3 = '\u0012';
                            c2 = '\uffff';
                            break;
                        }
                        case 'W': {
                            bl3 = true;
                            c3 = '\u0013';
                            c2 = '\uffff';
                            break;
                        }
                        case 's': {
                            bl3 = true;
                            c3 = '\u0016';
                            c2 = '\uffff';
                            break;
                        }
                        case 'S': {
                            bl3 = true;
                            c3 = '\u0017';
                            c2 = '\uffff';
                            break;
                        }
                        case 'd': {
                            bl3 = true;
                            c3 = '\u0018';
                            c2 = '\uffff';
                            break;
                        }
                        case 'D': {
                            bl3 = true;
                            c3 = '\u0019';
                            c2 = '\uffff';
                            break;
                        }
                        case 'n': {
                            c3 = '\n';
                            break;
                        }
                        case 'r': {
                            c3 = '\r';
                            break;
                        }
                        case 't': {
                            c3 = '\t';
                            break;
                        }
                        case 'f': {
                            c3 = '\f';
                            break;
                        }
                        case 'b': {
                            c3 = '\b';
                            break;
                        }
                        case 'e': {
                            c3 = '\u001b';
                            break;
                        }
                        case 'a': {
                            c3 = '\u0007';
                            break;
                        }
                        case 'x': {
                            c3 = (char)Perl5Compiler.__parseHex(this.__input._array, this.__input._getOffset(), 2, nArray);
                            this.__input._increment(nArray[0]);
                            break;
                        }
                        case 'c': {
                            c3 = this.__input._postIncrement();
                            if (Character.isLowerCase(c3)) {
                                c3 = Character.toUpperCase(c3);
                            }
                            c3 = (char)(c3 ^ 0x40);
                            break;
                        }
                        case '0': 
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': 
                        case '8': 
                        case '9': {
                            c3 = (char)Perl5Compiler.__parseOctal(this.__input._array, this.__input._getOffset() - 1, 3, nArray);
                            this.__input._increment(nArray[0] - 1);
                            break;
                        }
                    }
                }
            }
            if (bl) {
                if (c2 > c3) {
                    throw new MalformedPatternException("Invalid [] range in expression.");
                }
                bl = false;
            } else {
                c2 = c3;
                if (this.__input._getValue() == '-' && this.__input._getOffset() + 1 < this.__input._getLength() && this.__input._getValueRelative(1) != ']') {
                    this.__input._increment();
                    bl = true;
                    continue;
                }
            }
            if (c2 == c3) {
                if (bl3) {
                    if (!blArray[0]) {
                        this.__emitCode('/');
                    } else {
                        this.__emitCode('0');
                    }
                } else {
                    this.__emitCode('1');
                }
                this.__emitCode(c3);
                if ((this.__modifierFlags[0] & '\u0001') != 0 && Character.isUpperCase(c3) && Character.isUpperCase(c2)) {
                    --this.__programSize;
                    this.__emitCode(Character.toLowerCase(c3));
                }
            }
            if (c2 < c3) {
                this.__emitCode('%');
                this.__emitCode(c2);
                this.__emitCode(c3);
                if ((this.__modifierFlags[0] & '\u0001') != 0 && Character.isUpperCase(c3) && Character.isUpperCase(c2)) {
                    this.__programSize -= 2;
                    this.__emitCode(Character.toLowerCase(c2));
                    this.__emitCode(Character.toLowerCase(c3));
                }
                c2 = '\uffff';
                bl = false;
            }
            c2 = c3;
        }
        if (this.__input._getValue() != ']') {
            throw new MalformedPatternException("Unmatched [] in expression.");
        }
        this.__getNextChar();
        this.__emitCode('\u0000');
        return n;
    }

    private void __programAddOperatorTail(int n, int n2) {
        if (this.__program == null || n == -1 || OpCode._opType[this.__program[n]] != '\f') {
            return;
        }
        this.__programAddTail(OpCode._getNextOperator(n), n2);
    }

    private void __programAddTail(int n, int n2) {
        int n3;
        if (this.__program == null || n == -1) {
            return;
        }
        int n4 = n;
        while ((n3 = OpCode._getNext(this.__program, n4)) != -1) {
            n4 = n3;
        }
        int n5 = this.__program[n4] == '\r' ? n4 - n2 : n2 - n4;
        this.__program[n4 + 1] = (char)n5;
    }

    private void __programInsertOperator(char c2, int n) {
        int n2;
        int n3 = n2 = OpCode._opType[c2] == '\n' ? 2 : 0;
        if (this.__program == null) {
            this.__programSize += 2 + n2;
            return;
        }
        int n4 = this.__programSize;
        this.__programSize += 2 + n2;
        int n5 = this.__programSize;
        while (n4 > n) {
            this.__program[--n5] = this.__program[--n4];
        }
        this.__program[n++] = c2;
        this.__program[n++] = '\u0000';
        while (n2-- > 0) {
            this.__program[n++] = '\u0000';
        }
    }

    private void __setCharacterClassBits(char[] cArray, int n, char c2, char c3) {
        if (this.__program == null || c3 >= '\u0100') {
            return;
        }
        c3 = (char)(c3 & 0xFFFF);
        if (c2 == '\u0000') {
            int n2 = n + (c3 >> 4);
            cArray[n2] = (char)(cArray[n2] | 1 << (c3 & 0xF));
        } else {
            int n3 = n + (c3 >> 4);
            cArray[n3] = (char)(cArray[n3] & ~(1 << (c3 & 0xF)));
        }
    }

    private static void __setModifierFlag(char[] cArray, char c2) {
        switch (c2) {
            case 'i': {
                cArray[0] = (char)(cArray[0] | '\u0001');
                return;
            }
            case 'g': {
                cArray[0] = (char)(cArray[0] | 2);
                return;
            }
            case 'o': {
                cArray[0] = (char)(cArray[0] | 4);
                return;
            }
            case 'm': {
                cArray[0] = (char)(cArray[0] | 8);
                return;
            }
            case 's': {
                cArray[0] = (char)(cArray[0] | 0x10);
                return;
            }
            case 'x': {
                cArray[0] = (char)(cArray[0] | 0x20);
                return;
            }
        }
    }

    public Pattern compile(String string) throws MalformedPatternException {
        return this.compile(string.toCharArray(), 0);
    }

    public Pattern compile(String string, int n) throws MalformedPatternException {
        return this.compile(string.toCharArray(), n);
    }

    public Pattern compile(char[] cArray) throws MalformedPatternException {
        return this.compile(cArray, 0);
    }

    /*
     * Unable to fully structure code
     */
    public Pattern compile(char[] var1_1, int var2_2) throws MalformedPatternException {
        block40: {
            var3_3 = new int[1];
            var10_4 = false;
            var11_5 = false;
            var15_6 = 0;
            this.__input = new CharStringPointer(var1_1);
            var4_7 = var2_2 & 1;
            this.__modifierFlags[0] = (char)var2_2;
            this.__sawBackreference = false;
            this.__numParentheses = 1;
            this.__programSize = 0;
            this.__cost = 0;
            this.__program = null;
            this.__emitCode('\u0000');
            if (this.__parseExpression(false, var3_3) == -1) {
                throw new MalformedPatternException("Unknown compilation error.");
            }
            if (this.__programSize >= 65534) {
                throw new MalformedPatternException("Expression is too large.");
            }
            this.__program = new char[this.__programSize];
            var6_8 = new Perl5Pattern();
            var6_8._program = this.__program;
            var6_8._expression = new String(var1_1);
            this.__input._setOffset(0);
            this.__numParentheses = 1;
            this.__programSize = 0;
            this.__cost = 0;
            this.__emitCode('\u0000');
            if (this.__parseExpression(false, var3_3) == -1) {
                throw new MalformedPatternException("Unknown compilation error.");
            }
            var4_7 = this.__modifierFlags[0] & '\u0001';
            var6_8._isExpensive = this.__cost >= 10;
            var6_8._startClassOffset = -1;
            var6_8._anchor = 0;
            var6_8._back = -1;
            var6_8._options = var2_2;
            var6_8._startString = null;
            var6_8._mustString = null;
            var7_9 = null;
            var8_10 = null;
            var5_11 = 1;
            if (this.__program[OpCode._getNext(this.__program, var5_11)] != '\u0000') break block40;
            var9_12 = var5_11 = OpCode._getNextOperator(var5_11);
            var20_13 = this.__program[var9_12];
            if (true) ** GOTO lbl51
            while (true) {
                if (var20_13 == '\u0011') {
                    var11_5 = true;
                } else {
                    var9_12 += OpCode._operandLength[var20_13];
                }
                var9_12 = OpCode._getNextOperator(var9_12);
                var20_13 = this.__program[var9_12];
lbl51:
                // 2 sources

                if (var20_13 == '\u001b') {
                    var10_4 = true;
                    if (true) continue;
                }
                if (!(var20_13 == '\f' && this.__program[OpCode._getNext(this.__program, var9_12)] != '\f' || var20_13 == '\u0011' || var20_13 == '\u001d' || OpCode._opType[var20_13] == '\n' && OpCode._getArg1(this.__program, var9_12) > '\u0000')) break;
            }
            var19_14 = true;
            while (var19_14) {
                var19_14 = false;
                var20_13 = this.__program[var9_12];
                if (var20_13 == '\u000e') {
                    var8_10 = new String(this.__program, OpCode._getOperand(var9_12 + 1), (int)this.__program[OpCode._getOperand(var9_12)]);
                    continue;
                }
                if (OpCode._isInArray(var20_13, OpCode._opLengthOne, 2)) {
                    var6_8._startClassOffset = var9_12;
                    continue;
                }
                if (var20_13 == '\u0014' || var20_13 == '\u0015') {
                    var6_8._startClassOffset = var9_12;
                    continue;
                }
                if (OpCode._opType[var20_13] == '\u0001') {
                    var6_8._anchor = var20_13 == '\u0001' ? 1 : (var20_13 == '\u0002' ? 2 : 3);
                    var9_12 = OpCode._getNextOperator(var9_12);
                    var19_14 = true;
                    continue;
                }
                if (var20_13 != '\u0010' || OpCode._opType[this.__program[OpCode._getNextOperator(var9_12)]] != '\u0007' || (var6_8._anchor & 3) == 0) continue;
                var6_8._anchor = 11;
                var9_12 = OpCode._getNextOperator(var9_12);
                var19_14 = true;
            }
            if (!(!var11_5 || var10_4 && this.__sawBackreference)) {
                var6_8._anchor |= 4;
            }
            var12_15 = new StringBuffer();
            var13_16 = new StringBuffer();
            var14_17 = 0;
            var15_6 = 0;
            var16_18 = 0;
            var17_19 = 0;
            var18_20 = 0;
            while (var5_11 > 0 && (var20_13 = this.__program[var5_11]) != '\u0000') {
                if (var20_13 == '\f') {
                    if (this.__program[OpCode._getNext(this.__program, var5_11)] == '\f') {
                        var16_18 = -30000;
                        while (this.__program[var5_11] == '\f') {
                            var5_11 = OpCode._getNext(this.__program, var5_11);
                        }
                        continue;
                    }
                    var5_11 = OpCode._getNextOperator(var5_11);
                    continue;
                }
                if (var20_13 == ' ') {
                    var16_18 = -30000;
                    var5_11 = OpCode._getNext(this.__program, var5_11);
                    continue;
                }
                if (var20_13 == '\u000e') {
                    var9_12 = var5_11;
                    while (this.__program[var21_21 = OpCode._getNext(this.__program, var5_11)] == '\u001c') {
                        var5_11 = var21_21;
                    }
                    var15_6 += this.__program[OpCode._getOperand(var9_12)];
                    var21_21 = this.__program[OpCode._getOperand(var9_12)];
                    if (var16_18 - var17_19 == var14_17) {
                        var12_15.append(new String(this.__program, OpCode._getOperand(var9_12) + 1, var21_21));
                        var14_17 += var21_21;
                        var16_18 += var21_21;
                        var9_12 = OpCode._getNext(this.__program, var5_11);
                    } else if (var21_21 >= var14_17 + (var16_18 >= 0 ? 1 : 0)) {
                        var14_17 = var21_21;
                        var12_15 = new StringBuffer(new String(this.__program, OpCode._getOperand(var9_12) + 1, var21_21));
                        var17_19 = var16_18;
                        var16_18 += var14_17;
                        var9_12 = OpCode._getNext(this.__program, var5_11);
                    } else {
                        var16_18 += var21_21;
                    }
                } else if (OpCode._isInArray(var20_13, OpCode._opLengthVaries, 0)) {
                    var16_18 = -30000;
                    var14_17 = 0;
                    if (var12_15.length() > var13_16.length()) {
                        var13_16 = var12_15;
                        var18_20 = var17_19;
                    }
                    var12_15 = new StringBuffer();
                    if (var20_13 == '\u0011' && OpCode._isInArray(this.__program[OpCode._getNextOperator(var5_11)], OpCode._opLengthOne, 0)) {
                        ++var15_6;
                    } else if (OpCode._opType[var20_13] == '\n' && OpCode._isInArray(this.__program[OpCode._getNextOperator(var5_11) + 2], OpCode._opLengthOne, 0)) {
                        var15_6 += OpCode._getArg1(this.__program, var5_11);
                    }
                } else if (OpCode._isInArray(var20_13, OpCode._opLengthOne, 0)) {
                    ++var16_18;
                    ++var15_6;
                    var14_17 = 0;
                    if (var12_15.length() > var13_16.length()) {
                        var13_16 = var12_15;
                        var18_20 = var17_19;
                    }
                    var12_15 = new StringBuffer();
                }
                var5_11 = OpCode._getNext(this.__program, var5_11);
            }
            if (var12_15.length() + (OpCode._opType[this.__program[var9_12]] == '\u0004' ? 1 : 0) > var13_16.length()) {
                var13_16 = var12_15;
                var18_20 = var17_19;
            } else {
                var12_15 = new StringBuffer();
            }
            if (var13_16.length() > 0 && var8_10 == null) {
                var7_9 = var13_16.toString();
                if (var18_20 < 0) {
                    var18_20 = -1;
                }
                var6_8._back = var18_20;
            } else {
                var13_16 = null;
            }
        }
        var6_8._isCaseInsensitive = (var4_7 & 1) != 0;
        var6_8._numParentheses = this.__numParentheses - 1;
        var6_8._minLength = var15_6;
        if (var7_9 != null) {
            var6_8._mustString = var7_9.toCharArray();
            var6_8._mustUtility = 100;
        }
        if (var8_10 != null) {
            var6_8._startString = var8_10.toCharArray();
        }
        return var6_8;
    }

    public static final String quotemeta(String string) {
        return Perl5Compiler.quotemeta(string.toCharArray());
    }

    public static final String quotemeta(char[] cArray) {
        StringBuffer stringBuffer = new StringBuffer(2 * cArray.length);
        int n = 0;
        while (n < cArray.length) {
            if (!OpCode._isWordCharacter(cArray[n])) {
                stringBuffer.append('\\');
            }
            stringBuffer.append(cArray[n]);
            ++n;
        }
        return stringBuffer.toString();
    }
}

