/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.iterators;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class IteratorChain
implements Iterator {
    protected final List iteratorChain = new ArrayList();
    protected int currentIteratorIndex = 0;
    protected Iterator currentIterator = null;
    protected Iterator lastUsedIterator = null;
    protected boolean isLocked = false;

    public IteratorChain() {
    }

    public IteratorChain(Iterator iterator) {
        this.addIterator(iterator);
    }

    public IteratorChain(Iterator a2, Iterator b2) {
        this.addIterator(a2);
        this.addIterator(b2);
    }

    public IteratorChain(Iterator[] iterators) {
        int i = 0;
        while (i < iterators.length) {
            this.addIterator(iterators[i]);
            ++i;
        }
    }

    public IteratorChain(Collection iterators) {
        Iterator it = iterators.iterator();
        while (it.hasNext()) {
            Iterator item = (Iterator)it.next();
            this.addIterator(item);
        }
    }

    public void addIterator(Iterator iterator) {
        this.checkLocked();
        if (iterator == null) {
            throw new NullPointerException("Iterator must not be null");
        }
        this.iteratorChain.add(iterator);
    }

    public void setIterator(int index, Iterator iterator) throws IndexOutOfBoundsException {
        this.checkLocked();
        if (iterator == null) {
            throw new NullPointerException("Iterator must not be null");
        }
        this.iteratorChain.set(index, iterator);
    }

    public List getIterators() {
        return Collections.unmodifiableList(this.iteratorChain);
    }

    public int size() {
        return this.iteratorChain.size();
    }

    public boolean isLocked() {
        return this.isLocked;
    }

    private void checkLocked() {
        if (this.isLocked) {
            throw new UnsupportedOperationException("IteratorChain cannot be changed after the first use of a method from the Iterator interface");
        }
    }

    private void checkChainIntegrity() {
        if (this.iteratorChain.size() == 0) {
            throw new UnsupportedOperationException("IteratorChains must contain at least one Iterator");
        }
    }

    private void lockChain() {
        if (!this.isLocked) {
            this.checkChainIntegrity();
            this.isLocked = true;
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void updateCurrentIterator() {
        if (this.currentIterator == null) {
            this.lastUsedIterator = this.currentIterator = (Iterator)this.iteratorChain.get(0);
        }
        if (this.currentIteratorIndex != this.iteratorChain.size() - 1) ** GOTO lbl9
        return;
lbl-1000:
        // 1 sources

        {
            ++this.currentIteratorIndex;
            this.currentIterator = (Iterator)this.iteratorChain.get(this.currentIteratorIndex);
            if (this.currentIteratorIndex != this.iteratorChain.size() - 1) continue;
            return;
lbl9:
            // 2 sources

            ** while (!this.currentIterator.hasNext())
        }
lbl10:
        // 1 sources

    }

    public boolean hasNext() throws UnsupportedOperationException {
        this.lockChain();
        this.updateCurrentIterator();
        this.lastUsedIterator = this.currentIterator;
        return this.currentIterator.hasNext();
    }

    public Object next() throws NoSuchElementException, UnsupportedOperationException {
        this.lockChain();
        this.updateCurrentIterator();
        this.lastUsedIterator = this.currentIterator;
        return this.currentIterator.next();
    }

    public void remove() throws UnsupportedOperationException, IllegalStateException {
        this.lockChain();
        this.updateCurrentIterator();
        this.lastUsedIterator.remove();
    }
}

