/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.Bag;
import org.apache.commons.collections.HashBag;
import org.apache.commons.collections.MapUtils;

public abstract class DefaultMapBag
implements Bag {
    private Map _map = null;
    private int _total = 0;
    private int _mods = 0;

    public DefaultMapBag() {
    }

    public DefaultMapBag(Map map) {
        this.setMap(map);
    }

    public boolean add(Object o) {
        return this.add(o, 1);
    }

    public boolean add(Object o, int i) {
        ++this._mods;
        if (i > 0) {
            int count = i + this.getCount(o);
            this._map.put(o, new Integer(count));
            this._total += i;
            return count == i;
        }
        return false;
    }

    public boolean addAll(Collection c2) {
        boolean changed = false;
        Iterator i = c2.iterator();
        while (i.hasNext()) {
            boolean added = this.add(i.next());
            boolean bl = changed = changed || added;
        }
        return changed;
    }

    public void clear() {
        ++this._mods;
        this._map.clear();
        this._total = 0;
    }

    public boolean contains(Object o) {
        return this._map.containsKey(o);
    }

    public boolean containsAll(Collection c2) {
        return this.containsAll(new HashBag(c2));
    }

    public boolean containsAll(Bag other) {
        boolean result = true;
        Iterator i = other.uniqueSet().iterator();
        while (i.hasNext()) {
            Object current = i.next();
            boolean contains = this.getCount(current) >= other.getCount(current);
            boolean bl = result = result && contains;
        }
        return result;
    }

    public boolean equals(Object o) {
        return o == this || o != null && o.getClass().equals(this.getClass()) && ((DefaultMapBag)o)._map.equals(this._map);
    }

    public int hashCode() {
        return this._map.hashCode();
    }

    public boolean isEmpty() {
        return this._map.isEmpty();
    }

    public Iterator iterator() {
        return new BagIterator(this, this.extractList().iterator());
    }

    public boolean remove(Object o) {
        return this.remove(o, this.getCount(o));
    }

    public boolean remove(Object o, int i) {
        ++this._mods;
        boolean result = false;
        int count = this.getCount(o);
        if (i <= 0) {
            result = false;
        } else if (count > i) {
            this._map.put(o, new Integer(count - i));
            result = true;
            this._total -= i;
        } else {
            result = this._map.remove(o) != null;
            this._total -= count;
        }
        return result;
    }

    public boolean removeAll(Collection c2) {
        boolean result = false;
        if (c2 != null) {
            Iterator i = c2.iterator();
            while (i.hasNext()) {
                boolean changed = this.remove(i.next(), 1);
                boolean bl = result = result || changed;
            }
        }
        return result;
    }

    public boolean retainAll(Collection c2) {
        return this.retainAll(new HashBag(c2));
    }

    public boolean retainAll(Bag other) {
        boolean result = false;
        HashBag excess = new HashBag();
        Iterator i = this.uniqueSet().iterator();
        while (i.hasNext()) {
            Object current = i.next();
            int myCount = this.getCount(current);
            int otherCount = other.getCount(current);
            if (1 <= otherCount && otherCount <= myCount) {
                excess.add(current, myCount - otherCount);
                continue;
            }
            excess.add(current, myCount);
        }
        if (!excess.isEmpty()) {
            result = this.removeAll((Collection)excess);
        }
        return result;
    }

    public Object[] toArray() {
        return this.extractList().toArray();
    }

    public Object[] toArray(Object[] a2) {
        return this.extractList().toArray(a2);
    }

    public int getCount(Object o) {
        int result = 0;
        Integer count = MapUtils.getInteger(this._map, o);
        if (count != null) {
            result = count;
        }
        return result;
    }

    public Set uniqueSet() {
        return Collections.unmodifiableSet(this._map.keySet());
    }

    public int size() {
        return this._total;
    }

    protected int calcTotalSize() {
        this._total = this.extractList().size();
        return this._total;
    }

    protected void setMap(Map m) {
        this._map = m;
    }

    protected Map getMap() {
        return this._map;
    }

    private List extractList() {
        ArrayList result = new ArrayList();
        Iterator i = this.uniqueSet().iterator();
        while (i.hasNext()) {
            Object current = i.next();
            int index = this.getCount(current);
            while (index > 0) {
                result.add(current);
                --index;
            }
        }
        return result;
    }

    private int modCount() {
        return this._mods;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("[");
        Iterator i = this.uniqueSet().iterator();
        while (i.hasNext()) {
            Object current = i.next();
            int count = this.getCount(current);
            buf.append(count);
            buf.append(":");
            buf.append(current);
            if (!i.hasNext()) continue;
            buf.append(",");
        }
        buf.append("]");
        return buf.toString();
    }

    private class BagIterator
    implements Iterator {
        private DefaultMapBag _parent = null;
        private Iterator _support = null;
        private Object _current = null;
        private int _mods = 0;

        public BagIterator(DefaultMapBag parent, Iterator support) {
            this._parent = parent;
            this._support = support;
            this._current = null;
            this._mods = parent.modCount();
        }

        public boolean hasNext() {
            return this._support.hasNext();
        }

        public Object next() {
            if (this._parent.modCount() != this._mods) {
                throw new ConcurrentModificationException();
            }
            this._current = this._support.next();
            return this._current;
        }

        public void remove() {
            if (this._parent.modCount() != this._mods) {
                throw new ConcurrentModificationException();
            }
            this._support.remove();
            this._parent.remove(this._current, 1);
            ++this._mods;
        }
    }
}

