/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;

class CommonsLinkedList
extends LinkedList
implements List,
Serializable {
    private static final long serialVersionUID = 1L;
    protected transient Node marker;
    protected transient int size;

    public CommonsLinkedList() {
        this.initializeEmptyList();
    }

    public CommonsLinkedList(Collection c2) {
        this.initializeEmptyList();
        this.addAll(c2);
    }

    protected void initializeEmptyList() {
        this.marker.next = this.marker = this.createNode();
        this.marker.previous = this.marker;
    }

    protected Node createNode() {
        return new Node();
    }

    protected Node createNode(Node next, Node previous, Object element) {
        return new Node(next, previous, element);
    }

    private void addNodeBefore(Node node, Object o) {
        Node newNode;
        node.previous.next = newNode = this.createNode(node.previous, node, o);
        node.previous = newNode;
        ++this.size;
        ++this.modCount;
    }

    protected void addNodeAfter(Node node, Object o) {
        Node newNode;
        node.next.previous = newNode = this.createNode(node, node.next, o);
        node.next = newNode;
        ++this.size;
        ++this.modCount;
    }

    protected void removeNode(Node node) {
        node.previous.next = node.next;
        node.next.previous = node.previous;
        --this.size;
        ++this.modCount;
    }

    protected void removeAllNodes() {
        this.marker.next = this.marker;
        this.marker.previous = this.marker;
        this.size = 0;
        ++this.modCount;
    }

    protected Node getNode(int index, boolean endMarkerAllowed) throws IndexOutOfBoundsException {
        Node node;
        if (index < 0) {
            throw new IndexOutOfBoundsException("Couldn't get the node: index (" + index + ") less than zero.");
        }
        if (!endMarkerAllowed && index == this.size) {
            throw new IndexOutOfBoundsException("Couldn't get the node: index (" + index + ") is the size of the list.");
        }
        if (index > this.size) {
            throw new IndexOutOfBoundsException("Couldn't get the node: index (" + index + ") greater than the size of the " + "list (" + this.size + ").");
        }
        if (index < this.size / 2) {
            node = this.marker.next;
            int currentIndex = 0;
            while (currentIndex < index) {
                node = node.next;
                ++currentIndex;
            }
        } else {
            node = this.marker;
            int currentIndex = this.size;
            while (currentIndex > index) {
                node = node.previous;
                --currentIndex;
            }
        }
        return node;
    }

    public ListIterator listIterator() {
        return new ListIteratorImpl();
    }

    public ListIterator listIterator(int startIndex) {
        return new ListIteratorImpl(startIndex);
    }

    public int size() {
        return this.size;
    }

    public void clear() {
        this.removeAllNodes();
    }

    public boolean add(Object o) {
        this.addLast(o);
        return true;
    }

    public void add(int index, Object element) {
        Node node = this.getNode(index, true);
        this.addNodeBefore(node, element);
    }

    public boolean addAll(Collection c2) {
        return this.addAll(this.size, c2);
    }

    public boolean addAll(int index, Collection c2) {
        Node node = this.getNode(index, true);
        Iterator itr = c2.iterator();
        while (itr.hasNext()) {
            Object element = itr.next();
            this.addNodeBefore(node, element);
        }
        return true;
    }

    public Object get(int index) {
        Node node = this.getNode(index, false);
        return node.element;
    }

    public Object set(int index, Object element) {
        Node node = this.getNode(index, false);
        Object oldElement = node.element;
        node.element = element;
        return oldElement;
    }

    public Object remove(int index) {
        Node node = this.getNode(index, false);
        Object oldElement = node.element;
        this.removeNode(node);
        return oldElement;
    }

    public boolean remove(Object element) {
        Node node = this.marker.next;
        while (node != this.marker) {
            if (node.elementEquals(element)) {
                this.removeNode(node);
                return true;
            }
            node = node.next;
        }
        return false;
    }

    public int indexOf(Object element) {
        int i = 0;
        Node node = this.marker.next;
        while (node != this.marker) {
            if (node.elementEquals(element)) {
                return i;
            }
            ++i;
            node = node.next;
        }
        return -1;
    }

    public int lastIndexOf(Object element) {
        int i = this.size - 1;
        Node node = this.marker.previous;
        while (node != this.marker) {
            if (node.elementEquals(element)) {
                return i;
            }
            --i;
            node = node.previous;
        }
        return -1;
    }

    public boolean contains(Object element) {
        return this.indexOf(element) != -1;
    }

    public Object[] toArray() {
        return this.toArray(new Object[this.size]);
    }

    public Object[] toArray(Object[] array) {
        if (array.length < this.size) {
            Class<?> componentType = array.getClass().getComponentType();
            array = (Object[])Array.newInstance(componentType, this.size);
        }
        Node node = this.marker.next;
        int i = 0;
        while (i < this.size) {
            array[i] = node.element;
            node = node.next;
            ++i;
        }
        if (array.length > this.size) {
            array[this.size] = null;
        }
        return array;
    }

    public Object getFirst() {
        Node node = this.marker.next;
        if (node == this.marker) {
            throw new NoSuchElementException();
        }
        return node.element;
    }

    public Object getLast() {
        Node node = this.marker.previous;
        if (node == this.marker) {
            throw new NoSuchElementException();
        }
        return node.element;
    }

    public void addFirst(Object o) {
        this.addNodeAfter(this.marker, o);
    }

    public void addLast(Object o) {
        this.addNodeBefore(this.marker, o);
    }

    public Object removeFirst() {
        Node node = this.marker.next;
        if (node == this.marker) {
            throw new NoSuchElementException();
        }
        Object oldElement = node.element;
        this.removeNode(node);
        return oldElement;
    }

    public Object removeLast() {
        Node node = this.marker.previous;
        if (node == this.marker) {
            throw new NoSuchElementException();
        }
        Object oldElement = node.element;
        this.removeNode(node);
        return oldElement;
    }

    private void writeObject(ObjectOutputStream outputStream) throws IOException, ClassNotFoundException {
        outputStream.defaultWriteObject();
        outputStream.writeInt(this.size());
        Iterator itr = this.iterator();
        while (itr.hasNext()) {
            outputStream.writeObject(itr.next());
        }
    }

    private void readObject(ObjectInputStream inputStream) throws IOException, ClassNotFoundException {
        inputStream.defaultReadObject();
        this.initializeEmptyList();
        int size = inputStream.readInt();
        int i = 0;
        while (i < size) {
            this.add(inputStream.readObject());
            ++i;
        }
    }

    protected class ListIteratorImpl
    implements ListIterator {
        protected Node nextNode;
        protected int nextIndex;
        protected Node lastNodeReturned;
        protected int expectedModCount;

        public ListIteratorImpl() throws IndexOutOfBoundsException {
            this(0);
        }

        public ListIteratorImpl(int startIndex) throws IndexOutOfBoundsException {
            this.expectedModCount = CommonsLinkedList.this.modCount;
            this.nextNode = CommonsLinkedList.this.getNode(startIndex, true);
            this.nextIndex = startIndex;
        }

        protected void checkModCount() throws ConcurrentModificationException {
            if (CommonsLinkedList.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
        }

        protected Node getLastNodeReturned() throws IllegalStateException {
            if (this.lastNodeReturned == null) {
                throw new IllegalStateException();
            }
            return this.lastNodeReturned;
        }

        public boolean hasNext() {
            return this.nextNode != CommonsLinkedList.this.marker;
        }

        public Object next() {
            this.checkModCount();
            if (!this.hasNext()) {
                throw new NoSuchElementException("No element at index " + this.nextIndex + ".");
            }
            Object element = this.nextNode.element;
            this.lastNodeReturned = this.nextNode;
            this.nextNode = this.nextNode.next;
            ++this.nextIndex;
            return element;
        }

        public boolean hasPrevious() {
            return this.nextNode.previous != CommonsLinkedList.this.marker;
        }

        public Object previous() {
            this.checkModCount();
            if (!this.hasPrevious()) {
                throw new NoSuchElementException("Already at start of list.");
            }
            this.nextNode = this.nextNode.previous;
            Object element = this.nextNode.element;
            this.lastNodeReturned = this.nextNode;
            --this.nextIndex;
            return element;
        }

        public int nextIndex() {
            return this.nextIndex;
        }

        public int previousIndex() {
            return this.nextIndex - 1;
        }

        public void remove() {
            this.checkModCount();
            CommonsLinkedList.this.removeNode(this.getLastNodeReturned());
            this.lastNodeReturned = null;
            --this.nextIndex;
            ++this.expectedModCount;
        }

        public void set(Object o) {
            this.checkModCount();
            this.getLastNodeReturned().element = o;
        }

        public void add(Object o) {
            this.checkModCount();
            CommonsLinkedList.this.addNodeBefore(this.nextNode, o);
            this.lastNodeReturned = null;
            ++this.nextIndex;
            ++this.expectedModCount;
        }
    }

    protected static class Node {
        public Node previous;
        public Node next;
        public Object element;

        public Node() {
        }

        public Node(Node previous, Node next, Object element) {
            this.previous = previous;
            this.next = next;
            this.element = element;
        }

        public boolean elementEquals(Object otherElement) {
            if (this.element == null) {
                return otherElement == null;
            }
            return this.element.equals(otherElement);
        }
    }
}

