/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.commons.collections.BoundedCollection;
import org.apache.commons.collections.Closure;
import org.apache.commons.collections.IteratorUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.Transformer;
import org.apache.commons.collections.iterators.ArrayIterator;
import org.apache.commons.collections.iterators.EnumerationIterator;

public class CollectionUtils {
    public static final Collection EMPTY_COLLECTION = Collections.unmodifiableCollection(new ArrayList());
    public static final Iterator EMPTY_ITERATOR = IteratorUtils.EMPTY_ITERATOR;

    public static Collection union(Collection a2, Collection b2) {
        ArrayList list = new ArrayList();
        Map mapa = CollectionUtils.getCardinalityMap(a2);
        Map mapb = CollectionUtils.getCardinalityMap(b2);
        HashSet elts = new HashSet(a2);
        elts.addAll(b2);
        Iterator it = elts.iterator();
        while (it.hasNext()) {
            Object obj = it.next();
            int i = 0;
            int m = Math.max(CollectionUtils.getFreq(obj, mapa), CollectionUtils.getFreq(obj, mapb));
            while (i < m) {
                list.add(obj);
                ++i;
            }
        }
        return list;
    }

    public static Collection intersection(Collection a2, Collection b2) {
        ArrayList list = new ArrayList();
        Map mapa = CollectionUtils.getCardinalityMap(a2);
        Map mapb = CollectionUtils.getCardinalityMap(b2);
        HashSet elts = new HashSet(a2);
        elts.addAll(b2);
        Iterator it = elts.iterator();
        while (it.hasNext()) {
            Object obj = it.next();
            int i = 0;
            int m = Math.min(CollectionUtils.getFreq(obj, mapa), CollectionUtils.getFreq(obj, mapb));
            while (i < m) {
                list.add(obj);
                ++i;
            }
        }
        return list;
    }

    public static Collection disjunction(Collection a2, Collection b2) {
        ArrayList list = new ArrayList();
        Map mapa = CollectionUtils.getCardinalityMap(a2);
        Map mapb = CollectionUtils.getCardinalityMap(b2);
        HashSet elts = new HashSet(a2);
        elts.addAll(b2);
        Iterator it = elts.iterator();
        while (it.hasNext()) {
            Object obj = it.next();
            int i = 0;
            int m = Math.max(CollectionUtils.getFreq(obj, mapa), CollectionUtils.getFreq(obj, mapb)) - Math.min(CollectionUtils.getFreq(obj, mapa), CollectionUtils.getFreq(obj, mapb));
            while (i < m) {
                list.add(obj);
                ++i;
            }
        }
        return list;
    }

    public static Collection subtract(Collection a2, Collection b2) {
        ArrayList list = new ArrayList(a2);
        Iterator it = b2.iterator();
        while (it.hasNext()) {
            list.remove(it.next());
        }
        return list;
    }

    public static boolean containsAny(Collection a2, Collection b2) {
        Iterator iter = a2.iterator();
        while (iter.hasNext()) {
            if (!b2.contains(iter.next())) continue;
            return true;
        }
        return false;
    }

    public static Map getCardinalityMap(Collection col) {
        HashMap count = new HashMap();
        Iterator it = col.iterator();
        while (it.hasNext()) {
            Object obj = it.next();
            Integer c2 = (Integer)count.get(obj);
            if (null == c2) {
                count.put(obj, new Integer(1));
                continue;
            }
            count.put(obj, new Integer(c2 + 1));
        }
        return count;
    }

    public static boolean isSubCollection(Collection a2, Collection b2) {
        Map mapa = CollectionUtils.getCardinalityMap(a2);
        Map mapb = CollectionUtils.getCardinalityMap(b2);
        Iterator it = a2.iterator();
        while (it.hasNext()) {
            Object obj = it.next();
            if (CollectionUtils.getFreq(obj, mapa) <= CollectionUtils.getFreq(obj, mapb)) continue;
            return false;
        }
        return true;
    }

    public static boolean isProperSubCollection(Collection a2, Collection b2) {
        return CollectionUtils.isSubCollection(a2, b2) && !CollectionUtils.isEqualCollection(a2, b2);
    }

    public static boolean isEqualCollection(Collection a2, Collection b2) {
        if (a2.size() != b2.size()) {
            return false;
        }
        Map mapa = CollectionUtils.getCardinalityMap(a2);
        Map mapb = CollectionUtils.getCardinalityMap(b2);
        if (mapa.size() != mapb.size()) {
            return false;
        }
        Iterator it = mapa.keySet().iterator();
        while (it.hasNext()) {
            Object obj = it.next();
            if (CollectionUtils.getFreq(obj, mapa) == CollectionUtils.getFreq(obj, mapb)) continue;
            return false;
        }
        return true;
    }

    public static int cardinality(Object obj, Collection col) {
        int count = 0;
        if (null == obj) {
            Iterator it = col.iterator();
            while (it.hasNext()) {
                if (null != it.next()) continue;
                ++count;
            }
        } else {
            Iterator it = col.iterator();
            while (it.hasNext()) {
                if (!obj.equals(it.next())) continue;
                ++count;
            }
        }
        return count;
    }

    public static Object find(Collection collection, Predicate predicate) {
        if (collection != null && predicate != null) {
            Iterator iter = collection.iterator();
            while (iter.hasNext()) {
                Object item = iter.next();
                if (!predicate.evaluate(item)) continue;
                return item;
            }
        }
        return null;
    }

    public static void forAllDo(Collection collection, Closure closure) {
        if (collection != null && closure != null) {
            Iterator it = collection.iterator();
            while (it.hasNext()) {
                closure.execute(it.next());
            }
        }
    }

    public static void filter(Collection collection, Predicate predicate) {
        if (collection != null && predicate != null) {
            Iterator it = collection.iterator();
            while (it.hasNext()) {
                if (predicate.evaluate(it.next())) continue;
                it.remove();
            }
        }
    }

    public static void transform(Collection collection, Transformer transformer) {
        if (collection != null && transformer != null) {
            if (collection instanceof List) {
                List list = (List)collection;
                ListIterator<Object> it = list.listIterator();
                while (it.hasNext()) {
                    it.set(transformer.transform(it.next()));
                }
            } else {
                Collection resultCollection = CollectionUtils.collect(collection, transformer);
                collection.clear();
                collection.addAll(resultCollection);
            }
        }
    }

    public static int countMatches(Collection inputCollection, Predicate predicate) {
        int count = 0;
        if (inputCollection != null && predicate != null) {
            Iterator it = inputCollection.iterator();
            while (it.hasNext()) {
                if (!predicate.evaluate(it.next())) continue;
                ++count;
            }
        }
        return count;
    }

    public static boolean exists(Collection collection, Predicate predicate) {
        if (collection != null && predicate != null) {
            Iterator it = collection.iterator();
            while (it.hasNext()) {
                if (!predicate.evaluate(it.next())) continue;
                return true;
            }
        }
        return false;
    }

    public static Collection select(Collection inputCollection, Predicate predicate) {
        ArrayList answer = new ArrayList(inputCollection.size());
        CollectionUtils.select(inputCollection, predicate, answer);
        return answer;
    }

    public static void select(Collection inputCollection, Predicate predicate, Collection outputCollection) {
        if (inputCollection != null && predicate != null) {
            Iterator iter = inputCollection.iterator();
            while (iter.hasNext()) {
                Object item = iter.next();
                if (!predicate.evaluate(item)) continue;
                outputCollection.add(item);
            }
        }
    }

    public static Collection selectRejected(Collection inputCollection, Predicate predicate) {
        ArrayList answer = new ArrayList(inputCollection.size());
        CollectionUtils.selectRejected(inputCollection, predicate, answer);
        return answer;
    }

    public static void selectRejected(Collection inputCollection, Predicate predicate, Collection outputCollection) {
        if (inputCollection != null && predicate != null) {
            Iterator iter = inputCollection.iterator();
            while (iter.hasNext()) {
                Object item = iter.next();
                if (predicate.evaluate(item)) continue;
                outputCollection.add(item);
            }
        }
    }

    public static Collection collect(Collection inputCollection, Transformer transformer) {
        ArrayList answer = new ArrayList(inputCollection.size());
        CollectionUtils.collect(inputCollection, transformer, answer);
        return answer;
    }

    public static Collection collect(Iterator inputIterator, Transformer transformer) {
        ArrayList answer = new ArrayList();
        CollectionUtils.collect(inputIterator, transformer, answer);
        return answer;
    }

    public static Collection collect(Collection inputCollection, Transformer transformer, Collection outputCollection) {
        if (inputCollection != null) {
            return CollectionUtils.collect(inputCollection.iterator(), transformer, outputCollection);
        }
        return outputCollection;
    }

    public static Collection collect(Iterator inputIterator, Transformer transformer, Collection outputCollection) {
        if (inputIterator != null && transformer != null) {
            while (inputIterator.hasNext()) {
                Object item = inputIterator.next();
                Object value = transformer.transform(item);
                outputCollection.add(value);
            }
        }
        return outputCollection;
    }

    public static void addAll(Collection collection, Iterator iterator) {
        while (iterator.hasNext()) {
            collection.add(iterator.next());
        }
    }

    public static void addAll(Collection collection, Enumeration enumeration) {
        while (enumeration.hasMoreElements()) {
            collection.add(enumeration.nextElement());
        }
    }

    public static void addAll(Collection collection, Object[] elements) {
        int i = 0;
        int size = elements.length;
        while (i < size) {
            collection.add(elements[i]);
            ++i;
        }
    }

    public static Object index(Object obj, int idx) {
        return CollectionUtils.index(obj, new Integer(idx));
    }

    public static Object index(Object obj, Object index) {
        Map map;
        if (obj instanceof Map && (map = (Map)obj).containsKey(index)) {
            return map.get(index);
        }
        int idx = -1;
        if (index instanceof Integer) {
            idx = (Integer)index;
        }
        if (idx < 0) {
            return obj;
        }
        if (obj instanceof Map) {
            Map map2 = (Map)obj;
            Iterator iterator = map2.keySet().iterator();
            return CollectionUtils.index(iterator, idx);
        }
        if (obj instanceof List) {
            return ((List)obj).get(idx);
        }
        if (obj instanceof Object[]) {
            return ((Object[])obj)[idx];
        }
        if (obj instanceof Enumeration) {
            Enumeration enumeration = (Enumeration)obj;
            while (enumeration.hasMoreElements()) {
                if (--idx == -1) {
                    return enumeration.nextElement();
                }
                enumeration.nextElement();
            }
        } else {
            if (obj instanceof Iterator) {
                return CollectionUtils.index((Iterator)obj, idx);
            }
            if (obj instanceof Collection) {
                Iterator iterator = ((Collection)obj).iterator();
                return CollectionUtils.index(iterator, idx);
            }
        }
        return obj;
    }

    private static Object index(Iterator iterator, int idx) {
        while (iterator.hasNext()) {
            if (--idx == -1) {
                return iterator.next();
            }
            iterator.next();
        }
        return iterator;
    }

    public static Iterator getIterator(Object obj) {
        if (obj instanceof Iterator) {
            return (Iterator)obj;
        }
        if (obj instanceof Collection) {
            return ((Collection)obj).iterator();
        }
        if (obj instanceof Object[]) {
            return new ArrayIterator(obj);
        }
        if (obj instanceof Enumeration) {
            return new EnumerationIterator((Enumeration)obj);
        }
        if (obj instanceof Map) {
            return ((Map)obj).values().iterator();
        }
        if (obj != null && obj.getClass().isArray()) {
            return new ArrayIterator(obj);
        }
        return null;
    }

    public static void reverseArray(Object[] array) {
        int i = 0;
        int j = array.length - 1;
        while (j > i) {
            Object tmp = array[j];
            array[j] = array[i];
            array[i] = tmp;
            --j;
            ++i;
        }
    }

    private static final int getFreq(Object obj, Map freqMap) {
        try {
            return (Integer)freqMap.get(obj);
        }
        catch (NullPointerException e2) {
        }
        catch (NoSuchElementException e3) {
        }
        return 0;
    }

    public static boolean isFull(Collection coll) {
        if (coll == null) {
            throw new NullPointerException("The collection must not be null");
        }
        Collection unwrappedCollection = coll;
        while (true) {
            if (unwrappedCollection instanceof CollectionWrapper) {
                unwrappedCollection = ((CollectionWrapper)unwrappedCollection).collection;
                continue;
            }
            if (!(unwrappedCollection instanceof SynchronizedCollection)) break;
            unwrappedCollection = ((SynchronizedCollection)((Object)unwrappedCollection)).collection;
        }
        if (unwrappedCollection instanceof BoundedCollection) {
            return ((BoundedCollection)unwrappedCollection).isFull();
        }
        return false;
    }

    public static int maxSize(Collection coll) {
        if (coll == null) {
            throw new NullPointerException("The collection must not be null");
        }
        Collection unwrappedCollection = coll;
        while (true) {
            if (unwrappedCollection instanceof CollectionWrapper) {
                unwrappedCollection = ((CollectionWrapper)unwrappedCollection).collection;
                continue;
            }
            if (!(unwrappedCollection instanceof SynchronizedCollection)) break;
            unwrappedCollection = ((SynchronizedCollection)((Object)unwrappedCollection)).collection;
        }
        if (unwrappedCollection instanceof BoundedCollection) {
            return ((BoundedCollection)unwrappedCollection).maxSize();
        }
        return -1;
    }

    public static Collection synchronizedCollection(Collection collection) {
        return Collections.synchronizedCollection(collection);
    }

    public static Collection unmodifiableCollection(Collection collection) {
        return Collections.unmodifiableCollection(collection);
    }

    public static Collection predicatedCollection(Collection collection, Predicate predicate) {
        return new PredicatedCollection(collection, predicate);
    }

    static class SynchronizedCollection {
        protected final Collection collection;

        public SynchronizedCollection(Collection collection) {
            if (collection == null) {
                throw new IllegalArgumentException("Collection must not be null");
            }
            this.collection = collection;
        }

        public synchronized int size() {
            return this.collection.size();
        }

        public synchronized boolean isEmpty() {
            return this.collection.isEmpty();
        }

        public synchronized boolean contains(Object o) {
            return this.collection.contains(o);
        }

        public Iterator iterator() {
            return this.collection.iterator();
        }

        public synchronized Object[] toArray() {
            return this.collection.toArray();
        }

        public synchronized Object[] toArray(Object[] o) {
            return this.collection.toArray(o);
        }

        public synchronized boolean add(Object o) {
            return this.collection.add(o);
        }

        public synchronized boolean remove(Object o) {
            return this.collection.remove(o);
        }

        public synchronized boolean containsAll(Collection c2) {
            return this.collection.containsAll(c2);
        }

        public synchronized boolean addAll(Collection c2) {
            return this.collection.addAll(c2);
        }

        public synchronized boolean removeAll(Collection c2) {
            return this.collection.removeAll(c2);
        }

        public synchronized boolean retainAll(Collection c2) {
            return this.collection.retainAll(c2);
        }

        public synchronized void clear() {
            this.collection.clear();
        }

        public synchronized boolean equals(Object o) {
            return this.collection.equals(o);
        }

        public synchronized int hashCode() {
            return this.collection.hashCode();
        }

        public synchronized String toString() {
            return this.collection.toString();
        }
    }

    static class UnmodifiableCollection
    extends CollectionWrapper {
        public UnmodifiableCollection(Collection c2) {
            super(c2);
        }

        public boolean add(Object o) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(Collection c2) {
            throw new UnsupportedOperationException();
        }

        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        public boolean removeAll(Collection c2) {
            throw new UnsupportedOperationException();
        }

        public boolean retainAll(Collection c2) {
            throw new UnsupportedOperationException();
        }

        public void clear() {
            throw new UnsupportedOperationException();
        }

        public Iterator iterator() {
            return new IteratorUtils.UnmodifiableIterator(this.collection.iterator());
        }
    }

    static class PredicatedCollection
    extends CollectionWrapper {
        protected final Predicate predicate;

        public PredicatedCollection(Collection c2, Predicate p) {
            super(c2);
            if (p == null) {
                throw new IllegalArgumentException("Predicate must not be null");
            }
            this.predicate = p;
            Iterator iter = c2.iterator();
            while (iter.hasNext()) {
                this.validate(iter.next());
            }
        }

        public boolean add(Object o) {
            this.validate(o);
            return this.collection.add(o);
        }

        public boolean addAll(Collection c2) {
            Iterator iter = c2.iterator();
            while (iter.hasNext()) {
                this.validate(iter.next());
            }
            return this.collection.addAll(c2);
        }

        protected void validate(Object o) {
            if (!this.predicate.evaluate(o)) {
                throw new IllegalArgumentException("Cannot add Object - Predicate rejected it");
            }
        }
    }

    static class CollectionWrapper
    implements Collection {
        protected final Collection collection;

        public CollectionWrapper(Collection collection) {
            if (collection == null) {
                throw new IllegalArgumentException("Collection must not be null");
            }
            this.collection = collection;
        }

        public int size() {
            return this.collection.size();
        }

        public boolean isEmpty() {
            return this.collection.isEmpty();
        }

        public boolean contains(Object o) {
            return this.collection.contains(o);
        }

        public Iterator iterator() {
            return this.collection.iterator();
        }

        public Object[] toArray() {
            return this.collection.toArray();
        }

        public Object[] toArray(Object[] o) {
            return this.collection.toArray(o);
        }

        public boolean add(Object o) {
            return this.collection.add(o);
        }

        public boolean remove(Object o) {
            return this.collection.remove(o);
        }

        public boolean containsAll(Collection c2) {
            return this.collection.containsAll(c2);
        }

        public boolean addAll(Collection c2) {
            return this.collection.addAll(c2);
        }

        public boolean removeAll(Collection c2) {
            return this.collection.removeAll(c2);
        }

        public boolean retainAll(Collection c2) {
            return this.collection.retainAll(c2);
        }

        public void clear() {
            this.collection.clear();
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            return this.collection.equals(o);
        }

        public int hashCode() {
            return this.collection.hashCode();
        }

        public String toString() {
            return this.collection.toString();
        }
    }
}

