/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.commons.collections.BulkTest;

class BulkTestSuiteMaker {
    private Class startingClass;
    private List ignored;
    private TestSuite result;
    private String prefix;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$apache$commons$collections$BulkTest;

    public BulkTestSuiteMaker(Class startingClass) {
        this.startingClass = startingClass;
    }

    public TestSuite make() {
        this.result = new TestSuite();
        this.prefix = BulkTestSuiteMaker.getBaseName(this.startingClass);
        this.result.setName(this.prefix);
        BulkTest bulk = BulkTestSuiteMaker.makeFirstTestCase(this.startingClass);
        this.ignored = new ArrayList();
        String[] s = bulk.ignoredSimpleTests();
        if (s != null) {
            this.ignored.addAll(Arrays.asList(s));
        }
        this.make(bulk);
        return this.result;
    }

    void make(BulkTest bulk) {
        Class<?> c2 = bulk.getClass();
        Method[] all = c2.getMethods();
        int i = 0;
        while (i < all.length) {
            if (BulkTestSuiteMaker.isTest(all[i])) {
                this.addTest(bulk, all[i]);
            }
            if (BulkTestSuiteMaker.isBulk(all[i])) {
                this.addBulk(bulk, all[i]);
            }
            ++i;
        }
    }

    void addTest(BulkTest bulk, Method m) {
        BulkTest bulk2 = (BulkTest)bulk.clone();
        bulk2.setName(m.getName());
        bulk2.verboseName = this.prefix + "." + m.getName();
        if (this.ignored.contains(bulk2.verboseName)) {
            return;
        }
        this.result.addTest((Test)bulk2);
    }

    void addBulk(BulkTest bulk, Method m) {
        BulkTest bulk2;
        try {
            bulk2 = (BulkTest)m.invoke((Object)bulk, null);
            if (bulk2 == null) {
                return;
            }
        }
        catch (InvocationTargetException e2) {
            throw new Error();
        }
        catch (IllegalAccessException e3) {
            throw new Error();
        }
        String oldPrefix = this.prefix;
        TestSuite oldResult = this.result;
        this.prefix = this.prefix + "." + m.getName();
        this.result = new TestSuite();
        this.result.setName(m.getName());
        this.make(bulk2);
        oldResult.addTest((Test)this.result);
        this.prefix = oldPrefix;
        this.result = oldResult;
    }

    private static String getBaseName(Class c2) {
        String name = c2.getName();
        int p = name.lastIndexOf(46);
        if (p > 0) {
            name = name.substring(p + 1);
        }
        return name;
    }

    private static Constructor getTestCaseConstructor(Class c2) {
        try {
            return c2.getConstructor(class$java$lang$String == null ? (class$java$lang$String = BulkTestSuiteMaker.class$("java.lang.String")) : class$java$lang$String);
        }
        catch (NoSuchMethodException e2) {
            throw new IllegalArgumentException(c2 + " must provide " + "a (String) constructor");
        }
    }

    private static BulkTest makeTestCase(Class c2, Method m) {
        Constructor con = BulkTestSuiteMaker.getTestCaseConstructor(c2);
        try {
            return (BulkTest)con.newInstance(m.getName());
        }
        catch (InvocationTargetException e2) {
            e2.printStackTrace();
            throw new RuntimeException();
        }
        catch (IllegalAccessException e3) {
            throw new Error();
        }
        catch (InstantiationException e4) {
            throw new RuntimeException();
        }
    }

    private static BulkTest makeFirstTestCase(Class c2) {
        Method[] all = c2.getMethods();
        int i = 0;
        while (i < all.length) {
            if (BulkTestSuiteMaker.isTest(all[i])) {
                return BulkTestSuiteMaker.makeTestCase(c2, all[i]);
            }
            ++i;
        }
        throw new IllegalArgumentException(c2.getName() + " must provide " + " at least one test method.");
    }

    private static boolean isTest(Method m) {
        if (!m.getName().startsWith("test")) {
            return false;
        }
        if (m.getReturnType() != Void.TYPE) {
            return false;
        }
        if (m.getParameterTypes().length != 0) {
            return false;
        }
        int mods = m.getModifiers();
        if (Modifier.isStatic(mods)) {
            return false;
        }
        return !Modifier.isAbstract(mods);
    }

    private static boolean isBulk(Method m) {
        if (!m.getName().startsWith("bulkTest")) {
            return false;
        }
        if (m.getReturnType() != (class$org$apache$commons$collections$BulkTest == null ? (class$org$apache$commons$collections$BulkTest = BulkTestSuiteMaker.class$("org.apache.commons.collections.BulkTest")) : class$org$apache$commons$collections$BulkTest)) {
            return false;
        }
        if (m.getParameterTypes().length != 0) {
            return false;
        }
        int mods = m.getModifiers();
        if (Modifier.isStatic(mods)) {
            return false;
        }
        return !Modifier.isAbstract(mods);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

