/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.verifier.structurals;

import java.awt.Color;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import org.apache.bcel.generic.ASTORE;
import org.apache.bcel.generic.ATHROW;
import org.apache.bcel.generic.BranchInstruction;
import org.apache.bcel.generic.CodeExceptionGen;
import org.apache.bcel.generic.GotoInstruction;
import org.apache.bcel.generic.IndexedInstruction;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.JsrInstruction;
import org.apache.bcel.generic.LocalVariableInstruction;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.RET;
import org.apache.bcel.generic.ReturnInstruction;
import org.apache.bcel.generic.Select;
import org.apache.bcel.verifier.exc.AssertionViolatedException;
import org.apache.bcel.verifier.exc.StructuralCodeConstraintException;
import org.apache.bcel.verifier.structurals.Subroutine;

public class Subroutines {
    private Hashtable subroutines = new Hashtable();
    public final Subroutine TOPLEVEL;

    public Subroutines(MethodGen mg) {
        InstructionHandle[] all = mg.getInstructionList().getInstructionHandles();
        CodeExceptionGen[] handlers = mg.getExceptionHandlers();
        this.TOPLEVEL = new SubroutineImpl();
        HashSet<InstructionHandle> sub_leaders = new HashSet<InstructionHandle>();
        InstructionHandle ih = all[0];
        int i = 0;
        while (i < all.length) {
            Instruction inst = all[i].getInstruction();
            if (inst instanceof JsrInstruction) {
                sub_leaders.add(((JsrInstruction)inst).getTarget());
            }
            ++i;
        }
        Iterator iter = sub_leaders.iterator();
        while (iter.hasNext()) {
            SubroutineImpl sr = new SubroutineImpl();
            InstructionHandle astore = (InstructionHandle)iter.next();
            sr.setLocalVariable(((ASTORE)astore.getInstruction()).getIndex());
            this.subroutines.put(astore, sr);
        }
        this.subroutines.put(all[0], this.TOPLEVEL);
        sub_leaders.add(all[0]);
        int i2 = 0;
        while (i2 < all.length) {
            Instruction inst = all[i2].getInstruction();
            if (inst instanceof JsrInstruction) {
                InstructionHandle leader = ((JsrInstruction)inst).getTarget();
                ((SubroutineImpl)this.getSubroutine(leader)).addEnteringJsrInstruction(all[i2]);
            }
            ++i2;
        }
        HashSet<InstructionHandle> instructions_assigned = new HashSet<InstructionHandle>();
        Hashtable<InstructionHandle, Color> colors = new Hashtable<InstructionHandle, Color>();
        iter = sub_leaders.iterator();
        while (iter.hasNext()) {
            InstructionHandle actual = (InstructionHandle)iter.next();
            int i3 = 0;
            while (i3 < all.length) {
                colors.put(all[i3], Color.white);
                ++i3;
            }
            colors.put(actual, Color.gray);
            ArrayList<InstructionHandle> Q = new ArrayList<InstructionHandle>();
            Q.add(actual);
            if (actual == all[0]) {
                int j = 0;
                while (j < handlers.length) {
                    colors.put(handlers[j].getHandlerPC(), Color.gray);
                    Q.add(handlers[j].getHandlerPC());
                    ++j;
                }
            }
            while (Q.size() != 0) {
                InstructionHandle u = (InstructionHandle)Q.remove(0);
                InstructionHandle[] successors = Subroutines.getSuccessors(u);
                int i4 = 0;
                while (i4 < successors.length) {
                    if ((Color)colors.get(successors[i4]) == Color.white) {
                        colors.put(successors[i4], Color.gray);
                        Q.add(successors[i4]);
                    }
                    ++i4;
                }
                colors.put(u, Color.black);
            }
            int i5 = 0;
            while (i5 < all.length) {
                if (colors.get(all[i5]) == Color.black) {
                    ((SubroutineImpl)(actual == all[0] ? this.getTopLevel() : this.getSubroutine(actual))).addInstruction(all[i5]);
                    if (instructions_assigned.contains(all[i5])) {
                        throw new StructuralCodeConstraintException("Instruction '" + all[i5] + "' is part of more than one subroutine (or of the top level and a subroutine).");
                    }
                    instructions_assigned.add(all[i5]);
                }
                ++i5;
            }
            if (actual == all[0]) continue;
            ((SubroutineImpl)this.getSubroutine(actual)).setLeavingRET();
        }
        int i6 = 0;
        while (i6 < handlers.length) {
            InstructionHandle _protected = handlers[i6].getStartPC();
            while (_protected != handlers[i6].getEndPC().getNext()) {
                Enumeration subs = this.subroutines.elements();
                while (subs.hasMoreElements()) {
                    Subroutine sub = (Subroutine)subs.nextElement();
                    if (sub == this.subroutines.get(all[0]) || !sub.contains(_protected)) continue;
                    throw new StructuralCodeConstraintException("Subroutine instruction '" + _protected + "' is protected by an exception handler, '" + handlers[i6] + "'. This is forbidden by the JustIce verifier due to its clear definition of subroutines.");
                }
                _protected = _protected.getNext();
            }
            ++i6;
        }
        this.noRecursiveCalls(this.getTopLevel(), new HashSet());
    }

    private void noRecursiveCalls(Subroutine sub, HashSet set) {
        Subroutine[] subs = sub.subSubs();
        int i = 0;
        while (i < subs.length) {
            int index = ((RET)subs[i].getLeavingRET().getInstruction()).getIndex();
            if (!set.add(new Integer(index))) {
                SubroutineImpl si = (SubroutineImpl)subs[i];
                throw new StructuralCodeConstraintException("Subroutine with local variable '" + si.localVariable + "', JSRs '" + si.theJSRs + "', RET '" + si.theRET + "' is called by a subroutine which uses the same local variable index as itself; maybe even a recursive call? JustIce's clean definition of a subroutine forbids both.");
            }
            this.noRecursiveCalls(subs[i], set);
            set.remove(new Integer(index));
            ++i;
        }
    }

    public Subroutine getSubroutine(InstructionHandle leader) {
        Subroutine ret = (Subroutine)this.subroutines.get(leader);
        if (ret == null) {
            throw new AssertionViolatedException("Subroutine requested for an InstructionHandle that is not a leader of a subroutine.");
        }
        if (ret == this.TOPLEVEL) {
            throw new AssertionViolatedException("TOPLEVEL special subroutine requested; use getTopLevel().");
        }
        return ret;
    }

    public Subroutine subroutineOf(InstructionHandle any) {
        Iterator i = this.subroutines.values().iterator();
        while (i.hasNext()) {
            Subroutine s = (Subroutine)i.next();
            if (!s.contains(any)) continue;
            return s;
        }
        System.err.println("DEBUG: Please verify '" + any + "' lies in dead code.");
        return null;
    }

    public Subroutine getTopLevel() {
        return this.TOPLEVEL;
    }

    private static InstructionHandle[] getSuccessors(InstructionHandle instruction) {
        InstructionHandle[] empty = new InstructionHandle[]{};
        InstructionHandle[] single = new InstructionHandle[1];
        InstructionHandle[] pair = new InstructionHandle[2];
        Instruction inst = instruction.getInstruction();
        if (inst instanceof RET) {
            return empty;
        }
        if (inst instanceof ReturnInstruction) {
            return empty;
        }
        if (inst instanceof ATHROW) {
            return empty;
        }
        if (inst instanceof JsrInstruction) {
            single[0] = instruction.getNext();
            return single;
        }
        if (inst instanceof GotoInstruction) {
            single[0] = ((GotoInstruction)inst).getTarget();
            return single;
        }
        if (inst instanceof BranchInstruction) {
            if (inst instanceof Select) {
                InstructionHandle[] matchTargets = ((Select)inst).getTargets();
                InstructionHandle[] ret = new InstructionHandle[matchTargets.length + 1];
                ret[0] = ((Select)inst).getTarget();
                System.arraycopy(matchTargets, 0, ret, 1, matchTargets.length);
                return ret;
            }
            pair[0] = instruction.getNext();
            pair[1] = ((BranchInstruction)inst).getTarget();
            return pair;
        }
        single[0] = instruction.getNext();
        return single;
    }

    public String toString() {
        return "---\n" + this.subroutines.toString() + "\n---\n";
    }

    private class SubroutineImpl
    implements Subroutine {
        private final int UNSET = -1;
        private int localVariable = -1;
        private HashSet instructions = new HashSet();
        private HashSet theJSRs = new HashSet();
        private InstructionHandle theRET;

        public boolean contains(InstructionHandle inst) {
            return this.instructions.contains(inst);
        }

        public String toString() {
            String ret = "Subroutine: Local variable is '" + this.localVariable + "', JSRs are '" + this.theJSRs + "', RET is '" + this.theRET + "', Instructions: '" + this.instructions.toString() + "'.";
            ret = ret + " Accessed local variable slots: '";
            int[] alv = this.getAccessedLocalsIndices();
            int i = 0;
            while (i < alv.length) {
                ret = ret + alv[i] + " ";
                ++i;
            }
            ret = ret + "'.";
            ret = ret + " Recursively (via subsub...routines) accessed local variable slots: '";
            alv = this.getRecursivelyAccessedLocalsIndices();
            int i2 = 0;
            while (i2 < alv.length) {
                ret = ret + alv[i2] + " ";
                ++i2;
            }
            ret = ret + "'.";
            return ret;
        }

        void setLeavingRET() {
            if (this.localVariable == -1) {
                throw new AssertionViolatedException("setLeavingRET() called for top-level 'subroutine' or forgot to set local variable first.");
            }
            Iterator iter = this.instructions.iterator();
            InstructionHandle ret = null;
            while (iter.hasNext()) {
                InstructionHandle actual = (InstructionHandle)iter.next();
                if (!(actual.getInstruction() instanceof RET)) continue;
                if (ret != null) {
                    throw new StructuralCodeConstraintException("Subroutine with more then one RET detected: '" + ret + "' and '" + actual + "'.");
                }
                ret = actual;
            }
            if (ret == null) {
                throw new StructuralCodeConstraintException("Subroutine without a RET detected.");
            }
            if (((RET)ret.getInstruction()).getIndex() != this.localVariable) {
                throw new StructuralCodeConstraintException("Subroutine uses '" + ret + "' which does not match the correct local variable '" + this.localVariable + "'.");
            }
            this.theRET = ret;
        }

        public InstructionHandle[] getEnteringJsrInstructions() {
            if (this == Subroutines.this.TOPLEVEL) {
                throw new AssertionViolatedException("getLeavingRET() called on top level pseudo-subroutine.");
            }
            InstructionHandle[] jsrs = new InstructionHandle[this.theJSRs.size()];
            return ((AbstractCollection)this.theJSRs).toArray(jsrs);
        }

        public void addEnteringJsrInstruction(InstructionHandle jsrInst) {
            if (jsrInst == null || !(jsrInst.getInstruction() instanceof JsrInstruction)) {
                throw new AssertionViolatedException("Expecting JsrInstruction InstructionHandle.");
            }
            if (this.localVariable == -1) {
                throw new AssertionViolatedException("Set the localVariable first!");
            }
            if (this.localVariable != ((ASTORE)((JsrInstruction)jsrInst.getInstruction()).getTarget().getInstruction()).getIndex()) {
                throw new AssertionViolatedException("Setting a wrong JsrInstruction.");
            }
            this.theJSRs.add(jsrInst);
        }

        public InstructionHandle getLeavingRET() {
            if (this == Subroutines.this.TOPLEVEL) {
                throw new AssertionViolatedException("getLeavingRET() called on top level pseudo-subroutine.");
            }
            return this.theRET;
        }

        public InstructionHandle[] getInstructions() {
            InstructionHandle[] ret = new InstructionHandle[this.instructions.size()];
            return ((AbstractCollection)this.instructions).toArray(ret);
        }

        void addInstruction(InstructionHandle ih) {
            if (this.theRET != null) {
                throw new AssertionViolatedException("All instructions must have been added before invoking setLeavingRET().");
            }
            this.instructions.add(ih);
        }

        public int[] getRecursivelyAccessedLocalsIndices() {
            HashSet<Integer> s = new HashSet<Integer>();
            int[] lvs = this.getAccessedLocalsIndices();
            int j = 0;
            while (j < lvs.length) {
                s.add(new Integer(lvs[j]));
                ++j;
            }
            this._getRecursivelyAccessedLocalsIndicesHelper(s, this.subSubs());
            int[] ret = new int[s.size()];
            Iterator i = s.iterator();
            int j2 = -1;
            while (i.hasNext()) {
                ret[++j2] = (Integer)i.next();
            }
            return ret;
        }

        private void _getRecursivelyAccessedLocalsIndicesHelper(HashSet s, Subroutine[] subs) {
            int i = 0;
            while (i < subs.length) {
                int[] lvs = subs[i].getAccessedLocalsIndices();
                int j = 0;
                while (j < lvs.length) {
                    s.add(new Integer(lvs[j]));
                    ++j;
                }
                if (subs[i].subSubs().length != 0) {
                    this._getRecursivelyAccessedLocalsIndicesHelper(s, subs[i].subSubs());
                }
                ++i;
            }
        }

        public int[] getAccessedLocalsIndices() {
            HashSet<Integer> acc = new HashSet<Integer>();
            if (this.theRET == null && this != Subroutines.this.TOPLEVEL) {
                throw new AssertionViolatedException("This subroutine object must be built up completely before calculating accessed locals.");
            }
            Iterator i = this.instructions.iterator();
            while (i.hasNext()) {
                InstructionHandle ih = (InstructionHandle)i.next();
                if (!(ih.getInstruction() instanceof LocalVariableInstruction) && !(ih.getInstruction() instanceof RET)) continue;
                int idx = ((IndexedInstruction)((Object)ih.getInstruction())).getIndex();
                acc.add(new Integer(idx));
                try {
                    int s;
                    if (!(ih.getInstruction() instanceof LocalVariableInstruction) || (s = ((LocalVariableInstruction)ih.getInstruction()).getType(null).getSize()) != 2) continue;
                    acc.add(new Integer(idx + 1));
                }
                catch (RuntimeException re) {
                    throw new AssertionViolatedException("Oops. BCEL did not like NULL as a ConstantPoolGen object.");
                }
            }
            int[] ret = new int[acc.size()];
            i = acc.iterator();
            int j = -1;
            while (i.hasNext()) {
                ret[++j] = (Integer)i.next();
            }
            return ret;
        }

        public Subroutine[] subSubs() {
            HashSet<Subroutine> h2 = new HashSet<Subroutine>();
            Iterator i = this.instructions.iterator();
            while (i.hasNext()) {
                Instruction inst = ((InstructionHandle)i.next()).getInstruction();
                if (!(inst instanceof JsrInstruction)) continue;
                InstructionHandle targ = ((JsrInstruction)inst).getTarget();
                h2.add(Subroutines.this.getSubroutine(targ));
            }
            Subroutine[] ret = new Subroutine[h2.size()];
            return ((AbstractCollection)h2).toArray(ret);
        }

        void setLocalVariable(int i) {
            if (this.localVariable != -1) {
                throw new AssertionViolatedException("localVariable set twice.");
            }
            this.localVariable = i;
        }
    }
}

