/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.transcoder.svg2svg;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.LinkedList;
import org.apache.batik.transcoder.ErrorHandler;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.svg2svg.OutputManager;
import org.apache.batik.transcoder.svg2svg.SVGTranscoder;
import org.apache.batik.xml.XMLException;
import org.apache.batik.xml.XMLScanner;

public class PrettyPrinter {
    public static final int DOCTYPE_CHANGE = 0;
    public static final int DOCTYPE_REMOVE = 1;
    public static final int DOCTYPE_KEEP_UNCHANGED = 2;
    protected XMLScanner scanner;
    protected OutputManager output;
    protected Writer writer;
    protected ErrorHandler errorHandler = SVGTranscoder.DEFAULT_ERROR_HANDLER;
    protected String newline = "\n";
    protected boolean format = true;
    protected int tabulationWidth = 4;
    protected int documentWidth = 80;
    protected int doctypeOption = 2;
    protected String publicId;
    protected String systemId;
    protected String xmlDeclaration;
    protected int type;

    public void setXMLDeclaration(String string) {
        this.xmlDeclaration = string;
    }

    public void setDoctypeOption(int n) {
        this.doctypeOption = n;
    }

    public void setPublicId(String string) {
        this.publicId = string;
    }

    public void setSystemId(String string) {
        this.systemId = string;
    }

    public void setNewline(String string) {
        this.newline = string;
    }

    public String getNewline() {
        return this.newline;
    }

    public void setFormat(boolean bl) {
        this.format = bl;
    }

    public boolean getFormat() {
        return this.format;
    }

    public void setTabulationWidth(int n) {
        this.tabulationWidth = Math.max(n, 0);
    }

    public int getTabulationWidth() {
        return this.tabulationWidth;
    }

    public void setDocumentWidth(int n) {
        this.documentWidth = Math.max(n, 0);
    }

    public int getDocumentWidth() {
        return this.documentWidth;
    }

    public void print(Reader reader, Writer writer) throws TranscoderException, IOException {
        try {
            this.scanner = new XMLScanner(reader);
            this.output = new OutputManager(this, writer);
            this.writer = writer;
            this.type = this.scanner.next();
            this.printXMLDecl();
            block17: while (true) {
                switch (this.type) {
                    case 1: {
                        this.output.printTopSpaces(this.getCurrentValue());
                        this.scanner.clearBuffer();
                        this.type = this.scanner.next();
                        continue block17;
                    }
                    case 4: {
                        this.output.printComment(this.getCurrentValue());
                        this.scanner.clearBuffer();
                        this.type = this.scanner.next();
                        continue block17;
                    }
                    case 5: {
                        this.printPI();
                        continue block17;
                    }
                }
                break;
            }
            this.printDoctype();
            block18: while (true) {
                this.scanner.clearBuffer();
                switch (this.type) {
                    case 1: {
                        this.output.printTopSpaces(this.getCurrentValue());
                        this.scanner.clearBuffer();
                        this.type = this.scanner.next();
                        continue block18;
                    }
                    case 4: {
                        this.output.printComment(this.getCurrentValue());
                        this.scanner.clearBuffer();
                        this.type = this.scanner.next();
                        continue block18;
                    }
                    case 5: {
                        this.printPI();
                        continue block18;
                    }
                }
                break;
            }
            if (this.type != 9) {
                throw this.fatalError("element", null);
            }
            this.printElement();
            block19: while (true) {
                switch (this.type) {
                    case 1: {
                        this.output.printTopSpaces(this.getCurrentValue());
                        this.scanner.clearBuffer();
                        this.type = this.scanner.next();
                        continue block19;
                    }
                    case 4: {
                        this.output.printComment(this.getCurrentValue());
                        this.scanner.clearBuffer();
                        this.type = this.scanner.next();
                        continue block19;
                    }
                    case 5: {
                        this.printPI();
                        continue block19;
                    }
                }
                break;
            }
        }
        catch (XMLException xMLException) {
            this.errorHandler.fatalError(new TranscoderException(xMLException.getMessage()));
        }
    }

    protected void printXMLDecl() throws TranscoderException, XMLException, IOException {
        if (this.xmlDeclaration == null) {
            if (this.type == 2) {
                if (this.scanner.next() != 1) {
                    throw this.fatalError("space", null);
                }
                char[] cArray = this.getCurrentValue();
                if (this.scanner.next() != 22) {
                    throw this.fatalError("token", new Object[]{"version"});
                }
                this.type = this.scanner.next();
                char[] cArray2 = null;
                if (this.type == 1) {
                    cArray2 = this.getCurrentValue();
                    this.type = this.scanner.next();
                }
                if (this.type != 15) {
                    throw this.fatalError("token", new Object[]{"="});
                }
                this.type = this.scanner.next();
                char[] cArray3 = null;
                if (this.type == 1) {
                    cArray3 = this.getCurrentValue();
                    this.type = this.scanner.next();
                }
                if (this.type != 25) {
                    throw this.fatalError("string", null);
                }
                char[] cArray4 = this.getCurrentValue();
                char c2 = this.scanner.getStringDelimiter();
                char[] cArray5 = null;
                char[] cArray6 = null;
                char[] cArray7 = null;
                char[] cArray8 = null;
                char c3 = '\u0000';
                char[] cArray9 = null;
                char[] cArray10 = null;
                char[] cArray11 = null;
                char[] cArray12 = null;
                char c4 = '\u0000';
                char[] cArray13 = null;
                this.type = this.scanner.next();
                if (this.type == 1) {
                    cArray5 = this.getCurrentValue();
                    this.type = this.scanner.next();
                    if (this.type == 23) {
                        this.type = this.scanner.next();
                        if (this.type == 1) {
                            cArray6 = this.getCurrentValue();
                            this.type = this.scanner.next();
                        }
                        if (this.type != 15) {
                            throw this.fatalError("token", new Object[]{"="});
                        }
                        this.type = this.scanner.next();
                        if (this.type == 1) {
                            cArray7 = this.getCurrentValue();
                            this.type = this.scanner.next();
                        }
                        if (this.type != 25) {
                            throw this.fatalError("string", null);
                        }
                        cArray8 = this.getCurrentValue();
                        c3 = this.scanner.getStringDelimiter();
                        this.type = this.scanner.next();
                        if (this.type == 1) {
                            cArray9 = this.getCurrentValue();
                            this.type = this.scanner.next();
                        }
                    }
                    if (this.type == 24) {
                        this.type = this.scanner.next();
                        if (this.type == 1) {
                            cArray10 = this.getCurrentValue();
                            this.type = this.scanner.next();
                        }
                        if (this.type != 15) {
                            throw this.fatalError("token", new Object[]{"="});
                        }
                        this.type = this.scanner.next();
                        if (this.type == 1) {
                            cArray11 = this.getCurrentValue();
                            this.type = this.scanner.next();
                        }
                        if (this.type != 25) {
                            throw this.fatalError("string", null);
                        }
                        cArray12 = this.getCurrentValue();
                        c4 = this.scanner.getStringDelimiter();
                        this.type = this.scanner.next();
                        if (this.type == 1) {
                            cArray13 = this.getCurrentValue();
                            this.type = this.scanner.next();
                        }
                    }
                }
                if (this.type != 7) {
                    throw this.fatalError("pi.end", null);
                }
                this.output.printXMLDecl(cArray, cArray2, cArray3, cArray4, c2, cArray5, cArray6, cArray7, cArray8, c3, cArray9, cArray10, cArray11, cArray12, c4, cArray13);
                this.type = this.scanner.next();
            }
        } else {
            this.output.printString(this.xmlDeclaration);
            this.output.printNewline();
            if (this.type == 2) {
                if (this.scanner.next() != 1) {
                    throw this.fatalError("space", null);
                }
                if (this.scanner.next() != 22) {
                    throw this.fatalError("token", new Object[]{"version"});
                }
                this.type = this.scanner.next();
                if (this.type == 1) {
                    this.type = this.scanner.next();
                }
                if (this.type != 15) {
                    throw this.fatalError("token", new Object[]{"="});
                }
                this.type = this.scanner.next();
                if (this.type == 1) {
                    this.type = this.scanner.next();
                }
                if (this.type != 25) {
                    throw this.fatalError("string", null);
                }
                this.type = this.scanner.next();
                if (this.type == 1) {
                    this.type = this.scanner.next();
                    if (this.type == 23) {
                        this.type = this.scanner.next();
                        if (this.type == 1) {
                            this.type = this.scanner.next();
                        }
                        if (this.type != 15) {
                            throw this.fatalError("token", new Object[]{"="});
                        }
                        this.type = this.scanner.next();
                        if (this.type == 1) {
                            this.type = this.scanner.next();
                        }
                        if (this.type != 25) {
                            throw this.fatalError("string", null);
                        }
                        this.type = this.scanner.next();
                        if (this.type == 1) {
                            this.type = this.scanner.next();
                        }
                    }
                    if (this.type == 24) {
                        this.type = this.scanner.next();
                        if (this.type == 1) {
                            this.type = this.scanner.next();
                        }
                        if (this.type != 15) {
                            throw this.fatalError("token", new Object[]{"="});
                        }
                        this.type = this.scanner.next();
                        if (this.type == 1) {
                            this.type = this.scanner.next();
                        }
                        if (this.type != 25) {
                            throw this.fatalError("string", null);
                        }
                        this.type = this.scanner.next();
                        if (this.type == 1) {
                            this.type = this.scanner.next();
                        }
                    }
                }
                if (this.type != 7) {
                    throw this.fatalError("pi.end", null);
                }
                this.type = this.scanner.next();
            }
        }
    }

    protected void printPI() throws TranscoderException, XMLException, IOException {
        char[] cArray = this.getCurrentValue();
        this.type = this.scanner.next();
        char[] cArray2 = new char[]{};
        if (this.type == 1) {
            cArray2 = this.getCurrentValue();
            this.type = this.scanner.next();
        }
        if (this.type != 6) {
            throw this.fatalError("pi.data", null);
        }
        char[] cArray3 = this.getCurrentValue();
        this.type = this.scanner.next();
        if (this.type != 7) {
            throw this.fatalError("pi.end", null);
        }
        this.output.printPI(cArray, cArray2, cArray3);
        this.type = this.scanner.next();
    }

    protected void printDoctype() throws TranscoderException, XMLException, IOException {
        switch (this.doctypeOption) {
            default: {
                if (this.type == 3) {
                    this.type = this.scanner.next();
                    if (this.type != 1) {
                        throw this.fatalError("space", null);
                    }
                    char[] cArray = this.getCurrentValue();
                    this.type = this.scanner.next();
                    if (this.type != 14) {
                        throw this.fatalError("name", null);
                    }
                    char[] cArray2 = this.getCurrentValue();
                    char[] cArray3 = null;
                    String string = null;
                    char[] cArray4 = null;
                    char[] cArray5 = null;
                    char c2 = '\u0000';
                    char[] cArray6 = null;
                    char[] cArray7 = null;
                    int n = 0;
                    char[] cArray8 = null;
                    this.type = this.scanner.next();
                    if (this.type == 1) {
                        cArray3 = this.getCurrentValue();
                        this.type = this.scanner.next();
                        switch (this.type) {
                            case 27: {
                                string = "PUBLIC";
                                this.type = this.scanner.next();
                                if (this.type != 1) {
                                    throw this.fatalError("space", null);
                                }
                                cArray4 = this.getCurrentValue();
                                this.type = this.scanner.next();
                                if (this.type != 25) {
                                    throw this.fatalError("string", null);
                                }
                                cArray5 = this.getCurrentValue();
                                c2 = this.scanner.getStringDelimiter();
                                this.type = this.scanner.next();
                                if (this.type != 1) {
                                    throw this.fatalError("space", null);
                                }
                                cArray6 = this.getCurrentValue();
                                this.type = this.scanner.next();
                                if (this.type != 25) {
                                    throw this.fatalError("string", null);
                                }
                                cArray7 = this.getCurrentValue();
                                n = this.scanner.getStringDelimiter();
                                this.type = this.scanner.next();
                                if (this.type != 1) break;
                                cArray8 = this.getCurrentValue();
                                this.type = this.scanner.next();
                                break;
                            }
                            case 26: {
                                string = "SYSTEM";
                                this.type = this.scanner.next();
                                if (this.type != 1) {
                                    throw this.fatalError("space", null);
                                }
                                cArray4 = this.getCurrentValue();
                                this.type = this.scanner.next();
                                if (this.type != 25) {
                                    throw this.fatalError("string", null);
                                }
                                cArray5 = this.getCurrentValue();
                                c2 = this.scanner.getStringDelimiter();
                                this.type = this.scanner.next();
                                if (this.type != 1) break;
                                cArray6 = this.getCurrentValue();
                                this.type = this.scanner.next();
                            }
                        }
                    }
                    if (this.doctypeOption == 0) {
                        if (this.publicId != null) {
                            string = "PUBLIC";
                            cArray5 = this.publicId.toCharArray();
                            c2 = '\"';
                            if (this.systemId != null) {
                                cArray7 = this.systemId.toCharArray();
                                n = 34;
                            }
                        } else if (this.systemId != null) {
                            string = "SYSTEM";
                            cArray5 = this.systemId.toCharArray();
                            c2 = '\"';
                            cArray7 = null;
                        }
                    }
                    this.output.printDoctypeStart(cArray, cArray2, cArray3, string, cArray4, cArray5, c2, cArray6, cArray7, (char)n, cArray8);
                    if (this.type == 28) {
                        this.output.printCharacter('[');
                        this.type = this.scanner.next();
                        block22: while (true) {
                            switch (this.type) {
                                case 1: {
                                    this.output.printSpaces(this.getCurrentValue(), true);
                                    this.scanner.clearBuffer();
                                    this.type = this.scanner.next();
                                    continue block22;
                                }
                                case 4: {
                                    this.output.printComment(this.getCurrentValue());
                                    this.scanner.clearBuffer();
                                    this.type = this.scanner.next();
                                    continue block22;
                                }
                                case 5: {
                                    this.printPI();
                                    continue block22;
                                }
                                case 34: {
                                    this.output.printParameterEntityReference(this.getCurrentValue());
                                    this.scanner.clearBuffer();
                                    this.type = this.scanner.next();
                                    continue block22;
                                }
                                case 30: {
                                    this.scanner.clearBuffer();
                                    this.printElementDeclaration();
                                    continue block22;
                                }
                                case 31: {
                                    this.scanner.clearBuffer();
                                    this.printAttlist();
                                    continue block22;
                                }
                                case 33: {
                                    this.scanner.clearBuffer();
                                    this.printNotation();
                                    continue block22;
                                }
                                case 32: {
                                    this.scanner.clearBuffer();
                                    this.printEntityDeclaration();
                                    continue block22;
                                }
                                case 29: {
                                    this.output.printCharacter(']');
                                    this.scanner.clearBuffer();
                                    this.type = this.scanner.next();
                                    break block22;
                                }
                                default: {
                                    throw this.fatalError("xml", null);
                                }
                            }
                            break;
                        }
                    }
                    char[] cArray9 = null;
                    if (this.type == 1) {
                        cArray9 = this.getCurrentValue();
                        this.type = this.scanner.next();
                    }
                    if (this.type != 20) {
                        throw this.fatalError("end", null);
                    }
                    this.type = this.scanner.next();
                    this.output.printDoctypeEnd(cArray9);
                    break;
                }
                if (this.doctypeOption != 0) break;
                String string = "PUBLIC";
                char[] cArray = "-//W3C//DTD SVG 1.0//EN".toCharArray();
                char[] cArray10 = "http://www.w3.org/TR/2001/REC-SVG-20010904/DTD/svg10.dtd".toCharArray();
                if (this.publicId != null) {
                    cArray = this.publicId.toCharArray();
                    if (this.systemId != null) {
                        cArray10 = this.systemId.toCharArray();
                    }
                } else if (this.systemId != null) {
                    string = "SYSTEM";
                    cArray = this.systemId.toCharArray();
                    cArray10 = null;
                }
                this.output.printDoctypeStart(new char[]{' '}, new char[]{'s', 'v', 'g'}, new char[]{' '}, string, new char[]{' '}, cArray, '\"', new char[]{' '}, cArray10, '\"', null);
                this.output.printDoctypeEnd(null);
                break;
            }
            case 1: {
                if (this.type == 3) {
                    this.type = this.scanner.next();
                    if (this.type != 1) {
                        throw this.fatalError("space", null);
                    }
                    this.type = this.scanner.next();
                    if (this.type != 14) {
                        throw this.fatalError("name", null);
                    }
                    this.type = this.scanner.next();
                    if (this.type == 1) {
                        this.type = this.scanner.next();
                        switch (this.type) {
                            case 27: {
                                this.type = this.scanner.next();
                                if (this.type != 1) {
                                    throw this.fatalError("space", null);
                                }
                                this.type = this.scanner.next();
                                if (this.type != 25) {
                                    throw this.fatalError("string", null);
                                }
                                this.type = this.scanner.next();
                                if (this.type != 1) {
                                    throw this.fatalError("space", null);
                                }
                                this.type = this.scanner.next();
                                if (this.type != 25) {
                                    throw this.fatalError("string", null);
                                }
                                this.type = this.scanner.next();
                                if (this.type != 1) break;
                                this.type = this.scanner.next();
                                break;
                            }
                            case 26: {
                                this.type = this.scanner.next();
                                if (this.type != 1) {
                                    throw this.fatalError("space", null);
                                }
                                this.type = this.scanner.next();
                                if (this.type != 25) {
                                    throw this.fatalError("string", null);
                                }
                                this.type = this.scanner.next();
                                if (this.type != 1) break;
                                this.type = this.scanner.next();
                            }
                        }
                    }
                    if (this.type == 28) {
                        do {
                            this.type = this.scanner.next();
                        } while (this.type != 29);
                    }
                    if (this.type == 1) {
                        this.type = this.scanner.next();
                    }
                    if (this.type != 20) {
                        throw this.fatalError("end", null);
                    }
                }
                this.type = this.scanner.next();
            }
        }
    }

    protected String printElement() throws TranscoderException, XMLException, IOException {
        char[] cArray = this.getCurrentValue();
        String string = new String(cArray);
        LinkedList<OutputManager.AttributeInfo> linkedList = new LinkedList<OutputManager.AttributeInfo>();
        char[] cArray2 = null;
        this.type = this.scanner.next();
        while (this.type == 1) {
            cArray2 = this.getCurrentValue();
            this.type = this.scanner.next();
            if (this.type != 14) continue;
            char[] cArray3 = this.getCurrentValue();
            char[] cArray4 = null;
            this.type = this.scanner.next();
            if (this.type == 1) {
                cArray4 = this.getCurrentValue();
                this.type = this.scanner.next();
            }
            if (this.type != 15) {
                throw this.fatalError("token", new Object[]{"="});
            }
            this.type = this.scanner.next();
            char[] cArray5 = null;
            if (this.type == 1) {
                cArray5 = this.getCurrentValue();
                this.type = this.scanner.next();
            }
            if (this.type != 25 && this.type != 16) {
                throw this.fatalError("string", null);
            }
            char c2 = this.scanner.getStringDelimiter();
            boolean bl = false;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.getCurrentValue());
            block10: while (true) {
                this.scanner.clearBuffer();
                this.type = this.scanner.next();
                switch (this.type) {
                    case 16: 
                    case 17: 
                    case 18: 
                    case 25: {
                        stringBuffer.append(this.getCurrentValue());
                        continue block10;
                    }
                    case 12: {
                        bl = true;
                        stringBuffer.append("&#");
                        stringBuffer.append(this.getCurrentValue());
                        stringBuffer.append(";");
                        continue block10;
                    }
                    case 13: {
                        bl = true;
                        stringBuffer.append("&");
                        stringBuffer.append(this.getCurrentValue());
                        stringBuffer.append(";");
                        continue block10;
                    }
                }
                break;
            }
            linkedList.add(new OutputManager.AttributeInfo(cArray2, cArray3, cArray4, cArray5, new String(stringBuffer), c2, bl));
            cArray2 = null;
        }
        this.output.printElementStart(cArray, linkedList, cArray2);
        switch (this.type) {
            default: {
                throw this.fatalError("xml", null);
            }
            case 19: {
                this.output.printElementEnd(null, null);
                break;
            }
            case 20: {
                this.output.printCharacter('>');
                this.type = this.scanner.next();
                this.printContent(this.allowSpaceAtStart(string));
                if (this.type != 10) {
                    throw this.fatalError("end.tag", null);
                }
                cArray = this.getCurrentValue();
                this.type = this.scanner.next();
                cArray2 = null;
                if (this.type == 1) {
                    cArray2 = this.getCurrentValue();
                    this.type = this.scanner.next();
                }
                this.output.printElementEnd(cArray, cArray2);
                if (this.type == 20) break;
                throw this.fatalError("end", null);
            }
        }
        this.type = this.scanner.next();
        return string;
    }

    boolean allowSpaceAtStart(String string) {
        return true;
    }

    protected void printContent(boolean bl) throws TranscoderException, XMLException, IOException {
        boolean bl2 = false;
        block9: while (true) {
            switch (this.type) {
                case 4: {
                    this.output.printComment(this.getCurrentValue());
                    this.scanner.clearBuffer();
                    this.type = this.scanner.next();
                    bl2 = false;
                    continue block9;
                }
                case 5: {
                    this.printPI();
                    bl2 = false;
                    continue block9;
                }
                case 8: {
                    bl2 = this.output.printCharacterData(this.getCurrentValue(), bl, bl2);
                    this.scanner.clearBuffer();
                    this.type = this.scanner.next();
                    bl = false;
                    continue block9;
                }
                case 11: {
                    this.type = this.scanner.next();
                    if (this.type != 8) {
                        throw this.fatalError("character.data", null);
                    }
                    this.output.printCDATASection(this.getCurrentValue());
                    if (this.scanner.next() != 21) {
                        throw this.fatalError("section.end", null);
                    }
                    this.scanner.clearBuffer();
                    this.type = this.scanner.next();
                    bl2 = false;
                    bl = false;
                    continue block9;
                }
                case 9: {
                    String string = this.printElement();
                    bl = this.allowSpaceAtStart(string);
                    continue block9;
                }
                case 12: {
                    this.output.printCharacterEntityReference(this.getCurrentValue(), bl, bl2);
                    this.scanner.clearBuffer();
                    this.type = this.scanner.next();
                    bl = false;
                    bl2 = false;
                    continue block9;
                }
                case 13: {
                    this.output.printEntityReference(this.getCurrentValue(), bl);
                    this.scanner.clearBuffer();
                    this.type = this.scanner.next();
                    bl = false;
                    bl2 = false;
                    continue block9;
                }
            }
            break;
        }
    }

    protected void printNotation() throws TranscoderException, XMLException, IOException {
        int n = this.scanner.next();
        if (n != 1) {
            throw this.fatalError("space", null);
        }
        char[] cArray = this.getCurrentValue();
        n = this.scanner.next();
        if (n != 14) {
            throw this.fatalError("name", null);
        }
        char[] cArray2 = this.getCurrentValue();
        n = this.scanner.next();
        if (n != 1) {
            throw this.fatalError("space", null);
        }
        char[] cArray3 = this.getCurrentValue();
        n = this.scanner.next();
        String string = null;
        char[] cArray4 = null;
        char[] cArray5 = null;
        char c2 = '\u0000';
        char[] cArray6 = null;
        char[] cArray7 = null;
        char c3 = '\u0000';
        switch (n) {
            default: {
                throw this.fatalError("notation.definition", null);
            }
            case 27: {
                string = "PUBLIC";
                n = this.scanner.next();
                if (n != 1) {
                    throw this.fatalError("space", null);
                }
                cArray4 = this.getCurrentValue();
                n = this.scanner.next();
                if (n != 25) {
                    throw this.fatalError("string", null);
                }
                cArray5 = this.getCurrentValue();
                c2 = this.scanner.getStringDelimiter();
                n = this.scanner.next();
                if (n != 1) break;
                cArray6 = this.getCurrentValue();
                n = this.scanner.next();
                if (n != 25) break;
                cArray7 = this.getCurrentValue();
                c3 = this.scanner.getStringDelimiter();
                n = this.scanner.next();
                break;
            }
            case 26: {
                string = "SYSTEM";
                n = this.scanner.next();
                if (n != 1) {
                    throw this.fatalError("space", null);
                }
                cArray4 = this.getCurrentValue();
                n = this.scanner.next();
                if (n != 25) {
                    throw this.fatalError("string", null);
                }
                cArray5 = this.getCurrentValue();
                c2 = this.scanner.getStringDelimiter();
                n = this.scanner.next();
            }
        }
        char[] cArray8 = null;
        if (n == 1) {
            cArray8 = this.getCurrentValue();
            n = this.scanner.next();
        }
        if (n != 20) {
            throw this.fatalError("end", null);
        }
        this.output.printNotation(cArray, cArray2, cArray3, string, cArray4, cArray5, c2, cArray6, cArray7, c3, cArray8);
        this.scanner.next();
    }

    protected void printAttlist() throws TranscoderException, XMLException, IOException {
        this.type = this.scanner.next();
        if (this.type != 1) {
            throw this.fatalError("space", null);
        }
        char[] cArray = this.getCurrentValue();
        this.type = this.scanner.next();
        if (this.type != 14) {
            throw this.fatalError("name", null);
        }
        char[] cArray2 = this.getCurrentValue();
        this.type = this.scanner.next();
        this.output.printAttlistStart(cArray, cArray2);
        while (this.type == 1) {
            cArray = this.getCurrentValue();
            this.type = this.scanner.next();
            if (this.type != 14) break;
            cArray2 = this.getCurrentValue();
            this.type = this.scanner.next();
            if (this.type != 1) {
                throw this.fatalError("space", null);
            }
            char[] cArray3 = this.getCurrentValue();
            this.type = this.scanner.next();
            this.output.printAttName(cArray, cArray2, cArray3);
            switch (this.type) {
                case 45: 
                case 46: 
                case 47: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: {
                    this.output.printCharacters(this.getCurrentValue());
                    this.type = this.scanner.next();
                    break;
                }
                case 57: {
                    this.output.printCharacters(this.getCurrentValue());
                    this.type = this.scanner.next();
                    if (this.type != 1) {
                        throw this.fatalError("space", null);
                    }
                    this.output.printSpaces(this.getCurrentValue(), false);
                    this.type = this.scanner.next();
                    if (this.type != 40) {
                        throw this.fatalError("left.brace", null);
                    }
                    this.type = this.scanner.next();
                    LinkedList<OutputManager.NameInfo> linkedList = new LinkedList();
                    cArray = null;
                    if (this.type == 1) {
                        cArray = this.getCurrentValue();
                        this.type = this.scanner.next();
                    }
                    if (this.type != 14) {
                        throw this.fatalError("name", null);
                    }
                    cArray2 = this.getCurrentValue();
                    this.type = this.scanner.next();
                    cArray3 = null;
                    if (this.type == 1) {
                        cArray3 = this.getCurrentValue();
                        this.type = this.scanner.next();
                    }
                    linkedList.add(new OutputManager.NameInfo(cArray, cArray2, cArray3));
                    block22: while (true) {
                        switch (this.type) {
                            default: {
                                break block22;
                            }
                            case 42: {
                                this.type = this.scanner.next();
                                cArray = null;
                                if (this.type == 1) {
                                    cArray = this.getCurrentValue();
                                    this.type = this.scanner.next();
                                }
                                if (this.type != 14) {
                                    throw this.fatalError("name", null);
                                }
                                cArray2 = this.getCurrentValue();
                                this.type = this.scanner.next();
                                cArray3 = null;
                                if (this.type == 1) {
                                    cArray3 = this.getCurrentValue();
                                    this.type = this.scanner.next();
                                }
                                linkedList.add(new OutputManager.NameInfo(cArray, cArray2, cArray3));
                                continue block22;
                            }
                        }
                        break;
                    }
                    if (this.type != 41) {
                        throw this.fatalError("right.brace", null);
                    }
                    this.output.printEnumeration(linkedList);
                    this.type = this.scanner.next();
                    break;
                }
                case 40: {
                    this.type = this.scanner.next();
                    LinkedList<OutputManager.NameInfo> linkedList = new LinkedList<OutputManager.NameInfo>();
                    cArray = null;
                    if (this.type == 1) {
                        cArray = this.getCurrentValue();
                        this.type = this.scanner.next();
                    }
                    if (this.type != 56) {
                        throw this.fatalError("nmtoken", null);
                    }
                    cArray2 = this.getCurrentValue();
                    this.type = this.scanner.next();
                    cArray3 = null;
                    if (this.type == 1) {
                        cArray3 = this.getCurrentValue();
                        this.type = this.scanner.next();
                    }
                    linkedList.add(new OutputManager.NameInfo(cArray, cArray2, cArray3));
                    block23: while (true) {
                        switch (this.type) {
                            default: {
                                break block23;
                            }
                            case 42: {
                                this.type = this.scanner.next();
                                cArray = null;
                                if (this.type == 1) {
                                    cArray = this.getCurrentValue();
                                    this.type = this.scanner.next();
                                }
                                if (this.type != 56) {
                                    throw this.fatalError("nmtoken", null);
                                }
                                cArray2 = this.getCurrentValue();
                                this.type = this.scanner.next();
                                cArray3 = null;
                                if (this.type == 1) {
                                    cArray3 = this.getCurrentValue();
                                    this.type = this.scanner.next();
                                }
                                linkedList.add(new OutputManager.NameInfo(cArray, cArray2, cArray3));
                                continue block23;
                            }
                        }
                        break;
                    }
                    if (this.type != 41) {
                        throw this.fatalError("right.brace", null);
                    }
                    this.output.printEnumeration(linkedList);
                    this.type = this.scanner.next();
                }
            }
            if (this.type == 1) {
                this.output.printSpaces(this.getCurrentValue(), true);
                this.type = this.scanner.next();
            }
            switch (this.type) {
                default: {
                    throw this.fatalError("default.decl", null);
                }
                case 53: 
                case 54: {
                    this.output.printCharacters(this.getCurrentValue());
                    this.type = this.scanner.next();
                    break;
                }
                case 55: {
                    this.output.printCharacters(this.getCurrentValue());
                    this.type = this.scanner.next();
                    if (this.type != 1) {
                        throw this.fatalError("space", null);
                    }
                    this.output.printSpaces(this.getCurrentValue(), false);
                    this.type = this.scanner.next();
                    if (this.type != 25 && this.type != 16) {
                        throw this.fatalError("space", null);
                    }
                }
                case 16: 
                case 25: {
                    this.output.printCharacter(this.scanner.getStringDelimiter());
                    this.output.printCharacters(this.getCurrentValue());
                    block24: while (true) {
                        this.type = this.scanner.next();
                        switch (this.type) {
                            case 16: 
                            case 17: 
                            case 18: 
                            case 25: {
                                this.output.printCharacters(this.getCurrentValue());
                                continue block24;
                            }
                            case 12: {
                                this.output.printString("&#");
                                this.output.printCharacters(this.getCurrentValue());
                                this.output.printCharacter(';');
                                continue block24;
                            }
                            case 13: {
                                this.output.printCharacter('&');
                                this.output.printCharacters(this.getCurrentValue());
                                this.output.printCharacter(';');
                                continue block24;
                            }
                        }
                        break;
                    }
                    this.output.printCharacter(this.scanner.getStringDelimiter());
                }
            }
            cArray = null;
        }
        if (this.type != 20) {
            throw this.fatalError("end", null);
        }
        this.output.printAttlistEnd(cArray);
        this.type = this.scanner.next();
    }

    protected void printEntityDeclaration() throws TranscoderException, XMLException, IOException {
        this.writer.write("<!ENTITY");
        this.type = this.scanner.next();
        if (this.type != 1) {
            throw this.fatalError("space", null);
        }
        this.writer.write(this.getCurrentValue());
        this.type = this.scanner.next();
        boolean bl = false;
        switch (this.type) {
            default: {
                throw this.fatalError("xml", null);
            }
            case 14: {
                this.writer.write(this.getCurrentValue());
                this.type = this.scanner.next();
                break;
            }
            case 58: {
                bl = true;
                this.writer.write(37);
                this.type = this.scanner.next();
                if (this.type != 1) {
                    throw this.fatalError("space", null);
                }
                this.writer.write(this.getCurrentValue());
                this.type = this.scanner.next();
                if (this.type != 14) {
                    throw this.fatalError("name", null);
                }
                this.writer.write(this.getCurrentValue());
                this.type = this.scanner.next();
            }
        }
        if (this.type != 1) {
            throw this.fatalError("space", null);
        }
        this.writer.write(this.getCurrentValue());
        this.type = this.scanner.next();
        switch (this.type) {
            case 16: 
            case 25: {
                char c2 = this.scanner.getStringDelimiter();
                this.writer.write(c2);
                block14: while (true) {
                    switch (this.type) {
                        case 16: 
                        case 17: 
                        case 18: 
                        case 25: {
                            this.writer.write(this.getCurrentValue());
                            break;
                        }
                        case 13: {
                            this.writer.write(38);
                            this.writer.write(this.getCurrentValue());
                            this.writer.write(59);
                            break;
                        }
                        case 34: {
                            this.writer.write(38);
                            this.writer.write(this.getCurrentValue());
                            this.writer.write(59);
                            break;
                        }
                        default: {
                            break block14;
                        }
                    }
                    this.type = this.scanner.next();
                }
                this.writer.write(c2);
                if (this.type == 1) {
                    this.writer.write(this.getCurrentValue());
                    this.type = this.scanner.next();
                }
                if (this.type != 20) {
                    throw this.fatalError("end", null);
                }
                this.writer.write(">");
                this.type = this.scanner.next();
                return;
            }
            case 27: {
                this.writer.write("PUBLIC");
                this.type = this.scanner.next();
                if (this.type != 1) {
                    throw this.fatalError("space", null);
                }
                this.type = this.scanner.next();
                if (this.type != 25) {
                    throw this.fatalError("string", null);
                }
                this.writer.write(" \"");
                this.writer.write(this.getCurrentValue());
                this.writer.write("\" \"");
                this.type = this.scanner.next();
                if (this.type != 1) {
                    throw this.fatalError("space", null);
                }
                this.type = this.scanner.next();
                if (this.type != 25) {
                    throw this.fatalError("string", null);
                }
                this.writer.write(this.getCurrentValue());
                this.writer.write(34);
                break;
            }
            case 26: {
                this.writer.write("SYSTEM");
                this.type = this.scanner.next();
                if (this.type != 1) {
                    throw this.fatalError("space", null);
                }
                this.type = this.scanner.next();
                if (this.type != 25) {
                    throw this.fatalError("string", null);
                }
                this.writer.write(" \"");
                this.writer.write(this.getCurrentValue());
                this.writer.write(34);
            }
        }
        this.type = this.scanner.next();
        if (this.type == 1) {
            this.writer.write(this.getCurrentValue());
            this.type = this.scanner.next();
            if (!bl && this.type == 59) {
                this.writer.write("NDATA");
                this.type = this.scanner.next();
                if (this.type != 1) {
                    throw this.fatalError("space", null);
                }
                this.writer.write(this.getCurrentValue());
                this.type = this.scanner.next();
                if (this.type != 14) {
                    throw this.fatalError("name", null);
                }
                this.writer.write(this.getCurrentValue());
                this.type = this.scanner.next();
            }
            if (this.type == 1) {
                this.writer.write(this.getCurrentValue());
                this.type = this.scanner.next();
            }
        }
        if (this.type != 20) {
            throw this.fatalError("end", null);
        }
        this.writer.write(62);
        this.type = this.scanner.next();
    }

    protected void printElementDeclaration() throws TranscoderException, XMLException, IOException {
        this.writer.write("<!ELEMENT");
        this.type = this.scanner.next();
        if (this.type != 1) {
            throw this.fatalError("space", null);
        }
        this.writer.write(this.getCurrentValue());
        this.type = this.scanner.next();
        switch (this.type) {
            default: {
                throw this.fatalError("name", null);
            }
            case 14: 
        }
        this.writer.write(this.getCurrentValue());
        this.type = this.scanner.next();
        if (this.type != 1) {
            throw this.fatalError("space", null);
        }
        this.writer.write(this.getCurrentValue());
        this.type = this.scanner.next();
        block3 : switch (this.type) {
            case 35: {
                this.writer.write("EMPTY");
                this.type = this.scanner.next();
                break;
            }
            case 36: {
                this.writer.write("ANY");
                this.type = this.scanner.next();
                break;
            }
            case 40: {
                this.writer.write(40);
                this.type = this.scanner.next();
                if (this.type == 1) {
                    this.writer.write(this.getCurrentValue());
                    this.type = this.scanner.next();
                }
                switch (this.type) {
                    case 44: {
                        this.writer.write("#PCDATA");
                        this.type = this.scanner.next();
                        while (true) {
                            switch (this.type) {
                                case 1: {
                                    this.writer.write(this.getCurrentValue());
                                    this.type = this.scanner.next();
                                    break;
                                }
                                case 42: {
                                    this.writer.write(124);
                                    this.type = this.scanner.next();
                                    if (this.type == 1) {
                                        this.writer.write(this.getCurrentValue());
                                        this.type = this.scanner.next();
                                    }
                                    if (this.type != 14) {
                                        throw this.fatalError("name", null);
                                    }
                                    this.writer.write(this.getCurrentValue());
                                    this.type = this.scanner.next();
                                    break;
                                }
                                case 41: {
                                    this.writer.write(41);
                                    this.type = this.scanner.next();
                                    break block3;
                                }
                            }
                        }
                    }
                    case 14: 
                    case 40: {
                        this.printChildren();
                        if (this.type != 41) {
                            throw this.fatalError("right.brace", null);
                        }
                        this.writer.write(41);
                        this.type = this.scanner.next();
                        if (this.type == 1) {
                            this.writer.write(this.getCurrentValue());
                            this.type = this.scanner.next();
                        }
                        switch (this.type) {
                            case 37: {
                                this.writer.write(63);
                                this.type = this.scanner.next();
                                break block3;
                            }
                            case 39: {
                                this.writer.write(42);
                                this.type = this.scanner.next();
                                break block3;
                            }
                            case 38: {
                                this.writer.write(43);
                                this.type = this.scanner.next();
                            }
                        }
                    }
                }
            }
        }
        if (this.type == 1) {
            this.writer.write(this.getCurrentValue());
            this.type = this.scanner.next();
        }
        if (this.type != 20) {
            throw this.fatalError("end", null);
        }
        this.writer.write(62);
        this.scanner.next();
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void printChildren() throws TranscoderException, XMLException, IOException {
        int n = 0;
        while (true) {
            switch (this.type) {
                default: {
                    throw new RuntimeException("Invalid XML");
                }
                case 14: {
                    this.writer.write(this.getCurrentValue());
                    this.type = this.scanner.next();
                    break;
                }
                case 40: {
                    this.writer.write(40);
                    this.type = this.scanner.next();
                    if (this.type == 1) {
                        this.writer.write(this.getCurrentValue());
                        this.type = this.scanner.next();
                    }
                    this.printChildren();
                    if (this.type != 41) {
                        throw this.fatalError("right.brace", null);
                    }
                    this.writer.write(41);
                    this.type = this.scanner.next();
                }
            }
            if (this.type == 1) {
                this.writer.write(this.getCurrentValue());
                this.type = this.scanner.next();
            }
            switch (this.type) {
                case 41: {
                    return;
                }
                case 39: {
                    this.writer.write(42);
                    this.type = this.scanner.next();
                    break;
                }
                case 37: {
                    this.writer.write(63);
                    this.type = this.scanner.next();
                    break;
                }
                case 38: {
                    this.writer.write(43);
                    this.type = this.scanner.next();
                }
            }
            if (this.type == 1) {
                this.writer.write(this.getCurrentValue());
                this.type = this.scanner.next();
            }
            switch (this.type) {
                case 42: {
                    if (n != 0 && n != this.type) {
                        throw new RuntimeException("Invalid XML");
                    }
                    this.writer.write(124);
                    n = this.type;
                    this.type = this.scanner.next();
                    break;
                }
                case 43: {
                    if (n != 0 && n != this.type) {
                        throw new RuntimeException("Invalid XML");
                    }
                    this.writer.write(44);
                    n = this.type;
                    this.type = this.scanner.next();
                    break;
                }
            }
            if (this.type != 1) continue;
            this.writer.write(this.getCurrentValue());
            this.type = this.scanner.next();
        }
    }

    protected char[] getCurrentValue() {
        int n = this.scanner.getStart() + this.scanner.getStartOffset();
        int n2 = this.scanner.getEnd() + this.scanner.getEndOffset() - n;
        char[] cArray = new char[n2];
        char[] cArray2 = this.scanner.getBuffer();
        for (int i = 0; i < n2; ++i) {
            cArray[i] = cArray2[n + i];
        }
        return cArray;
    }

    protected TranscoderException fatalError(String string, Object[] objectArray) throws TranscoderException {
        TranscoderException transcoderException = new TranscoderException(string);
        this.errorHandler.fatalError(transcoderException);
        return transcoderException;
    }
}

