/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.transcoder.image;

import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGEncodeParam;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.TranscodingHints;
import org.apache.batik.transcoder.image.ImageTranscoder;
import org.apache.batik.transcoder.image.resources.Messages;

public class JPEGTranscoder
extends ImageTranscoder {
    public static final TranscodingHints.Key KEY_QUALITY = new QualityKey();

    public JPEGTranscoder() {
        this.hints.put(ImageTranscoder.KEY_BACKGROUND_COLOR, Color.white);
    }

    public BufferedImage createImage(int n, int n2) {
        return new BufferedImage(n, n2, 1);
    }

    public void writeImage(BufferedImage bufferedImage, TranscoderOutput transcoderOutput) throws TranscoderException {
        OutputStream outputStream = transcoderOutput.getOutputStream();
        if ((outputStream = new OutputStreamWrapper(outputStream)) == null) {
            throw new TranscoderException(Messages.formatMessage("jpeg.badoutput", null));
        }
        try {
            TranscoderException transcoderException;
            float f2;
            if (this.hints.containsKey(KEY_QUALITY)) {
                f2 = ((Float)this.hints.get(KEY_QUALITY)).floatValue();
            } else {
                transcoderException = new TranscoderException(Messages.formatMessage("jpeg.unspecifiedQuality", null));
                this.handler.error(transcoderException);
                f2 = 0.75f;
            }
            transcoderException = JPEGCodec.createJPEGEncoder((OutputStream)outputStream);
            JPEGEncodeParam jPEGEncodeParam = JPEGCodec.getDefaultJPEGEncodeParam((BufferedImage)bufferedImage);
            jPEGEncodeParam.setQuality(f2, true);
            float f3 = this.userAgent.getPixelUnitToMillimeter();
            int n = (int)(25.4 / (double)f3 + 0.5);
            jPEGEncodeParam.setDensityUnit(1);
            jPEGEncodeParam.setXDensity(n);
            jPEGEncodeParam.setYDensity(n);
            transcoderException.encode(bufferedImage, jPEGEncodeParam);
            outputStream.flush();
        }
        catch (IOException iOException) {
            throw new TranscoderException(iOException);
        }
    }

    private static class OutputStreamWrapper
    extends OutputStream {
        OutputStream os;

        OutputStreamWrapper(OutputStream outputStream) {
            this.os = outputStream;
        }

        public void close() throws IOException {
            if (this.os == null) {
                return;
            }
            try {
                this.os.close();
            }
            catch (IOException iOException) {
                this.os = null;
            }
        }

        public void flush() throws IOException {
            if (this.os == null) {
                return;
            }
            try {
                this.os.flush();
            }
            catch (IOException iOException) {
                this.os = null;
            }
        }

        public void write(byte[] byArray) throws IOException {
            if (this.os == null) {
                return;
            }
            try {
                this.os.write(byArray);
            }
            catch (IOException iOException) {
                this.os = null;
            }
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
            if (this.os == null) {
                return;
            }
            try {
                this.os.write(byArray, n, n2);
            }
            catch (IOException iOException) {
                this.os = null;
            }
        }

        public void write(int n) throws IOException {
            if (this.os == null) {
                return;
            }
            try {
                this.os.write(n);
            }
            catch (IOException iOException) {
                this.os = null;
            }
        }
    }

    private static class QualityKey
    extends TranscodingHints.Key {
        private QualityKey() {
        }

        public boolean isCompatibleValue(Object object) {
            if (object instanceof Float) {
                float f2 = ((Float)object).floatValue();
                return f2 > 0.0f && f2 <= 1.0f;
            }
            return false;
        }
    }
}

