/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.parser;

import java.awt.geom.AffineTransform;
import java.io.Reader;
import org.apache.batik.parser.ParseException;
import org.apache.batik.parser.TransformListHandler;
import org.apache.batik.parser.TransformListParser;

public class AWTTransformProducer
implements TransformListHandler {
    protected AffineTransform affineTransform;

    public static AffineTransform createAffineTransform(Reader reader) throws ParseException {
        TransformListParser transformListParser = new TransformListParser();
        AWTTransformProducer aWTTransformProducer = new AWTTransformProducer();
        transformListParser.setTransformListHandler(aWTTransformProducer);
        transformListParser.parse(reader);
        return aWTTransformProducer.getAffineTransform();
    }

    public static AffineTransform createAffineTransform(String string) throws ParseException {
        TransformListParser transformListParser = new TransformListParser();
        AWTTransformProducer aWTTransformProducer = new AWTTransformProducer();
        transformListParser.setTransformListHandler(aWTTransformProducer);
        transformListParser.parse(string);
        return aWTTransformProducer.getAffineTransform();
    }

    public AffineTransform getAffineTransform() {
        return this.affineTransform;
    }

    public void startTransformList() throws ParseException {
        this.affineTransform = new AffineTransform();
    }

    public void matrix(float f2, float f3, float f4, float f5, float f6, float f7) throws ParseException {
        this.affineTransform.concatenate(new AffineTransform(f2, f3, f4, f5, f6, f7));
    }

    public void rotate(float f2) throws ParseException {
        this.affineTransform.concatenate(AffineTransform.getRotateInstance(Math.PI * (double)f2 / 180.0));
    }

    public void rotate(float f2, float f3, float f4) throws ParseException {
        AffineTransform affineTransform = AffineTransform.getRotateInstance(Math.PI * (double)f2 / 180.0, f3, f4);
        this.affineTransform.concatenate(affineTransform);
    }

    public void translate(float f2) throws ParseException {
        AffineTransform affineTransform = AffineTransform.getTranslateInstance(f2, 0.0);
        this.affineTransform.concatenate(affineTransform);
    }

    public void translate(float f2, float f3) throws ParseException {
        AffineTransform affineTransform = AffineTransform.getTranslateInstance(f2, f3);
        this.affineTransform.concatenate(affineTransform);
    }

    public void scale(float f2) throws ParseException {
        this.affineTransform.concatenate(AffineTransform.getScaleInstance(f2, f2));
    }

    public void scale(float f2, float f3) throws ParseException {
        this.affineTransform.concatenate(AffineTransform.getScaleInstance(f2, f3));
    }

    public void skewX(float f2) throws ParseException {
        this.affineTransform.concatenate(AffineTransform.getShearInstance(Math.tan(Math.PI * (double)f2 / 180.0), 0.0));
    }

    public void skewY(float f2) throws ParseException {
        this.affineTransform.concatenate(AffineTransform.getShearInstance(0.0, Math.tan(Math.PI * (double)f2 / 180.0)));
    }

    public void endTransformList() throws ParseException {
    }
}

