/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.gvt.text;

import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.TextAttribute;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.text.AttributedCharacterIterator;
import java.util.HashSet;
import java.util.Set;
import org.apache.batik.gvt.font.AWTGVTFont;
import org.apache.batik.gvt.font.AltGlyphHandler;
import org.apache.batik.gvt.font.GVTFont;
import org.apache.batik.gvt.font.GVTGlyphMetrics;
import org.apache.batik.gvt.font.GVTGlyphVector;
import org.apache.batik.gvt.font.GVTLineMetrics;
import org.apache.batik.gvt.text.ArabicTextHandler;
import org.apache.batik.gvt.text.GVTAttributedCharacterIterator;
import org.apache.batik.gvt.text.TextHit;
import org.apache.batik.gvt.text.TextPath;
import org.apache.batik.gvt.text.TextSpanLayout;

public class GlyphLayout
implements TextSpanLayout {
    public static final char SOFT_HYPHEN = '\u00ad';
    public static final char ZERO_WIDTH_SPACE = '\u200b';
    public static final char ZERO_WIDTH_JOINER = '\u200d';
    public static final char SPACE = ' ';
    private GVTGlyphVector gv;
    private GVTFont font;
    private GVTLineMetrics metrics;
    private AttributedCharacterIterator aci;
    private FontRenderContext frc;
    private Point2D advance;
    private Point2D offset;
    private float xScale = 1.0f;
    private float yScale = 1.0f;
    private Point2D prevCharPosition;
    private TextPath textPath;
    private Point2D textPathAdvance;
    private int[] charMap;
    private boolean vertical;
    private boolean adjSpacing = true;
    private float[] glyphAdvances;
    private boolean isAltGlyph;
    private boolean layoutApplied = false;
    private boolean spacingApplied = false;
    private boolean pathApplied = false;
    public static final AttributedCharacterIterator.Attribute FLOW_LINE_BREAK = GVTAttributedCharacterIterator.TextAttribute.FLOW_LINE_BREAK;
    public static final AttributedCharacterIterator.Attribute FLOW_PARAGRAPH = GVTAttributedCharacterIterator.TextAttribute.FLOW_PARAGRAPH;
    public static final AttributedCharacterIterator.Attribute FLOW_EMPTY_PARAGRAPH = GVTAttributedCharacterIterator.TextAttribute.FLOW_EMPTY_PARAGRAPH;
    public static final AttributedCharacterIterator.Attribute LINE_HEIGHT = GVTAttributedCharacterIterator.TextAttribute.LINE_HEIGHT;
    public static final AttributedCharacterIterator.Attribute TEXT_COMPOUND_DELIMITER = GVTAttributedCharacterIterator.TextAttribute.TEXT_COMPOUND_DELIMITER;
    public static final AttributedCharacterIterator.Attribute VERTICAL_ORIENTATION = GVTAttributedCharacterIterator.TextAttribute.VERTICAL_ORIENTATION;
    public static final AttributedCharacterIterator.Attribute VERTICAL_ORIENTATION_ANGLE = GVTAttributedCharacterIterator.TextAttribute.VERTICAL_ORIENTATION_ANGLE;
    public static final AttributedCharacterIterator.Attribute HORIZONTAL_ORIENTATION_ANGLE = GVTAttributedCharacterIterator.TextAttribute.HORIZONTAL_ORIENTATION_ANGLE;
    private static final AttributedCharacterIterator.Attribute X = GVTAttributedCharacterIterator.TextAttribute.X;
    private static final AttributedCharacterIterator.Attribute Y = GVTAttributedCharacterIterator.TextAttribute.Y;
    private static final AttributedCharacterIterator.Attribute DX = GVTAttributedCharacterIterator.TextAttribute.DX;
    private static final AttributedCharacterIterator.Attribute DY = GVTAttributedCharacterIterator.TextAttribute.DY;
    private static final AttributedCharacterIterator.Attribute ROTATION = GVTAttributedCharacterIterator.TextAttribute.ROTATION;
    private static final AttributedCharacterIterator.Attribute BASELINE_SHIFT = GVTAttributedCharacterIterator.TextAttribute.BASELINE_SHIFT;
    private static final AttributedCharacterIterator.Attribute WRITING_MODE = GVTAttributedCharacterIterator.TextAttribute.WRITING_MODE;
    private static final Integer WRITING_MODE_TTB = GVTAttributedCharacterIterator.TextAttribute.WRITING_MODE_TTB;
    private static final Integer ORIENTATION_AUTO = GVTAttributedCharacterIterator.TextAttribute.ORIENTATION_AUTO;
    public static final AttributedCharacterIterator.Attribute GVT_FONT = GVTAttributedCharacterIterator.TextAttribute.GVT_FONT;
    protected static Set runAtts = new HashSet();
    protected static Set szAtts;
    public static final float eps = 1.0E-5f;

    public GlyphLayout(AttributedCharacterIterator attributedCharacterIterator, int[] nArray, Point2D point2D, FontRenderContext fontRenderContext) {
        this.aci = attributedCharacterIterator;
        this.frc = fontRenderContext;
        this.offset = point2D;
        this.font = this.getFont();
        this.charMap = nArray;
        this.metrics = this.font.getLineMetrics(attributedCharacterIterator, attributedCharacterIterator.getBeginIndex(), attributedCharacterIterator.getEndIndex(), fontRenderContext);
        this.gv = null;
        this.aci.first();
        this.vertical = attributedCharacterIterator.getAttribute(WRITING_MODE) == WRITING_MODE_TTB;
        this.textPath = (TextPath)attributedCharacterIterator.getAttribute(GVTAttributedCharacterIterator.TextAttribute.TEXTPATH);
        AltGlyphHandler altGlyphHandler = (AltGlyphHandler)this.aci.getAttribute(GVTAttributedCharacterIterator.TextAttribute.ALT_GLYPH_HANDLER);
        if (altGlyphHandler != null) {
            this.gv = altGlyphHandler.createGlyphVector(fontRenderContext, this.font.getSize(), this.aci);
            if (this.gv != null) {
                this.isAltGlyph = true;
            }
        }
        if (this.gv == null) {
            this.gv = this.font.createGlyphVector(fontRenderContext, this.aci);
        }
    }

    public GVTGlyphVector getGlyphVector() {
        return this.gv;
    }

    public Point2D getOffset() {
        return this.offset;
    }

    public void setScale(float f2, float f3, boolean bl) {
        if (this.vertical) {
            f2 = 1.0f;
        } else {
            f3 = 1.0f;
        }
        if (f2 != this.xScale || f3 != this.yScale || bl != this.adjSpacing) {
            this.xScale = f2;
            this.yScale = f3;
            this.adjSpacing = bl;
            this.spacingApplied = false;
            this.glyphAdvances = null;
            this.pathApplied = false;
        }
    }

    public void setOffset(Point2D point2D) {
        if (point2D.getX() != this.offset.getX() || point2D.getY() != this.offset.getY()) {
            if (this.layoutApplied || this.spacingApplied) {
                float f2 = (float)(point2D.getX() - this.offset.getX());
                float f3 = (float)(point2D.getY() - this.offset.getY());
                int n = this.gv.getNumGlyphs();
                float[] fArray = this.gv.getGlyphPositions(0, n + 1, null);
                Point2D.Float float_ = new Point2D.Float();
                for (int i = 0; i <= n; ++i) {
                    float_.x = fArray[2 * i] + f2;
                    float_.y = fArray[2 * i + 1] + f3;
                    this.gv.setGlyphPosition(i, float_);
                }
            }
            this.offset = point2D;
            this.pathApplied = false;
        }
    }

    public GVTGlyphMetrics getGlyphMetrics(int n) {
        return this.gv.getGlyphMetrics(n);
    }

    public boolean isVertical() {
        return this.vertical;
    }

    public boolean isOnATextPath() {
        return this.textPath != null;
    }

    public int getGlyphCount() {
        return this.gv.getNumGlyphs();
    }

    public int getCharacterCount(int n, int n2) {
        return this.gv.getCharacterCount(n, n2);
    }

    public boolean isLeftToRight() {
        this.aci.first();
        int n = (Integer)this.aci.getAttribute(GVTAttributedCharacterIterator.TextAttribute.BIDI_LEVEL);
        return (n & 1) == 0;
    }

    private final void syncLayout() {
        if (!this.pathApplied) {
            this.doPathLayout();
        }
    }

    public void draw(Graphics2D graphics2D) {
        this.syncLayout();
        this.gv.draw(graphics2D, this.aci);
    }

    public Point2D getAdvance2D() {
        this.adjustTextSpacing();
        return this.advance;
    }

    public Shape getOutline() {
        this.syncLayout();
        return this.gv.getOutline();
    }

    public float[] getGlyphAdvances() {
        if (this.glyphAdvances != null) {
            return this.glyphAdvances;
        }
        if (!this.spacingApplied) {
            this.adjustTextSpacing();
        }
        int n = this.gv.getNumGlyphs();
        float[] fArray = this.gv.getGlyphPositions(0, n + 1, null);
        this.glyphAdvances = new float[n + 1];
        int n2 = 0;
        if (this.isVertical()) {
            n2 = 1;
        }
        float f2 = fArray[n2];
        for (int i = 0; i < n + 1; ++i) {
            this.glyphAdvances[i] = fArray[i + i + n2] - f2;
        }
        return this.glyphAdvances;
    }

    public Shape getDecorationOutline(int n) {
        this.syncLayout();
        GeneralPath generalPath = new GeneralPath();
        if ((n & 1) != 0) {
            generalPath.append(this.getUnderlineShape(), false);
        }
        if ((n & 2) != 0) {
            generalPath.append(this.getStrikethroughShape(), false);
        }
        if ((n & 4) != 0) {
            generalPath.append(this.getOverlineShape(), false);
        }
        return generalPath;
    }

    public Rectangle2D getBounds2D() {
        this.syncLayout();
        return this.gv.getBounds2D(this.aci);
    }

    public Rectangle2D getGeometricBounds() {
        this.syncLayout();
        Rectangle2D rectangle2D = this.gv.getGeometricBounds();
        Rectangle2D rectangle2D2 = this.getDecorationOutline(7).getBounds2D();
        return rectangle2D.createUnion(rectangle2D2);
    }

    public Point2D getTextPathAdvance() {
        this.syncLayout();
        if (this.textPath != null) {
            return this.textPathAdvance;
        }
        return this.getAdvance2D();
    }

    public int getGlyphIndex(int n) {
        int n2 = this.getGlyphCount();
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            int n4 = this.getCharacterCount(i, i);
            for (int j = 0; j < n4; ++j) {
                int n5;
                if (n == (n5 = this.charMap[n3++])) {
                    return i;
                }
                if (n3 < this.charMap.length) continue;
                return -1;
            }
        }
        return -1;
    }

    public int getLastGlyphIndex(int n) {
        int n2 = this.getGlyphCount();
        int n3 = this.charMap.length - 1;
        for (int i = n2 - 1; i >= 0; --i) {
            int n4 = this.getCharacterCount(i, i);
            for (int j = 0; j < n4; ++j) {
                int n5;
                if (n == (n5 = this.charMap[n3--])) {
                    return i;
                }
                if (n3 >= 0) continue;
                return -1;
            }
        }
        return -1;
    }

    public double getComputedOrientationAngle(int n) {
        if (this.isGlyphOrientationAuto()) {
            if (this.isVertical()) {
                char c2 = this.aci.setIndex(n);
                if (this.isLatinChar(c2)) {
                    return 90.0;
                }
                return 0.0;
            }
            return 0.0;
        }
        return this.getGlyphOrientationAngle();
    }

    public Shape getHighlightShape(int n, int n2) {
        this.syncLayout();
        if (n > n2) {
            int n3 = n;
            n = n2;
            n2 = n3;
        }
        GeneralPath generalPath = null;
        int n4 = this.getGlyphCount();
        Point2D.Float[] floatArray = new Point2D.Float[2 * n4];
        Point2D.Float[] floatArray2 = new Point2D.Float[2 * n4];
        int n5 = 0;
        int n6 = 0;
        for (int i = 0; i < n4; ++i) {
            Shape shape;
            int n7 = this.charMap[n6];
            if (n7 >= n && n7 <= n2 && this.gv.isGlyphVisible(i) && (shape = this.gv.getGlyphLogicalBounds(i)) != null) {
                if (generalPath == null) {
                    generalPath = new GeneralPath();
                }
                float[] fArray = new float[6];
                int n8 = 0;
                int n9 = -1;
                PathIterator pathIterator = shape.getPathIterator(null);
                Point2D.Float float_ = null;
                while (!pathIterator.isDone()) {
                    n9 = pathIterator.currentSegment(fArray);
                    if (n9 == 0 || n9 == 1) {
                        if (n8 > 4) break;
                        if (n8 == 4) {
                            if (float_ == null || float_.x != fArray[0] || float_.y != fArray[1]) {
                                break;
                            }
                        } else {
                            Point2D.Float float_2 = new Point2D.Float(fArray[0], fArray[1]);
                            if (n8 == 0) {
                                float_ = float_2;
                            }
                            switch (n8) {
                                case 0: {
                                    floatArray2[n5] = float_2;
                                    break;
                                }
                                case 1: {
                                    floatArray[n5] = float_2;
                                    break;
                                }
                                case 2: {
                                    floatArray[n5 + 1] = float_2;
                                    break;
                                }
                                case 3: {
                                    floatArray2[n5 + 1] = float_2;
                                }
                            }
                        }
                    } else if (n9 != 4 || n8 < 4 || n8 > 5) break;
                    ++n8;
                    pathIterator.next();
                }
                if (pathIterator.isDone()) {
                    if (floatArray2[n5] != null && (floatArray[n5].x != floatArray[n5 + 1].x || floatArray[n5].y != floatArray[n5 + 1].y)) {
                        n5 += 2;
                    }
                } else {
                    GlyphLayout.addPtsToPath(generalPath, floatArray, floatArray2, n5);
                    n5 = 0;
                    generalPath.append(shape, false);
                }
            }
            if ((n6 += this.getCharacterCount(i, i)) < this.charMap.length) continue;
            n6 = this.charMap.length - 1;
        }
        GlyphLayout.addPtsToPath(generalPath, floatArray, floatArray2, n5);
        return generalPath;
    }

    public static boolean epsEQ(double d2, double d3) {
        return d2 + (double)1.0E-5f > d3 && d2 - (double)1.0E-5f < d3;
    }

    public static int makeConvexHull(Point2D.Float[] floatArray, int n) {
        int n2;
        float f2;
        float f3;
        float f4;
        for (int i = 1; i < n; ++i) {
            if (!(floatArray[i].x < floatArray[i - 1].x) && (floatArray[i].x != floatArray[i - 1].x || !(floatArray[i].y < floatArray[i - 1].y))) continue;
            Point2D.Float float_ = floatArray[i];
            floatArray[i] = floatArray[i - 1];
            floatArray[i - 1] = float_;
            i = 0;
        }
        Point2D.Float float_ = floatArray[0];
        Point2D.Float float_2 = floatArray[n - 1];
        Point2D.Float float_3 = new Point2D.Float(float_2.x - float_.x, float_2.y - float_.y);
        float f5 = float_3.y * float_.x - float_3.x * float_.y;
        Point2D.Float[] floatArray2 = new Point2D.Float[n];
        Point2D.Float[] floatArray3 = new Point2D.Float[n];
        floatArray3[0] = floatArray2[0] = floatArray[0];
        int n3 = 1;
        int n4 = 1;
        for (int i = 1; i < n - 1; ++i) {
            float f6;
            Point2D.Float float_4 = floatArray[i];
            f4 = float_3.x * float_4.y - float_3.y * float_4.x + f5;
            if (f4 < 0.0f) {
                while (n4 >= 2) {
                    float_ = floatArray3[n4 - 2];
                    float_2 = floatArray3[n4 - 1];
                    f3 = float_2.x - float_.x;
                    f2 = float_2.y - float_.y;
                    f6 = f2 * float_.x - f3 * float_.y;
                    f4 = f3 * float_4.y - f2 * float_4.x + f6;
                    if (f4 > 1.0E-5f) break;
                    if (f4 > -1.0E-5f) {
                        if (float_2.y < float_4.y) {
                            float_4 = float_2;
                        }
                        break;
                    }
                    --n4;
                }
                int n5 = --n4;
                ++n4;
                floatArray3[n5] = float_4;
                continue;
            }
            while (n3 >= 2) {
                float_ = floatArray2[n3 - 2];
                float_2 = floatArray2[n3 - 1];
                f3 = float_2.x - float_.x;
                f2 = float_2.y - float_.y;
                f6 = f2 * float_.x - f3 * float_.y;
                f4 = f3 * float_4.y - f2 * float_4.x + f6;
                if (f4 < -1.0E-5f) break;
                if (f4 < 1.0E-5f) {
                    if (float_2.y > float_4.y) {
                        float_4 = float_2;
                    }
                    break;
                }
                --n3;
            }
            int n6 = --n3;
            ++n3;
            floatArray2[n6] = float_4;
        }
        Point2D.Float float_5 = floatArray[n - 1];
        while (n4 >= 2) {
            float_ = floatArray3[n4 - 2];
            float_2 = floatArray3[n4 - 1];
            float f7 = float_2.x - float_.x;
            f3 = float_2.y - float_.y;
            f2 = f3 * float_.x - f7 * float_.y;
            f4 = f7 * float_5.y - f3 * float_5.x + f2;
            if (f4 > 1.0E-5f) break;
            if (f4 > -1.0E-5f) {
                if (!(float_2.y >= float_5.y)) break;
                --n4;
                break;
            }
            --n4;
        }
        while (n3 >= 2) {
            float_ = floatArray2[n3 - 2];
            float_2 = floatArray2[n3 - 1];
            float f8 = float_2.x - float_.x;
            f3 = float_2.y - float_.y;
            f2 = f3 * float_.x - f8 * float_.y;
            f4 = f8 * float_5.y - f3 * float_5.x + f2;
            if (f4 < -1.0E-5f) break;
            if (f4 < 1.0E-5f) {
                if (!(float_2.y <= float_5.y)) break;
                --n3;
                break;
            }
            --n3;
        }
        for (n2 = 0; n2 < n3; ++n2) {
            floatArray[n2] = floatArray2[n2];
        }
        floatArray[n2++] = floatArray[n - 1];
        int n7 = n4 - 1;
        while (n7 > 0) {
            floatArray[n2] = floatArray3[n7];
            --n7;
            ++n2;
        }
        return n2;
    }

    public static void addPtsToPath(GeneralPath generalPath, Point2D.Float[] floatArray, Point2D.Float[] floatArray2, int n) {
        if (n < 2) {
            return;
        }
        if (n == 2) {
            generalPath.moveTo(floatArray[0].x, floatArray[0].y);
            generalPath.lineTo(floatArray[1].x, floatArray[1].y);
            generalPath.lineTo(floatArray2[1].x, floatArray2[1].y);
            generalPath.lineTo(floatArray2[0].x, floatArray2[0].y);
            generalPath.lineTo(floatArray[0].x, floatArray[0].y);
            return;
        }
        Point2D.Float[] floatArray3 = new Point2D.Float[8];
        Point2D.Float[] floatArray4 = new Point2D.Float[8];
        floatArray3[4] = floatArray[0];
        floatArray3[5] = floatArray[1];
        floatArray3[6] = floatArray2[1];
        floatArray3[7] = floatArray2[0];
        Area[] areaArray = new Area[n / 2];
        int n2 = 0;
        for (int i = 2; i < n; i += 2) {
            floatArray3[0] = floatArray3[4];
            floatArray3[1] = floatArray3[5];
            floatArray3[2] = floatArray3[6];
            floatArray3[3] = floatArray3[7];
            floatArray3[4] = floatArray[i];
            floatArray3[5] = floatArray[i + 1];
            floatArray3[6] = floatArray2[i + 1];
            floatArray3[7] = floatArray2[i];
            float f2 = floatArray3[2].x - floatArray3[0].x;
            float f3 = f2 * f2;
            f2 = floatArray3[2].y - floatArray3[0].y;
            float f4 = (float)Math.sqrt(f3 += f2 * f2);
            f2 = floatArray3[6].x - floatArray3[4].x;
            f3 = f2 * f2;
            f2 = floatArray3[6].y - floatArray3[4].y;
            f4 += (float)Math.sqrt(f3 += f2 * f2);
            f2 = (floatArray3[0].x + floatArray3[1].x + floatArray3[2].x + floatArray3[3].x - (floatArray3[4].x + floatArray3[5].x + floatArray3[6].x + floatArray3[7].x)) / 4.0f;
            f3 = f2 * f2;
            f2 = (floatArray3[0].y + floatArray3[1].y + floatArray3[2].y + floatArray3[3].y - (floatArray3[4].y + floatArray3[5].y + floatArray3[6].y + floatArray3[7].y)) / 4.0f;
            f3 += f2 * f2;
            f3 = (float)Math.sqrt(f3);
            GeneralPath generalPath2 = new GeneralPath();
            if (f3 < f4) {
                System.arraycopy(floatArray3, 0, floatArray4, 0, 8);
                int n3 = GlyphLayout.makeConvexHull(floatArray4, 8);
                generalPath2.moveTo(floatArray4[0].x, floatArray4[0].y);
                for (int j = 1; j < n3; ++j) {
                    generalPath2.lineTo(floatArray4[j].x, floatArray4[j].y);
                }
                generalPath2.closePath();
            } else {
                GlyphLayout.mergeAreas(generalPath, areaArray, n2);
                n2 = 0;
                if (i == 2) {
                    generalPath2.moveTo(floatArray3[0].x, floatArray3[0].y);
                    generalPath2.lineTo(floatArray3[1].x, floatArray3[1].y);
                    generalPath2.lineTo(floatArray3[2].x, floatArray3[2].y);
                    generalPath2.lineTo(floatArray3[3].x, floatArray3[3].y);
                    generalPath2.closePath();
                    generalPath.append(generalPath2, false);
                    generalPath2.reset();
                }
                generalPath2.moveTo(floatArray3[4].x, floatArray3[4].y);
                generalPath2.lineTo(floatArray3[5].x, floatArray3[5].y);
                generalPath2.lineTo(floatArray3[6].x, floatArray3[6].y);
                generalPath2.lineTo(floatArray3[7].x, floatArray3[7].y);
                generalPath2.closePath();
            }
            areaArray[n2++] = new Area(generalPath2);
        }
        GlyphLayout.mergeAreas(generalPath, areaArray, n2);
    }

    public static void mergeAreas(GeneralPath generalPath, Area[] areaArray, int n) {
        while (n > 1) {
            int n2 = 0;
            for (int i = 1; i < n; i += 2) {
                areaArray[i - 1].add(areaArray[i]);
                areaArray[n2++] = areaArray[i - 1];
                areaArray[i] = null;
            }
            if ((n & 1) == 1) {
                areaArray[n2 - 1].add(areaArray[n - 1]);
            }
            n /= 2;
        }
        if (n == 1) {
            generalPath.append(areaArray[0], false);
        }
    }

    public TextHit hitTestChar(float f2, float f3) {
        this.syncLayout();
        TextHit textHit = null;
        int n = 0;
        for (int i = 0; i < this.gv.getNumGlyphs(); ++i) {
            Shape shape = this.gv.getGlyphLogicalBounds(i);
            if (shape != null) {
                Rectangle2D rectangle2D = shape.getBounds2D();
                if (shape.contains(f2, f3)) {
                    boolean bl = (double)f2 > rectangle2D.getX() + rectangle2D.getWidth() / 2.0;
                    boolean bl2 = !bl;
                    int n2 = this.charMap[n];
                    textHit = new TextHit(n2, bl2);
                    return textHit;
                }
            }
            if ((n += this.getCharacterCount(i, i)) < this.charMap.length) continue;
            n = this.charMap.length - 1;
        }
        return textHit;
    }

    protected GVTFont getFont() {
        this.aci.first();
        GVTFont gVTFont = (GVTFont)this.aci.getAttributes().get(GVT_FONT);
        if (gVTFont != null) {
            return gVTFont;
        }
        return new AWTGVTFont(this.aci.getAttributes());
    }

    protected Shape getOverlineShape() {
        double d2 = this.metrics.getOverlineOffset();
        float f2 = this.metrics.getOverlineThickness();
        d2 += (double)f2;
        this.aci.first();
        Float f3 = (Float)this.aci.getAttribute(DY);
        if (f3 != null) {
            d2 += (double)f3.floatValue();
        }
        BasicStroke basicStroke = new BasicStroke(f2);
        Rectangle2D rectangle2D = this.gv.getLogicalBounds();
        return basicStroke.createStrokedShape(new Line2D.Double(rectangle2D.getMinX() + (double)f2 / 2.0, this.offset.getY() + d2, rectangle2D.getMaxX() - (double)f2 / 2.0, this.offset.getY() + d2));
    }

    protected Shape getUnderlineShape() {
        double d2 = this.metrics.getUnderlineOffset();
        float f2 = this.metrics.getUnderlineThickness();
        d2 += (double)f2 * 1.5;
        BasicStroke basicStroke = new BasicStroke(f2);
        this.aci.first();
        Float f3 = (Float)this.aci.getAttribute(DY);
        if (f3 != null) {
            d2 += (double)f3.floatValue();
        }
        Rectangle2D rectangle2D = this.gv.getLogicalBounds();
        return basicStroke.createStrokedShape(new Line2D.Double(rectangle2D.getMinX() + (double)f2 / 2.0, this.offset.getY() + d2, rectangle2D.getMaxX() - (double)f2 / 2.0, this.offset.getY() + d2));
    }

    protected Shape getStrikethroughShape() {
        double d2 = this.metrics.getStrikethroughOffset();
        float f2 = this.metrics.getStrikethroughThickness();
        BasicStroke basicStroke = new BasicStroke(f2);
        this.aci.first();
        Float f3 = (Float)this.aci.getAttribute(DY);
        if (f3 != null) {
            d2 += (double)f3.floatValue();
        }
        Rectangle2D rectangle2D = this.gv.getLogicalBounds();
        return basicStroke.createStrokedShape(new Line2D.Double(rectangle2D.getMinX() + (double)f2 / 2.0, this.offset.getY() + d2, rectangle2D.getMaxX() - (double)f2 / 2.0, this.offset.getY() + d2));
    }

    protected void doExplicitGlyphLayout() {
        int n;
        this.gv.performDefaultLayout();
        float f2 = this.vertical ? (float)this.gv.getLogicalBounds().getWidth() : this.metrics.getAscent() + Math.abs(this.metrics.getDescent());
        int n2 = this.gv.getNumGlyphs();
        float[] fArray = this.gv.getGlyphPositions(0, n2 + 1, null);
        float f3 = 0.0f;
        float f4 = 0.0f;
        boolean bl = this.isGlyphOrientationAuto();
        int n3 = 0;
        if (!bl) {
            n3 = this.getGlyphOrientationAngle();
        }
        int n4 = this.aci.getBeginIndex();
        int n5 = 0;
        char c2 = this.aci.first();
        int n6 = n5 + n4;
        Float f5 = null;
        Float f6 = null;
        Float f7 = null;
        Float f8 = null;
        Float f9 = null;
        Object object = null;
        float f10 = 0.0f;
        float f11 = 0.0f;
        float f12 = (float)this.offset.getX();
        float f13 = (float)this.offset.getY();
        Point2D.Float float_ = new Point2D.Float();
        boolean bl2 = false;
        for (n = 0; n < n2; ++n) {
            Cloneable cloneable;
            float f14;
            if (n5 + n4 >= n6) {
                n6 = this.aci.getRunLimit(runAtts);
                f5 = (Float)this.aci.getAttribute(X);
                f6 = (Float)this.aci.getAttribute(Y);
                f7 = (Float)this.aci.getAttribute(DX);
                f8 = (Float)this.aci.getAttribute(DY);
                f9 = (Float)this.aci.getAttribute(ROTATION);
                object = this.aci.getAttribute(BASELINE_SHIFT);
            }
            GVTGlyphMetrics gVTGlyphMetrics = this.gv.getGlyphMetrics(n);
            if (this.textPath == null) {
                if (n == 0) {
                    if (this.isVertical()) {
                        f3 = bl ? (this.isLatinChar(c2) ? 0.0f : (float)gVTGlyphMetrics.getBounds2D().getHeight()) : (n3 == 0 ? (float)gVTGlyphMetrics.getBounds2D().getHeight() : 0.0f);
                    } else {
                        f4 = n3 == 270 ? (float)gVTGlyphMetrics.getBounds2D().getHeight() : 0.0f;
                    }
                } else if (bl && f3 == 0.0f && !this.isLatinChar(c2)) {
                    f3 = (float)gVTGlyphMetrics.getBounds2D().getHeight();
                }
            }
            float f15 = 0.0f;
            float f16 = 0.0f;
            float f17 = 0.0f;
            float f18 = 0.0f;
            if (c2 != '\uffff') {
                if (this.vertical) {
                    f17 = bl ? (this.isLatinChar(c2) ? 1.5707964f : 0.0f) : (float)Math.toRadians(n3);
                    if (this.textPath != null) {
                        f5 = null;
                    }
                } else {
                    f17 = (float)Math.toRadians(n3);
                    if (this.textPath != null) {
                        f6 = null;
                    }
                }
                f18 = f9 == null || f9.isNaN() ? f17 : f9.floatValue() + f17;
                if (f5 != null && !f5.isNaN()) {
                    if (n == 0) {
                        f10 = (float)((double)f5.floatValue() - this.offset.getX());
                    }
                    f12 = f5.floatValue() - f10;
                }
                if (f7 != null && !f7.isNaN()) {
                    f12 += f7.floatValue();
                }
                if (f6 != null && !f6.isNaN()) {
                    if (n == 0) {
                        f11 = (float)((double)f6.floatValue() - this.offset.getY());
                    }
                    f13 = f6.floatValue() - f11;
                }
                if (f8 != null && !f8.isNaN()) {
                    f13 += f8.floatValue();
                } else if (n > 0) {
                    f13 += fArray[n * 2 + 1] - fArray[n * 2 - 1];
                }
                f14 = 0.0f;
                if (object != null) {
                    if (object instanceof Integer) {
                        if (object == TextAttribute.SUPERSCRIPT_SUPER) {
                            f14 = f2 * 0.5f;
                        } else if (object == TextAttribute.SUPERSCRIPT_SUB) {
                            f14 = -f2 * 0.5f;
                        }
                    } else if (object instanceof Float) {
                        f14 = ((Float)object).floatValue();
                    }
                    if (this.vertical) {
                        f15 = f14;
                    } else {
                        f16 = -f14;
                    }
                }
                if (this.vertical) {
                    f16 += f3;
                    if (bl) {
                        if (this.isLatinChar(c2)) {
                            f15 += this.metrics.getStrikethroughOffset();
                        } else {
                            cloneable = this.gv.getGlyphVisualBounds(n).getBounds2D();
                            f15 -= (float)(((RectangularShape)cloneable).getMaxX() - (double)fArray[2 * n] - ((RectangularShape)cloneable).getWidth() / 2.0);
                        }
                    } else {
                        cloneable = this.gv.getGlyphVisualBounds(n).getBounds2D();
                        f15 = n3 == 0 ? (f15 -= (float)(((RectangularShape)cloneable).getMaxX() - (double)fArray[2 * n] - ((RectangularShape)cloneable).getWidth() / 2.0)) : (n3 == 180 ? (f15 += (float)(((RectangularShape)cloneable).getMaxX() - (double)fArray[2 * n] - ((RectangularShape)cloneable).getWidth() / 2.0)) : (n3 == 90 ? (f15 += this.metrics.getStrikethroughOffset()) : (f15 -= this.metrics.getStrikethroughOffset())));
                    }
                } else {
                    f15 += f4;
                    if (n3 == 90) {
                        f16 -= gVTGlyphMetrics.getHorizontalAdvance();
                    } else if (n3 == 180) {
                        f16 -= this.metrics.getAscent();
                    }
                }
            }
            float_.x = f12 + f15;
            float_.y = f13 + f16;
            this.gv.setGlyphPosition(n, float_);
            if (ArabicTextHandler.arabicCharTransparent(c2)) {
                bl2 = true;
            } else if (this.vertical) {
                f14 = 0.0f;
                if (bl) {
                    f14 = this.isLatinChar(c2) ? gVTGlyphMetrics.getHorizontalAdvance() : gVTGlyphMetrics.getVerticalAdvance();
                } else if (n3 == 0 || n3 == 180) {
                    f14 = gVTGlyphMetrics.getVerticalAdvance();
                } else if (n3 == 90) {
                    f14 = gVTGlyphMetrics.getHorizontalAdvance();
                } else {
                    f14 = gVTGlyphMetrics.getHorizontalAdvance();
                    this.gv.setGlyphTransform(n, AffineTransform.getTranslateInstance(0.0, f14));
                }
                f13 += f14;
            } else {
                f14 = 0.0f;
                if (n3 == 0) {
                    f14 = gVTGlyphMetrics.getHorizontalAdvance();
                } else if (n3 == 180) {
                    f14 = gVTGlyphMetrics.getHorizontalAdvance();
                    this.gv.setGlyphTransform(n, AffineTransform.getTranslateInstance(f14, 0.0));
                } else {
                    f14 = gVTGlyphMetrics.getVerticalAdvance();
                }
                f12 += f14;
            }
            if (!GlyphLayout.epsEQ(f18, 0.0)) {
                AffineTransform affineTransform = this.gv.getGlyphTransform(n);
                if (affineTransform == null) {
                    affineTransform = new AffineTransform();
                }
                cloneable = GlyphLayout.epsEQ(f18, 1.5707963267948966) ? new AffineTransform(0.0f, 1.0f, -1.0f, 0.0f, 0.0f, 0.0f) : (GlyphLayout.epsEQ(f18, Math.PI) ? new AffineTransform(-1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f) : (GlyphLayout.epsEQ(f18, 4.71238898038469) ? new AffineTransform(0.0f, -1.0f, 1.0f, 0.0f, 0.0f, 0.0f) : AffineTransform.getRotateInstance(f18)));
                affineTransform.concatenate((AffineTransform)cloneable);
                this.gv.setGlyphTransform(n, affineTransform);
            }
            if ((n5 += this.gv.getCharacterCount(n, n)) >= this.charMap.length) {
                n5 = this.charMap.length - 1;
            }
            c2 = this.aci.setIndex(n5 + n4);
        }
        float_.x = f12;
        float_.y = f13;
        this.gv.setGlyphPosition(n, float_);
        this.advance = new Point2D.Float((float)((double)f12 - this.offset.getX()), (float)((double)f13 - this.offset.getY()));
        if (bl2) {
            c2 = this.aci.first();
            n5 = 0;
            int n7 = -1;
            for (n = 0; n < n2; ++n) {
                if (ArabicTextHandler.arabicCharTransparent(c2)) {
                    if (n7 == -1) {
                        n7 = n;
                    }
                } else if (n7 != -1) {
                    Point2D point2D = this.gv.getGlyphPosition(n);
                    GVTGlyphMetrics gVTGlyphMetrics = this.gv.getGlyphMetrics(n);
                    boolean bl3 = false;
                    boolean bl4 = false;
                    float f19 = 0.0f;
                    float f20 = 0.0f;
                    if (this.vertical) {
                        if (bl || n3 == 90) {
                            f20 = gVTGlyphMetrics.getHorizontalAdvance();
                        } else if (n3 == 270) {
                            f20 = 0.0f;
                        } else {
                            f19 = n3 == 0 ? gVTGlyphMetrics.getHorizontalAdvance() : -gVTGlyphMetrics.getHorizontalAdvance();
                        }
                    } else if (n3 == 0) {
                        f19 = gVTGlyphMetrics.getHorizontalAdvance();
                    } else if (n3 == 90) {
                        f20 = gVTGlyphMetrics.getHorizontalAdvance();
                    } else if (n3 == 180) {
                        f19 = 0.0f;
                    } else {
                        f20 = -gVTGlyphMetrics.getHorizontalAdvance();
                    }
                    float f21 = (float)(point2D.getX() + (double)f19);
                    float f22 = (float)(point2D.getY() + (double)f20);
                    for (int i = n7; i < n; ++i) {
                        Point2D point2D2 = this.gv.getGlyphPosition(i);
                        GVTGlyphMetrics gVTGlyphMetrics2 = this.gv.getGlyphMetrics(i);
                        float f23 = (float)point2D2.getX();
                        float f24 = (float)point2D2.getY();
                        float f25 = 0.0f;
                        float f26 = 0.0f;
                        float f27 = gVTGlyphMetrics2.getHorizontalAdvance();
                        if (this.vertical) {
                            if (bl || n3 == 90) {
                                f24 = f22 - f27;
                            } else if (n3 == 270) {
                                f24 = f22 + f27;
                            } else {
                                f23 = n3 == 0 ? f21 - f27 : f21 + f27;
                            }
                        } else if (n3 == 0) {
                            f23 = f21 - f27;
                        } else if (n3 == 90) {
                            f24 = f22 - f27;
                        } else if (n3 == 180) {
                            f23 = f21 + f27;
                        } else {
                            f24 = f22 + f27;
                        }
                        point2D2 = new Point2D.Double(f23, f24);
                        this.gv.setGlyphPosition(i, point2D2);
                        if (!bl4 && !bl3) continue;
                        AffineTransform affineTransform = AffineTransform.getTranslateInstance(f25, f26);
                        affineTransform.concatenate(this.gv.getGlyphTransform(n));
                        this.gv.setGlyphTransform(n, affineTransform);
                    }
                    n7 = -1;
                }
                if ((n5 += this.gv.getCharacterCount(n, n)) >= this.charMap.length) {
                    n5 = this.charMap.length - 1;
                }
                c2 = this.aci.setIndex(n5 + n4);
            }
        }
        this.layoutApplied = true;
        this.spacingApplied = false;
        this.glyphAdvances = null;
        this.pathApplied = false;
    }

    protected void adjustTextSpacing() {
        if (this.spacingApplied) {
            return;
        }
        if (!this.layoutApplied) {
            this.doExplicitGlyphLayout();
        }
        this.aci.first();
        Boolean bl = (Boolean)this.aci.getAttribute(GVTAttributedCharacterIterator.TextAttribute.CUSTOM_SPACING);
        if (bl != null && bl.booleanValue()) {
            this.advance = this.doSpacing((Float)this.aci.getAttribute(GVTAttributedCharacterIterator.TextAttribute.KERNING), (Float)this.aci.getAttribute(GVTAttributedCharacterIterator.TextAttribute.LETTER_SPACING), (Float)this.aci.getAttribute(GVTAttributedCharacterIterator.TextAttribute.WORD_SPACING));
            this.layoutApplied = false;
        }
        this.applyStretchTransform(!this.adjSpacing);
        this.spacingApplied = true;
        this.pathApplied = false;
    }

    protected Point2D doSpacing(Float f2, Float f3, Float f4) {
        boolean bl = true;
        boolean bl2 = false;
        boolean bl3 = false;
        float f5 = 0.0f;
        float f6 = 0.0f;
        if (f2 != null && !f2.isNaN()) {
            f5 = f2.floatValue();
            bl = false;
        }
        if (f3 != null && !f3.isNaN()) {
            f6 = f3.floatValue();
            bl3 = true;
        }
        if (f4 != null && !f4.isNaN()) {
            bl2 = true;
        }
        int n = this.gv.getNumGlyphs();
        float f7 = 0.0f;
        float f8 = 0.0f;
        Point2D[] point2DArray = new Point2D[n + 1];
        Point2D point2D = this.gv.getGlyphPosition(0);
        int n2 = this.gv.getGlyphCode(0);
        float f9 = (float)point2D.getX();
        float f10 = (float)point2D.getY();
        Point2D.Double double_ = new Point2D.Double(this.advance.getX() - (this.gv.getGlyphPosition(n - 1).getX() - (double)f9), this.advance.getY() - (this.gv.getGlyphPosition(n - 1).getY() - (double)f10));
        try {
            int n3;
            Point2D point2D2;
            int n4;
            GVTFont gVTFont = this.gv.getFont();
            if (n > 1 && (bl3 || !bl)) {
                for (n4 = 1; n4 <= n; ++n4) {
                    float f11;
                    point2D2 = this.gv.getGlyphPosition(n4);
                    n3 = n4 == n ? -1 : this.gv.getGlyphCode(n4);
                    f7 = (float)point2D2.getX() - (float)point2D.getX();
                    f8 = (float)point2D2.getY() - (float)point2D.getY();
                    if (bl) {
                        if (this.vertical) {
                            f8 += f6;
                        } else {
                            f7 += f6;
                        }
                    } else if (this.vertical) {
                        f11 = 0.0f;
                        if (n3 != -1) {
                            f11 = gVTFont.getVKern(n2, n3);
                        }
                        f8 += f5 - f11 + f6;
                    } else {
                        f11 = 0.0f;
                        if (n3 != -1) {
                            f11 = gVTFont.getHKern(n2, n3);
                        }
                        f7 += f5 - f11 + f6;
                    }
                    point2DArray[n4] = new Point2D.Float(f9 += f7, f10 += f8);
                    point2D = point2D2;
                    n2 = n3;
                }
                for (n4 = 1; n4 <= n; ++n4) {
                    if (point2DArray[n4] == null) continue;
                    this.gv.setGlyphPosition(n4, point2DArray[n4]);
                }
            }
            if (this.vertical) {
                ((Point2D)double_).setLocation(((Point2D)double_).getX(), ((Point2D)double_).getY() + (double)f5 + (double)f6);
            } else {
                ((Point2D)double_).setLocation(((Point2D)double_).getX() + (double)f5 + (double)f6, ((Point2D)double_).getY());
            }
            f7 = 0.0f;
            f8 = 0.0f;
            point2D = this.gv.getGlyphPosition(0);
            f9 = (float)point2D.getX();
            f10 = (float)point2D.getY();
            if (n > 1 && bl2) {
                for (n4 = 1; n4 < n; ++n4) {
                    point2D2 = this.gv.getGlyphPosition(n4);
                    f7 = (float)point2D2.getX() - (float)point2D.getX();
                    f8 = (float)point2D2.getY() - (float)point2D.getY();
                    n3 = 0;
                    int n5 = n4;
                    int n6 = n4;
                    GVTGlyphMetrics gVTGlyphMetrics = this.gv.getGlyphMetrics(n4);
                    while (gVTGlyphMetrics.getBounds2D().getWidth() < 0.01 || gVTGlyphMetrics.isWhitespace()) {
                        if (n3 == 0) {
                            n3 = 1;
                        }
                        if (n4 == n - 1) break;
                        ++n6;
                        point2D2 = this.gv.getGlyphPosition(++n4);
                        gVTGlyphMetrics = this.gv.getGlyphMetrics(n4);
                    }
                    if (n3 != 0) {
                        int n7 = n6 - n5;
                        float f12 = (float)point2D.getX();
                        float f13 = (float)point2D.getY();
                        f7 = (float)(point2D2.getX() - (double)f12) / (float)(n7 + 1);
                        f8 = (float)(point2D2.getY() - (double)f13) / (float)(n7 + 1);
                        if (this.vertical) {
                            f8 += f4.floatValue() / (float)(n7 + 1);
                        } else {
                            f7 += f4.floatValue() / (float)(n7 + 1);
                        }
                        for (int i = n5; i <= n6; ++i) {
                            point2DArray[i] = new Point2D.Float(f9 += f7, f10 += f8);
                        }
                    } else {
                        f7 = (float)(point2D2.getX() - point2D.getX());
                        f8 = (float)(point2D2.getY() - point2D.getY());
                        point2DArray[n4] = new Point2D.Float(f9 += f7, f10 += f8);
                    }
                    point2D = point2D2;
                }
                Point2D point2D3 = this.gv.getGlyphPosition(n);
                point2DArray[n] = new Point2D.Float(f9 += (float)(point2D3.getX() - point2D.getX()), f10 += (float)(point2D3.getY() - point2D.getY()));
                for (int i = 1; i <= n; ++i) {
                    if (point2DArray[i] == null) continue;
                    this.gv.setGlyphPosition(i, point2DArray[i]);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        double d2 = this.gv.getGlyphPosition(n - 1).getX() - this.gv.getGlyphPosition(0).getX();
        double d3 = this.gv.getGlyphPosition(n - 1).getY() - this.gv.getGlyphPosition(0).getY();
        Point2D.Double double_2 = new Point2D.Double(d2 + ((Point2D)double_).getX(), d3 + ((Point2D)double_).getY());
        return double_2;
    }

    protected void applyStretchTransform(boolean bl) {
        if (this.xScale == 1.0f && this.yScale == 1.0f) {
            return;
        }
        AffineTransform affineTransform = AffineTransform.getScaleInstance(this.xScale, this.yScale);
        int n = this.gv.getNumGlyphs();
        float[] fArray = this.gv.getGlyphPositions(0, n + 1, null);
        float f2 = fArray[0];
        float f3 = fArray[1];
        float f4 = 0.0f;
        float f5 = 0.0f;
        Point2D.Float float_ = new Point2D.Float();
        for (int i = 0; i <= n; ++i) {
            f4 = fArray[2 * i] - f2;
            f5 = fArray[2 * i + 1] - f3;
            float_.x = f2 + f4 * this.xScale;
            float_.y = f3 + f5 * this.yScale;
            this.gv.setGlyphPosition(i, float_);
            if (!bl || i == n) continue;
            AffineTransform affineTransform2 = this.gv.getGlyphTransform(i);
            if (affineTransform2 != null) {
                affineTransform2.preConcatenate(affineTransform);
                this.gv.setGlyphTransform(i, affineTransform2);
                continue;
            }
            this.gv.setGlyphTransform(i, affineTransform);
        }
        this.advance = new Point2D.Float((float)(this.advance.getX() * (double)this.xScale), (float)(this.advance.getY() * (double)this.yScale));
        this.layoutApplied = false;
    }

    protected void doPathLayout() {
        float f2;
        if (this.pathApplied) {
            return;
        }
        if (!this.spacingApplied) {
            this.adjustTextSpacing();
        }
        this.getGlyphAdvances();
        if (this.textPath == null) {
            this.pathApplied = true;
            return;
        }
        boolean bl = !this.isVertical();
        boolean bl2 = this.isGlyphOrientationAuto();
        int n = 0;
        if (!bl2) {
            n = this.getGlyphOrientationAngle();
        }
        float f3 = this.textPath.lengthOfPath();
        float f4 = this.textPath.getStartOffset();
        int n2 = this.gv.getNumGlyphs();
        for (int i = 0; i < n2; ++i) {
            this.gv.setGlyphVisible(i, true);
        }
        float f5 = bl ? (float)this.gv.getLogicalBounds().getWidth() : (float)this.gv.getLogicalBounds().getHeight();
        if (f3 == 0.0f || f5 == 0.0f) {
            this.pathApplied = true;
            this.textPathAdvance = this.advance;
            return;
        }
        Point2D point2D = this.gv.getGlyphPosition(0);
        float f6 = 0.0f;
        if (bl) {
            f6 = (float)point2D.getY();
            f2 = (float)(point2D.getX() + (double)f4);
        } else {
            f6 = (float)point2D.getX();
            f2 = (float)(point2D.getY() + (double)f4);
        }
        char c2 = this.aci.first();
        int n3 = this.aci.getBeginIndex();
        int n4 = 0;
        int n5 = -1;
        float f7 = 0.0f;
        for (int i = 0; i < n2; ++i) {
            Object object;
            Point2D point2D2 = this.gv.getGlyphPosition(i);
            float f8 = 0.0f;
            float f9 = 0.0f;
            if (i < this.gv.getNumGlyphs() - 1) {
                object = this.gv.getGlyphPosition(i + 1);
                if (bl) {
                    f8 = (float)(((Point2D)object).getX() - point2D2.getX());
                    f9 = (float)(((Point2D)object).getY() - point2D2.getY());
                } else {
                    f8 = (float)(((Point2D)object).getY() - point2D2.getY());
                    f9 = (float)(((Point2D)object).getX() - point2D2.getX());
                }
            } else {
                object = this.gv.getGlyphMetrics(i);
                f8 = bl ? (n == 0 || n == 180 ? ((GVTGlyphMetrics)object).getHorizontalAdvance() : ((GVTGlyphMetrics)object).getVerticalAdvance()) : (bl2 ? (this.isLatinChar(c2) ? ((GVTGlyphMetrics)object).getHorizontalAdvance() : ((GVTGlyphMetrics)object).getVerticalAdvance()) : (n == 0 || n == 180 ? ((GVTGlyphMetrics)object).getVerticalAdvance() : ((GVTGlyphMetrics)object).getHorizontalAdvance()));
            }
            object = this.gv.getGlyphOutline(i).getBounds2D();
            float f10 = (float)((RectangularShape)object).getWidth();
            float f11 = (float)((RectangularShape)object).getHeight();
            float f12 = bl ? f2 + f10 / 2.0f : f2 + f11 / 2.0f;
            Point2D point2D3 = this.textPath.pointAtLength(f12);
            if (point2D3 != null) {
                float f13 = this.textPath.angleAtLength(f12);
                AffineTransform affineTransform = new AffineTransform();
                if (bl) {
                    affineTransform.rotate(f13);
                } else {
                    affineTransform.rotate((double)f13 - 1.5707963267948966);
                }
                if (bl) {
                    affineTransform.translate(0.0, f6);
                } else {
                    affineTransform.translate(f6, 0.0);
                }
                if (bl) {
                    if (n == 270) {
                        affineTransform.translate(f10 / 2.0f, 0.0);
                    } else {
                        affineTransform.translate(-f10 / 2.0f, 0.0);
                    }
                } else if (bl2) {
                    if (this.isLatinChar(c2)) {
                        affineTransform.translate(0.0, -f11 / 2.0f);
                    } else {
                        affineTransform.translate(0.0, f11 / 2.0f);
                    }
                } else if (n == 0) {
                    affineTransform.translate(0.0, f11 / 2.0f);
                } else {
                    affineTransform.translate(0.0, -f11 / 2.0f);
                }
                AffineTransform affineTransform2 = this.gv.getGlyphTransform(i);
                if (affineTransform2 != null) {
                    affineTransform.concatenate(affineTransform2);
                }
                this.gv.setGlyphTransform(i, affineTransform);
                this.gv.setGlyphPosition(i, point2D3);
                n5 = i;
                f7 = f8;
            } else {
                this.gv.setGlyphVisible(i, false);
            }
            f2 += f8;
            f6 += f9;
            if ((n4 += this.gv.getCharacterCount(i, i)) >= this.charMap.length) {
                n4 = this.charMap.length - 1;
            }
            c2 = this.aci.setIndex(n4 + n3);
        }
        if (n5 > -1) {
            Point2D point2D4 = this.gv.getGlyphPosition(n5);
            this.textPathAdvance = bl ? new Point2D.Double(point2D4.getX() + (double)f7, point2D4.getY()) : new Point2D.Double(point2D4.getX(), point2D4.getY() + (double)f7);
        } else {
            this.textPathAdvance = new Point2D.Double(0.0, 0.0);
        }
        this.layoutApplied = false;
        this.spacingApplied = false;
        this.pathApplied = true;
    }

    protected boolean isLatinChar(char c2) {
        Character.UnicodeBlock unicodeBlock = Character.UnicodeBlock.of(c2);
        return unicodeBlock == Character.UnicodeBlock.BASIC_LATIN || unicodeBlock == Character.UnicodeBlock.LATIN_1_SUPPLEMENT || unicodeBlock == Character.UnicodeBlock.LATIN_EXTENDED_ADDITIONAL || unicodeBlock == Character.UnicodeBlock.LATIN_EXTENDED_A || unicodeBlock == Character.UnicodeBlock.LATIN_EXTENDED_B || unicodeBlock == Character.UnicodeBlock.ARABIC || unicodeBlock == Character.UnicodeBlock.ARABIC_PRESENTATION_FORMS_A || unicodeBlock == Character.UnicodeBlock.ARABIC_PRESENTATION_FORMS_B;
    }

    protected boolean isGlyphOrientationAuto() {
        if (!this.isVertical()) {
            return false;
        }
        this.aci.first();
        Integer n = (Integer)this.aci.getAttribute(VERTICAL_ORIENTATION);
        if (n != null) {
            return n == ORIENTATION_AUTO;
        }
        return true;
    }

    protected int getGlyphOrientationAngle() {
        int n = 0;
        this.aci.first();
        Float f2 = this.isVertical() ? (Float)this.aci.getAttribute(VERTICAL_ORIENTATION_ANGLE) : (Float)this.aci.getAttribute(HORIZONTAL_ORIENTATION_ANGLE);
        if (f2 != null) {
            n = (int)f2.floatValue();
        }
        if (n != 0 || n != 90 || n != 180 || n != 270) {
            while (n < 0) {
                n += 360;
            }
            while (n >= 360) {
                n -= 360;
            }
            n = n <= 45 || n > 315 ? 0 : (n > 45 && n <= 135 ? 90 : (n > 135 && n <= 225 ? 180 : 270));
        }
        return n;
    }

    public boolean hasCharacterIndex(int n) {
        for (int i = 0; i < this.charMap.length; ++i) {
            if (n != this.charMap[i]) continue;
            return true;
        }
        return false;
    }

    public boolean isAltGlyph() {
        return this.isAltGlyph;
    }

    static {
        runAtts.add(X);
        runAtts.add(Y);
        runAtts.add(DX);
        runAtts.add(DY);
        runAtts.add(ROTATION);
        runAtts.add(BASELINE_SHIFT);
        szAtts = new HashSet();
        szAtts.add(TextAttribute.SIZE);
        szAtts.add(GVT_FONT);
        szAtts.add(LINE_HEIGHT);
    }
}

