/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.gvt.font;

import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphJustificationInfo;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.text.AttributedCharacterIterator;
import org.apache.batik.gvt.font.GVTFont;
import org.apache.batik.gvt.font.GVTGlyphMetrics;
import org.apache.batik.gvt.font.GVTGlyphVector;
import org.apache.batik.gvt.font.Glyph;
import org.apache.batik.gvt.text.ArabicTextHandler;
import org.apache.batik.gvt.text.GVTAttributedCharacterIterator;
import org.apache.batik.gvt.text.TextPaintInfo;

public final class SVGGVTGlyphVector
implements GVTGlyphVector {
    public static final AttributedCharacterIterator.Attribute PAINT_INFO = GVTAttributedCharacterIterator.TextAttribute.PAINT_INFO;
    private GVTFont font;
    private Glyph[] glyphs;
    private FontRenderContext frc;
    private GeneralPath outline;
    private Rectangle2D logicalBounds;
    private Rectangle2D bounds2D;
    private Shape[] glyphLogicalBounds;
    private boolean[] glyphVisible;
    private Point2D endPos;
    private TextPaintInfo cacheTPI;

    public SVGGVTGlyphVector(GVTFont gVTFont, Glyph[] glyphArray, FontRenderContext fontRenderContext) {
        this.font = gVTFont;
        this.glyphs = glyphArray;
        this.frc = fontRenderContext;
        this.outline = null;
        this.bounds2D = null;
        this.logicalBounds = null;
        this.glyphLogicalBounds = new Shape[glyphArray.length];
        this.glyphVisible = new boolean[glyphArray.length];
        for (int i = 0; i < glyphArray.length; ++i) {
            this.glyphVisible[i] = true;
        }
        this.endPos = glyphArray[glyphArray.length - 1].getPosition();
        this.endPos = new Point2D.Float((float)(this.endPos.getX() + (double)glyphArray[glyphArray.length - 1].getHorizAdvX()), (float)this.endPos.getY());
    }

    public GVTFont getFont() {
        return this.font;
    }

    public FontRenderContext getFontRenderContext() {
        return this.frc;
    }

    public int getGlyphCode(int n) throws IndexOutOfBoundsException {
        if (n < 0 || n > this.glyphs.length - 1) {
            throw new IndexOutOfBoundsException("glyphIndex " + n + " is out of bounds, should be between 0 and " + (this.glyphs.length - 1));
        }
        return this.glyphs[n].getGlyphCode();
    }

    public int[] getGlyphCodes(int n, int n2, int[] nArray) throws IndexOutOfBoundsException, IllegalArgumentException {
        if (n2 < 0) {
            throw new IllegalArgumentException("numEntries argument value, " + n2 + ", is illegal. It must be > 0.");
        }
        if (n < 0) {
            throw new IndexOutOfBoundsException("beginGlyphIndex " + n + " is out of bounds, should be between 0 and " + (this.glyphs.length - 1));
        }
        if (n + n2 > this.glyphs.length) {
            throw new IndexOutOfBoundsException("beginGlyphIndex + numEntries (" + n + "+" + n2 + ") exceeds the number of glpyhs in this GlyphVector");
        }
        if (nArray == null) {
            nArray = new int[n2];
        }
        for (int i = n; i < n + n2; ++i) {
            nArray[i - n] = this.glyphs[i].getGlyphCode();
        }
        return nArray;
    }

    public GlyphJustificationInfo getGlyphJustificationInfo(int n) {
        if (n < 0 || n > this.glyphs.length - 1) {
            throw new IndexOutOfBoundsException("glyphIndex: " + n + ", is out of bounds. Should be between 0 and " + (this.glyphs.length - 1) + ".");
        }
        return null;
    }

    public Shape getGlyphLogicalBounds(int n) {
        if (this.glyphLogicalBounds[n] == null && this.glyphVisible[n]) {
            this.computeGlyphLogicalBounds();
        }
        return this.glyphLogicalBounds[n];
    }

    private void computeGlyphLogicalBounds() {
        double d2;
        Cloneable cloneable;
        Cloneable cloneable2;
        Rectangle2D rectangle2D;
        Shape[] shapeArray;
        float f2 = 0.0f;
        float f3 = 0.0f;
        if (this.font != null) {
            shapeArray = this.font.getLineMetrics("By", this.frc);
            f2 = shapeArray.getAscent();
            f3 = shapeArray.getDescent();
            if (f3 < 0.0f) {
                f3 = -f3;
            }
        }
        if (f2 == 0.0f) {
            float f4 = 0.0f;
            float f5 = 0.0f;
            for (int i = 0; i < this.getNumGlyphs(); ++i) {
                if (!this.glyphVisible[i]) continue;
                GVTGlyphMetrics gVTGlyphMetrics = this.getGlyphMetrics(i);
                Rectangle2D rectangle2D2 = gVTGlyphMetrics.getBounds2D();
                f2 = (float)(-rectangle2D2.getMinY());
                f3 = (float)(rectangle2D2.getHeight() - (double)f2);
                if (f2 > f4) {
                    f4 = f2;
                }
                if (!(f3 > f5)) continue;
                f5 = f3;
            }
            f2 = f4;
            f3 = f5;
        }
        shapeArray = new Shape[this.getNumGlyphs()];
        boolean[] blArray = new boolean[this.getNumGlyphs()];
        double d3 = -1.0;
        double d4 = -1.0;
        for (int i = 0; i < this.getNumGlyphs(); ++i) {
            double d5;
            if (!this.glyphVisible[i]) {
                shapeArray[i] = null;
                continue;
            }
            AffineTransform affineTransform = this.getGlyphTransform(i);
            GVTGlyphMetrics gVTGlyphMetrics = this.getGlyphMetrics(i);
            rectangle2D = new Rectangle2D.Double(0.0, -f2, gVTGlyphMetrics.getHorizontalAdvance(), f2 + f3);
            if (rectangle2D.isEmpty()) {
                if (i > 0) {
                    blArray[i] = blArray[i - 1];
                    continue;
                }
                blArray[i] = true;
                continue;
            }
            Point2D.Double double_ = new Point2D.Double(rectangle2D.getMinX(), rectangle2D.getMinY());
            Point2D.Double double_2 = new Point2D.Double(rectangle2D.getMaxX(), rectangle2D.getMinY());
            Point2D.Double double_3 = new Point2D.Double(rectangle2D.getMinX(), rectangle2D.getMaxY());
            Point2D point2D = this.getGlyphPosition(i);
            cloneable2 = AffineTransform.getTranslateInstance(point2D.getX(), point2D.getY());
            if (affineTransform != null) {
                ((AffineTransform)cloneable2).concatenate(affineTransform);
            }
            shapeArray[i] = ((AffineTransform)cloneable2).createTransformedShape(rectangle2D);
            cloneable = new Point2D.Double();
            Point2D.Double double_4 = new Point2D.Double();
            Point2D.Double double_5 = new Point2D.Double();
            ((AffineTransform)cloneable2).transform(double_, (Point2D)cloneable);
            ((AffineTransform)cloneable2).transform(double_2, double_4);
            ((AffineTransform)cloneable2).transform(double_3, double_5);
            d2 = ((Point2D)cloneable).getX() - ((Point2D)double_4).getX();
            double d6 = ((Point2D)cloneable).getX() - ((Point2D)double_5).getX();
            double d7 = ((Point2D)cloneable).getY() - ((Point2D)double_4).getY();
            double d8 = ((Point2D)cloneable).getY() - ((Point2D)double_5).getY();
            if (Math.abs(d2) < 0.001 && Math.abs(d8) < 0.001) {
                blArray[i] = false;
                double d9 = ((Point2D)double_).getX() - ((Point2D)double_3).getX();
                d5 = ((Point2D)double_).getY() - ((Point2D)double_2).getY();
            } else if (Math.abs(d6) < 0.001 && Math.abs(d7) < 0.001) {
                blArray[i] = false;
                double d10 = ((Point2D)double_).getX() - ((Point2D)double_2).getX();
                d5 = ((Point2D)double_).getY() - ((Point2D)double_3).getY();
            } else {
                blArray[i] = true;
            }
            Rectangle2D rectangle2D3 = shapeArray[i].getBounds2D();
            if (rectangle2D3.getWidth() > d3) {
                d3 = rectangle2D3.getWidth();
            }
            if (!(rectangle2D3.getHeight() > d4)) continue;
            d4 = rectangle2D3.getHeight();
        }
        GeneralPath generalPath = new GeneralPath();
        for (int i = 0; i < this.getNumGlyphs(); ++i) {
            if (shapeArray[i] == null) continue;
            generalPath.append(shapeArray[i], false);
        }
        Rectangle2D rectangle2D4 = generalPath.getBounds2D();
        if (rectangle2D4.getHeight() < d4 * 1.5) {
            for (int i = 0; i < this.getNumGlyphs(); ++i) {
                if (blArray[i] || shapeArray[i] == null) continue;
                rectangle2D = shapeArray[i].getBounds2D();
                double d11 = rectangle2D.getMinX();
                double d12 = rectangle2D.getWidth();
                if (i < this.getNumGlyphs() - 1 && shapeArray[i + 1] != null) {
                    double d13;
                    cloneable2 = shapeArray[i + 1].getBounds2D();
                    cloneable = shapeArray[i + 1].getBounds2D();
                    if (((RectangularShape)cloneable).getX() > d11 && (d13 = ((RectangularShape)cloneable).getX() - d11) < d12 * 1.15 && d13 > d12 * 0.85) {
                        d2 = (d13 - d12) * 0.5;
                        d12 += d2;
                        ((Rectangle2D)cloneable).setRect(((RectangularShape)cloneable).getX() - d2, ((RectangularShape)cloneable).getY(), ((RectangularShape)cloneable).getWidth() + d2, ((RectangularShape)cloneable).getHeight());
                    }
                }
                shapeArray[i] = new Rectangle2D.Double(d11, rectangle2D4.getMinY(), d12, rectangle2D4.getHeight());
            }
        } else if (rectangle2D4.getWidth() < d3 * 1.5) {
            for (int i = 0; i < this.getNumGlyphs(); ++i) {
                double d14;
                if (blArray[i] || shapeArray[i] == null) continue;
                rectangle2D = shapeArray[i].getBounds2D();
                double d15 = rectangle2D.getMinY();
                double d16 = rectangle2D.getHeight();
                if (i < this.getNumGlyphs() - 1 && shapeArray[i + 1] != null && ((RectangularShape)(cloneable2 = shapeArray[i + 1].getBounds2D())).getY() > d15 && (d14 = ((RectangularShape)cloneable2).getY() - d15) < d16 * 1.15 && d14 > d16 * 0.85) {
                    double d17 = (d14 - d16) * 0.5;
                    d16 += d17;
                    ((Rectangle2D)cloneable2).setRect(((RectangularShape)cloneable2).getX(), ((RectangularShape)cloneable2).getY() - d17, ((RectangularShape)cloneable2).getWidth(), ((RectangularShape)cloneable2).getHeight() + d17);
                }
                shapeArray[i] = new Rectangle2D.Double(rectangle2D4.getMinX(), d15, rectangle2D4.getWidth(), d16);
            }
        }
        for (int i = 0; i < this.getNumGlyphs(); ++i) {
            this.glyphLogicalBounds[i] = shapeArray[i];
        }
    }

    public GVTGlyphMetrics getGlyphMetrics(int n) {
        if (n < 0 || n > this.glyphs.length - 1) {
            throw new IndexOutOfBoundsException("idx: " + n + ", is out of bounds. Should be between 0 and " + (this.glyphs.length - 1) + ".");
        }
        if (n < this.glyphs.length - 1 && this.font != null) {
            float f2 = this.font.getHKern(this.glyphs[n].getGlyphCode(), this.glyphs[n + 1].getGlyphCode());
            float f3 = this.font.getVKern(this.glyphs[n].getGlyphCode(), this.glyphs[n + 1].getGlyphCode());
            return this.glyphs[n].getGlyphMetrics(f2, f3);
        }
        return this.glyphs[n].getGlyphMetrics();
    }

    public Shape getGlyphOutline(int n) {
        if (n < 0 || n > this.glyphs.length - 1) {
            throw new IndexOutOfBoundsException("glyphIndex: " + n + ", is out of bounds. Should be between 0 and " + (this.glyphs.length - 1) + ".");
        }
        return this.glyphs[n].getOutline();
    }

    public Point2D getGlyphPosition(int n) {
        if (n == this.glyphs.length) {
            return this.endPos;
        }
        if (n < 0 || n > this.glyphs.length - 1) {
            throw new IndexOutOfBoundsException("glyphIndex: " + n + ", is out of bounds. Should be between 0 and " + (this.glyphs.length - 1) + ".");
        }
        return this.glyphs[n].getPosition();
    }

    public float[] getGlyphPositions(int n, int n2, float[] fArray) {
        if (n2 < 0) {
            throw new IllegalArgumentException("numEntries argument value, " + n2 + ", is illegal. It must be > 0.");
        }
        if (n < 0) {
            throw new IndexOutOfBoundsException("beginGlyphIndex " + n + " is out of bounds, should be between 0 and " + (this.glyphs.length - 1));
        }
        if (n + n2 > this.glyphs.length + 1) {
            throw new IndexOutOfBoundsException("beginGlyphIndex + numEntries (" + n + "+" + n2 + ") exceeds the number of glpyhs in this GlyphVector");
        }
        if (fArray == null) {
            fArray = new float[n2 * 2];
        }
        if (n + n2 == this.glyphs.length + 1) {
            fArray[--n2 * 2] = (float)this.endPos.getX();
            fArray[n2 * 2 + 1] = (float)this.endPos.getY();
        }
        for (int i = n; i < n + n2; ++i) {
            Point2D point2D = this.glyphs[i].getPosition();
            fArray[(i - n) * 2] = (float)point2D.getX();
            fArray[(i - n) * 2 + 1] = (float)point2D.getY();
        }
        return fArray;
    }

    public AffineTransform getGlyphTransform(int n) {
        if (n < 0 || n > this.glyphs.length - 1) {
            throw new IndexOutOfBoundsException("glyphIndex: " + n + ", is out of bounds. Should be between 0 and " + (this.glyphs.length - 1) + ".");
        }
        return this.glyphs[n].getTransform();
    }

    public Shape getGlyphVisualBounds(int n) {
        if (n < 0 || n > this.glyphs.length - 1) {
            throw new IndexOutOfBoundsException("glyphIndex: " + n + ", is out of bounds. Should be between 0 and " + (this.glyphs.length - 1) + ".");
        }
        return this.glyphs[n].getOutline();
    }

    public Rectangle2D getBounds2D(AttributedCharacterIterator attributedCharacterIterator) {
        attributedCharacterIterator.first();
        TextPaintInfo textPaintInfo = (TextPaintInfo)attributedCharacterIterator.getAttribute(PAINT_INFO);
        if (this.bounds2D != null && TextPaintInfo.equivilent(textPaintInfo, this.cacheTPI)) {
            return this.bounds2D;
        }
        Rectangle2D rectangle2D = null;
        if (textPaintInfo.visible) {
            for (int i = 0; i < this.getNumGlyphs(); ++i) {
                Rectangle2D rectangle2D2;
                if (!this.glyphVisible[i] || (rectangle2D2 = this.glyphs[i].getBounds2D()) == null) continue;
                rectangle2D = rectangle2D == null ? rectangle2D2 : rectangle2D2.createUnion(rectangle2D);
            }
        }
        this.bounds2D = rectangle2D;
        if (this.bounds2D == null) {
            this.bounds2D = new Rectangle2D.Float();
        }
        this.cacheTPI = new TextPaintInfo(textPaintInfo);
        return this.bounds2D;
    }

    public Rectangle2D getLogicalBounds() {
        if (this.logicalBounds == null) {
            GeneralPath generalPath = new GeneralPath();
            for (int i = 0; i < this.getNumGlyphs(); ++i) {
                Shape shape = this.getGlyphLogicalBounds(i);
                if (shape == null) continue;
                generalPath.append(shape, false);
            }
            this.logicalBounds = generalPath.getBounds2D();
        }
        return this.logicalBounds;
    }

    public int getNumGlyphs() {
        if (this.glyphs != null) {
            return this.glyphs.length;
        }
        return 0;
    }

    public Shape getOutline() {
        if (this.outline == null) {
            this.outline = new GeneralPath();
            for (int i = 0; i < this.glyphs.length; ++i) {
                Shape shape;
                if (!this.glyphVisible[i] || (shape = this.glyphs[i].getOutline()) == null) continue;
                this.outline.append(shape, false);
            }
        }
        return this.outline;
    }

    public Shape getOutline(float f2, float f3) {
        Shape shape = this.getOutline();
        AffineTransform affineTransform = AffineTransform.getTranslateInstance(f2, f3);
        Shape shape2 = affineTransform.createTransformedShape(shape);
        return shape2;
    }

    public Rectangle2D getGeometricBounds() {
        return this.getOutline().getBounds2D();
    }

    public void performDefaultLayout() {
        this.logicalBounds = null;
        this.outline = null;
        this.bounds2D = null;
        float f2 = 0.0f;
        float f3 = 0.0f;
        for (int i = 0; i < this.glyphs.length; ++i) {
            Glyph glyph = this.glyphs[i];
            glyph.setTransform(null);
            this.glyphLogicalBounds[i] = null;
            String string = glyph.getUnicode();
            if (string != null && string.length() != 0 && ArabicTextHandler.arabicCharTransparent(string.charAt(0))) {
                char c2;
                int n;
                for (n = i + 1; n < this.glyphs.length && (string = this.glyphs[n].getUnicode()) != null && string.length() != 0 && ArabicTextHandler.arabicCharTransparent(c2 = string.charAt(0)); ++n) {
                }
                if (n != this.glyphs.length) {
                    Glyph glyph2 = this.glyphs[n];
                    float f4 = f2 + glyph2.getHorizAdvX();
                    for (int j = i; j < n; ++j) {
                        glyph = this.glyphs[j];
                        glyph.setTransform(null);
                        this.glyphLogicalBounds[i] = null;
                        glyph.setPosition(new Point2D.Float(f4 - glyph.getHorizAdvX(), f3));
                    }
                    i = n;
                    glyph = glyph2;
                }
            }
            glyph.setPosition(new Point2D.Float(f2, f3));
            f2 += glyph.getHorizAdvX();
        }
        this.endPos = new Point2D.Float(f2, f3);
    }

    public void setGlyphPosition(int n, Point2D point2D) throws IndexOutOfBoundsException {
        if (n == this.glyphs.length) {
            this.endPos = (Point2D)point2D.clone();
            return;
        }
        if (n < 0 || n > this.glyphs.length - 1) {
            throw new IndexOutOfBoundsException("glyphIndex: " + n + ", is out of bounds. Should be between 0 and " + (this.glyphs.length - 1) + ".");
        }
        this.glyphs[n].setPosition(point2D);
        this.glyphLogicalBounds[n] = null;
        this.outline = null;
        this.bounds2D = null;
        this.logicalBounds = null;
    }

    public void setGlyphTransform(int n, AffineTransform affineTransform) {
        if (n < 0 || n > this.glyphs.length - 1) {
            throw new IndexOutOfBoundsException("glyphIndex: " + n + ", is out of bounds. Should be between 0 and " + (this.glyphs.length - 1) + ".");
        }
        this.glyphs[n].setTransform(affineTransform);
        this.glyphLogicalBounds[n] = null;
        this.outline = null;
        this.bounds2D = null;
        this.logicalBounds = null;
    }

    public void setGlyphVisible(int n, boolean bl) {
        if (bl == this.glyphVisible[n]) {
            return;
        }
        this.glyphVisible[n] = bl;
        this.outline = null;
        this.bounds2D = null;
        this.logicalBounds = null;
        this.glyphLogicalBounds[n] = null;
    }

    public boolean isGlyphVisible(int n) {
        return this.glyphVisible[n];
    }

    public int getCharacterCount(int n, int n2) {
        int n3 = 0;
        if (n < 0) {
            n = 0;
        }
        if (n2 > this.glyphs.length - 1) {
            n2 = this.glyphs.length - 1;
        }
        for (int i = n; i <= n2; ++i) {
            Glyph glyph = this.glyphs[i];
            if (glyph.getGlyphCode() == -1) {
                ++n3;
                continue;
            }
            String string = glyph.getUnicode();
            n3 += string.length();
        }
        return n3;
    }

    public void draw(Graphics2D graphics2D, AttributedCharacterIterator attributedCharacterIterator) {
        attributedCharacterIterator.first();
        TextPaintInfo textPaintInfo = (TextPaintInfo)attributedCharacterIterator.getAttribute(PAINT_INFO);
        if (!textPaintInfo.visible) {
            return;
        }
        for (int i = 0; i < this.glyphs.length; ++i) {
            if (!this.glyphVisible[i]) continue;
            this.glyphs[i].draw(graphics2D);
        }
    }
}

