/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.gvt.font;

import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphJustificationInfo;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.text.AttributedCharacterIterator;
import java.util.Iterator;
import java.util.List;
import org.apache.batik.gvt.font.GVTFont;
import org.apache.batik.gvt.font.GVTGlyphMetrics;
import org.apache.batik.gvt.font.GVTGlyphVector;
import org.apache.batik.gvt.text.AttributedCharacterSpanIterator;

public class MultiGlyphVector
implements GVTGlyphVector {
    GVTGlyphVector[] gvs;
    int[] nGlyphs;
    int[] off;
    int nGlyph;

    public MultiGlyphVector(List list) {
        this.gvs = new GVTGlyphVector[list.size()];
        this.nGlyphs = new int[list.size()];
        this.off = new int[list.size()];
        Iterator iterator = list.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            GVTGlyphVector gVTGlyphVector;
            this.off[n] = this.nGlyph;
            this.gvs[n] = gVTGlyphVector = (GVTGlyphVector)iterator.next();
            this.nGlyphs[n] = gVTGlyphVector.getNumGlyphs();
            this.nGlyph += this.nGlyphs[n];
            ++n;
        }
        int n2 = n - 1;
        this.nGlyphs[n2] = this.nGlyphs[n2] + 1;
    }

    public int getNumGlyphs() {
        return this.nGlyph;
    }

    int getGVIdx(int n) {
        if (n > this.nGlyph) {
            return -1;
        }
        if (n == this.nGlyph) {
            return this.gvs.length - 1;
        }
        for (int i = 0; i < this.nGlyphs.length; ++i) {
            if (n - this.off[i] >= this.nGlyphs[i]) continue;
            return i;
        }
        return -1;
    }

    public GVTFont getFont() {
        throw new IllegalArgumentException("Can't be correctly Implemented");
    }

    public FontRenderContext getFontRenderContext() {
        return this.gvs[0].getFontRenderContext();
    }

    public int getGlyphCode(int n) {
        int n2 = this.getGVIdx(n);
        return this.gvs[n2].getGlyphCode(n - this.off[n2]);
    }

    public GlyphJustificationInfo getGlyphJustificationInfo(int n) {
        int n2 = this.getGVIdx(n);
        return this.gvs[n2].getGlyphJustificationInfo(n - this.off[n2]);
    }

    public Shape getGlyphLogicalBounds(int n) {
        int n2 = this.getGVIdx(n);
        return this.gvs[n2].getGlyphLogicalBounds(n - this.off[n2]);
    }

    public GVTGlyphMetrics getGlyphMetrics(int n) {
        int n2 = this.getGVIdx(n);
        return this.gvs[n2].getGlyphMetrics(n - this.off[n2]);
    }

    public Shape getGlyphOutline(int n) {
        int n2 = this.getGVIdx(n);
        return this.gvs[n2].getGlyphOutline(n - this.off[n2]);
    }

    public Point2D getGlyphPosition(int n) {
        int n2 = this.getGVIdx(n);
        return this.gvs[n2].getGlyphPosition(n - this.off[n2]);
    }

    public AffineTransform getGlyphTransform(int n) {
        int n2 = this.getGVIdx(n);
        return this.gvs[n2].getGlyphTransform(n - this.off[n2]);
    }

    public Shape getGlyphVisualBounds(int n) {
        int n2 = this.getGVIdx(n);
        return this.gvs[n2].getGlyphVisualBounds(n - this.off[n2]);
    }

    public void setGlyphPosition(int n, Point2D point2D) {
        int n2 = this.getGVIdx(n);
        this.gvs[n2].setGlyphPosition(n - this.off[n2], point2D);
    }

    public void setGlyphTransform(int n, AffineTransform affineTransform) {
        int n2 = this.getGVIdx(n);
        this.gvs[n2].setGlyphTransform(n - this.off[n2], affineTransform);
    }

    public void setGlyphVisible(int n, boolean bl) {
        int n2 = this.getGVIdx(n);
        this.gvs[n2].setGlyphVisible(n - this.off[n2], bl);
    }

    public boolean isGlyphVisible(int n) {
        int n2 = this.getGVIdx(n);
        return this.gvs[n2].isGlyphVisible(n - this.off[n2]);
    }

    public int[] getGlyphCodes(int n, int n2, int[] nArray) {
        int[] nArray2 = nArray;
        if (nArray2 == null) {
            nArray2 = new int[n2];
        }
        int[] nArray3 = null;
        int n3 = this.getGVIdx(n);
        int n4 = n - this.off[n3];
        int n5 = 0;
        while (n2 != 0) {
            int n6 = n2;
            if (n4 + n6 > this.nGlyphs[n3]) {
                n6 = this.nGlyphs[n3] - n4;
            }
            GVTGlyphVector gVTGlyphVector = this.gvs[n3];
            if (n5 == 0) {
                gVTGlyphVector.getGlyphCodes(n4, n6, nArray2);
            } else {
                if (nArray3 == null || nArray3.length < n6) {
                    nArray3 = new int[n6];
                }
                gVTGlyphVector.getGlyphCodes(n4, n6, nArray3);
                for (int i = 0; i < n6; ++i) {
                    nArray2[n5 + i] = nArray3[i];
                }
            }
            n4 = 0;
            ++n3;
            n2 -= n6;
            n5 += n6;
        }
        return nArray2;
    }

    public float[] getGlyphPositions(int n, int n2, float[] fArray) {
        float[] fArray2 = fArray;
        if (fArray2 == null) {
            fArray2 = new float[n2 * 2];
        }
        float[] fArray3 = null;
        int n3 = this.getGVIdx(n);
        int n4 = n - this.off[n3];
        int n5 = 0;
        while (n2 != 0) {
            int n6 = n2;
            if (n4 + n6 > this.nGlyphs[n3]) {
                n6 = this.nGlyphs[n3] - n4;
            }
            GVTGlyphVector gVTGlyphVector = this.gvs[n3];
            if (n5 == 0) {
                gVTGlyphVector.getGlyphPositions(n4, n6, fArray2);
            } else {
                if (fArray3 == null || fArray3.length < n6 * 2) {
                    fArray3 = new float[n6 * 2];
                }
                gVTGlyphVector.getGlyphPositions(n4, n6, fArray3);
                for (int i = 0; i < n6 * 2; ++i) {
                    fArray2[n5 + i] = fArray3[i];
                }
            }
            n4 = 0;
            ++n3;
            n2 -= n6;
            n5 += n6 * 2;
        }
        return fArray2;
    }

    public Rectangle2D getLogicalBounds() {
        Rectangle2D rectangle2D = null;
        for (int i = 0; i < this.gvs.length; ++i) {
            Rectangle2D rectangle2D2 = this.gvs[i].getLogicalBounds();
            rectangle2D = rectangle2D == null ? rectangle2D2 : rectangle2D.createUnion(rectangle2D2);
        }
        return rectangle2D;
    }

    public Shape getOutline() {
        Path2D path2D = null;
        for (int i = 0; i < this.gvs.length; ++i) {
            Shape shape = this.gvs[i].getOutline();
            if (path2D == null) {
                path2D = new GeneralPath(shape);
                continue;
            }
            path2D.append(shape, false);
        }
        return path2D;
    }

    public Shape getOutline(float f2, float f3) {
        Shape shape = this.getOutline();
        AffineTransform affineTransform = AffineTransform.getTranslateInstance(f2, f3);
        shape = affineTransform.createTransformedShape(shape);
        return shape;
    }

    public Rectangle2D getBounds2D(AttributedCharacterIterator attributedCharacterIterator) {
        Rectangle2D rectangle2D = null;
        int n = attributedCharacterIterator.getBeginIndex();
        for (int i = 0; i < this.gvs.length; ++i) {
            GVTGlyphVector gVTGlyphVector = this.gvs[i];
            int n2 = gVTGlyphVector.getCharacterCount(0, gVTGlyphVector.getNumGlyphs()) + 1;
            Rectangle2D rectangle2D2 = this.gvs[i].getBounds2D(new AttributedCharacterSpanIterator(attributedCharacterIterator, n, n2));
            rectangle2D = rectangle2D == null ? rectangle2D2 : rectangle2D.createUnion(rectangle2D2);
            n = n2;
        }
        return rectangle2D;
    }

    public Rectangle2D getGeometricBounds() {
        Rectangle2D rectangle2D = null;
        for (int i = 0; i < this.gvs.length; ++i) {
            Rectangle2D rectangle2D2 = this.gvs[i].getGeometricBounds();
            rectangle2D = rectangle2D == null ? rectangle2D2 : rectangle2D.createUnion(rectangle2D2);
        }
        return rectangle2D;
    }

    public void performDefaultLayout() {
        for (int i = 0; i < this.gvs.length; ++i) {
            this.gvs[i].performDefaultLayout();
        }
    }

    public int getCharacterCount(int n, int n2) {
        int n3 = this.getGVIdx(n);
        int n4 = this.getGVIdx(n2);
        int n5 = 0;
        for (int i = n3; i <= n4; ++i) {
            int n6 = n - this.off[i];
            int n7 = n2 - this.off[i];
            if (n7 >= this.nGlyphs[i]) {
                n7 = this.nGlyphs[i] - 1;
            }
            n5 += this.gvs[i].getCharacterCount(n6, n7);
            n += n7 - n6 + 1;
        }
        return n5;
    }

    public void draw(Graphics2D graphics2D, AttributedCharacterIterator attributedCharacterIterator) {
        int n = attributedCharacterIterator.getBeginIndex();
        for (int i = 0; i < this.gvs.length; ++i) {
            GVTGlyphVector gVTGlyphVector = this.gvs[i];
            int n2 = gVTGlyphVector.getCharacterCount(0, gVTGlyphVector.getNumGlyphs()) + 1;
            gVTGlyphVector.draw(graphics2D, new AttributedCharacterSpanIterator(attributedCharacterIterator, n, n2));
            n = n2;
        }
    }
}

