/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.gvt.font;

import java.util.Arrays;
import org.apache.batik.gvt.font.UnicodeRange;

public class Kern {
    private int[] firstGlyphCodes;
    private int[] secondGlyphCodes;
    private UnicodeRange[] firstUnicodeRanges;
    private UnicodeRange[] secondUnicodeRanges;
    private float kerningAdjust;

    public Kern(int[] nArray, int[] nArray2, UnicodeRange[] unicodeRangeArray, UnicodeRange[] unicodeRangeArray2, float f2) {
        this.firstGlyphCodes = nArray;
        this.secondGlyphCodes = nArray2;
        this.firstUnicodeRanges = unicodeRangeArray;
        this.secondUnicodeRanges = unicodeRangeArray2;
        this.kerningAdjust = f2;
        if (nArray != null) {
            Arrays.sort(this.firstGlyphCodes);
        }
        if (nArray2 != null) {
            Arrays.sort(this.secondGlyphCodes);
        }
    }

    public boolean matchesFirstGlyph(int n, String string) {
        int n2;
        if (this.firstGlyphCodes != null && (n2 = Arrays.binarySearch(this.firstGlyphCodes, n)) >= 0) {
            return true;
        }
        if (string.length() < 1) {
            return false;
        }
        n2 = string.charAt(0);
        for (int i = 0; i < this.firstUnicodeRanges.length; ++i) {
            if (!this.firstUnicodeRanges[i].contains(n2)) continue;
            return true;
        }
        return false;
    }

    public boolean matchesFirstGlyph(int n, char c2) {
        int n2;
        if (this.firstGlyphCodes != null && (n2 = Arrays.binarySearch(this.firstGlyphCodes, n)) >= 0) {
            return true;
        }
        for (n2 = 0; n2 < this.firstUnicodeRanges.length; ++n2) {
            if (!this.firstUnicodeRanges[n2].contains(c2)) continue;
            return true;
        }
        return false;
    }

    public boolean matchesSecondGlyph(int n, String string) {
        int n2;
        if (this.secondGlyphCodes != null && (n2 = Arrays.binarySearch(this.secondGlyphCodes, n)) >= 0) {
            return true;
        }
        if (string.length() < 1) {
            return false;
        }
        n2 = string.charAt(0);
        for (int i = 0; i < this.secondUnicodeRanges.length; ++i) {
            if (!this.secondUnicodeRanges[i].contains(n2)) continue;
            return true;
        }
        return false;
    }

    public boolean matchesSecondGlyph(int n, char c2) {
        int n2;
        if (this.secondGlyphCodes != null && (n2 = Arrays.binarySearch(this.secondGlyphCodes, n)) >= 0) {
            return true;
        }
        for (n2 = 0; n2 < this.secondUnicodeRanges.length; ++n2) {
            if (!this.secondUnicodeRanges[n2].contains(c2)) continue;
            return true;
        }
        return false;
    }

    public float getAdjustValue() {
        return this.kerningAdjust;
    }
}

