/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.gvt.flow;

import java.awt.geom.Point2D;
import org.apache.batik.gvt.flow.BlockInfo;
import org.apache.batik.gvt.flow.FlowRegions;
import org.apache.batik.gvt.flow.GlyphGroupInfo;
import org.apache.batik.gvt.flow.WordInfo;
import org.apache.batik.gvt.font.GVTGlyphVector;

public class LineInfo {
    FlowRegions fr;
    double lineHeight = -1.0;
    double ascent = -1.0;
    double descent = -1.0;
    double hLeading = -1.0;
    double baseline;
    int numGlyphs;
    int words = 0;
    int size = 0;
    GlyphGroupInfo[] ggis = null;
    int newSize = 0;
    GlyphGroupInfo[] newGGIS = null;
    int numRanges;
    double[] ranges;
    double[] rangeAdv;
    BlockInfo bi = null;
    boolean paraStart;
    boolean paraEnd;
    protected static final int FULL_WORD = 0;
    protected static final int FULL_ADV = 1;
    static final float MAX_COMPRESS = 0.1f;
    static final float COMRESS_SCALE = 3.0f;

    public LineInfo(FlowRegions flowRegions, BlockInfo blockInfo, boolean bl) {
        this.fr = flowRegions;
        this.bi = blockInfo;
        this.lineHeight = blockInfo.getLineHeight();
        this.ascent = blockInfo.getAscent();
        this.descent = blockInfo.getDescent();
        this.hLeading = (this.lineHeight - (this.ascent + this.descent)) / 2.0;
        this.baseline = (float)(flowRegions.getCurrentY() + this.hLeading + this.ascent);
        this.paraStart = bl;
        this.paraEnd = false;
        if (this.lineHeight > 0.0) {
            flowRegions.newLineHeight(this.lineHeight);
            this.updateRangeInfo();
        }
    }

    public void setParaEnd(boolean bl) {
        this.paraEnd = bl;
    }

    public boolean addWord(WordInfo wordInfo) {
        double d2 = wordInfo.getLineHeight();
        if (d2 <= this.lineHeight) {
            return this.insertWord(wordInfo);
        }
        this.fr.newLineHeight(d2);
        if (!this.updateRangeInfo()) {
            if (this.lineHeight > 0.0) {
                this.fr.newLineHeight(this.lineHeight);
            }
            return false;
        }
        if (!this.insertWord(wordInfo)) {
            if (this.lineHeight > 0.0) {
                this.setLineHeight(this.lineHeight);
            }
            return false;
        }
        this.lineHeight = d2;
        if ((double)wordInfo.getAscent() > this.ascent) {
            this.ascent = wordInfo.getAscent();
        }
        if ((double)wordInfo.getDescent() > this.descent) {
            this.descent = wordInfo.getDescent();
        }
        this.hLeading = (d2 - (this.ascent + this.descent)) / 2.0;
        this.baseline = (float)(this.fr.getCurrentY() + this.hLeading + this.ascent);
        return true;
    }

    public boolean insertWord(WordInfo wordInfo) {
        this.mergeGlyphGroups(wordInfo);
        if (!this.assignGlyphGroupRanges(this.newSize, this.newGGIS)) {
            return false;
        }
        this.swapGlyphGroupInfo();
        return true;
    }

    public boolean assignGlyphGroupRanges(int n, GlyphGroupInfo[] glyphGroupInfoArray) {
        int n2 = 0;
        for (int i = 0; i < this.numRanges; ++i) {
            GlyphGroupInfo glyphGroupInfo;
            double d2 = this.ranges[2 * i + 1] - this.ranges[2 * i];
            float f2 = 0.0f;
            float f3 = 0.0f;
            double d3 = d2;
            while (n2 < n) {
                glyphGroupInfo = glyphGroupInfoArray[n2];
                glyphGroupInfo.setRange(i);
                f2 = glyphGroupInfo.getAdvance();
                double d4 = d2 - (double)(f3 + f2);
                if (d4 < 0.0) break;
                ++n2;
                f3 += f2;
            }
            if (n2 == n) {
                --n2;
                f3 -= f2;
            }
            glyphGroupInfo = glyphGroupInfoArray[n2];
            float f4 = glyphGroupInfo.getLastAdvance();
            while ((double)(f3 + f4) > d2) {
                f4 = 0.0f;
                if (--n2 < 0 || i != (glyphGroupInfo = glyphGroupInfoArray[n2]).getRange()) break;
                f3 -= glyphGroupInfo.getAdvance();
                f4 = glyphGroupInfo.getLastAdvance();
            }
            this.rangeAdv[i] = f3 + f4;
            if (++n2 != n) continue;
            return true;
        }
        return false;
    }

    public boolean setLineHeight(double d2) {
        this.fr.newLineHeight(d2);
        if (this.updateRangeInfo()) {
            this.lineHeight = d2;
            return true;
        }
        if (this.lineHeight > 0.0) {
            this.fr.newLineHeight(this.lineHeight);
        }
        return false;
    }

    public double getCurrentY() {
        return this.fr.getCurrentY();
    }

    public boolean gotoY(double d2) {
        if (this.fr.gotoY(d2)) {
            return true;
        }
        if (this.lineHeight > 0.0) {
            this.updateRangeInfo();
        }
        this.baseline = (float)(this.fr.getCurrentY() + this.hLeading + this.ascent);
        return false;
    }

    protected boolean updateRangeInfo() {
        int n;
        this.fr.resetRange();
        int n2 = this.fr.getNumRangeOnLine();
        if (n2 == 0) {
            return false;
        }
        this.numRanges = n2;
        if (this.ranges == null) {
            this.rangeAdv = new double[this.numRanges];
            this.ranges = new double[2 * this.numRanges];
        } else if (this.numRanges > this.rangeAdv.length) {
            n = 2 * this.rangeAdv.length;
            if (n < this.numRanges) {
                n = this.numRanges;
            }
            this.rangeAdv = new double[n];
            this.ranges = new double[2 * n];
        }
        for (n = 0; n < this.numRanges; ++n) {
            double d2;
            double[] dArray = this.fr.nextRange();
            double d3 = dArray[0];
            if (n == 0) {
                d2 = this.bi.getLeftMargin();
                if (this.paraStart) {
                    double d4 = this.bi.getIndent();
                    d2 = d2 < -d4 ? 0.0 : (d2 += d4);
                }
                d3 += d2;
            }
            d2 = dArray[1];
            if (n == this.numRanges - 1) {
                d2 -= (double)this.bi.getRightMargin();
            }
            this.ranges[2 * n] = d3;
            this.ranges[2 * n + 1] = d2;
        }
        return true;
    }

    protected void swapGlyphGroupInfo() {
        GlyphGroupInfo[] glyphGroupInfoArray = this.ggis;
        this.ggis = this.newGGIS;
        this.newGGIS = glyphGroupInfoArray;
        this.size = this.newSize;
        this.newSize = 0;
    }

    protected void mergeGlyphGroups(WordInfo wordInfo) {
        int n = wordInfo.getNumGlyphGroups();
        this.newSize = 0;
        if (this.ggis == null) {
            this.newSize = n;
            this.newGGIS = new GlyphGroupInfo[n];
            for (int i = 0; i < n; ++i) {
                this.newGGIS[i] = wordInfo.getGlyphGroup(i);
            }
        } else {
            int n2 = 0;
            int n3 = 0;
            GlyphGroupInfo glyphGroupInfo = wordInfo.getGlyphGroup(n3);
            int n4 = glyphGroupInfo.getStart();
            GlyphGroupInfo glyphGroupInfo2 = this.ggis[this.size - 1];
            int n5 = glyphGroupInfo2.getStart();
            this.newGGIS = LineInfo.assureSize(this.newGGIS, this.size + n);
            if (n4 < n5) {
                glyphGroupInfo2 = this.ggis[n2];
                n5 = glyphGroupInfo2.getStart();
                while (n2 < this.size && n3 < n) {
                    if (n4 < n5) {
                        this.newGGIS[this.newSize++] = glyphGroupInfo;
                        if (++n3 >= n) continue;
                        glyphGroupInfo = wordInfo.getGlyphGroup(n3);
                        n4 = glyphGroupInfo.getStart();
                        continue;
                    }
                    this.newGGIS[this.newSize++] = glyphGroupInfo2;
                    if (++n2 >= this.size) continue;
                    glyphGroupInfo2 = this.ggis[n2];
                    n5 = glyphGroupInfo2.getStart();
                }
            }
            while (n2 < this.size) {
                this.newGGIS[this.newSize++] = this.ggis[n2++];
            }
            while (n3 < n) {
                this.newGGIS[this.newSize++] = wordInfo.getGlyphGroup(n3++);
            }
        }
    }

    public void layout() {
        int n;
        int n2;
        if (this.size == 0) {
            return;
        }
        this.assignGlyphGroupRanges(this.size, this.ggis);
        GVTGlyphVector gVTGlyphVector = this.ggis[0].getGlyphVector();
        boolean bl = false;
        double d2 = 0.0;
        double d3 = 0.0;
        int[] nArray = new int[this.numRanges];
        int[] nArray2 = new int[this.numRanges];
        GlyphGroupInfo[] glyphGroupInfoArray = new GlyphGroupInfo[this.numRanges];
        GlyphGroupInfo glyphGroupInfo = this.ggis[0];
        int n3 = n2 = glyphGroupInfo.getRange();
        nArray[n3] = nArray[n3] + 1;
        int n4 = n2;
        nArray2[n4] = nArray2[n4] + glyphGroupInfo.getGlyphCount();
        for (n = 1; n < this.size; ++n) {
            glyphGroupInfo = this.ggis[n];
            n2 = glyphGroupInfo.getRange();
            if (glyphGroupInfoArray[n2] == null || !glyphGroupInfoArray[n2].getHideLast()) {
                int n5 = n2;
                nArray[n5] = nArray[n5] + 1;
            }
            glyphGroupInfoArray[n2] = glyphGroupInfo;
            int n6 = n2;
            nArray2[n6] = nArray2[n6] + glyphGroupInfo.getGlyphCount();
            GlyphGroupInfo glyphGroupInfo2 = this.ggis[n - 1];
            int n7 = glyphGroupInfo2.getRange();
            if (n2 == n7) continue;
            int n8 = n7;
            nArray2[n8] = nArray2[n8] + (glyphGroupInfo2.getLastGlyphCount() - glyphGroupInfo2.getGlyphCount());
        }
        int n9 = n2;
        nArray2[n9] = nArray2[n9] + (glyphGroupInfo.getLastGlyphCount() - glyphGroupInfo.getGlyphCount());
        n = -1;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        n2 = -1;
        glyphGroupInfo = null;
        for (int i = 0; i < this.size; ++i) {
            int n10;
            block20: {
                GlyphGroupInfo glyphGroupInfo3;
                block19: {
                    glyphGroupInfo3 = glyphGroupInfo;
                    int n11 = n;
                    glyphGroupInfo = this.ggis[i];
                    n = glyphGroupInfo.getRange();
                    if (n == n11) break block19;
                    d4 = this.ranges[2 * n];
                    d5 = this.ranges[2 * n + 1] - d4;
                    d6 = this.rangeAdv[n];
                    n10 = this.bi.getTextAlignment();
                    if (this.paraEnd && n10 == 3) {
                        n10 = 0;
                    }
                    switch (n10) {
                        default: {
                            double d7 = d5 - d6;
                            if (!bl) {
                                int n12 = nArray[n] - 1;
                                if (n12 >= 1) {
                                    d2 = d7 / (double)n12;
                                    break;
                                }
                            } else {
                                int n13 = nArray2[n] - 1;
                                if (n13 >= 1) {
                                    d3 = d7 / (double)n13;
                                    break;
                                }
                            }
                            break block20;
                        }
                        case 0: {
                            break;
                        }
                        case 1: {
                            d4 += (d5 - d6) / 2.0;
                            break;
                        }
                        case 2: {
                            d4 += d5 - d6;
                            break;
                        }
                    }
                    break block20;
                }
                if (glyphGroupInfo3 != null && glyphGroupInfo3.getHideLast()) {
                    gVTGlyphVector.setGlyphVisible(glyphGroupInfo3.getEnd(), false);
                }
            }
            n10 = glyphGroupInfo.getStart();
            int n14 = glyphGroupInfo.getEnd();
            boolean[] blArray = glyphGroupInfo.getHide();
            Point2D point2D = gVTGlyphVector.getGlyphPosition(n10);
            double d8 = point2D.getX();
            double d9 = 0.0;
            for (int j = n10; j <= n14; ++j) {
                Point2D point2D2 = gVTGlyphVector.getGlyphPosition(j + 1);
                if (blArray[j - n10]) {
                    gVTGlyphVector.setGlyphVisible(j, false);
                    d9 += point2D2.getX() - point2D.getX();
                } else {
                    gVTGlyphVector.setGlyphVisible(j, true);
                }
                point2D.setLocation(point2D.getX() - d8 - d9 + d4, point2D.getY() + this.baseline);
                gVTGlyphVector.setGlyphPosition(j, point2D);
                point2D = point2D2;
                d9 -= d3;
            }
            if (glyphGroupInfo.getHideLast()) {
                d4 += (double)glyphGroupInfo.getAdvance() - d9;
                continue;
            }
            d4 += (double)glyphGroupInfo.getAdvance() - d9 + d2;
        }
    }

    public static GlyphGroupInfo[] assureSize(GlyphGroupInfo[] glyphGroupInfoArray, int n) {
        if (glyphGroupInfoArray == null) {
            if (n < 10) {
                n = 10;
            }
            return new GlyphGroupInfo[n];
        }
        if (n <= glyphGroupInfoArray.length) {
            return glyphGroupInfoArray;
        }
        int n2 = glyphGroupInfoArray.length * 2;
        if (n2 < n) {
            n2 = n;
        }
        return new GlyphGroupInfo[n2];
    }
}

