/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.extension.svg;

import java.awt.font.TextAttribute;
import java.awt.geom.Point2D;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.batik.bridge.Bridge;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.BridgeException;
import org.apache.batik.bridge.CSSUtilities;
import org.apache.batik.bridge.SVGAElementBridge;
import org.apache.batik.bridge.SVGTextElementBridge;
import org.apache.batik.bridge.SVGUtilities;
import org.apache.batik.bridge.TextUtilities;
import org.apache.batik.bridge.UnitProcessor;
import org.apache.batik.bridge.UserAgent;
import org.apache.batik.dom.util.XLinkSupport;
import org.apache.batik.dom.util.XMLSupport;
import org.apache.batik.extension.svg.BatikExtConstants;
import org.apache.batik.extension.svg.FlowExtTextNode;
import org.apache.batik.extension.svg.MarginInfo;
import org.apache.batik.extension.svg.RegionInfo;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.gvt.TextNode;
import org.apache.batik.gvt.text.GVTAttributedCharacterIterator;
import org.apache.batik.gvt.text.TextPaintInfo;
import org.apache.batik.gvt.text.TextPath;
import org.apache.batik.parser.UnitProcessor;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.events.EventTarget;

public class BatikFlowTextElementBridge
extends SVGTextElementBridge
implements BatikExtConstants {
    public static final AttributedCharacterIterator.Attribute FLOW_PARAGRAPH = GVTAttributedCharacterIterator.TextAttribute.FLOW_PARAGRAPH;
    public static final AttributedCharacterIterator.Attribute FLOW_EMPTY_PARAGRAPH = GVTAttributedCharacterIterator.TextAttribute.FLOW_EMPTY_PARAGRAPH;
    public static final AttributedCharacterIterator.Attribute FLOW_LINE_BREAK = GVTAttributedCharacterIterator.TextAttribute.FLOW_LINE_BREAK;
    public static final AttributedCharacterIterator.Attribute FLOW_REGIONS = GVTAttributedCharacterIterator.TextAttribute.FLOW_REGIONS;
    public static final AttributedCharacterIterator.Attribute PREFORMATTED = GVTAttributedCharacterIterator.TextAttribute.PREFORMATTED;
    protected static final GVTAttributedCharacterIterator.TextAttribute TEXTPATH = GVTAttributedCharacterIterator.TextAttribute.TEXTPATH;
    protected static final GVTAttributedCharacterIterator.TextAttribute ANCHOR_TYPE = GVTAttributedCharacterIterator.TextAttribute.ANCHOR_TYPE;
    protected static final GVTAttributedCharacterIterator.TextAttribute LETTER_SPACING = GVTAttributedCharacterIterator.TextAttribute.LETTER_SPACING;
    protected static final GVTAttributedCharacterIterator.TextAttribute WORD_SPACING = GVTAttributedCharacterIterator.TextAttribute.WORD_SPACING;
    protected static final GVTAttributedCharacterIterator.TextAttribute KERNING = GVTAttributedCharacterIterator.TextAttribute.KERNING;

    public String getNamespaceURI() {
        return "http://xml.apache.org/batik/ext";
    }

    public String getLocalName() {
        return "flowText";
    }

    public Bridge getInstance() {
        return new BatikFlowTextElementBridge();
    }

    public boolean isComposite() {
        return false;
    }

    protected GraphicsNode instantiateGraphicsNode() {
        return new FlowExtTextNode();
    }

    protected Point2D getLocation(BridgeContext bridgeContext, Element element) {
        return new Point2D.Float(0.0f, 0.0f);
    }

    protected AttributedString buildAttributedString(BridgeContext bridgeContext, Element element) {
        List list = this.getRegions(bridgeContext, element);
        AttributedString attributedString = this.getFlowDiv(bridgeContext, element);
        attributedString.addAttribute(FLOW_REGIONS, list, 0, 1);
        return attributedString;
    }

    protected void addGlyphPositionAttributes(AttributedString attributedString, Element element, BridgeContext bridgeContext) {
        if (element.getNodeType() != 1) {
            return;
        }
        String string = element.getNamespaceURI();
        if (!string.equals(this.getNamespaceURI()) && !string.equals("http://www.w3.org/2000/svg")) {
            return;
        }
        if (element.getLocalName() != "flowText") {
            super.addGlyphPositionAttributes(attributedString, element, bridgeContext);
            return;
        }
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            Element element2;
            String string2;
            if (node.getNodeType() != 1) continue;
            String string3 = node.getNamespaceURI();
            if (!this.getNamespaceURI().equals(string3) && !"http://www.w3.org/2000/svg".equals(string3) || !(string2 = (element2 = (Element)node).getLocalName()).equals("flowDiv")) continue;
            super.addGlyphPositionAttributes(attributedString, element2, bridgeContext);
            return;
        }
    }

    protected void addChildGlyphPositionAttributes(AttributedString attributedString, Element element, BridgeContext bridgeContext) {
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            String string;
            if (node.getNodeType() != 1) continue;
            String string2 = node.getNamespaceURI();
            if (!this.getNamespaceURI().equals(string2) && !"http://www.w3.org/2000/svg".equals(string2) || !(string = node.getLocalName()).equals("flowPara") && !string.equals("flowRegionBreak") && !string.equals("flowLine") && !string.equals("flowSpan") && !string.equals("a") && !string.equals("tref")) continue;
            this.addGlyphPositionAttributes(attributedString, (Element)node, bridgeContext);
        }
    }

    protected void addNullPaintAttributes(AttributedString attributedString, Element element, BridgeContext bridgeContext) {
        if (element.getNodeType() != 1) {
            return;
        }
        String string = element.getNamespaceURI();
        if (!string.equals(this.getNamespaceURI()) && !string.equals("http://www.w3.org/2000/svg")) {
            return;
        }
        if (element.getLocalName() != "flowText") {
            super.addNullPaintAttributes(attributedString, element, bridgeContext);
            return;
        }
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            Element element2;
            String string2;
            if (node.getNodeType() != 1 || !this.getNamespaceURI().equals(node.getNamespaceURI()) || !(string2 = (element2 = (Element)node).getLocalName()).equals("flowDiv")) continue;
            super.addNullPaintAttributes(attributedString, element2, bridgeContext);
            return;
        }
    }

    protected void addChildNullPaintAttributes(AttributedString attributedString, Element element, BridgeContext bridgeContext) {
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            String string;
            if (node.getNodeType() != 1) continue;
            String string2 = node.getNamespaceURI();
            if (!this.getNamespaceURI().equals(string2) && !"http://www.w3.org/2000/svg".equals(string2) || !(string = node.getLocalName()).equals("flowPara") && !string.equals("flowRegionBreak") && !string.equals("flowLine") && !string.equals("flowSpan") && !string.equals("a") && !string.equals("tref")) continue;
            Element element2 = (Element)node;
            this.addNullPaintAttributes(attributedString, element2, bridgeContext);
        }
    }

    protected void addPaintAttributes(AttributedString attributedString, Element element, TextNode textNode, TextPaintInfo textPaintInfo, BridgeContext bridgeContext) {
        if (element.getNodeType() != 1) {
            return;
        }
        String string = element.getNamespaceURI();
        if (!string.equals(this.getNamespaceURI()) && !string.equals("http://www.w3.org/2000/svg")) {
            return;
        }
        if (element.getLocalName() != "flowText") {
            super.addPaintAttributes(attributedString, element, textNode, textPaintInfo, bridgeContext);
            return;
        }
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            Element element2;
            String string2;
            if (node.getNodeType() != 1 || !this.getNamespaceURI().equals(node.getNamespaceURI()) || !(string2 = (element2 = (Element)node).getLocalName()).equals("flowDiv")) continue;
            super.addPaintAttributes(attributedString, element2, textNode, textPaintInfo, bridgeContext);
            return;
        }
    }

    protected void addChildPaintAttributes(AttributedString attributedString, Element element, TextNode textNode, TextPaintInfo textPaintInfo, BridgeContext bridgeContext) {
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            String string;
            if (node.getNodeType() != 1) continue;
            String string2 = node.getNamespaceURI();
            if (!this.getNamespaceURI().equals(string2) && !"http://www.w3.org/2000/svg".equals(string2) || !(string = node.getLocalName()).equals("flowPara") && !string.equals("flowRegionBreak") && !string.equals("flowLine") && !string.equals("flowSpan") && !string.equals("a") && !string.equals("tref")) continue;
            Element element2 = (Element)node;
            TextPaintInfo textPaintInfo2 = this.getTextPaintInfo(element2, textNode, textPaintInfo, bridgeContext);
            this.addPaintAttributes(attributedString, element2, textNode, textPaintInfo2, bridgeContext);
        }
    }

    protected AttributedString getFlowDiv(BridgeContext bridgeContext, Element element) {
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1 || !this.getNamespaceURI().equals(node.getNamespaceURI())) continue;
            Element element2 = (Element)node;
            String string = node.getLocalName();
            if (!string.equals("flowDiv")) continue;
            return this.gatherFlowPara(bridgeContext, element2);
        }
        return null;
    }

    protected AttributedString gatherFlowPara(BridgeContext bridgeContext, Element element) {
        int n;
        Object object;
        Object object2;
        SVGTextElementBridge.AttributedStringBuffer attributedStringBuffer = new SVGTextElementBridge.AttributedStringBuffer();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        ArrayList<Element> arrayList2 = new ArrayList<Element>();
        ArrayList arrayList3 = new ArrayList();
        for (object2 = element.getFirstChild(); object2 != null; object2 = object2.getNextSibling()) {
            if (object2.getNodeType() != 1 || !this.getNamespaceURI().equals(object2.getNamespaceURI())) continue;
            Element element2 = (Element)object2;
            object = element2.getLocalName();
            if (((String)object).equals("flowPara")) {
                this.fillAttributedStringBuffer(bridgeContext, element2, true, null, attributedStringBuffer, arrayList3);
                arrayList2.add(element2);
                arrayList.add(new Integer(attributedStringBuffer.length()));
                continue;
            }
            if (!((String)object).equals("flowRegionBreak")) continue;
            this.fillAttributedStringBuffer(bridgeContext, element2, true, null, attributedStringBuffer, arrayList3);
            arrayList2.add(element2);
            arrayList.add(new Integer(attributedStringBuffer.length()));
        }
        object2 = attributedStringBuffer.toAttributedString();
        int n2 = 0;
        object = arrayList3.iterator();
        while (object.hasNext()) {
            n = (Integer)object.next();
            if (n == n2) continue;
            ((AttributedString)object2).addAttribute(FLOW_LINE_BREAK, new Object(), n2, n);
            n2 = n;
        }
        n = 0;
        LinkedList<MarginInfo> linkedList = null;
        for (int i = 0; i < arrayList2.size(); ++i) {
            Element element3 = (Element)arrayList2.get(i);
            int n3 = (Integer)arrayList.get(i);
            if (n == n3) {
                if (linkedList == null) {
                    linkedList = new LinkedList<MarginInfo>();
                }
                linkedList.add(this.makeMarginInfo(element3));
            } else {
                ((AttributedString)object2).addAttribute(FLOW_PARAGRAPH, this.makeMarginInfo(element3), n, n3);
                if (linkedList != null) {
                    ((AttributedString)object2).addAttribute(FLOW_EMPTY_PARAGRAPH, linkedList, n, n3);
                    linkedList = null;
                }
            }
            n = n3;
        }
        return object2;
    }

    protected List getRegions(BridgeContext bridgeContext, Element element) {
        LinkedList linkedList = new LinkedList();
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            Element element2;
            String string;
            if (node.getNodeType() != 1 || !this.getNamespaceURI().equals(node.getNamespaceURI()) || !"flowRegion".equals(string = (element2 = (Element)node).getLocalName())) continue;
            float f2 = 0.0f;
            String string2 = element2.getAttribute("vertical-align");
            if (string2 != null && string2.length() > 0) {
                if ("top".equals(string2)) {
                    f2 = 0.0f;
                } else if ("middle".equals(string2)) {
                    f2 = 0.5f;
                } else if ("bottom".equals(string2)) {
                    f2 = 1.0f;
                }
            }
            this.gatherRegionInfo(bridgeContext, element2, f2, linkedList);
        }
        return linkedList;
    }

    protected void gatherRegionInfo(BridgeContext bridgeContext, Element element, float f2, List list) {
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            UnitProcessor.Context context;
            RegionInfo regionInfo;
            if (node.getNodeType() != 1 || !this.getNamespaceURI().equals(node.getNamespaceURI())) continue;
            Element element2 = (Element)node;
            String string = node.getLocalName();
            if (!string.equals("rect") || (regionInfo = this.buildRegion(context = UnitProcessor.createContext(bridgeContext, element2), element2, f2)) == null) continue;
            list.add(regionInfo);
        }
    }

    protected RegionInfo buildRegion(UnitProcessor.Context context, Element element, float f2) {
        String string = element.getAttribute("x");
        float f3 = 0.0f;
        if (string.length() != 0) {
            f3 = UnitProcessor.svgHorizontalCoordinateToUserSpace(string, "x", context);
        }
        string = element.getAttribute("y");
        float f4 = 0.0f;
        if (string.length() != 0) {
            f4 = UnitProcessor.svgVerticalCoordinateToUserSpace(string, "y", context);
        }
        if ((string = element.getAttribute("width")).length() == 0) {
            throw new BridgeException(element, "attribute.missing", new Object[]{"width", string});
        }
        float f5 = UnitProcessor.svgHorizontalLengthToUserSpace(string, "width", context);
        if (f5 == 0.0f) {
            return null;
        }
        string = element.getAttribute("height");
        if (string.length() == 0) {
            throw new BridgeException(element, "attribute.missing", new Object[]{"height", string});
        }
        float f6 = UnitProcessor.svgVerticalLengthToUserSpace(string, "height", context);
        if (f6 == 0.0f) {
            return null;
        }
        return new RegionInfo(f3, f4, f5, f6, f2);
    }

    protected void fillAttributedStringBuffer(BridgeContext bridgeContext, Element element, boolean bl, Integer n, SVGTextElementBridge.AttributedStringBuffer attributedStringBuffer, List list) {
        if (!SVGUtilities.matchUserAgent(element, bridgeContext.getUserAgent()) || !CSSUtilities.convertDisplay(element)) {
            return;
        }
        String string = XMLSupport.getXMLSpace(element);
        boolean bl2 = string.equals("preserve");
        Element element2 = element;
        if (bl) {
            this.endLimit = 0;
        }
        if (bl2) {
            this.endLimit = attributedStringBuffer.length();
        }
        Map map = this.getAttributeMap(bridgeContext, element, null, n);
        Object v = map.get(TextAttribute.BIDI_EMBEDDING);
        Integer n2 = n;
        if (v != null) {
            n2 = (Integer)v;
        }
        block4: for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            boolean bl3 = bl2 ? false : (attributedStringBuffer.length() == 0 ? true : attributedStringBuffer.getLastChar() == 32);
            switch (node.getNodeType()) {
                case 1: {
                    Object object;
                    Object object2;
                    if (!this.getNamespaceURI().equals(node.getNamespaceURI()) && !"http://www.w3.org/2000/svg".equals(node.getNamespaceURI())) continue block4;
                    element2 = (Element)node;
                    String string2 = node.getLocalName();
                    if (string2.equals("flowLine")) {
                        this.fillAttributedStringBuffer(bridgeContext, element2, false, n2, attributedStringBuffer, list);
                        list.add(new Integer(attributedStringBuffer.length()));
                        continue block4;
                    }
                    if (string2.equals("flowSpan") || string2.equals("altGlyph")) {
                        this.fillAttributedStringBuffer(bridgeContext, element2, false, n2, attributedStringBuffer, list);
                        continue block4;
                    }
                    if (string2.equals("a")) {
                        if (bridgeContext.isInteractive()) {
                            object2 = (EventTarget)((Object)element2);
                            object = bridgeContext.getUserAgent();
                            object2.addEventListener("click", new SVGAElementBridge.AnchorListener((UserAgent)object), false);
                            object2.addEventListener("mouseover", new SVGAElementBridge.CursorMouseOverListener((UserAgent)object), false);
                            object2.addEventListener("mouseout", new SVGAElementBridge.CursorMouseOutListener((UserAgent)object), false);
                        }
                        this.fillAttributedStringBuffer(bridgeContext, element2, false, n2, attributedStringBuffer, list);
                        continue block4;
                    }
                    if (!string2.equals("tref")) continue block4;
                    object2 = XLinkSupport.getXLinkHref((Element)node);
                    object = bridgeContext.getReferencedElement((Element)node, (String)object2);
                    string = TextUtilities.getElementContent((Element)object);
                    if ((string = this.normalizeString(string, bl2, bl3)) == null) continue block4;
                    Map map2 = this.getAttributeMap(bridgeContext, element2, null, n);
                    attributedStringBuffer.append(string, map2);
                    continue block4;
                }
                case 3: 
                case 4: {
                    string = node.getNodeValue();
                    string = this.normalizeString(string, bl2, bl3);
                    attributedStringBuffer.append(string, map);
                    if (!bl2) continue block4;
                    this.endLimit = attributedStringBuffer.length();
                }
            }
        }
        if (bl) {
            while (this.endLimit < attributedStringBuffer.length() && attributedStringBuffer.getLastChar() == 32) {
                attributedStringBuffer.stripLast();
            }
        }
    }

    protected Map getAttributeMap(BridgeContext bridgeContext, Element element, TextPath textPath, Integer n) {
        Map map = super.getAttributeMap(bridgeContext, element, textPath, n);
        String string = element.getAttribute("preformatted");
        if (string.length() != 0 && string.equals("true")) {
            map.put(PREFORMATTED, Boolean.TRUE);
        }
        return map;
    }

    protected void checkMap(Map map) {
        if (map.containsKey(TEXTPATH)) {
            return;
        }
        if (map.containsKey(ANCHOR_TYPE)) {
            return;
        }
        if (map.containsKey(LETTER_SPACING)) {
            return;
        }
        if (map.containsKey(WORD_SPACING)) {
            return;
        }
        if (map.containsKey(KERNING)) {
            return;
        }
    }

    public MarginInfo makeMarginInfo(Element element) {
        float f2;
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = 0.0f;
        float f6 = 0.0f;
        String string = element.getAttribute("margin");
        try {
            if (string.length() != 0) {
                f5 = f6 = (f2 = Float.parseFloat(string));
                f4 = f6;
                f3 = f6;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        string = element.getAttribute("top-margin");
        try {
            if (string.length() != 0) {
                f3 = f2 = Float.parseFloat(string);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        string = element.getAttribute("right-margin");
        try {
            if (string.length() != 0) {
                float f7;
                f4 = f7 = Float.parseFloat(string);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        string = element.getAttribute("bottom-margin");
        try {
            if (string.length() != 0) {
                float f8;
                f5 = f8 = Float.parseFloat(string);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        string = element.getAttribute("left-margin");
        try {
            if (string.length() != 0) {
                float f9;
                f6 = f9 = Float.parseFloat(string);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        float f10 = 0.0f;
        string = element.getAttribute("indent");
        try {
            if (string.length() != 0) {
                float f11;
                f10 = f11 = Float.parseFloat(string);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        int n = 0;
        string = element.getAttribute("justification");
        try {
            if (string.length() != 0) {
                if ("start".equals(string)) {
                    n = 0;
                } else if ("middle".equals(string)) {
                    n = 1;
                } else if ("end".equals(string)) {
                    n = 2;
                } else if ("full".equals(string)) {
                    n = 3;
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        String string2 = element.getLocalName();
        boolean bl = string2.equals("flowRegionBreak");
        return new MarginInfo(f3, f4, f5, f6, f10, n, bl);
    }

    public static class LineBreakInfo {
        int breakIdx;
        float lineAdvAdj;
        boolean relative;

        public LineBreakInfo(int n, float f2, boolean bl) {
            this.breakIdx = n;
            this.lineAdvAdj = f2;
            this.relative = bl;
        }

        public int getBreakIdx() {
            return this.breakIdx;
        }

        public boolean isRelative() {
            return this.relative;
        }

        public float getLineAdvAdj() {
            return this.lineAdvAdj;
        }
    }
}

