/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.image.spi;

import java.awt.image.renderable.RenderableImage;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StreamCorruptedException;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.apache.batik.ext.awt.color.ICCColorSpaceExt;
import org.apache.batik.ext.awt.image.URLImageCache;
import org.apache.batik.ext.awt.image.renderable.Filter;
import org.apache.batik.ext.awt.image.renderable.ProfileRable;
import org.apache.batik.ext.awt.image.spi.BrokenLinkProvider;
import org.apache.batik.ext.awt.image.spi.DefaultBrokenLinkProvider;
import org.apache.batik.ext.awt.image.spi.ErrorConstants;
import org.apache.batik.ext.awt.image.spi.JDKRegistryEntry;
import org.apache.batik.ext.awt.image.spi.JPEGRegistryEntry;
import org.apache.batik.ext.awt.image.spi.PNGRegistryEntry;
import org.apache.batik.ext.awt.image.spi.RegistryEntry;
import org.apache.batik.ext.awt.image.spi.StreamRegistryEntry;
import org.apache.batik.ext.awt.image.spi.TIFFRegistryEntry;
import org.apache.batik.ext.awt.image.spi.URLRegistryEntry;
import org.apache.batik.util.ParsedURL;
import org.apache.batik.util.Service;

public class ImageTagRegistry
implements ErrorConstants {
    List entries = new LinkedList();
    List extensions = null;
    List mimeTypes = null;
    URLImageCache rawCache;
    URLImageCache imgCache;
    static ImageTagRegistry registry = null;
    static BrokenLinkProvider defaultProvider = new DefaultBrokenLinkProvider();
    static BrokenLinkProvider brokenLinkProvider = null;

    public ImageTagRegistry() {
        this(null, null);
    }

    public ImageTagRegistry(URLImageCache uRLImageCache, URLImageCache uRLImageCache2) {
        if (uRLImageCache == null) {
            uRLImageCache = new URLImageCache();
        }
        if (uRLImageCache2 == null) {
            uRLImageCache2 = new URLImageCache();
        }
        this.rawCache = uRLImageCache;
        this.imgCache = uRLImageCache2;
    }

    public void flushCache() {
        this.rawCache.flush();
        this.imgCache.flush();
    }

    public Filter checkCache(ParsedURL parsedURL, ICCColorSpaceExt iCCColorSpaceExt) {
        boolean bl = iCCColorSpaceExt != null;
        Filter filter = null;
        URLImageCache uRLImageCache = bl ? this.rawCache : this.imgCache;
        filter = uRLImageCache.request(parsedURL);
        if (filter == null) {
            uRLImageCache.clear(parsedURL);
            return null;
        }
        if (iCCColorSpaceExt != null) {
            filter = new ProfileRable(filter, iCCColorSpaceExt);
        }
        return filter;
    }

    public Filter readURL(ParsedURL parsedURL) {
        return this.readURL(null, parsedURL, null, true, true);
    }

    public Filter readURL(ParsedURL parsedURL, ICCColorSpaceExt iCCColorSpaceExt) {
        return this.readURL(null, parsedURL, iCCColorSpaceExt, true, true);
    }

    public Filter readURL(InputStream inputStream, ParsedURL parsedURL, ICCColorSpaceExt iCCColorSpaceExt, boolean bl, boolean bl2) {
        if (inputStream != null && !inputStream.markSupported()) {
            inputStream = new BufferedInputStream(inputStream);
        }
        boolean bl3 = iCCColorSpaceExt != null;
        Filter filter = null;
        URLImageCache uRLImageCache = null;
        if (parsedURL != null && (filter = (uRLImageCache = bl3 ? this.rawCache : this.imgCache).request(parsedURL)) != null) {
            if (iCCColorSpaceExt != null) {
                filter = new ProfileRable(filter, iCCColorSpaceExt);
            }
            return filter;
        }
        boolean bl4 = false;
        List list = this.getRegisteredMimeTypes();
        Iterator iterator = this.entries.iterator();
        while (iterator.hasNext()) {
            RegistryEntry registryEntry;
            RegistryEntry registryEntry2 = (RegistryEntry)iterator.next();
            if (registryEntry2 instanceof URLRegistryEntry) {
                if (parsedURL == null || !bl || !(registryEntry = (URLRegistryEntry)registryEntry2).isCompatibleURL(parsedURL) || (filter = registryEntry.handleURL(parsedURL, bl3)) == null) continue;
                break;
            }
            if (!(registryEntry2 instanceof StreamRegistryEntry)) continue;
            registryEntry = (StreamRegistryEntry)registryEntry2;
            if (bl4) continue;
            try {
                if (inputStream == null) {
                    if (parsedURL == null || !bl) break;
                    try {
                        inputStream = parsedURL.openStream(list.iterator());
                    }
                    catch (IOException iOException) {
                        bl4 = true;
                        continue;
                    }
                    if (!inputStream.markSupported()) {
                        inputStream = new BufferedInputStream(inputStream);
                    }
                }
                if (!registryEntry.isCompatibleStream(inputStream) || (filter = registryEntry.handleStream(inputStream, parsedURL, bl3)) == null) continue;
                break;
            }
            catch (StreamCorruptedException streamCorruptedException) {
                inputStream = null;
            }
        }
        if (uRLImageCache != null) {
            uRLImageCache.put(parsedURL, filter);
        }
        if (filter == null) {
            if (!bl2) {
                return null;
            }
            if (bl4) {
                return ImageTagRegistry.getBrokenLinkImage(this, "url.unreachable", new Object[]{parsedURL});
            }
            return ImageTagRegistry.getBrokenLinkImage(this, "url.uninterpretable", new Object[]{parsedURL});
        }
        if (filter.getProperty("org.apache.batik.BrokenLinkImage") != null) {
            return bl2 ? filter : null;
        }
        if (iCCColorSpaceExt != null) {
            filter = new ProfileRable(filter, iCCColorSpaceExt);
        }
        return filter;
    }

    public Filter readStream(InputStream inputStream) {
        return this.readStream(inputStream, null);
    }

    public Filter readStream(InputStream inputStream, ICCColorSpaceExt iCCColorSpaceExt) {
        if (!inputStream.markSupported()) {
            inputStream = new BufferedInputStream(inputStream);
        }
        boolean bl = iCCColorSpaceExt != null;
        RenderableImage renderableImage = null;
        Iterator iterator = this.entries.iterator();
        while (iterator.hasNext()) {
            RegistryEntry registryEntry = (RegistryEntry)iterator.next();
            if (!(registryEntry instanceof StreamRegistryEntry)) continue;
            StreamRegistryEntry streamRegistryEntry = (StreamRegistryEntry)registryEntry;
            try {
                if (!streamRegistryEntry.isCompatibleStream(inputStream) || (renderableImage = streamRegistryEntry.handleStream(inputStream, null, bl)) == null) continue;
                break;
            }
            catch (StreamCorruptedException streamCorruptedException) {
                // empty catch block
                break;
            }
        }
        if (renderableImage == null) {
            return ImageTagRegistry.getBrokenLinkImage(this, "stream.unreadable", null);
        }
        if (iCCColorSpaceExt != null && renderableImage.getProperty("org.apache.batik.BrokenLinkImage") == null) {
            renderableImage = new ProfileRable((Filter)renderableImage, iCCColorSpaceExt);
        }
        return renderableImage;
    }

    public synchronized void register(RegistryEntry registryEntry) {
        float f2 = registryEntry.getPriority();
        ListIterator<RegistryEntry> listIterator = this.entries.listIterator();
        while (listIterator.hasNext()) {
            RegistryEntry registryEntry2 = (RegistryEntry)listIterator.next();
            if (!(registryEntry2.getPriority() > f2)) continue;
            listIterator.previous();
            listIterator.add(registryEntry);
            return;
        }
        listIterator.add(registryEntry);
        this.extensions = null;
        this.mimeTypes = null;
    }

    public synchronized List getRegisteredExtensions() {
        if (this.extensions != null) {
            return this.extensions;
        }
        this.extensions = new LinkedList();
        Iterator iterator = this.entries.iterator();
        while (iterator.hasNext()) {
            RegistryEntry registryEntry = (RegistryEntry)iterator.next();
            this.extensions.addAll(registryEntry.getStandardExtensions());
        }
        this.extensions = Collections.unmodifiableList(this.extensions);
        return this.extensions;
    }

    public synchronized List getRegisteredMimeTypes() {
        if (this.mimeTypes != null) {
            return this.mimeTypes;
        }
        this.mimeTypes = new LinkedList();
        Iterator iterator = this.entries.iterator();
        while (iterator.hasNext()) {
            RegistryEntry registryEntry = (RegistryEntry)iterator.next();
            this.mimeTypes.addAll(registryEntry.getMimeTypes());
        }
        this.mimeTypes = Collections.unmodifiableList(this.mimeTypes);
        return this.mimeTypes;
    }

    public static synchronized ImageTagRegistry getRegistry() {
        if (registry != null) {
            return registry;
        }
        registry = new ImageTagRegistry();
        registry.register(new PNGRegistryEntry());
        registry.register(new TIFFRegistryEntry());
        registry.register(new JPEGRegistryEntry());
        registry.register(new JDKRegistryEntry());
        Iterator iterator = Service.providers(RegistryEntry.class);
        while (iterator.hasNext()) {
            RegistryEntry registryEntry = (RegistryEntry)iterator.next();
            registry.register(registryEntry);
        }
        return registry;
    }

    public static synchronized Filter getBrokenLinkImage(Object object, String string, Object[] objectArray) {
        Filter filter = null;
        if (brokenLinkProvider != null) {
            filter = brokenLinkProvider.getBrokenLinkImage(object, string, objectArray);
        }
        if (filter == null) {
            filter = defaultProvider.getBrokenLinkImage(object, string, objectArray);
        }
        return filter;
    }

    public static synchronized void setBrokenLinkProvider(BrokenLinkProvider brokenLinkProvider) {
        ImageTagRegistry.brokenLinkProvider = brokenLinkProvider;
    }
}

