/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.image.rendered;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.util.Iterator;
import java.util.Vector;
import org.apache.batik.ext.awt.image.GraphicsUtil;

public class IndexImage {
    public static BufferedImage getIndexedImage(BufferedImage bufferedImage, int n) {
        int n2;
        int n3;
        int n4;
        Object object;
        Object object2;
        int n5;
        int n6;
        int n7 = bufferedImage.getWidth();
        int n8 = bufferedImage.getHeight();
        Vector[] vectorArray = new Vector[4096];
        int n9 = 0;
        for (n6 = 0; n6 < n7; ++n6) {
            block1: for (n5 = 0; n5 < n8; ++n5) {
                n9 = bufferedImage.getRGB(n6, n5) & 0xFFFFFF;
                int n10 = (n9 & 0xF00000) >>> 12 | (n9 & 0xF000) >>> 8 | (n9 & 0xF0) >>> 4;
                object2 = vectorArray[n10];
                if (object2 == null) {
                    object2 = new Vector();
                    ((Vector)object2).add(new Counter(n9));
                    vectorArray[n10] = object2;
                    continue;
                }
                object = ((Vector)object2).iterator();
                while (object.hasNext()) {
                    if (!((Counter)object.next()).add(n9)) continue;
                    continue block1;
                }
                ((Vector)object2).add(new Counter(n9));
            }
        }
        n6 = 1;
        n5 = 0;
        Cube[] cubeArray = new Cube[n];
        cubeArray[0] = new Cube(vectorArray, n7 * n8);
        while (n6 < n) {
            while (cubeArray[n5].isDone() && ++n5 != n6) {
            }
            if (n5 == n6) break;
            object2 = cubeArray[n5];
            object = ((Cube)object2).split();
            if (object == null) continue;
            if (((Cube)object).count > ((Cube)object2).count) {
                Object object3 = object2;
                object2 = object;
                object = object3;
            }
            int n11 = n5;
            n4 = ((Cube)object2).count;
            for (n3 = n5 + 1; n3 < n6 && cubeArray[n3].count >= n4; ++n3) {
                cubeArray[n11++] = cubeArray[n3];
            }
            cubeArray[n11++] = object2;
            n4 = ((Cube)object).count;
            while (n11 < n6 && cubeArray[n11].count >= n4) {
                ++n11;
            }
            for (n3 = n6; n3 > n11; --n3) {
                cubeArray[n3] = cubeArray[n3 - 1];
            }
            cubeArray[n11++] = object;
            ++n6;
        }
        object2 = new byte[n6];
        object = new byte[n6];
        byte[] byArray = new byte[n6];
        for (n4 = 0; n4 < n6; ++n4) {
            n3 = cubeArray[n4].averageColor();
            object2[n4] = (byte)(n3 >> 16 & 0xFF);
            object[n4] = (byte)(n3 >> 8 & 0xFF);
            byArray[n4] = (byte)(n3 & 0xFF);
        }
        IndexColorModel indexColorModel = new IndexColorModel(8, n6, (byte[])object2, (byte[])object, byArray);
        BufferedImage bufferedImage2 = new BufferedImage(n7, n8, 13, indexColorModel);
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
        graphics2D.drawImage((Image)bufferedImage, 0, 0, null);
        graphics2D.dispose();
        for (n2 = 1; n2 <= 8 && 1 << n2 < n6; ++n2) {
        }
        if (n2 > 4) {
            return bufferedImage2;
        }
        if (n2 == 3) {
            n2 = 4;
        }
        IndexColorModel indexColorModel2 = new IndexColorModel(n2, n6, (byte[])object2, (byte[])object, byArray);
        MultiPixelPackedSampleModel multiPixelPackedSampleModel = new MultiPixelPackedSampleModel(0, n7, n8, n2);
        WritableRaster writableRaster = Raster.createWritableRaster(multiPixelPackedSampleModel, new Point(0, 0));
        bufferedImage = bufferedImage2;
        bufferedImage2 = new BufferedImage(indexColorModel2, writableRaster, bufferedImage.isAlphaPremultiplied(), null);
        GraphicsUtil.copyData(bufferedImage, bufferedImage2);
        return bufferedImage2;
    }

    private static class Cube {
        int[] min = new int[]{0, 0, 0};
        int[] max = new int[]{255, 255, 255};
        boolean done = false;
        Vector[] colors = null;
        int count = 0;
        static final int RED = 0;
        static final int GRN = 1;
        static final int BLU = 2;

        public Cube(Vector[] vectorArray, int n) {
            this.colors = vectorArray;
            this.count = n;
        }

        public boolean isDone() {
            return this.done;
        }

        public Cube split() {
            int n;
            int n2;
            int n3;
            int n4 = this.max[0] - this.min[0] + 1;
            int n5 = this.max[1] - this.min[1] + 1;
            int n6 = this.max[2] - this.min[2] + 1;
            if (n4 >= n5) {
                n3 = 1;
                if (n4 >= n6) {
                    n2 = 0;
                    n = 2;
                } else {
                    n2 = 2;
                    n = 0;
                }
            } else if (n5 >= n6) {
                n2 = 1;
                n3 = 0;
                n = 2;
            } else {
                n2 = 2;
                n3 = 0;
                n = 1;
            }
            Cube cube = this.splitChannel(n2, n3, n);
            if (cube != null) {
                return cube;
            }
            cube = this.splitChannel(n3, n2, n);
            if (cube != null) {
                return cube;
            }
            cube = this.splitChannel(n, n2, n3);
            if (cube != null) {
                return cube;
            }
            this.done = true;
            return null;
        }

        public Cube splitChannel(int n, int n2, int n3) {
            int n4;
            int n5;
            int n6;
            int n7;
            int n8;
            if (this.min[n] == this.max[n]) {
                return null;
            }
            int n9 = (2 - n) * 4;
            int n10 = (2 - n2) * 4;
            int n11 = (2 - n3) * 4;
            int n12 = this.count / 2;
            int[] nArray = new int[256];
            int n13 = 0;
            int[] nArray2 = new int[]{this.min[0] >> 4, this.min[1] >> 4, this.min[2] >> 4};
            int[] nArray3 = new int[]{this.max[0] >> 4, this.max[1] >> 4, this.max[2] >> 4};
            int n14 = this.min[0];
            int n15 = this.min[1];
            int n16 = this.min[2];
            int n17 = this.max[0];
            int n18 = this.max[1];
            int n19 = this.max[2];
            int n20 = 0;
            int[] nArray4 = new int[]{0, 0, 0};
            for (n8 = nArray2[n]; n8 <= nArray3[n]; ++n8) {
                n7 = n8 << n9;
                for (n6 = nArray2[n2]; n6 <= nArray3[n2]; ++n6) {
                    n5 = n7 | n6 << n10;
                    for (n4 = nArray2[n3]; n4 <= nArray3[n3]; ++n4) {
                        int n21 = n5 | n4 << n11;
                        Vector vector = this.colors[n21];
                        if (vector == null) continue;
                        Iterator iterator = vector.iterator();
                        while (iterator.hasNext()) {
                            Counter counter = (Counter)iterator.next();
                            n20 = counter.val;
                            nArray4[0] = (n20 & 0xFF0000) >> 16;
                            nArray4[1] = (n20 & 0xFF00) >> 8;
                            nArray4[2] = n20 & 0xFF;
                            if (nArray4[0] < n14 || nArray4[0] > n17 || nArray4[1] < n15 || nArray4[1] > n18 || nArray4[2] < n16 || nArray4[2] > n19) continue;
                            int n22 = nArray4[n];
                            nArray[n22] = nArray[n22] + counter.count;
                            n13 += counter.count;
                        }
                    }
                }
                if (n13 >= n12) break;
            }
            n13 = 0;
            n8 = -1;
            n7 = this.min[n];
            n6 = this.max[n];
            for (n5 = this.min[n]; n5 <= this.max[n]; ++n5) {
                n4 = nArray[n5];
                if (n4 == 0) {
                    if (n13 != 0 || n5 >= this.max[n]) continue;
                    this.min[n] = n5 + 1;
                    continue;
                }
                if (n13 + n4 < n12) {
                    n8 = n5;
                    n13 += n4;
                    continue;
                }
                if (n12 - n13 <= n13 + n4 - n12) {
                    if (n8 == -1) {
                        if (n4 == this.count) {
                            this.max[n] = n5;
                            return null;
                        }
                        n7 = n5;
                        n6 = n5 + 1;
                        break;
                    }
                    n7 = n8;
                    n6 = n5;
                    break;
                }
                if (n5 == this.max[n]) {
                    if (n4 == this.count) {
                        return null;
                    }
                    n7 = n8;
                    n6 = n5;
                    break;
                }
                n13 += n4;
                n7 = n5;
                n6 = n5 + 1;
                break;
            }
            Cube cube = new Cube(this.colors, n13);
            this.count -= n13;
            cube.min[n] = this.min[n];
            cube.max[n] = n7;
            this.min[n] = n6;
            cube.min[n2] = this.min[n2];
            cube.max[n2] = this.max[n2];
            cube.min[n3] = this.min[n3];
            cube.max[n3] = this.max[n3];
            return cube;
        }

        public int averageColor() {
            if (this.count == 0) {
                return 0;
            }
            float f2 = 0.0f;
            float f3 = 0.0f;
            float f4 = 0.0f;
            int n = this.min[0];
            int n2 = this.min[1];
            int n3 = this.min[2];
            int n4 = this.max[0];
            int n5 = this.max[1];
            int n6 = this.max[2];
            int[] nArray = new int[]{n >> 4, n2 >> 4, n3 >> 4};
            int[] nArray2 = new int[]{n4 >> 4, n5 >> 4, n6 >> 4};
            for (int i = nArray[0]; i <= nArray2[0]; ++i) {
                int n7 = i << 8;
                for (int j = nArray[1]; j <= nArray2[1]; ++j) {
                    int n8 = n7 | j << 4;
                    for (int k = nArray[2]; k <= nArray2[2]; ++k) {
                        int n9 = n8 | k;
                        Vector vector = this.colors[n9];
                        if (vector == null) continue;
                        Iterator iterator = vector.iterator();
                        while (iterator.hasNext()) {
                            Counter counter = (Counter)iterator.next();
                            int n10 = counter.val;
                            int n11 = (n10 & 0xFF0000) >> 16;
                            int n12 = (n10 & 0xFF00) >> 8;
                            int n13 = n10 & 0xFF;
                            if (n11 < n || n11 > n4 || n12 < n2 || n12 > n5 || n13 < n3 || n13 > n6) continue;
                            float f5 = (float)counter.count / (float)this.count;
                            f2 += (float)n11 * f5;
                            f3 += (float)n12 * f5;
                            f4 += (float)n13 * f5;
                        }
                    }
                }
            }
            return (int)((double)f2 + 0.5) << 16 | (int)((double)f3 + 0.5) << 8 | (int)((double)f4 + 0.5);
        }
    }

    private static class Counter {
        public int val;
        public int count = 1;

        public Counter(int n) {
            this.val = n;
        }

        public boolean add(int n) {
            if (this.val != n) {
                return false;
            }
            ++this.count;
            return true;
        }
    }
}

