/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.image.rendered;

import java.awt.Rectangle;
import java.awt.image.DataBufferInt;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SinglePixelPackedSampleModel;

public final class BumpMap {
    private RenderedImage texture;
    private double surfaceScale;
    private double surfaceScaleX;
    private double surfaceScaleY;
    private double scaleX;
    private double scaleY;

    public BumpMap(RenderedImage renderedImage, double d2, double d3, double d4) {
        this.texture = renderedImage;
        this.surfaceScaleX = d2 * d3;
        this.surfaceScaleY = d2 * d4;
        this.surfaceScale = d2;
        this.scaleX = d3;
        this.scaleY = d4;
    }

    public final double getSurfaceScale() {
        return this.surfaceScale;
    }

    public final double[][][] getNormalArray(int n, int n2, int n3, int n4) {
        double d2;
        double[] dArray;
        int n5;
        int n6;
        double[][] dArray2;
        double[][][] dArray3 = new double[n4][n3][4];
        Rectangle rectangle = new Rectangle(n - 1, n2 - 1, n3 + 2, n4 + 2);
        Rectangle rectangle2 = new Rectangle(this.texture.getMinX(), this.texture.getMinY(), this.texture.getWidth(), this.texture.getHeight());
        if (!rectangle.intersects(rectangle2)) {
            return dArray3;
        }
        rectangle = rectangle.intersection(rectangle2);
        Raster raster = this.texture.getData(rectangle);
        rectangle = raster.getBounds();
        DataBufferInt dataBufferInt = (DataBufferInt)raster.getDataBuffer();
        int[] nArray = dataBufferInt.getBankData()[0];
        SinglePixelPackedSampleModel singlePixelPackedSampleModel = (SinglePixelPackedSampleModel)raster.getSampleModel();
        int n7 = singlePixelPackedSampleModel.getScanlineStride();
        int n8 = n7 + 1;
        int n9 = n7 - 1;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = 0.0;
        double d9 = 0.0;
        double d10 = 0.0;
        double d11 = 0.0;
        double d12 = this.surfaceScaleX / 4.0;
        double d13 = this.surfaceScaleY / 4.0;
        double d14 = this.surfaceScaleX / 2.0;
        double d15 = this.surfaceScaleY / 2.0;
        double d16 = this.surfaceScaleX / 3.0;
        double d17 = this.surfaceScaleY / 3.0;
        double d18 = this.surfaceScaleX * 2.0 / 3.0;
        double d19 = this.surfaceScaleY * 2.0 / 3.0;
        if (n3 <= 0) {
            return dArray3;
        }
        if (n4 <= 0) {
            return dArray3;
        }
        int n10 = Math.min(rectangle.x + rectangle.width - 1, n + n3);
        int n11 = Math.min(rectangle.y + rectangle.height - 1, n2 + n4);
        int n12 = dataBufferInt.getOffset() + singlePixelPackedSampleModel.getOffset(rectangle.x - raster.getSampleModelTranslateX(), rectangle.y - raster.getSampleModelTranslateY());
        int n13 = n2;
        if (n13 < rectangle.y) {
            n13 = rectangle.y;
        }
        if (n13 == rectangle.y) {
            if (n13 == n11) {
                double d20;
                double[] dArray4;
                double[][] dArray5 = dArray3[n13 - n2];
                int n14 = n;
                if (n14 < rectangle.x) {
                    n14 = rectangle.x;
                }
                int n15 = n12 + (n14 - rectangle.x) + n7 * (n13 - rectangle.y);
                d7 = (double)(nArray[n15] >>> 24) * 0.00392156862745098;
                if (n14 != rectangle.x) {
                    d6 = (double)(nArray[n15 - 1] >>> 24) * 0.00392156862745098;
                } else if (n14 < n10) {
                    d8 = (double)(nArray[n15 + 1] >>> 24) * 0.00392156862745098;
                    dArray4 = dArray5[n14 - n];
                    dArray4[0] = 2.0 * this.surfaceScaleX * (d7 - d8);
                    d20 = 1.0 / Math.sqrt(dArray4[0] * dArray4[0] + 1.0);
                    dArray4[0] = dArray4[0] * d20;
                    dArray4[1] = 0.0;
                    dArray4[2] = d20;
                    dArray4[3] = d7 * this.surfaceScale;
                    ++n15;
                    ++n14;
                    d6 = d7;
                    d7 = d8;
                } else {
                    d6 = d7;
                }
                while (n14 < n10) {
                    d8 = (double)(nArray[n15 + 1] >>> 24) * 0.00392156862745098;
                    dArray4 = dArray5[n14 - n];
                    dArray4[0] = this.surfaceScaleX * (d6 - d8);
                    d20 = 1.0 / Math.sqrt(dArray4[0] * dArray4[0] + 1.0);
                    dArray4[0] = dArray4[0] * d20;
                    dArray4[1] = 0.0;
                    dArray4[2] = d20;
                    dArray4[3] = d7 * this.surfaceScale;
                    ++n15;
                    d6 = d7;
                    d7 = d8;
                    ++n14;
                }
                if (n14 < n + n3 && n14 == rectangle.x + rectangle.width - 1) {
                    dArray4 = dArray5[n14 - n];
                    dArray4[0] = 2.0 * this.surfaceScaleX * (d6 - d7);
                    d20 = 1.0 / Math.sqrt(dArray4[0] * dArray4[0] + dArray4[1] * dArray4[1] + 1.0);
                    dArray4[0] = dArray4[0] * d20;
                    dArray4[1] = dArray4[1] * d20;
                    dArray4[2] = d20;
                    dArray4[3] = d7 * this.surfaceScale;
                }
                return dArray3;
            }
            dArray2 = dArray3[n13 - n2];
            n6 = n12 + n7 * (n13 - rectangle.y);
            n5 = n;
            if (n5 < rectangle.x) {
                n5 = rectangle.x;
            }
            d7 = (double)(nArray[n6 += n5 - rectangle.x] >>> 24) * 0.00392156862745098;
            d10 = (double)(nArray[n6 + n7] >>> 24) * 0.00392156862745098;
            if (n5 != rectangle.x) {
                d6 = (double)(nArray[n6 - 1] >>> 24) * 0.00392156862745098;
                d9 = (double)(nArray[n6 + n9] >>> 24) * 0.00392156862745098;
            } else if (n5 < n10) {
                d8 = (double)(nArray[n6 + 1] >>> 24) * 0.00392156862745098;
                d11 = (double)(nArray[n6 + n8] >>> 24) * 0.00392156862745098;
                dArray = dArray2[n5 - n];
                dArray[0] = -d18 * (2.0 * d8 + d11 - 2.0 * d7 - d10);
                dArray[1] = -d19 * (2.0 * d10 + d11 - 2.0 * d7 - d8);
                d2 = 1.0 / Math.sqrt(dArray[0] * dArray[0] + dArray[1] * dArray[1] + 1.0);
                dArray[0] = dArray[0] * d2;
                dArray[1] = dArray[1] * d2;
                dArray[2] = d2;
                dArray[3] = d7 * this.surfaceScale;
                ++n6;
                ++n5;
                d6 = d7;
                d9 = d10;
                d7 = d8;
                d10 = d11;
            } else {
                d6 = d7;
                d9 = d10;
            }
            while (n5 < n10) {
                d8 = (double)(nArray[n6 + 1] >>> 24) * 0.00392156862745098;
                d11 = (double)(nArray[n6 + n8] >>> 24) * 0.00392156862745098;
                dArray = dArray2[n5 - n];
                dArray[0] = -d16 * (2.0 * d8 + d11 - (2.0 * d6 + d9));
                dArray[1] = -d15 * (d9 + 2.0 * d10 + d11 - (d6 + 2.0 * d7 + d8));
                d2 = 1.0 / Math.sqrt(dArray[0] * dArray[0] + dArray[1] * dArray[1] + 1.0);
                dArray[0] = dArray[0] * d2;
                dArray[1] = dArray[1] * d2;
                dArray[2] = d2;
                dArray[3] = d7 * this.surfaceScale;
                ++n6;
                d6 = d7;
                d9 = d10;
                d7 = d8;
                d10 = d11;
                ++n5;
            }
            if (n5 < n + n3 && n5 == rectangle.x + rectangle.width - 1) {
                dArray = dArray2[n5 - n];
                dArray[0] = -d18 * (2.0 * d7 + d10 - (2.0 * d6 + d9));
                dArray[1] = -d19 * (2.0 * d10 + d9 - (2.0 * d7 + d6));
                d2 = 1.0 / Math.sqrt(dArray[0] * dArray[0] + dArray[1] * dArray[1] + 1.0);
                dArray[0] = dArray[0] * d2;
                dArray[1] = dArray[1] * d2;
                dArray[2] = d2;
                dArray[3] = d7 * this.surfaceScale;
            }
            ++n13;
        }
        while (n13 < n11) {
            dArray2 = dArray3[n13 - n2];
            n6 = n12 + n7 * (n13 - rectangle.y);
            n5 = n;
            if (n5 < rectangle.x) {
                n5 = rectangle.x;
            }
            d4 = (double)(nArray[(n6 += n5 - rectangle.x) - n7] >>> 24) * 0.00392156862745098;
            d7 = (double)(nArray[n6] >>> 24) * 0.00392156862745098;
            d10 = (double)(nArray[n6 + n7] >>> 24) * 0.00392156862745098;
            if (n5 != rectangle.x) {
                d3 = (double)(nArray[n6 - n8] >>> 24) * 0.00392156862745098;
                d6 = (double)(nArray[n6 - 1] >>> 24) * 0.00392156862745098;
                d9 = (double)(nArray[n6 + n9] >>> 24) * 0.00392156862745098;
            } else if (n5 < n10) {
                d8 = (double)(nArray[n6 + 1] >>> 24) * 0.00392156862745098;
                d5 = (double)(nArray[n6 - n9] >>> 24) * 0.00392156862745098;
                d11 = (double)(nArray[n6 + n8] >>> 24) * 0.00392156862745098;
                dArray = dArray2[n5 - n];
                dArray[0] = -d14 * (d5 + 2.0 * d8 + d11 - (d4 + 2.0 * d7 + d10));
                dArray[1] = -d17 * (2.0 * d4 + d5 - (2.0 * d7 + d8));
                d2 = 1.0 / Math.sqrt(dArray[0] * dArray[0] + dArray[1] * dArray[1] + 1.0);
                dArray[0] = dArray[0] * d2;
                dArray[1] = dArray[1] * d2;
                dArray[2] = d2;
                dArray[3] = d7 * this.surfaceScale;
                ++n6;
                ++n5;
                d3 = d4;
                d6 = d7;
                d9 = d10;
                d4 = d5;
                d7 = d8;
                d10 = d11;
            } else {
                d3 = d4;
                d6 = d7;
                d9 = d10;
            }
            while (n5 < n10) {
                d5 = (double)(nArray[n6 - n9] >>> 24) * 0.00392156862745098;
                d8 = (double)(nArray[n6 + 1] >>> 24) * 0.00392156862745098;
                d11 = (double)(nArray[n6 + n8] >>> 24) * 0.00392156862745098;
                dArray = dArray2[n5 - n];
                dArray[0] = -d12 * (d5 + 2.0 * d8 + d11 - (d3 + 2.0 * d6 + d9));
                dArray[1] = -d13 * (d9 + 2.0 * d10 + d11 - (d3 + 2.0 * d4 + d5));
                d2 = 1.0 / Math.sqrt(dArray[0] * dArray[0] + dArray[1] * dArray[1] + 1.0);
                dArray[0] = dArray[0] * d2;
                dArray[1] = dArray[1] * d2;
                dArray[2] = d2;
                dArray[3] = d7 * this.surfaceScale;
                ++n6;
                d3 = d4;
                d6 = d7;
                d9 = d10;
                d4 = d5;
                d7 = d8;
                d10 = d11;
                ++n5;
            }
            if (n5 < n + n3 && n5 == rectangle.x + rectangle.width - 1) {
                dArray = dArray2[n5 - n];
                dArray[0] = -d14 * (d4 + 2.0 * d7 + d10 - (d3 + 2.0 * d6 + d9));
                dArray[1] = -d17 * (d9 + 2.0 * d10 - (d3 + 2.0 * d4));
                d2 = 1.0 / Math.sqrt(dArray[0] * dArray[0] + dArray[1] * dArray[1] + 1.0);
                dArray[0] = dArray[0] * d2;
                dArray[1] = dArray[1] * d2;
                dArray[2] = d2;
                dArray[3] = d7 * this.surfaceScale;
            }
            ++n13;
        }
        if (n13 < n2 + n4 && n13 == rectangle.y + rectangle.height - 1) {
            dArray2 = dArray3[n13 - n2];
            n6 = n12 + n7 * (n13 - rectangle.y);
            n5 = n;
            if (n5 < rectangle.x) {
                n5 = rectangle.x;
            }
            d7 = (double)(nArray[n6 += n5 - rectangle.x] >>> 24) * 0.00392156862745098;
            d4 = (double)(nArray[n6 - n7] >>> 24) * 0.00392156862745098;
            if (n5 != rectangle.x) {
                d3 = (double)(nArray[n6 - n8] >>> 24) * 0.00392156862745098;
                d6 = (double)(nArray[n6 - 1] >>> 24) * 0.00392156862745098;
            } else if (n5 < n10) {
                d8 = (double)(nArray[n6 + 1] >>> 24) * 0.00392156862745098;
                d5 = (double)(nArray[n6 - n9] >>> 24) * 0.00392156862745098;
                dArray = dArray2[n5 - n];
                dArray[0] = -d18 * (2.0 * d8 + d5 - 2.0 * d7 - d4);
                dArray[1] = -d19 * (2.0 * d7 + d8 - 2.0 * d4 - d5);
                d2 = 1.0 / Math.sqrt(dArray[0] * dArray[0] + dArray[1] * dArray[1] + 1.0);
                dArray[0] = dArray[0] * d2;
                dArray[1] = dArray[1] * d2;
                dArray[2] = d2;
                dArray[3] = d7 * this.surfaceScale;
                ++n6;
                ++n5;
                d6 = d7;
                d3 = d4;
                d7 = d8;
                d4 = d5;
            } else {
                d6 = d7;
                d3 = d4;
            }
            while (n5 < n10) {
                d8 = (double)(nArray[n6 + 1] >>> 24) * 0.00392156862745098;
                d5 = (double)(nArray[n6 - n9] >>> 24) * 0.00392156862745098;
                dArray = dArray2[n5 - n];
                dArray[0] = -d16 * (2.0 * d8 + d5 - (2.0 * d6 + d3));
                dArray[1] = -d15 * (d6 + 2.0 * d7 + d8 - (d3 + 2.0 * d4 + d5));
                d2 = 1.0 / Math.sqrt(dArray[0] * dArray[0] + dArray[1] * dArray[1] + 1.0);
                dArray[0] = dArray[0] * d2;
                dArray[1] = dArray[1] * d2;
                dArray[2] = d2;
                dArray[3] = d7 * this.surfaceScale;
                ++n6;
                d6 = d7;
                d3 = d4;
                d7 = d8;
                d4 = d5;
                ++n5;
            }
            if (n5 < n + n3 && n5 == rectangle.x + rectangle.width - 1) {
                dArray = dArray2[n5 - n];
                dArray[0] = -d18 * (2.0 * d7 + d4 - (2.0 * d6 + d3));
                dArray[1] = -d19 * (2.0 * d7 + d6 - (2.0 * d4 + d3));
                d2 = 1.0 / Math.sqrt(dArray[0] * dArray[0] + dArray[1] * dArray[1] + 1.0);
                dArray[0] = dArray[0] * d2;
                dArray[1] = dArray[1] * d2;
                dArray[2] = d2;
                dArray[3] = d7 * this.surfaceScale;
            }
        }
        return dArray3;
    }
}

