/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.image.renderable;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderContext;
import org.apache.batik.ext.awt.RenderingHintsKeyExt;
import org.apache.batik.ext.awt.image.GraphicsUtil;
import org.apache.batik.ext.awt.image.renderable.AbstractColorInterpolationRable;
import org.apache.batik.ext.awt.image.renderable.Filter;
import org.apache.batik.ext.awt.image.renderable.TileRable;
import org.apache.batik.ext.awt.image.rendered.AbstractRed;
import org.apache.batik.ext.awt.image.rendered.AffineRed;
import org.apache.batik.ext.awt.image.rendered.BufferedImageCachableRed;
import org.apache.batik.ext.awt.image.rendered.CachableRed;
import org.apache.batik.ext.awt.image.rendered.TileRed;

public class TileRable8Bit
extends AbstractColorInterpolationRable
implements TileRable {
    private Rectangle2D tileRegion;
    private Rectangle2D tiledRegion;
    private boolean overflow;

    public Rectangle2D getTileRegion() {
        return this.tileRegion;
    }

    public void setTileRegion(Rectangle2D rectangle2D) {
        if (rectangle2D == null) {
            throw new IllegalArgumentException();
        }
        this.touch();
        this.tileRegion = rectangle2D;
    }

    public Rectangle2D getTiledRegion() {
        return this.tiledRegion;
    }

    public void setTiledRegion(Rectangle2D rectangle2D) {
        if (rectangle2D == null) {
            throw new IllegalArgumentException();
        }
        this.touch();
        this.tiledRegion = rectangle2D;
    }

    public boolean isOverflow() {
        return this.overflow;
    }

    public void setOverflow(boolean bl) {
        this.touch();
        this.overflow = bl;
    }

    public TileRable8Bit(Filter filter, Rectangle2D rectangle2D, Rectangle2D rectangle2D2, boolean bl) {
        super(filter);
        this.setTileRegion(rectangle2D2);
        this.setTiledRegion(rectangle2D);
        this.setOverflow(bl);
    }

    public void setSource(Filter filter) {
        this.init(filter);
    }

    public Filter getSource() {
        return (Filter)this.srcs.get(0);
    }

    public Rectangle2D getBounds2D() {
        return (Rectangle2D)this.tiledRegion.clone();
    }

    public RenderedImage createRendering(RenderContext renderContext) {
        Rectangle2D rectangle2D;
        RenderingHints renderingHints = renderContext.getRenderingHints();
        if (renderingHints == null) {
            renderingHints = new RenderingHints(null);
        }
        AffineTransform affineTransform = renderContext.getTransform();
        double d2 = affineTransform.getScaleX();
        double d3 = affineTransform.getScaleY();
        double d4 = affineTransform.getShearX();
        double d5 = affineTransform.getShearY();
        double d6 = affineTransform.getTranslateX();
        double d7 = affineTransform.getTranslateY();
        double d8 = Math.sqrt(d2 * d2 + d5 * d5);
        double d9 = Math.sqrt(d3 * d3 + d4 * d4);
        Rectangle2D rectangle2D2 = this.getBounds2D();
        Shape shape = renderContext.getAreaOfInterest();
        if (shape == null) {
            rectangle2D = rectangle2D2;
        } else {
            rectangle2D = shape.getBounds2D();
            if (!rectangle2D2.intersects(rectangle2D)) {
                return null;
            }
            Rectangle2D.intersect(rectangle2D2, rectangle2D, rectangle2D2);
        }
        Rectangle2D rectangle2D3 = this.tileRegion;
        int n = (int)Math.ceil(rectangle2D3.getWidth() * d8);
        int n2 = (int)Math.ceil(rectangle2D3.getHeight() * d9);
        double d10 = (double)n / rectangle2D3.getWidth();
        double d11 = (double)n2 / rectangle2D3.getHeight();
        int n3 = (int)Math.floor(rectangle2D3.getX() * d10);
        int n4 = (int)Math.floor(rectangle2D3.getY() * d11);
        double d12 = (double)n3 - rectangle2D3.getX() * d10;
        double d13 = (double)n4 - rectangle2D3.getY() * d11;
        AffineTransform affineTransform2 = AffineTransform.getTranslateInstance(d12, d13);
        affineTransform2.scale(d10, d11);
        Filter filter = this.getSource();
        Rectangle2D rectangle2D4 = this.overflow ? filter.getBounds2D() : rectangle2D3;
        RenderContext renderContext2 = new RenderContext(affineTransform2, rectangle2D4, renderingHints);
        RenderedImage renderedImage = filter.createRendering(renderContext2);
        if (renderedImage == null) {
            return null;
        }
        Rectangle rectangle = affineTransform2.createTransformedShape(rectangle2D).getBounds();
        if (rectangle.width == Integer.MAX_VALUE || rectangle.height == Integer.MAX_VALUE) {
            rectangle = new Rectangle(-536870912, -536870912, 0x3FFFFFFF, 0x3FFFFFFF);
        }
        renderedImage = this.convertSourceCS(renderedImage);
        TileRed tileRed = new TileRed(renderedImage, rectangle, n, n2);
        AffineTransform affineTransform3 = new AffineTransform(d2 / d8, d5 / d8, d4 / d9, d3 / d9, d6, d7);
        affineTransform3.scale(d8 / d10, d9 / d11);
        affineTransform3.translate(-d12, -d13);
        AbstractRed abstractRed = tileRed;
        if (!affineTransform3.isIdentity()) {
            abstractRed = new AffineRed((CachableRed)tileRed, affineTransform3, renderingHints);
        }
        return abstractRed;
    }

    public Rectangle2D getActualTileBounds(Rectangle2D rectangle2D) {
        Rectangle2D rectangle2D2 = (Rectangle2D)this.tileRegion.clone();
        if (rectangle2D2.getWidth() <= 0.0 || rectangle2D2.getHeight() <= 0.0 || rectangle2D.getWidth() <= 0.0 || rectangle2D.getHeight() <= 0.0) {
            return null;
        }
        double d2 = rectangle2D2.getWidth();
        double d3 = rectangle2D2.getHeight();
        double d4 = rectangle2D.getWidth();
        double d5 = rectangle2D.getHeight();
        double d6 = Math.min(d2, d4);
        double d7 = Math.min(d3, d5);
        Rectangle2D.Double double_ = new Rectangle2D.Double(rectangle2D2.getX(), rectangle2D2.getY(), d6, d7);
        return double_;
    }

    public RenderedImage createTile(RenderContext renderContext) {
        Cloneable cloneable;
        Object object;
        Object object2;
        Rectangle rectangle;
        Shape shape;
        Rectangle2D rectangle2D;
        AffineTransform affineTransform = renderContext.getTransform();
        RenderingHints renderingHints = renderContext.getRenderingHints();
        renderingHints = renderingHints == null ? new RenderingHints(null) : new RenderingHints(renderingHints);
        Rectangle2D rectangle2D2 = this.getBounds2D();
        if (!rectangle2D2.intersects(rectangle2D = (shape = renderContext.getAreaOfInterest()).getBounds2D())) {
            return null;
        }
        Rectangle2D.intersect(rectangle2D2, rectangle2D, rectangle2D2);
        Rectangle2D rectangle2D3 = (Rectangle2D)this.tileRegion.clone();
        if (rectangle2D3.getWidth() <= 0.0 || rectangle2D3.getHeight() <= 0.0 || rectangle2D2.getWidth() <= 0.0 || rectangle2D2.getHeight() <= 0.0) {
            return null;
        }
        double d2 = rectangle2D3.getX();
        double d3 = rectangle2D3.getY();
        double d4 = rectangle2D3.getWidth();
        double d5 = rectangle2D3.getHeight();
        double d6 = rectangle2D2.getX();
        double d7 = rectangle2D2.getY();
        double d8 = rectangle2D2.getWidth();
        double d9 = rectangle2D2.getHeight();
        double d10 = Math.min(d4, d8);
        double d11 = Math.min(d5, d9);
        double d12 = (d6 - d2) % d4;
        double d13 = (d7 - d3) % d5;
        d12 = d12 > 0.0 ? d4 - d12 : (d12 *= -1.0);
        d13 = d13 > 0.0 ? d5 - d13 : (d13 *= -1.0);
        double d14 = affineTransform.getScaleX();
        double d15 = affineTransform.getScaleY();
        double d16 = Math.floor(d14 * d12);
        double d17 = Math.floor(d15 * d13);
        d12 = d16 / d14;
        d13 = d17 / d15;
        Rectangle2D.Double double_ = new Rectangle2D.Double(d2 + d4 - d12, d3 + d5 - d13, d12, d13);
        Rectangle2D.Double double_2 = new Rectangle2D.Double(d2, d3 + d5 - d13, d10 - d12, d13);
        Rectangle2D.Double double_3 = new Rectangle2D.Double(d2 + d4 - d12, d3, d12, d11 - d13);
        Rectangle2D.Double double_4 = new Rectangle2D.Double(d2, d3, d10 - d12, d11 - d13);
        Rectangle2D.Double double_5 = new Rectangle2D.Double(rectangle2D2.getX(), rectangle2D2.getY(), d10, d11);
        RenderedImage renderedImage = null;
        RenderedImage renderedImage2 = null;
        RenderedImage renderedImage3 = null;
        RenderedImage renderedImage4 = null;
        Filter filter = this.getSource();
        if (double_.getWidth() > 0.0 && double_.getHeight() > 0.0) {
            rectangle = affineTransform.createTransformedShape(double_).getBounds();
            if (rectangle.width > 0 && rectangle.height > 0) {
                object2 = new AffineTransform(affineTransform);
                ((AffineTransform)object2).translate(-double_.x + d6, -double_.y + d7);
                object = double_;
                if (this.overflow) {
                    object = new Rectangle2D.Double(double_.x, double_.y, d8, d9);
                }
                renderingHints.put(RenderingHintsKeyExt.KEY_AREA_OF_INTEREST, object);
                cloneable = new RenderContext((AffineTransform)object2, (Shape)object, renderingHints);
                renderedImage = filter.createRendering((RenderContext)cloneable);
            }
        }
        if (double_2.getWidth() > 0.0 && double_2.getHeight() > 0.0) {
            rectangle = affineTransform.createTransformedShape(double_2).getBounds();
            if (rectangle.width > 0 && rectangle.height > 0) {
                object2 = new AffineTransform(affineTransform);
                ((AffineTransform)object2).translate(-double_2.x + (d6 + d12), -double_2.y + d7);
                object = double_2;
                if (this.overflow) {
                    object = new Rectangle2D.Double(double_2.x - d8 + d10 - d12, double_2.y, d8, d9);
                }
                renderingHints.put(RenderingHintsKeyExt.KEY_AREA_OF_INTEREST, object);
                cloneable = new RenderContext((AffineTransform)object2, (Shape)object, renderingHints);
                renderedImage2 = filter.createRendering((RenderContext)cloneable);
            }
        }
        if (double_3.getWidth() > 0.0 && double_3.getHeight() > 0.0) {
            rectangle = affineTransform.createTransformedShape(double_3).getBounds();
            if (rectangle.width > 0 && rectangle.height > 0) {
                object2 = new AffineTransform(affineTransform);
                ((AffineTransform)object2).translate(-double_3.x + d6, -double_3.y + (d7 + d13));
                object = double_3;
                if (this.overflow) {
                    object = new Rectangle2D.Double(double_3.x, double_3.y - d5 + d11 - d13, d8, d9);
                }
                renderingHints.put(RenderingHintsKeyExt.KEY_AREA_OF_INTEREST, object);
                cloneable = new RenderContext((AffineTransform)object2, (Shape)object, renderingHints);
                renderedImage3 = filter.createRendering((RenderContext)cloneable);
            }
        }
        if (double_4.getWidth() > 0.0 && double_4.getHeight() > 0.0) {
            rectangle = affineTransform.createTransformedShape(double_4).getBounds();
            if (rectangle.width > 0 && rectangle.height > 0) {
                object2 = new AffineTransform(affineTransform);
                ((AffineTransform)object2).translate(-double_4.x + (d6 + d12), -double_4.y + (d7 + d13));
                object = double_4;
                if (this.overflow) {
                    object = new Rectangle2D.Double(double_4.x - d4 + d10 - d12, double_4.y - d5 + d11 - d13, d8, d9);
                }
                renderingHints.put(RenderingHintsKeyExt.KEY_AREA_OF_INTEREST, object);
                cloneable = new RenderContext((AffineTransform)object2, (Shape)object, renderingHints);
                renderedImage4 = filter.createRendering((RenderContext)cloneable);
            }
        }
        rectangle = affineTransform.createTransformedShape(double_5).getBounds();
        if (rectangle.width == 0 || rectangle.height == 0) {
            return null;
        }
        object2 = new BufferedImage(rectangle.width, rectangle.height, 2);
        object = GraphicsUtil.createGraphics((BufferedImage)object2, renderContext.getRenderingHints());
        ((Graphics2D)object).translate(-rectangle.x, -rectangle.y);
        cloneable = new AffineTransform();
        Point2D.Double double_6 = new Point2D.Double();
        RenderedImage renderedImage5 = null;
        if (renderedImage != null) {
            ((Graphics2D)object).drawRenderedImage(renderedImage, (AffineTransform)cloneable);
            renderedImage5 = renderedImage;
        }
        if (renderedImage2 != null) {
            if (renderedImage5 == null) {
                renderedImage5 = renderedImage2;
            }
            double_6.x = d12;
            double_6.y = 0.0;
            affineTransform.deltaTransform(double_6, double_6);
            double_6.x = Math.floor(double_6.x) - (double)(renderedImage2.getMinX() - renderedImage5.getMinX());
            double_6.y = Math.floor(double_6.y) - (double)(renderedImage2.getMinY() - renderedImage5.getMinY());
            ((Graphics2D)object).drawRenderedImage(renderedImage2, (AffineTransform)cloneable);
        }
        if (renderedImage3 != null) {
            if (renderedImage5 == null) {
                renderedImage5 = renderedImage3;
            }
            double_6.x = 0.0;
            double_6.y = d13;
            affineTransform.deltaTransform(double_6, double_6);
            double_6.x = Math.floor(double_6.x) - (double)(renderedImage3.getMinX() - renderedImage5.getMinX());
            double_6.y = Math.floor(double_6.y) - (double)(renderedImage3.getMinY() - renderedImage5.getMinY());
            ((Graphics2D)object).drawRenderedImage(renderedImage3, (AffineTransform)cloneable);
        }
        if (renderedImage4 != null) {
            if (renderedImage5 == null) {
                renderedImage5 = renderedImage4;
            }
            double_6.x = d12;
            double_6.y = d13;
            affineTransform.deltaTransform(double_6, double_6);
            double_6.x = Math.floor(double_6.x) - (double)(renderedImage4.getMinX() - renderedImage5.getMinX());
            double_6.y = Math.floor(double_6.y) - (double)(renderedImage4.getMinY() - renderedImage5.getMinY());
            ((Graphics2D)object).drawRenderedImage(renderedImage4, (AffineTransform)cloneable);
        }
        BufferedImageCachableRed bufferedImageCachableRed = new BufferedImageCachableRed((BufferedImage)object2, rectangle.x, rectangle.y);
        return bufferedImageCachableRed;
    }
}

