/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.image.renderable;

import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Rectangle2D;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderContext;
import org.apache.batik.ext.awt.image.PadMode;
import org.apache.batik.ext.awt.image.renderable.AbstractColorInterpolationRable;
import org.apache.batik.ext.awt.image.renderable.Filter;
import org.apache.batik.ext.awt.image.renderable.GaussianBlurRable;
import org.apache.batik.ext.awt.image.rendered.AffineRed;
import org.apache.batik.ext.awt.image.rendered.CachableRed;
import org.apache.batik.ext.awt.image.rendered.GaussianBlurRed8Bit;
import org.apache.batik.ext.awt.image.rendered.PadRed;

public class GaussianBlurRable8Bit
extends AbstractColorInterpolationRable
implements GaussianBlurRable {
    private double stdDeviationX;
    private double stdDeviationY;
    static final float DSQRT2PI = (float)(Math.sqrt(Math.PI * 2) * 3.0 / 4.0);
    public static final double eps = 1.0E-4;

    public GaussianBlurRable8Bit(Filter filter, double d2, double d3) {
        super(filter, null);
        this.setStdDeviationX(d2);
        this.setStdDeviationY(d3);
    }

    public void setStdDeviationX(double d2) {
        if (d2 < 0.0) {
            throw new IllegalArgumentException();
        }
        this.touch();
        this.stdDeviationX = d2;
    }

    public void setStdDeviationY(double d2) {
        if (d2 < 0.0) {
            throw new IllegalArgumentException();
        }
        this.touch();
        this.stdDeviationY = d2;
    }

    public double getStdDeviationX() {
        return this.stdDeviationX;
    }

    public double getStdDeviationY() {
        return this.stdDeviationY;
    }

    public void setSource(Filter filter) {
        this.init(filter, null);
    }

    public Rectangle2D getBounds2D() {
        Rectangle2D rectangle2D = this.getSource().getBounds2D();
        float f2 = (float)(this.stdDeviationX * (double)DSQRT2PI);
        float f3 = (float)(this.stdDeviationY * (double)DSQRT2PI);
        float f4 = 3.0f * f2 / 2.0f;
        float f5 = 3.0f * f3 / 2.0f;
        return new Rectangle2D.Float((float)(rectangle2D.getMinX() - (double)f4), (float)(rectangle2D.getMinY() - (double)f5), (float)(rectangle2D.getWidth() + (double)(2.0f * f4)), (float)(rectangle2D.getHeight() + (double)(2.0f * f5)));
    }

    public Filter getSource() {
        return (Filter)this.getSources().get(0);
    }

    public static boolean eps_eq(double d2, double d3) {
        return d2 >= d3 - 1.0E-4 && d2 <= d3 + 1.0E-4;
    }

    public static boolean eps_abs_eq(double d2, double d3) {
        if (d2 < 0.0) {
            d2 = -d2;
        }
        if (d3 < 0.0) {
            d3 = -d3;
        }
        return GaussianBlurRable8Bit.eps_eq(d2, d3);
    }

    public RenderedImage createRendering(RenderContext renderContext) {
        Rectangle2D rectangle2D;
        Object object;
        int n;
        int n2;
        AffineTransform affineTransform;
        AffineTransform affineTransform2;
        RenderingHints renderingHints = renderContext.getRenderingHints();
        if (renderingHints == null) {
            renderingHints = new RenderingHints(null);
        }
        AffineTransform affineTransform3 = renderContext.getTransform();
        double d2 = affineTransform3.getScaleX();
        double d3 = affineTransform3.getScaleY();
        double d4 = affineTransform3.getShearX();
        double d5 = affineTransform3.getShearY();
        double d6 = affineTransform3.getTranslateX();
        double d7 = affineTransform3.getTranslateY();
        double d8 = Math.sqrt(d2 * d2 + d5 * d5);
        double d9 = Math.sqrt(d3 * d3 + d4 * d4);
        double d10 = this.stdDeviationX * d8;
        double d11 = this.stdDeviationY * d9;
        if (d10 < 10.0 && d11 < 10.0 && GaussianBlurRable8Bit.eps_eq(d10, d11) && GaussianBlurRable8Bit.eps_abs_eq(d2 / d8, d3 / d9)) {
            affineTransform2 = affineTransform3;
            affineTransform = null;
            n2 = 0;
            n = 0;
        } else {
            if (d10 > 10.0) {
                d8 = d8 * 10.0 / d10;
                d10 = 10.0;
            }
            if (d11 > 10.0) {
                d9 = d9 * 10.0 / d11;
                d11 = 10.0;
            }
            affineTransform2 = AffineTransform.getScaleInstance(d8, d9);
            affineTransform = new AffineTransform(d2 / d8, d5 / d8, d4 / d9, d3 / d9, d6, d7);
            n2 = 1;
            n = 1;
        }
        Shape shape = renderContext.getAreaOfInterest();
        if (shape == null) {
            shape = this.getBounds2D();
        }
        Shape shape2 = affineTransform2.createTransformedShape(shape);
        Rectangle rectangle = shape2.getBounds();
        rectangle.x -= (n2 += GaussianBlurRed8Bit.surroundPixels(d10, renderingHints));
        rectangle.y -= (n += GaussianBlurRed8Bit.surroundPixels(d11, renderingHints));
        rectangle.width += 2 * n2;
        rectangle.height += 2 * n;
        try {
            object = affineTransform2.createInverse();
            rectangle2D = ((AffineTransform)object).createTransformedShape(rectangle).getBounds2D();
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            rectangle2D = shape.getBounds2D();
            rectangle2D = new Rectangle2D.Double(rectangle2D.getX() - (double)n2 / d8, rectangle2D.getY() - (double)n / d9, rectangle2D.getWidth() + (double)(2 * n2) / d8, rectangle2D.getHeight() + (double)(2 * n) / d9);
        }
        object = this.getSource().createRendering(new RenderContext(affineTransform2, rectangle2D, renderingHints));
        if (object == null) {
            return null;
        }
        CachableRed cachableRed = this.convertSourceCS((RenderedImage)object);
        if (!rectangle.equals(cachableRed.getBounds())) {
            cachableRed = new PadRed(cachableRed, rectangle, PadMode.ZERO_PAD, renderingHints);
        }
        cachableRed = new GaussianBlurRed8Bit(cachableRed, d10, d11, renderingHints);
        if (affineTransform != null && !affineTransform.isIdentity()) {
            cachableRed = new AffineRed(cachableRed, affineTransform, renderingHints);
        }
        return cachableRed;
    }

    public Shape getDependencyRegion(int n, Rectangle2D rectangle2D) {
        if (n != 0) {
            rectangle2D = null;
        } else {
            Rectangle2D rectangle2D2;
            float f2 = (float)(this.stdDeviationX * (double)DSQRT2PI);
            float f3 = (float)(this.stdDeviationY * (double)DSQRT2PI);
            float f4 = 3.0f * f2 / 2.0f;
            float f5 = 3.0f * f3 / 2.0f;
            if (!(rectangle2D = new Rectangle2D.Float((float)(rectangle2D.getMinX() - (double)f4), (float)(rectangle2D.getMinY() - (double)f5), (float)(rectangle2D.getWidth() + (double)(2.0f * f4)), (float)(rectangle2D.getHeight() + (double)(2.0f * f5)))).intersects(rectangle2D2 = this.getBounds2D())) {
                return new Rectangle2D.Float();
            }
            rectangle2D = rectangle2D.createIntersection(rectangle2D2);
        }
        return rectangle2D;
    }

    public Shape getDirtyRegion(int n, Rectangle2D rectangle2D) {
        Rectangle2D rectangle2D2 = null;
        if (n == 0) {
            Rectangle2D rectangle2D3;
            float f2 = (float)(this.stdDeviationX * (double)DSQRT2PI);
            float f3 = (float)(this.stdDeviationY * (double)DSQRT2PI);
            float f4 = 3.0f * f2 / 2.0f;
            float f5 = 3.0f * f3 / 2.0f;
            if (!(rectangle2D = new Rectangle2D.Float((float)(rectangle2D.getMinX() - (double)f4), (float)(rectangle2D.getMinY() - (double)f5), (float)(rectangle2D.getWidth() + (double)(2.0f * f4)), (float)(rectangle2D.getHeight() + (double)(2.0f * f5)))).intersects(rectangle2D3 = this.getBounds2D())) {
                return new Rectangle2D.Float();
            }
            rectangle2D2 = rectangle2D.createIntersection(rectangle2D3);
        }
        return rectangle2D2;
    }
}

