/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.geom;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.FlatteningPathIterator;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.util.Vector;

public class PathLength {
    private Shape path = null;
    private Vector segments = null;
    private float pathLength = 0.0f;
    private boolean initialised = false;

    public PathLength(Shape shape) {
        this.setPath(shape);
    }

    public Shape getPath() {
        return this.path;
    }

    public void setPath(Shape shape) {
        this.path = shape;
        this.initialised = false;
    }

    public float lengthOfPath() {
        if (!this.initialised) {
            this.initialise();
        }
        return this.pathLength;
    }

    protected void initialise() {
        this.pathLength = 0.0f;
        FlatteningPathIterator flatteningPathIterator = new FlatteningPathIterator(this.path.getPathIterator(new AffineTransform()), 0.01f);
        this.segments = new Vector(20);
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = 0.0f;
        float[] fArray = new float[6];
        this.segments.add(new PathSegment(0, 0.0f, 0.0f, 0.0f));
        while (!flatteningPathIterator.isDone()) {
            int n = flatteningPathIterator.currentSegment(fArray);
            switch (n) {
                case 0: {
                    this.segments.add(new PathSegment(n, fArray[0], fArray[1], this.pathLength));
                    f4 = fArray[0];
                    f5 = fArray[1];
                    f2 = f4;
                    f3 = f5;
                    break;
                }
                case 1: {
                    this.pathLength = (float)((double)this.pathLength + Point2D.distance(f4, f5, fArray[0], fArray[1]));
                    this.segments.add(new PathSegment(n, fArray[0], fArray[1], this.pathLength));
                    f4 = fArray[0];
                    f5 = fArray[1];
                    break;
                }
                case 4: {
                    this.pathLength = (float)((double)this.pathLength + Point2D.distance(f4, f5, f2, f3));
                    this.segments.add(new PathSegment(1, f2, f3, this.pathLength));
                    f4 = f2;
                    f5 = f3;
                    break;
                }
                default: {
                    System.out.println("Bad path segment types");
                }
            }
            flatteningPathIterator.next();
        }
        this.initialised = true;
    }

    public Point2D pointAtLength(float f2) {
        int n = this.findUpperIndex(f2);
        if (n == -1) {
            return null;
        }
        PathSegment pathSegment = (PathSegment)this.segments.elementAt(n);
        if (n == 0) {
            return new Point2D.Float(pathSegment.getX(), pathSegment.getY());
        }
        PathSegment pathSegment2 = (PathSegment)this.segments.elementAt(n - 1);
        float f3 = f2 - pathSegment2.getLength();
        double d2 = Math.atan2(pathSegment.getY() - pathSegment2.getY(), pathSegment.getX() - pathSegment2.getX());
        float f4 = (float)((double)pathSegment2.getX() + (double)f3 * Math.cos(d2));
        float f5 = (float)((double)pathSegment2.getY() + (double)f3 * Math.sin(d2));
        return new Point2D.Float(f4, f5);
    }

    public float angleAtLength(float f2) {
        int n = this.findUpperIndex(f2);
        if (n == -1) {
            return 0.0f;
        }
        PathSegment pathSegment = (PathSegment)this.segments.elementAt(n);
        if (n == 0) {
            n = 1;
        }
        PathSegment pathSegment2 = (PathSegment)this.segments.elementAt(n - 1);
        float f3 = (float)Math.atan2(pathSegment.getY() - pathSegment2.getY(), pathSegment.getX() - pathSegment2.getX());
        return f3;
    }

    public int findUpperIndex(float f2) {
        PathSegment pathSegment;
        if (!this.initialised) {
            this.initialise();
        }
        if (f2 < 0.0f) {
            return -1;
        }
        if (f2 > this.pathLength) {
            return -1;
        }
        int n = 0;
        int n2 = this.segments.size() - 1;
        while (n != n2) {
            int n3 = n + n2 >> 1;
            PathSegment pathSegment2 = (PathSegment)this.segments.elementAt(n3);
            if (pathSegment2.getLength() >= f2) {
                n2 = n3;
                continue;
            }
            n = n3 + 1;
        }
        while ((pathSegment = (PathSegment)this.segments.elementAt(n2)).getSegType() == 0 && n2 != this.segments.size() - 1) {
            ++n2;
        }
        int n4 = -1;
        int n5 = this.segments.size();
        for (int i = 0; n4 <= 0 && i < n5; ++i) {
            PathSegment pathSegment3 = (PathSegment)this.segments.elementAt(i);
            if (!(pathSegment3.getLength() >= f2) || pathSegment3.getSegType() == 0) continue;
            n4 = i;
        }
        if (n2 != n4) {
            System.err.println("UB: " + n2 + " UI: " + n4);
        }
        return n4;
    }

    public static void main(String[] stringArray) {
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(100.0f, 100.0f);
        generalPath.lineTo(200.0f, 150.0f);
        generalPath.closePath();
        PathLength pathLength = new PathLength(generalPath);
        System.out.println("New Path Length created");
        System.out.println("Path Length = " + pathLength.lengthOfPath());
        System.out.println("Point at 0 = " + pathLength.pointAtLength(0.0f));
        System.out.println("Point at 10 = " + pathLength.pointAtLength(10.0f));
        System.out.println("Point at 20 = " + pathLength.pointAtLength(20.0f));
        System.out.println("Point at 300 = " + pathLength.pointAtLength(300.0f));
        System.out.println("Point at 3000 = " + pathLength.pointAtLength(3000.0f));
        generalPath = new GeneralPath();
        generalPath.moveTo(100.0f, 100.0f);
        generalPath.lineTo(200.0f, 150.0f);
        generalPath.quadTo(450.0f, 525.0f, 400.0f, 250.0f);
        generalPath.closePath();
        pathLength = new PathLength(generalPath);
        System.out.println("Path Length = " + pathLength.lengthOfPath());
        System.out.println("Point at 0 = " + pathLength.pointAtLength(0.0f));
        System.out.println("Point at 10 = " + pathLength.pointAtLength(10.0f));
        System.out.println("Point at 20 = " + pathLength.pointAtLength(20.0f));
        System.out.println("Point at 300 = " + pathLength.pointAtLength(300.0f));
        generalPath = new GeneralPath();
        generalPath.moveTo(100.0f, 100.0f);
        generalPath.lineTo(200.0f, 150.0f);
        generalPath.quadTo(450.0f, 525.0f, 400.0f, 250.0f);
        generalPath.lineTo(300.0f, 200.0f);
        generalPath.closePath();
        pathLength = new PathLength(generalPath);
        System.out.println("Path Length = " + pathLength.lengthOfPath());
        System.out.println("Point at 3000 = " + pathLength.pointAtLength(3000.0f));
        System.out.println("Point at 300 = " + pathLength.pointAtLength(300.0f));
        System.out.println("Point at 10 = " + pathLength.pointAtLength(10.0f));
        System.out.println("Point at 0 = " + pathLength.pointAtLength(0.0f));
    }

    protected class PathSegment {
        int segType;
        float X;
        float Y;
        float length;

        public PathSegment(int n, float f2, float f3, float f4) {
            this.setSegType(n);
            this.setX(f2);
            this.setY(f3);
            this.setLength(f4);
        }

        public int getSegType() {
            return this.segType;
        }

        public void setSegType(int n) {
            this.segType = n;
        }

        public float getX() {
            return this.X;
        }

        public void setX(float f2) {
            this.X = f2;
        }

        public float getY() {
            return this.Y;
        }

        public void setY(float f2) {
            this.Y = f2;
        }

        public float getLength() {
            return this.length;
        }

        public void setLength(float f2) {
            this.length = f2;
        }
    }
}

