/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt;

import java.awt.Color;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.ColorModel;
import org.apache.batik.ext.awt.MultipleGradientPaint;
import org.apache.batik.ext.awt.MultipleGradientPaintContext;

final class LinearGradientPaintContext
extends MultipleGradientPaintContext {
    private float dgdX;
    private float dgdY;
    private float gc;
    private float pixSz;
    private static final int DEFAULT_IMPL = 1;
    private static final int ANTI_ALIAS_IMPL = 3;
    private int fillMethod;

    public LinearGradientPaintContext(ColorModel colorModel, Rectangle rectangle, Rectangle2D rectangle2D, AffineTransform affineTransform, RenderingHints renderingHints, Point2D point2D, Point2D point2D2, float[] fArray, Color[] colorArray, MultipleGradientPaint.CycleMethodEnum cycleMethodEnum, MultipleGradientPaint.ColorSpaceEnum colorSpaceEnum) throws NoninvertibleTransformException {
        super(colorModel, rectangle, rectangle2D, affineTransform, renderingHints, fArray, colorArray, cycleMethodEnum, colorSpaceEnum);
        Point2D.Float float_ = new Point2D.Float((float)point2D.getX(), (float)point2D.getY());
        Point2D.Float float_2 = new Point2D.Float((float)point2D2.getX(), (float)point2D2.getY());
        float f2 = float_2.x - float_.x;
        float f3 = float_2.y - float_.y;
        float f4 = f2 * f2 + f3 * f3;
        float f5 = f2 / f4;
        float f6 = f3 / f4;
        this.dgdX = this.a00 * f5 + this.a10 * f6;
        this.dgdY = this.a01 * f5 + this.a11 * f6;
        float f7 = Math.abs(this.dgdX);
        float f8 = Math.abs(this.dgdY);
        this.pixSz = f7 > f8 ? f7 : f8;
        this.gc = (this.a02 - float_.x) * f5 + (this.a12 - float_.y) * f6;
        Object object = renderingHints.get(RenderingHints.KEY_COLOR_RENDERING);
        Object object2 = renderingHints.get(RenderingHints.KEY_RENDERING);
        this.fillMethod = 1;
        if (cycleMethodEnum == MultipleGradientPaint.REPEAT || this.hasDiscontinuity) {
            if (object2 == RenderingHints.VALUE_RENDER_QUALITY) {
                this.fillMethod = 3;
            }
            if (object == RenderingHints.VALUE_COLOR_RENDER_SPEED) {
                this.fillMethod = 1;
            } else if (object == RenderingHints.VALUE_COLOR_RENDER_QUALITY) {
                this.fillMethod = 3;
            }
        }
    }

    protected void fillHardNoCycle(int[] nArray, int n, int n2, int n3, int n4, int n5, int n6) {
        float f2 = this.dgdX * (float)n3 + this.gc;
        for (int i = 0; i < n6; ++i) {
            int n7;
            int n8;
            float f3 = f2 + this.dgdY * (float)(n4 + i);
            int n9 = n + n5;
            if (this.dgdX == 0.0f) {
                if (f3 <= 0.0f) {
                    n8 = this.gradientUnderflow;
                } else if (f3 >= 1.0f) {
                    n8 = this.gradientOverflow;
                } else {
                    for (n7 = 0; n7 < this.gradientsLength - 1 && !(f3 < this.fractions[n7 + 1]); ++n7) {
                    }
                    float f4 = f3 - this.fractions[n7];
                    float f5 = f4 * 255.0f / this.normalizedIntervals[n7] + 0.5f;
                    n8 = this.gradients[n7][(int)f5];
                }
                while (n < n9) {
                    nArray[n++] = n8;
                }
            } else {
                int n10;
                int n11;
                int n12;
                int n13;
                double d2;
                int[] nArray2;
                float f6;
                int n14;
                int n15;
                int n16;
                float f7;
                float f8;
                if (this.dgdX >= 0.0f) {
                    f8 = (1.0f - f3) / this.dgdX;
                    f7 = (float)Math.ceil((0.0f - f3) / this.dgdX);
                    n16 = this.gradientUnderflow;
                    n15 = this.gradientOverflow;
                } else {
                    f8 = (0.0f - f3) / this.dgdX;
                    f7 = (float)Math.ceil((1.0f - f3) / this.dgdX);
                    n16 = this.gradientOverflow;
                    n15 = this.gradientUnderflow;
                }
                n8 = f8 > (float)n5 ? n5 : (int)f8;
                n7 = f7 > (float)n5 ? n5 : (int)f7;
                int n17 = n + n8;
                if (n7 > 0) {
                    n14 = n + n7;
                    while (n < n14) {
                        nArray[n++] = n16;
                    }
                    f3 += this.dgdX * (float)n7;
                }
                if (this.dgdX > 0.0f) {
                    for (n14 = 0; n14 < this.gradientsLength - 1 && !(f3 < this.fractions[n14 + 1]); ++n14) {
                    }
                    while (n < n17) {
                        f6 = f3 - this.fractions[n14];
                        nArray2 = this.gradients[n14];
                        d2 = Math.ceil((this.fractions[n14 + 1] - f3) / this.dgdX);
                        n13 = d2 > (double)n5 ? n5 : (int)d2;
                        n12 = n + n13;
                        if (n12 > n17) {
                            n12 = n17;
                        }
                        n11 = (int)(f6 * 255.0f / this.normalizedIntervals[n14] * 65536.0f) + 32768;
                        n10 = (int)(this.dgdX * 255.0f / this.normalizedIntervals[n14] * 65536.0f);
                        while (n < n12) {
                            nArray[n++] = nArray2[n11 >> 16];
                            n11 += n10;
                        }
                        f3 = (float)((double)f3 + (double)this.dgdX * d2);
                        ++n14;
                    }
                } else {
                    for (n14 = this.gradientsLength - 1; n14 > 0 && !(f3 > this.fractions[n14]); --n14) {
                    }
                    while (n < n17) {
                        f6 = f3 - this.fractions[n14];
                        nArray2 = this.gradients[n14];
                        d2 = Math.ceil(f6 / -this.dgdX);
                        n13 = d2 > (double)n5 ? n5 : (int)d2;
                        n12 = n + n13;
                        if (n12 > n17) {
                            n12 = n17;
                        }
                        n11 = (int)(f6 * 255.0f / this.normalizedIntervals[n14] * 65536.0f) + 32768;
                        n10 = (int)(this.dgdX * 255.0f / this.normalizedIntervals[n14] * 65536.0f);
                        while (n < n12) {
                            nArray[n++] = nArray2[n11 >> 16];
                            n11 += n10;
                        }
                        f3 = (float)((double)f3 + (double)this.dgdX * d2);
                        --n14;
                    }
                }
                while (n < n9) {
                    nArray[n++] = n15;
                }
            }
            n += n2;
        }
    }

    protected void fillSimpleNoCycle(int[] nArray, int n, int n2, int n3, int n4, int n5, int n6) {
        float f2 = this.dgdX * (float)n3 + this.gc;
        float f3 = this.dgdX * (float)this.fastGradientArraySize;
        int n7 = (int)(f3 * 65536.0f);
        int[] nArray2 = this.gradient;
        for (int i = 0; i < n6; ++i) {
            int n8;
            float f4 = f2 + this.dgdY * (float)(n4 + i);
            f4 *= (float)this.fastGradientArraySize;
            f4 = (float)((double)f4 + 0.5);
            int n9 = n + n5;
            float f5 = this.dgdX * (float)this.fastGradientArraySize * (float)n5;
            if (f5 < 0.0f) {
                f5 = -f5;
            }
            if ((double)f5 < 0.3) {
                n8 = f4 <= 0.0f ? this.gradientUnderflow : (f4 >= (float)this.fastGradientArraySize ? this.gradientOverflow : nArray2[(int)f4]);
                while (n < n9) {
                    nArray[n++] = n8;
                }
            } else {
                int n10;
                int n11;
                int n12;
                int n13;
                if (this.dgdX > 0.0f) {
                    n8 = (int)(((float)this.fastGradientArraySize - f4) / f3);
                    n13 = (int)Math.ceil(0.0f - f4 / f3);
                    n12 = this.gradientUnderflow;
                    n11 = this.gradientOverflow;
                } else {
                    n8 = (int)((0.0f - f4) / f3);
                    n13 = (int)Math.ceil(((float)this.fastGradientArraySize - f4) / f3);
                    n12 = this.gradientOverflow;
                    n11 = this.gradientUnderflow;
                }
                if (n8 > n5) {
                    n8 = n5;
                }
                int n14 = n + n8;
                if (n13 > 0) {
                    if (n13 > n5) {
                        n13 = n5;
                    }
                    n10 = n + n13;
                    while (n < n10) {
                        nArray[n++] = n12;
                    }
                    f4 += f3 * (float)n13;
                }
                n10 = (int)(f4 * 65536.0f);
                while (n < n14) {
                    nArray[n++] = nArray2[n10 >> 16];
                    n10 += n7;
                }
                while (n < n9) {
                    nArray[n++] = n11;
                }
            }
            n += n2;
        }
    }

    protected void fillSimpleRepeat(int[] nArray, int n, int n2, int n3, int n4, int n5, int n6) {
        float f2 = this.dgdX * (float)n3 + this.gc;
        float f3 = (this.dgdX - (float)((int)this.dgdX)) * (float)this.fastGradientArraySize;
        if (f3 < 0.0f) {
            f3 += (float)this.fastGradientArraySize;
        }
        int[] nArray2 = this.gradient;
        for (int i = 0; i < n6; ++i) {
            float f4 = f2 + this.dgdY * (float)(n4 + i);
            if ((f4 -= (float)((int)f4)) < 0.0f) {
                f4 += 1.0f;
            }
            f4 *= (float)this.fastGradientArraySize;
            f4 = (float)((double)f4 + 0.5);
            int n7 = n + n5;
            while (n < n7) {
                int n8 = (int)f4;
                if (n8 >= this.fastGradientArraySize) {
                    f4 -= (float)this.fastGradientArraySize;
                    n8 -= this.fastGradientArraySize;
                }
                nArray[n++] = nArray2[n8];
                f4 += f3;
            }
            n += n2;
        }
    }

    protected void fillSimpleReflect(int[] nArray, int n, int n2, int n3, int n4, int n5, int n6) {
        float f2 = this.dgdX * (float)n3 + this.gc;
        int[] nArray2 = this.gradient;
        for (int i = 0; i < n6; ++i) {
            float f3 = f2 + this.dgdY * (float)(n4 + i);
            f3 -= (float)(2 * (int)(f3 / 2.0f));
            float f4 = this.dgdX;
            if (f3 < 0.0f) {
                f3 = -f3;
                f4 = -f4;
            }
            if ((f4 -= 2.0f * ((float)((int)f4) / 2.0f)) < 0.0f) {
                f4 = (float)((double)f4 + 2.0);
            }
            int n7 = 2 * this.fastGradientArraySize;
            f3 *= (float)this.fastGradientArraySize;
            f3 = (float)((double)f3 + 0.5);
            f4 *= (float)this.fastGradientArraySize;
            int n8 = n + n5;
            while (n < n8) {
                int n9 = (int)f3;
                if (n9 >= n7) {
                    f3 -= (float)n7;
                    n9 -= n7;
                }
                nArray[n++] = n9 <= this.fastGradientArraySize ? nArray2[n9] : nArray2[n7 - n9];
                f3 += f4;
            }
            n += n2;
        }
    }

    protected void fillRaster(int[] nArray, int n, int n2, int n3, int n4, int n5, int n6) {
        float f2 = this.dgdX * (float)n3 + this.gc;
        if (this.fillMethod == 3) {
            for (int i = 0; i < n6; ++i) {
                float f3 = f2 + this.dgdY * (float)(n4 + i);
                int n7 = n + n5;
                while (n < n7) {
                    nArray[n++] = this.indexGradientAntiAlias(f3, this.pixSz);
                    f3 += this.dgdX;
                }
                n += n2;
            }
        } else if (!this.isSimpleLookup) {
            if (this.cycleMethod == MultipleGradientPaint.NO_CYCLE) {
                this.fillHardNoCycle(nArray, n, n2, n3, n4, n5, n6);
            } else {
                for (int i = 0; i < n6; ++i) {
                    float f4 = f2 + this.dgdY * (float)(n4 + i);
                    int n8 = n + n5;
                    while (n < n8) {
                        nArray[n++] = this.indexIntoGradientsArrays(f4);
                        f4 += this.dgdX;
                    }
                    n += n2;
                }
            }
        } else if (this.cycleMethod == MultipleGradientPaint.NO_CYCLE) {
            this.fillSimpleNoCycle(nArray, n, n2, n3, n4, n5, n6);
        } else if (this.cycleMethod == MultipleGradientPaint.REPEAT) {
            this.fillSimpleRepeat(nArray, n, n2, n3, n4, n5, n6);
        } else {
            this.fillSimpleReflect(nArray, n, n2, n3, n4, n5, n6);
        }
    }
}

