/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt;

import java.awt.Color;
import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.ColorModel;
import org.apache.batik.ext.awt.LinearGradientPaintContext;
import org.apache.batik.ext.awt.MultipleGradientPaint;

public final class LinearGradientPaint
extends MultipleGradientPaint {
    private Point2D start;
    private Point2D end;

    public LinearGradientPaint(float f2, float f3, float f4, float f5, float[] fArray, Color[] colorArray) {
        this(new Point2D.Float(f2, f3), new Point2D.Float(f4, f5), fArray, colorArray, NO_CYCLE, SRGB);
    }

    public LinearGradientPaint(float f2, float f3, float f4, float f5, float[] fArray, Color[] colorArray, MultipleGradientPaint.CycleMethodEnum cycleMethodEnum) {
        this(new Point2D.Float(f2, f3), new Point2D.Float(f4, f5), fArray, colorArray, cycleMethodEnum, SRGB);
    }

    public LinearGradientPaint(Point2D point2D, Point2D point2D2, float[] fArray, Color[] colorArray) {
        this(point2D, point2D2, fArray, colorArray, NO_CYCLE, SRGB);
    }

    public LinearGradientPaint(Point2D point2D, Point2D point2D2, float[] fArray, Color[] colorArray, MultipleGradientPaint.CycleMethodEnum cycleMethodEnum, MultipleGradientPaint.ColorSpaceEnum colorSpaceEnum) {
        this(point2D, point2D2, fArray, colorArray, cycleMethodEnum, colorSpaceEnum, new AffineTransform());
    }

    public LinearGradientPaint(Point2D point2D, Point2D point2D2, float[] fArray, Color[] colorArray, MultipleGradientPaint.CycleMethodEnum cycleMethodEnum, MultipleGradientPaint.ColorSpaceEnum colorSpaceEnum, AffineTransform affineTransform) {
        super(fArray, colorArray, cycleMethodEnum, colorSpaceEnum, affineTransform);
        if (point2D == null || point2D2 == null) {
            throw new NullPointerException("Start and end points must benon-null");
        }
        if (point2D.equals(point2D2)) {
            throw new IllegalArgumentException("Start point cannot equalendpoint");
        }
        this.start = (Point2D)point2D.clone();
        this.end = (Point2D)point2D2.clone();
    }

    public PaintContext createContext(ColorModel colorModel, Rectangle rectangle, Rectangle2D rectangle2D, AffineTransform affineTransform, RenderingHints renderingHints) {
        affineTransform = new AffineTransform(affineTransform);
        affineTransform.concatenate(this.gradientTransform);
        try {
            return new LinearGradientPaintContext(colorModel, rectangle, rectangle2D, affineTransform, renderingHints, this.start, this.end, this.fractions, this.getColors(), this.cycleMethod, this.colorSpace);
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            noninvertibleTransformException.printStackTrace();
            throw new IllegalArgumentException("transform should beinvertible");
        }
    }

    public Point2D getStartPoint() {
        return new Point2D.Double(this.start.getX(), this.start.getY());
    }

    public Point2D getEndPoint() {
        return new Point2D.Double(this.end.getX(), this.end.getY());
    }
}

