/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.dom.svg;

import java.awt.geom.AffineTransform;
import org.w3c.dom.svg.SVGMatrix;
import org.w3c.dom.svg.SVGTransform;

public abstract class AbstractSVGTransform
implements SVGTransform {
    protected short type = 0;
    protected AffineTransform affineTransform;
    protected float angle;
    protected float x;
    protected float y;

    protected abstract SVGMatrix createMatrix();

    protected AbstractSVGTransform() {
    }

    protected void setType(short s) {
        this.type = s;
    }

    protected float getX() {
        return this.x;
    }

    protected float getY() {
        return this.y;
    }

    public short getType() {
        return this.type;
    }

    public SVGMatrix getMatrix() {
        return this.createMatrix();
    }

    public float getAngle() {
        return this.angle;
    }

    public void setMatrix(SVGMatrix sVGMatrix) {
        this.type = 1;
        this.affineTransform = new AffineTransform(sVGMatrix.getA(), sVGMatrix.getB(), sVGMatrix.getC(), sVGMatrix.getD(), sVGMatrix.getE(), sVGMatrix.getF());
    }

    public void setTranslate(float f2, float f3) {
        this.type = (short)2;
        this.affineTransform = AffineTransform.getTranslateInstance(f2, f3);
    }

    public void setScale(float f2, float f3) {
        this.type = (short)3;
        this.affineTransform = AffineTransform.getScaleInstance(f2, f3);
    }

    public void setRotate(float f2, float f3, float f4) {
        this.type = (short)4;
        this.affineTransform = AffineTransform.getRotateInstance(Math.toRadians(f2), f3, f4);
        this.angle = f2;
        this.x = f3;
        this.y = f4;
    }

    public void setSkewX(float f2) {
        this.type = (short)5;
        this.affineTransform = new AffineTransform(1.0, Math.tan(Math.toRadians(f2)), 0.0, 1.0, 0.0, 0.0);
        this.angle = f2;
    }

    public void setSkewY(float f2) {
        this.type = (short)6;
        this.angle = f2;
        this.affineTransform = new AffineTransform(1.0, 0.0, Math.tan(Math.toRadians(f2)), 1.0, 0.0, 0.0);
    }
}

