/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.dom.svg;

import org.apache.batik.dom.svg.AbstractSVGList;
import org.apache.batik.dom.svg.AbstractSVGNumber;
import org.apache.batik.dom.svg.ListHandler;
import org.apache.batik.dom.svg.SVGItem;
import org.apache.batik.parser.NumberListHandler;
import org.apache.batik.parser.NumberListParser;
import org.apache.batik.parser.ParseException;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.svg.SVGException;
import org.w3c.dom.svg.SVGNumber;
import org.w3c.dom.svg.SVGNumberList;

public abstract class AbstractSVGNumberList
extends AbstractSVGList
implements SVGNumberList {
    public static final String SVG_NUMBER_LIST_SEPARATOR = " ";

    protected String getItemSeparator() {
        return SVG_NUMBER_LIST_SEPARATOR;
    }

    protected abstract SVGException createSVGException(short var1, String var2, Object[] var3);

    protected abstract Element getElement();

    protected AbstractSVGNumberList() {
    }

    public SVGNumber initialize(SVGNumber sVGNumber) throws DOMException, SVGException {
        return (SVGNumber)((Object)this.initializeImpl(sVGNumber));
    }

    public SVGNumber getItem(int n) throws DOMException {
        return (SVGNumber)((Object)this.getItemImpl(n));
    }

    public SVGNumber insertItemBefore(SVGNumber sVGNumber, int n) throws DOMException, SVGException {
        return (SVGNumber)((Object)this.insertItemBeforeImpl(sVGNumber, n));
    }

    public SVGNumber replaceItem(SVGNumber sVGNumber, int n) throws DOMException, SVGException {
        return (SVGNumber)((Object)this.replaceItemImpl(sVGNumber, n));
    }

    public SVGNumber removeItem(int n) throws DOMException {
        return (SVGNumber)((Object)this.removeItemImpl(n));
    }

    public SVGNumber appendItem(SVGNumber sVGNumber) throws DOMException, SVGException {
        return (SVGNumber)((Object)this.appendItemImpl(sVGNumber));
    }

    protected SVGItem createSVGItem(Object object) {
        SVGNumber sVGNumber = (SVGNumber)object;
        return new SVGNumberItem(sVGNumber.getValue());
    }

    protected void doParse(String string, ListHandler listHandler) throws ParseException {
        NumberListParser numberListParser = new NumberListParser();
        NumberListBuilder numberListBuilder = new NumberListBuilder(listHandler);
        numberListParser.setNumberListHandler(numberListBuilder);
        numberListParser.parse(string);
    }

    protected void checkItemType(Object object) throws SVGException {
        if (!(object instanceof SVGNumber)) {
            this.createSVGException((short)0, "expected SVGNumber", null);
        }
    }

    protected class NumberListBuilder
    implements NumberListHandler {
        protected ListHandler listHandler;
        protected float currentValue;

        public NumberListBuilder(ListHandler listHandler) {
            this.listHandler = listHandler;
        }

        public void startNumberList() throws ParseException {
            this.listHandler.startList();
        }

        public void startNumber() throws ParseException {
            this.currentValue = 0.0f;
        }

        public void numberValue(float f2) throws ParseException {
            this.currentValue = f2;
        }

        public void endNumber() throws ParseException {
            this.listHandler.item(new SVGNumberItem(this.currentValue));
        }

        public void endNumberList() throws ParseException {
            this.listHandler.endList();
        }
    }

    protected class SVGNumberItem
    extends AbstractSVGNumber
    implements SVGItem {
        protected AbstractSVGList parentList;

        public SVGNumberItem(float f2) {
            this.value = f2;
        }

        public String getValueAsString() {
            return Float.toString(this.value);
        }

        public void setParent(AbstractSVGList abstractSVGList) {
            this.parentList = abstractSVGList;
        }

        public AbstractSVGList getParent() {
            return this.parentList;
        }

        protected void reset() {
            if (this.parentList != null) {
                this.parentList.itemChanged();
            }
        }
    }
}

