/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.css.parser;

import org.w3c.css.sac.LexicalUnit;

public abstract class CSSLexicalUnit
implements LexicalUnit {
    public static final String UNIT_TEXT_CENTIMETER = "cm";
    public static final String UNIT_TEXT_DEGREE = "deg";
    public static final String UNIT_TEXT_EM = "em";
    public static final String UNIT_TEXT_EX = "ex";
    public static final String UNIT_TEXT_GRADIAN = "grad";
    public static final String UNIT_TEXT_HERTZ = "Hz";
    public static final String UNIT_TEXT_INCH = "in";
    public static final String UNIT_TEXT_KILOHERTZ = "kHz";
    public static final String UNIT_TEXT_MILLIMETER = "mm";
    public static final String UNIT_TEXT_MILLISECOND = "ms";
    public static final String UNIT_TEXT_PERCENTAGE = "%";
    public static final String UNIT_TEXT_PICA = "pc";
    public static final String UNIT_TEXT_PIXEL = "px";
    public static final String UNIT_TEXT_POINT = "pt";
    public static final String UNIT_TEXT_RADIAN = "rad";
    public static final String UNIT_TEXT_REAL = "";
    public static final String UNIT_TEXT_SECOND = "s";
    public static final String UNIT_TEXT_DPI = "dpi";
    public static final String UNIT_TEXT_DPCM = "dpcm";
    protected short lexicalUnitType;
    protected LexicalUnit nextLexicalUnit;
    protected LexicalUnit previousLexicalUnit;
    protected int lineNumber;

    protected CSSLexicalUnit(short s, LexicalUnit lexicalUnit, int n) {
        this.lexicalUnitType = s;
        this.previousLexicalUnit = lexicalUnit;
        if (lexicalUnit != null) {
            ((CSSLexicalUnit)lexicalUnit).nextLexicalUnit = this;
        }
        this.lineNumber = n;
    }

    public short getLexicalUnitType() {
        return this.lexicalUnitType;
    }

    public LexicalUnit getNextLexicalUnit() {
        return this.nextLexicalUnit;
    }

    public void setNextLexicalUnit(LexicalUnit lexicalUnit) {
        this.nextLexicalUnit = lexicalUnit;
    }

    public LexicalUnit getPreviousLexicalUnit() {
        return this.previousLexicalUnit;
    }

    public void setPreviousLexicalUnit(LexicalUnit lexicalUnit) {
        this.previousLexicalUnit = lexicalUnit;
    }

    public int getIntegerValue() {
        throw new IllegalStateException();
    }

    public float getFloatValue() {
        throw new IllegalStateException();
    }

    public String getDimensionUnitText() {
        switch (this.lexicalUnitType) {
            case 19: {
                return UNIT_TEXT_CENTIMETER;
            }
            case 28: {
                return UNIT_TEXT_DEGREE;
            }
            case 43: {
                return UNIT_TEXT_DPI;
            }
            case 44: {
                return UNIT_TEXT_DPCM;
            }
            case 15: {
                return UNIT_TEXT_EM;
            }
            case 16: {
                return UNIT_TEXT_EX;
            }
            case 29: {
                return UNIT_TEXT_GRADIAN;
            }
            case 33: {
                return UNIT_TEXT_HERTZ;
            }
            case 18: {
                return UNIT_TEXT_INCH;
            }
            case 34: {
                return UNIT_TEXT_KILOHERTZ;
            }
            case 20: {
                return UNIT_TEXT_MILLIMETER;
            }
            case 31: {
                return UNIT_TEXT_MILLISECOND;
            }
            case 23: {
                return UNIT_TEXT_PERCENTAGE;
            }
            case 22: {
                return UNIT_TEXT_PICA;
            }
            case 17: {
                return UNIT_TEXT_PIXEL;
            }
            case 21: {
                return UNIT_TEXT_POINT;
            }
            case 30: {
                return UNIT_TEXT_RADIAN;
            }
            case 14: {
                return UNIT_TEXT_REAL;
            }
            case 32: {
                return UNIT_TEXT_SECOND;
            }
        }
        throw new IllegalStateException("No Unit Text for type: " + this.lexicalUnitType);
    }

    public String getFunctionName() {
        throw new IllegalStateException();
    }

    public LexicalUnit getParameters() {
        throw new IllegalStateException();
    }

    public String getStringValue() {
        throw new IllegalStateException();
    }

    public LexicalUnit getSubValues() {
        throw new IllegalStateException();
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public static CSSLexicalUnit createSimple(short s, LexicalUnit lexicalUnit) {
        return new SimpleLexicalUnit(s, lexicalUnit, -1);
    }

    public static CSSLexicalUnit createSimple(short s, LexicalUnit lexicalUnit, int n) {
        return new SimpleLexicalUnit(s, lexicalUnit, n);
    }

    public static CSSLexicalUnit createInteger(int n, LexicalUnit lexicalUnit) {
        return new IntegerLexicalUnit(n, lexicalUnit, -1);
    }

    public static CSSLexicalUnit createInteger(int n, LexicalUnit lexicalUnit, int n2) {
        return new IntegerLexicalUnit(n, lexicalUnit, n2);
    }

    public static CSSLexicalUnit createFloat(short s, float f2, LexicalUnit lexicalUnit) {
        return new FloatLexicalUnit(s, f2, lexicalUnit, -1);
    }

    public static CSSLexicalUnit createFloat(short s, float f2, LexicalUnit lexicalUnit, int n) {
        return new FloatLexicalUnit(s, f2, lexicalUnit, n);
    }

    public static CSSLexicalUnit createDimension(float f2, String string, LexicalUnit lexicalUnit) {
        return new DimensionLexicalUnit(f2, string, lexicalUnit, -1);
    }

    public static CSSLexicalUnit createDimension(float f2, String string, LexicalUnit lexicalUnit, int n) {
        return new DimensionLexicalUnit(f2, string, lexicalUnit, n);
    }

    public static CSSLexicalUnit createFunction(String string, LexicalUnit lexicalUnit, LexicalUnit lexicalUnit2) {
        return new FunctionLexicalUnit(string, lexicalUnit, lexicalUnit2, -1);
    }

    public static CSSLexicalUnit createFunction(String string, LexicalUnit lexicalUnit, LexicalUnit lexicalUnit2, int n) {
        return new FunctionLexicalUnit(string, lexicalUnit, lexicalUnit2, n);
    }

    public static CSSLexicalUnit createPredefinedFunction(short s, LexicalUnit lexicalUnit, LexicalUnit lexicalUnit2) {
        return new PredefinedFunctionLexicalUnit(s, lexicalUnit, lexicalUnit2, -1);
    }

    public static CSSLexicalUnit createPredefinedFunction(short s, LexicalUnit lexicalUnit, LexicalUnit lexicalUnit2, int n) {
        return new PredefinedFunctionLexicalUnit(s, lexicalUnit, lexicalUnit2, n);
    }

    public static CSSLexicalUnit createString(short s, String string, LexicalUnit lexicalUnit) {
        return new StringLexicalUnit(s, string, lexicalUnit, -1);
    }

    public static CSSLexicalUnit createString(short s, String string, LexicalUnit lexicalUnit, int n) {
        return new StringLexicalUnit(s, string, lexicalUnit, n);
    }

    public abstract void appendToStringBuffer(StringBuffer var1);

    protected void appendNextToStringBuffer(StringBuffer stringBuffer) {
        if (this.nextLexicalUnit != null) {
            stringBuffer.append(' ');
            ((CSSLexicalUnit)this.nextLexicalUnit).appendToStringBuffer(stringBuffer);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        this.appendToStringBuffer(stringBuffer);
        return stringBuffer.toString();
    }

    protected static class StringLexicalUnit
    extends CSSLexicalUnit {
        protected String value;

        public StringLexicalUnit(short s, String string, LexicalUnit lexicalUnit, int n) {
            super(s, lexicalUnit, n);
            this.value = string;
        }

        public String getStringValue() {
            return this.value;
        }

        public void appendToStringBuffer(StringBuffer stringBuffer) {
            stringBuffer.append('\"');
            stringBuffer.append(this.value.replace('\"', '\''));
            stringBuffer.append('\"');
            this.appendNextToStringBuffer(stringBuffer);
        }
    }

    protected static class PredefinedFunctionLexicalUnit
    extends CSSLexicalUnit {
        protected LexicalUnit parameters;

        public PredefinedFunctionLexicalUnit(short s, LexicalUnit lexicalUnit, LexicalUnit lexicalUnit2, int n) {
            super(s, lexicalUnit2, n);
            this.parameters = lexicalUnit;
        }

        public LexicalUnit getParameters() {
            return this.parameters;
        }

        private String getName() {
            switch (this.getLexicalUnitType()) {
                case 25: {
                    return "counter";
                }
                case 26: {
                    return "counters";
                }
                case 27: {
                    return "rgb";
                }
                case 38: {
                    return "rect";
                }
            }
            throw new Error("Internal CSS parser error!");
        }

        public void appendToStringBuffer(StringBuffer stringBuffer) {
            stringBuffer.append(this.getName());
            stringBuffer.append('(');
            ((CSSLexicalUnit)this.parameters).appendToStringBuffer(stringBuffer);
            stringBuffer.append(')');
            this.appendNextToStringBuffer(stringBuffer);
        }
    }

    protected static class FunctionLexicalUnit
    extends CSSLexicalUnit {
        protected String name;
        protected LexicalUnit parameters;

        public FunctionLexicalUnit(String string, LexicalUnit lexicalUnit, LexicalUnit lexicalUnit2, int n) {
            super((short)41, lexicalUnit2, n);
            this.name = string;
            this.parameters = lexicalUnit;
        }

        public String getFunctionName() {
            return this.name;
        }

        public LexicalUnit getParameters() {
            return this.parameters;
        }

        public void appendToStringBuffer(StringBuffer stringBuffer) {
            stringBuffer.append(this.name);
            stringBuffer.append('(');
            ((CSSLexicalUnit)this.parameters).appendToStringBuffer(stringBuffer);
            stringBuffer.append(')');
            this.appendNextToStringBuffer(stringBuffer);
        }
    }

    protected static class DimensionLexicalUnit
    extends CSSLexicalUnit {
        protected float value;
        protected String dimension;

        public DimensionLexicalUnit(float f2, String string, LexicalUnit lexicalUnit, int n) {
            super((short)42, lexicalUnit, n);
            this.value = f2;
            this.dimension = string;
        }

        public float getFloatValue() {
            return this.value;
        }

        public String getDimensionUnitText() {
            return this.dimension;
        }

        public void appendToStringBuffer(StringBuffer stringBuffer) {
            stringBuffer.append(this.value);
            stringBuffer.append(this.dimension);
            this.appendNextToStringBuffer(stringBuffer);
        }
    }

    protected static class FloatLexicalUnit
    extends CSSLexicalUnit {
        protected float value;

        public FloatLexicalUnit(short s, float f2, LexicalUnit lexicalUnit, int n) {
            super(s, lexicalUnit, n);
            this.value = f2;
        }

        public float getFloatValue() {
            return this.value;
        }

        public void appendToStringBuffer(StringBuffer stringBuffer) {
            stringBuffer.append(this.value);
            this.appendNextToStringBuffer(stringBuffer);
            stringBuffer.append(this.getDimensionUnitText());
        }
    }

    protected static class IntegerLexicalUnit
    extends CSSLexicalUnit {
        protected int value;

        public IntegerLexicalUnit(int n, LexicalUnit lexicalUnit, int n2) {
            super((short)13, lexicalUnit, n2);
            this.value = n;
        }

        public int getIntegerValue() {
            return this.value;
        }

        public void appendToStringBuffer(StringBuffer stringBuffer) {
            stringBuffer.append(this.value);
            this.appendNextToStringBuffer(stringBuffer);
        }
    }

    protected static class SimpleLexicalUnit
    extends CSSLexicalUnit {
        public SimpleLexicalUnit(short s, LexicalUnit lexicalUnit, int n) {
            super(s, lexicalUnit, n);
            if (s != 0 && s != 4 && s != 12) {
                throw new Error("Internal CSS parser error!");
            }
        }

        public void appendToStringBuffer(StringBuffer stringBuffer) {
            switch (this.getLexicalUnitType()) {
                case 0: {
                    stringBuffer.append(',');
                    break;
                }
                case 4: {
                    stringBuffer.append('/');
                    break;
                }
                case 12: {
                    stringBuffer.append("inherit");
                    if (this.nextLexicalUnit == null) break;
                    stringBuffer.append(" ");
                }
            }
            if (this.nextLexicalUnit != null) {
                ((CSSLexicalUnit)this.nextLexicalUnit).appendToStringBuffer(stringBuffer);
            }
        }
    }
}

