/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.css.engine.value.css2;

import org.apache.batik.css.engine.CSSEngine;
import org.apache.batik.css.engine.value.AbstractValueManager;
import org.apache.batik.css.engine.value.FloatValue;
import org.apache.batik.css.engine.value.Value;
import org.apache.batik.css.engine.value.ValueConstants;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.dom.DOMException;

public class FontSizeAdjustManager
extends AbstractValueManager {
    public boolean isInheritedProperty() {
        return true;
    }

    public String getPropertyName() {
        return "font-size-adjust";
    }

    public Value getDefaultValue() {
        return ValueConstants.NONE_VALUE;
    }

    public Value createValue(LexicalUnit lexicalUnit, CSSEngine cSSEngine) throws DOMException {
        switch (lexicalUnit.getLexicalUnitType()) {
            case 12: {
                return ValueConstants.INHERIT_VALUE;
            }
            case 13: {
                return new FloatValue(1, lexicalUnit.getIntegerValue());
            }
            case 14: {
                return new FloatValue(1, lexicalUnit.getFloatValue());
            }
            case 35: {
                if (lexicalUnit.getStringValue().equalsIgnoreCase("none")) {
                    return ValueConstants.NONE_VALUE;
                }
                throw this.createInvalidIdentifierDOMException(lexicalUnit.getStringValue());
            }
        }
        throw this.createInvalidLexicalUnitDOMException(lexicalUnit.getLexicalUnitType());
    }

    public Value createStringValue(short s, String string, CSSEngine cSSEngine) throws DOMException {
        if (s != 21) {
            throw this.createInvalidStringTypeDOMException(s);
        }
        if (string.equalsIgnoreCase("none")) {
            return ValueConstants.NONE_VALUE;
        }
        throw this.createInvalidIdentifierDOMException(string);
    }

    public Value createFloatValue(short s, float f2) throws DOMException {
        if (s == 1) {
            return new FloatValue(s, f2);
        }
        throw this.createInvalidFloatTypeDOMException(s);
    }
}

