/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.css.engine.value;

import java.net.URL;
import org.apache.batik.css.engine.value.Messages;
import org.apache.batik.util.ParsedURL;
import org.w3c.dom.DOMException;

public abstract class AbstractValueFactory {
    public abstract String getPropertyName();

    protected static String resolveURI(URL uRL, String string) {
        return new ParsedURL(uRL, string).toString();
    }

    protected DOMException createInvalidIdentifierDOMException(String string) {
        Object[] objectArray = new Object[]{this.getPropertyName(), string};
        String string2 = Messages.formatMessage("invalid.identifier", objectArray);
        return new DOMException(12, string2);
    }

    protected DOMException createInvalidLexicalUnitDOMException(short s) {
        Object[] objectArray = new Object[]{this.getPropertyName(), new Integer(s)};
        String string = Messages.formatMessage("invalid.lexical.unit", objectArray);
        return new DOMException(9, string);
    }

    protected DOMException createInvalidFloatTypeDOMException(short s) {
        Object[] objectArray = new Object[]{this.getPropertyName(), new Integer(s)};
        String string = Messages.formatMessage("invalid.float.type", objectArray);
        return new DOMException(15, string);
    }

    protected DOMException createInvalidFloatValueDOMException(float f2) {
        Object[] objectArray = new Object[]{this.getPropertyName(), new Float(f2)};
        String string = Messages.formatMessage("invalid.float.value", objectArray);
        return new DOMException(15, string);
    }

    protected DOMException createInvalidStringTypeDOMException(short s) {
        Object[] objectArray = new Object[]{this.getPropertyName(), new Integer(s)};
        String string = Messages.formatMessage("invalid.string.type", objectArray);
        return new DOMException(15, string);
    }

    protected DOMException createMalformedLexicalUnitDOMException() {
        Object[] objectArray = new Object[]{this.getPropertyName()};
        String string = Messages.formatMessage("malformed.lexical.unit", objectArray);
        return new DOMException(15, string);
    }

    protected DOMException createDOMException() {
        Object[] objectArray = new Object[]{this.getPropertyName()};
        String string = Messages.formatMessage("invalid.access", objectArray);
        return new DOMException(9, string);
    }
}

