/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge.svg12;

import java.awt.Shape;
import java.awt.font.TextAttribute;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.batik.bridge.Bridge;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.CSSUtilities;
import org.apache.batik.bridge.GVTBuilder;
import org.apache.batik.bridge.SVGAElementBridge;
import org.apache.batik.bridge.SVGTextElementBridge;
import org.apache.batik.bridge.SVGUtilities;
import org.apache.batik.bridge.TextUtilities;
import org.apache.batik.bridge.UserAgent;
import org.apache.batik.css.engine.CSSEngine;
import org.apache.batik.css.engine.value.ComputedValue;
import org.apache.batik.css.engine.value.Value;
import org.apache.batik.css.engine.value.ValueConstants;
import org.apache.batik.css.engine.value.svg12.LineHeightValue;
import org.apache.batik.css.engine.value.svg12.SVG12ValueConstants;
import org.apache.batik.dom.util.XLinkSupport;
import org.apache.batik.dom.util.XMLSupport;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.gvt.flow.BlockInfo;
import org.apache.batik.gvt.flow.FlowTextNode;
import org.apache.batik.gvt.flow.RegionInfo;
import org.apache.batik.gvt.flow.TextLineBreaks;
import org.apache.batik.gvt.text.GVTAttributedCharacterIterator;
import org.apache.batik.gvt.text.TextPath;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.events.EventTarget;

public class SVGFlowRootElementBridge
extends SVGTextElementBridge {
    public static final AttributedCharacterIterator.Attribute FLOW_PARAGRAPH = GVTAttributedCharacterIterator.TextAttribute.FLOW_PARAGRAPH;
    public static final AttributedCharacterIterator.Attribute FLOW_EMPTY_PARAGRAPH = GVTAttributedCharacterIterator.TextAttribute.FLOW_EMPTY_PARAGRAPH;
    public static final AttributedCharacterIterator.Attribute FLOW_LINE_BREAK = GVTAttributedCharacterIterator.TextAttribute.FLOW_LINE_BREAK;
    public static final AttributedCharacterIterator.Attribute FLOW_REGIONS = GVTAttributedCharacterIterator.TextAttribute.FLOW_REGIONS;
    public static final AttributedCharacterIterator.Attribute LINE_HEIGHT = GVTAttributedCharacterIterator.TextAttribute.LINE_HEIGHT;
    protected int startLen;
    protected static final GVTAttributedCharacterIterator.TextAttribute TEXTPATH = GVTAttributedCharacterIterator.TextAttribute.TEXTPATH;
    protected static final GVTAttributedCharacterIterator.TextAttribute ANCHOR_TYPE = GVTAttributedCharacterIterator.TextAttribute.ANCHOR_TYPE;
    protected static final GVTAttributedCharacterIterator.TextAttribute LETTER_SPACING = GVTAttributedCharacterIterator.TextAttribute.LETTER_SPACING;
    protected static final GVTAttributedCharacterIterator.TextAttribute WORD_SPACING = GVTAttributedCharacterIterator.TextAttribute.WORD_SPACING;
    protected static final GVTAttributedCharacterIterator.TextAttribute KERNING = GVTAttributedCharacterIterator.TextAttribute.KERNING;
    int marginTopIndex = -1;
    int marginRightIndex = -1;
    int marginBottomIndex = -1;
    int marginLeftIndex = -1;
    int indentIndex = -1;
    int textAlignIndex = -1;
    int lineHeightIndex = -1;

    public String getNamespaceURI() {
        return "http://www.w3.org/2000/svg";
    }

    public String getLocalName() {
        return "flowRoot";
    }

    public Bridge getInstance() {
        return new SVGFlowRootElementBridge();
    }

    public boolean isComposite() {
        return false;
    }

    protected GraphicsNode instantiateGraphicsNode() {
        return new FlowTextNode();
    }

    protected Point2D getLocation(BridgeContext bridgeContext, Element element) {
        return new Point2D.Float(0.0f, 0.0f);
    }

    protected boolean isTextElement(Element element) {
        if (!"http://www.w3.org/2000/svg".equals(element.getNamespaceURI())) {
            return false;
        }
        String string = element.getLocalName();
        return string.equals("flowDiv") || string.equals("flowLine") || string.equals("flowPara") || string.equals("flowRegionBreak") || string.equals("flowSpan");
    }

    protected boolean isTextChild(Element element) {
        if (!"http://www.w3.org/2000/svg".equals(element.getNamespaceURI())) {
            return false;
        }
        String string = element.getLocalName();
        return string.equals("a") || string.equals("flowLine") || string.equals("flowPara") || string.equals("flowRegionBreak") || string.equals("flowSpan");
    }

    protected void computeLaidoutText(BridgeContext bridgeContext, Element element, GraphicsNode graphicsNode) {
        super.computeLaidoutText(bridgeContext, this.getFlowDivElement(element), graphicsNode);
    }

    protected AttributedString buildAttributedString(BridgeContext bridgeContext, Element element) {
        List list = this.getRegions(bridgeContext, element);
        AttributedString attributedString = this.getFlowDiv(bridgeContext, element);
        attributedString.addAttribute(FLOW_REGIONS, list, 0, 1);
        TextLineBreaks.findLineBrk(attributedString);
        return attributedString;
    }

    protected void dumpACIWord(AttributedString attributedString) {
        String string = "";
        String string2 = "";
        AttributedCharacterIterator attributedCharacterIterator = attributedString.getIterator();
        AttributedCharacterIterator.Attribute attribute = TextLineBreaks.WORD_LIMIT;
        char c2 = attributedCharacterIterator.current();
        while (c2 != '\uffff') {
            string = string + c2 + "  ";
            int n = (Integer)attributedCharacterIterator.getAttribute(attribute);
            string2 = n >= 10 ? string2 + "" + n + " " : string2 + "" + n + "  ";
            c2 = attributedCharacterIterator.next();
        }
        System.out.println(string);
        System.out.println(string2);
    }

    protected Element getFlowDivElement(Element element) {
        String string = element.getNamespaceURI();
        if (!string.equals("http://www.w3.org/2000/svg")) {
            return null;
        }
        String string2 = element.getLocalName();
        if (string2.equals("flowDiv")) {
            return element;
        }
        if (!string2.equals("flowRoot")) {
            return null;
        }
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            Element element2;
            String string3;
            String string4;
            if (node.getNodeType() != 1 || !"http://www.w3.org/2000/svg".equals(string4 = node.getNamespaceURI()) || !(string3 = (element2 = (Element)node).getLocalName()).equals("flowDiv")) continue;
            return element2;
        }
        return null;
    }

    protected AttributedString getFlowDiv(BridgeContext bridgeContext, Element element) {
        Element element2 = this.getFlowDivElement(element);
        if (element2 == null) {
            return null;
        }
        return this.gatherFlowPara(bridgeContext, element2);
    }

    protected AttributedString gatherFlowPara(BridgeContext bridgeContext, Element element) {
        int n;
        Object object;
        Object object2;
        SVGTextElementBridge.AttributedStringBuffer attributedStringBuffer = new SVGTextElementBridge.AttributedStringBuffer();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        ArrayList<Element> arrayList2 = new ArrayList<Element>();
        ArrayList arrayList3 = new ArrayList();
        for (object2 = element.getFirstChild(); object2 != null; object2 = object2.getNextSibling()) {
            if (object2.getNodeType() != 1 || !this.getNamespaceURI().equals(object2.getNamespaceURI())) continue;
            Element element2 = (Element)object2;
            object = element2.getLocalName();
            if (((String)object).equals("flowPara")) {
                this.fillAttributedStringBuffer(bridgeContext, element2, true, null, attributedStringBuffer, arrayList3);
                arrayList2.add(element2);
                arrayList.add(new Integer(attributedStringBuffer.length()));
                continue;
            }
            if (!((String)object).equals("flowRegionBreak")) continue;
            this.fillAttributedStringBuffer(bridgeContext, element2, true, null, attributedStringBuffer, arrayList3);
            arrayList2.add(element2);
            arrayList.add(new Integer(attributedStringBuffer.length()));
        }
        object2 = attributedStringBuffer.toAttributedString();
        int n2 = 0;
        object = arrayList3.iterator();
        while (object.hasNext()) {
            n = (Integer)object.next();
            if (n == n2) continue;
            ((AttributedString)object2).addAttribute(FLOW_LINE_BREAK, new Object(), n2, n);
            n2 = n;
        }
        n = 0;
        LinkedList<BlockInfo> linkedList = null;
        for (int i = 0; i < arrayList2.size(); ++i) {
            Element element3 = (Element)arrayList2.get(i);
            int n3 = (Integer)arrayList.get(i);
            if (n == n3) {
                if (linkedList == null) {
                    linkedList = new LinkedList<BlockInfo>();
                }
                linkedList.add(this.makeBlockInfo(bridgeContext, element3));
            } else {
                ((AttributedString)object2).addAttribute(FLOW_PARAGRAPH, this.makeBlockInfo(bridgeContext, element3), n, n3);
                if (linkedList != null) {
                    ((AttributedString)object2).addAttribute(FLOW_EMPTY_PARAGRAPH, linkedList, n, n3);
                    linkedList = null;
                }
            }
            n = n3;
        }
        return object2;
    }

    protected List getRegions(BridgeContext bridgeContext, Element element) {
        element = (Element)element.getParentNode();
        LinkedList linkedList = new LinkedList();
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            Element element2;
            String string;
            if (node.getNodeType() != 1 || !"http://www.w3.org/2000/svg".equals(node.getNamespaceURI()) || !"flowRegion".equals(string = (element2 = (Element)node).getLocalName())) continue;
            float f2 = 0.0f;
            this.gatherRegionInfo(bridgeContext, element2, f2, linkedList);
        }
        return linkedList;
    }

    protected void gatherRegionInfo(BridgeContext bridgeContext, Element element, float f2, List list) {
        GVTBuilder gVTBuilder = bridgeContext.getGVTBuilder();
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            Shape shape;
            Element element2;
            GraphicsNode graphicsNode;
            if (node.getNodeType() != 1 || !this.getNamespaceURI().equals(node.getNamespaceURI()) || (graphicsNode = gVTBuilder.build(bridgeContext, element2 = (Element)node)) == null || (shape = graphicsNode.getOutline()) == null) continue;
            AffineTransform affineTransform = graphicsNode.getTransform();
            if (affineTransform != null) {
                shape = affineTransform.createTransformedShape(shape);
            }
            list.add(new RegionInfo(shape, f2));
        }
    }

    protected void fillAttributedStringBuffer(BridgeContext bridgeContext, Element element, boolean bl, Integer n, SVGTextElementBridge.AttributedStringBuffer attributedStringBuffer, List list) {
        int n2;
        if (!SVGUtilities.matchUserAgent(element, bridgeContext.getUserAgent()) || !CSSUtilities.convertDisplay(element)) {
            return;
        }
        String string = XMLSupport.getXMLSpace(element);
        boolean bl2 = string.equals("preserve");
        Element element2 = element;
        if (bl) {
            this.endLimit = this.startLen = attributedStringBuffer.length();
        }
        if (bl2) {
            this.endLimit = this.startLen;
        }
        Map map = this.getAttributeMap(bridgeContext, element, null, n);
        Object v = map.get(TextAttribute.BIDI_EMBEDDING);
        Integer n3 = n;
        if (v != null) {
            n3 = (Integer)v;
        }
        int n4 = -1;
        if (list.size() != 0) {
            n4 = (Integer)list.get(list.size() - 1);
        }
        block4: for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            Object object;
            boolean bl3;
            if (bl2) {
                bl3 = false;
            } else {
                n2 = attributedStringBuffer.length();
                if (n2 == this.startLen) {
                    bl3 = true;
                } else {
                    bl3 = attributedStringBuffer.getLastChar() == 32;
                    int n5 = list.size() - 1;
                    if (!bl3 && n5 >= 0 && (Integer)(object = (Integer)list.get(n5)) == n2) {
                        bl3 = true;
                    }
                }
            }
            switch (node.getNodeType()) {
                case 1: {
                    if (!"http://www.w3.org/2000/svg".equals(node.getNamespaceURI())) continue block4;
                    element2 = (Element)node;
                    String string2 = node.getLocalName();
                    if (string2.equals("flowLine")) {
                        this.fillAttributedStringBuffer(bridgeContext, element2, false, n3, attributedStringBuffer, list);
                        n4 = attributedStringBuffer.length();
                        list.add(new Integer(n4));
                        continue block4;
                    }
                    if (string2.equals("flowSpan") || string2.equals("altGlyph")) {
                        this.fillAttributedStringBuffer(bridgeContext, element2, false, n3, attributedStringBuffer, list);
                        continue block4;
                    }
                    if (string2.equals("a")) {
                        if (bridgeContext.isInteractive()) {
                            EventTarget eventTarget = (EventTarget)((Object)element2);
                            object = bridgeContext.getUserAgent();
                            eventTarget.addEventListener("click", new SVGAElementBridge.AnchorListener((UserAgent)object), false);
                            eventTarget.addEventListener("mouseover", new SVGAElementBridge.CursorMouseOverListener((UserAgent)object), false);
                            eventTarget.addEventListener("mouseout", new SVGAElementBridge.CursorMouseOutListener((UserAgent)object), false);
                        }
                        this.fillAttributedStringBuffer(bridgeContext, element2, false, n3, attributedStringBuffer, list);
                        continue block4;
                    }
                    if (!string2.equals("tref")) continue block4;
                    String string3 = XLinkSupport.getXLinkHref((Element)node);
                    object = bridgeContext.getReferencedElement((Element)node, string3);
                    string = TextUtilities.getElementContent((Element)object);
                    if ((string = this.normalizeString(string, bl2, bl3)) == null) continue block4;
                    Map map2 = this.getAttributeMap(bridgeContext, element2, null, n);
                    attributedStringBuffer.append(string, map2);
                    continue block4;
                }
                case 3: 
                case 4: {
                    string = node.getNodeValue();
                    string = this.normalizeString(string, bl2, bl3);
                    attributedStringBuffer.append(string, map);
                    if (!bl2) continue block4;
                    this.endLimit = attributedStringBuffer.length();
                }
            }
        }
        if (bl) {
            while (this.endLimit < attributedStringBuffer.length() && attributedStringBuffer.getLastChar() == 32) {
                Integer n6;
                int n7 = list.size() - 1;
                n2 = attributedStringBuffer.length();
                if (n7 >= 0 && (n6 = (Integer)list.get(n7)) >= n2) {
                    n6 = new Integer(n2 - 1);
                    list.set(n7, n6);
                    --n7;
                    while (n7 >= 0 && (n6 = (Integer)list.get(n7)) >= n2 - 1) {
                        list.remove(n7);
                        --n7;
                    }
                }
                attributedStringBuffer.stripLast();
            }
        }
    }

    protected Map getAttributeMap(BridgeContext bridgeContext, Element element, TextPath textPath, Integer n) {
        Map map = super.getAttributeMap(bridgeContext, element, textPath, n);
        float f2 = TextUtilities.convertFontSize(element).floatValue();
        float f3 = this.getLineHeight(bridgeContext, element, f2);
        map.put(LINE_HEIGHT, new Float(f3));
        return map;
    }

    protected void checkMap(Map map) {
        if (map.containsKey(TEXTPATH)) {
            return;
        }
        if (map.containsKey(ANCHOR_TYPE)) {
            return;
        }
        if (map.containsKey(LETTER_SPACING)) {
            return;
        }
        if (map.containsKey(WORD_SPACING)) {
            return;
        }
        if (map.containsKey(KERNING)) {
            return;
        }
    }

    protected void initCSSPropertyIndexes(Element element) {
        CSSEngine cSSEngine = CSSUtilities.getCSSEngine(element);
        this.marginTopIndex = cSSEngine.getPropertyIndex("margin-top");
        this.marginRightIndex = cSSEngine.getPropertyIndex("margin-right");
        this.marginBottomIndex = cSSEngine.getPropertyIndex("margin-bottom");
        this.marginLeftIndex = cSSEngine.getPropertyIndex("margin-left");
        this.indentIndex = cSSEngine.getPropertyIndex("indent");
        this.textAlignIndex = cSSEngine.getPropertyIndex("text-align");
        this.lineHeightIndex = cSSEngine.getPropertyIndex("line-height");
    }

    public BlockInfo makeBlockInfo(BridgeContext bridgeContext, Element element) {
        if (this.marginTopIndex == -1) {
            this.initCSSPropertyIndexes(element);
        }
        Value value = CSSUtilities.getComputedStyle(element, this.marginTopIndex);
        float f2 = value.getFloatValue();
        value = CSSUtilities.getComputedStyle(element, this.marginRightIndex);
        float f3 = value.getFloatValue();
        value = CSSUtilities.getComputedStyle(element, this.marginBottomIndex);
        float f4 = value.getFloatValue();
        value = CSSUtilities.getComputedStyle(element, this.marginLeftIndex);
        float f5 = value.getFloatValue();
        value = CSSUtilities.getComputedStyle(element, this.indentIndex);
        float f6 = value.getFloatValue();
        value = CSSUtilities.getComputedStyle(element, this.textAlignIndex);
        if (value == ValueConstants.INHERIT_VALUE) {
            value = CSSUtilities.getComputedStyle(element, 11);
            value = value == ValueConstants.LTR_VALUE ? SVG12ValueConstants.START_VALUE : SVG12ValueConstants.END_VALUE;
        }
        int n = value == SVG12ValueConstants.START_VALUE ? 0 : (value == SVG12ValueConstants.MIDDLE_VALUE ? 1 : (value == SVG12ValueConstants.END_VALUE ? 2 : 3));
        Map map = this.getFontProperties(bridgeContext, element, null);
        Float f7 = (Float)map.get(TextAttribute.SIZE);
        float f8 = f7.floatValue();
        float f9 = this.getLineHeight(bridgeContext, element, f8);
        List list = this.getFontFamilyList(element, bridgeContext);
        String string = element.getLocalName();
        boolean bl = string.equals("flowRegionBreak");
        return new BlockInfo(f2, f3, f4, f5, f6, n, f9, list, map, bl);
    }

    protected float getLineHeight(BridgeContext bridgeContext, Element element, float f2) {
        Value value;
        if (this.lineHeightIndex == -1) {
            this.initCSSPropertyIndexes(element);
        }
        if ((value = CSSUtilities.getComputedStyle(element, this.lineHeightIndex)) == ValueConstants.INHERIT_VALUE || value == SVG12ValueConstants.NORMAL_VALUE) {
            return f2 * 1.1f;
        }
        float f3 = value.getFloatValue();
        if (value instanceof ComputedValue) {
            value = ((ComputedValue)value).getComputedValue();
        }
        if (value instanceof LineHeightValue && ((LineHeightValue)value).getFontSizeRelative()) {
            f3 *= f2;
        }
        return f3;
    }
}

