/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.awt.font.FontRenderContext;
import java.text.AttributedCharacterIterator;
import java.text.CharacterIterator;
import java.text.StringCharacterIterator;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.CSSUtilities;
import org.apache.batik.bridge.SVGGlyphElementBridge;
import org.apache.batik.bridge.SVGHKernElementBridge;
import org.apache.batik.bridge.SVGKernElementBridge;
import org.apache.batik.bridge.SVGVKernElementBridge;
import org.apache.batik.css.engine.value.Value;
import org.apache.batik.dom.util.XMLSupport;
import org.apache.batik.gvt.font.GVTFont;
import org.apache.batik.gvt.font.GVTFontFace;
import org.apache.batik.gvt.font.GVTGlyphVector;
import org.apache.batik.gvt.font.GVTLineMetrics;
import org.apache.batik.gvt.font.Glyph;
import org.apache.batik.gvt.font.Kern;
import org.apache.batik.gvt.font.KerningTable;
import org.apache.batik.gvt.font.SVGGVTGlyphVector;
import org.apache.batik.gvt.text.GVTAttributedCharacterIterator;
import org.apache.batik.gvt.text.TextPaintInfo;
import org.apache.batik.util.SVGConstants;
import org.w3c.dom.Element;

public final class SVGGVTFont
implements GVTFont,
SVGConstants {
    public static final AttributedCharacterIterator.Attribute PAINT_INFO = GVTAttributedCharacterIterator.TextAttribute.PAINT_INFO;
    private float fontSize;
    private GVTFontFace fontFace;
    private String[] glyphUnicodes;
    private String[] glyphNames;
    private String[] glyphLangs;
    private String[] glyphOrientations;
    private String[] glyphForms;
    private Element[] glyphElements;
    private Element[] hkernElements;
    private Element[] vkernElements;
    private BridgeContext ctx;
    private Element textElement;
    private Element missingGlyphElement;
    private KerningTable hKerningTable;
    private KerningTable vKerningTable;
    private String language;
    private String orientation;
    private float scale;
    private GVTLineMetrics lineMetrics = null;

    public SVGGVTFont(float f2, GVTFontFace gVTFontFace, String[] stringArray, String[] stringArray2, String[] stringArray3, String[] stringArray4, String[] stringArray5, BridgeContext bridgeContext, Element[] elementArray, Element element, Element[] elementArray2, Element[] elementArray3, Element element2) {
        this.fontFace = gVTFontFace;
        this.fontSize = f2;
        this.glyphUnicodes = stringArray;
        this.glyphNames = stringArray2;
        this.glyphLangs = stringArray3;
        this.glyphOrientations = stringArray4;
        this.glyphForms = stringArray5;
        this.ctx = bridgeContext;
        this.glyphElements = elementArray;
        this.missingGlyphElement = element;
        this.hkernElements = elementArray2;
        this.vkernElements = elementArray3;
        this.scale = f2 / gVTFontFace.getUnitsPerEm();
        this.textElement = element2;
        this.language = XMLSupport.getXMLLang(element2);
        Value value = CSSUtilities.getComputedStyle(element2, 59);
        this.orientation = value.getStringValue().startsWith("tb") ? "v" : "h";
        this.createKerningTables();
    }

    private void createKerningTables() {
        Object object;
        Object object2;
        Kern[] kernArray = new Kern[this.hkernElements.length];
        for (int i = 0; i < this.hkernElements.length; ++i) {
            Element element = this.hkernElements[i];
            object2 = (SVGHKernElementBridge)this.ctx.getBridge(element);
            object = ((SVGKernElementBridge)object2).createKern(this.ctx, element, this);
            kernArray[i] = object;
        }
        this.hKerningTable = new KerningTable(kernArray);
        Kern[] kernArray2 = new Kern[this.vkernElements.length];
        for (int i = 0; i < this.vkernElements.length; ++i) {
            Kern kern;
            object2 = this.vkernElements[i];
            object = (SVGVKernElementBridge)this.ctx.getBridge((Element)object2);
            kernArray2[i] = kern = ((SVGKernElementBridge)object).createKern(this.ctx, (Element)object2, this);
        }
        this.vKerningTable = new KerningTable(kernArray2);
    }

    public float getHKern(int n, int n2) {
        if (n < 0 || n >= this.glyphUnicodes.length || n2 < 0 || n2 >= this.glyphUnicodes.length) {
            return 0.0f;
        }
        float f2 = this.hKerningTable.getKerningValue(n, n2, this.glyphUnicodes[n], this.glyphUnicodes[n2]);
        return f2 * this.scale;
    }

    public float getVKern(int n, int n2) {
        if (n < 0 || n >= this.glyphUnicodes.length || n2 < 0 || n2 >= this.glyphUnicodes.length) {
            return 0.0f;
        }
        float f2 = this.vKerningTable.getKerningValue(n, n2, this.glyphUnicodes[n], this.glyphUnicodes[n2]);
        return f2 * this.scale;
    }

    public int[] getGlyphCodesForName(String string) {
        Vector<Integer> vector = new Vector<Integer>();
        for (int i = 0; i < this.glyphNames.length; ++i) {
            if (this.glyphNames[i] == null || !this.glyphNames[i].equals(string)) continue;
            vector.add(new Integer(i));
        }
        int[] nArray = new int[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            nArray[i] = (Integer)vector.elementAt(i);
        }
        return nArray;
    }

    public int[] getGlyphCodesForUnicode(String string) {
        Vector<Integer> vector = new Vector<Integer>();
        for (int i = 0; i < this.glyphUnicodes.length; ++i) {
            if (this.glyphUnicodes[i] == null || !this.glyphUnicodes[i].equals(string)) continue;
            vector.add(new Integer(i));
        }
        int[] nArray = new int[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            nArray[i] = (Integer)vector.elementAt(i);
        }
        return nArray;
    }

    private boolean languageMatches(String string) {
        if (string == null || string.length() == 0) {
            return true;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (!string2.equals(this.language) && (!string2.startsWith(this.language) || string2.length() <= this.language.length() || string2.charAt(this.language.length()) != '-')) continue;
            return true;
        }
        return false;
    }

    private boolean orientationMatches(String string) {
        if (string == null || string.length() == 0) {
            return true;
        }
        return string.equals(this.orientation);
    }

    private boolean formMatches(String string, String string2, AttributedCharacterIterator attributedCharacterIterator, int n) {
        if (attributedCharacterIterator == null || string2 == null || string2.length() == 0) {
            return true;
        }
        char c2 = attributedCharacterIterator.setIndex(n);
        Integer n2 = (Integer)attributedCharacterIterator.getAttribute(GVTAttributedCharacterIterator.TextAttribute.ARABIC_FORM);
        if (n2 == null || n2.equals(GVTAttributedCharacterIterator.TextAttribute.ARABIC_NONE)) {
            return false;
        }
        if (string.length() > 1) {
            boolean bl = true;
            for (int i = 1; i < string.length(); ++i) {
                c2 = attributedCharacterIterator.next();
                if (string.charAt(i) == c2) continue;
                bl = false;
                break;
            }
            attributedCharacterIterator.setIndex(n);
            if (bl) {
                attributedCharacterIterator.setIndex(n + string.length() - 1);
                Integer n3 = (Integer)attributedCharacterIterator.getAttribute(GVTAttributedCharacterIterator.TextAttribute.ARABIC_FORM);
                attributedCharacterIterator.setIndex(n);
                if (n2 != null && n3 != null) {
                    if (n2.equals(GVTAttributedCharacterIterator.TextAttribute.ARABIC_TERMINAL) && n3.equals(GVTAttributedCharacterIterator.TextAttribute.ARABIC_INITIAL)) {
                        return string2.equals("isolated");
                    }
                    if (n2.equals(GVTAttributedCharacterIterator.TextAttribute.ARABIC_TERMINAL)) {
                        return string2.equals("terminal");
                    }
                    if (n2.equals(GVTAttributedCharacterIterator.TextAttribute.ARABIC_MEDIAL) && n3.equals(GVTAttributedCharacterIterator.TextAttribute.ARABIC_MEDIAL)) {
                        return string2.equals("medial");
                    }
                }
            }
        }
        if (n2.equals(GVTAttributedCharacterIterator.TextAttribute.ARABIC_ISOLATED)) {
            return string2.equals("isolated");
        }
        if (n2.equals(GVTAttributedCharacterIterator.TextAttribute.ARABIC_TERMINAL)) {
            return string2.equals("terminal");
        }
        if (n2.equals(GVTAttributedCharacterIterator.TextAttribute.ARABIC_INITIAL)) {
            return string2.equals("initial");
        }
        if (n2.equals(GVTAttributedCharacterIterator.TextAttribute.ARABIC_MEDIAL)) {
            return string2.equals("medial");
        }
        return false;
    }

    public boolean canDisplayGivenName(String string) {
        for (int i = 0; i < this.glyphNames.length; ++i) {
            if (this.glyphNames[i] == null || !this.glyphNames[i].equals(string) || !this.languageMatches(this.glyphLangs[i]) || !this.orientationMatches(this.glyphOrientations[i])) continue;
            return true;
        }
        return false;
    }

    public boolean canDisplay(char c2) {
        for (int i = 0; i < this.glyphUnicodes.length; ++i) {
            if (this.glyphUnicodes[i].indexOf(c2) == -1 || !this.languageMatches(this.glyphLangs[i]) || !this.orientationMatches(this.glyphOrientations[i])) continue;
            return true;
        }
        return false;
    }

    public int canDisplayUpTo(char[] cArray, int n, int n2) {
        StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(new String(cArray));
        return this.canDisplayUpTo(stringCharacterIterator, n, n2);
    }

    public int canDisplayUpTo(CharacterIterator characterIterator, int n, int n2) {
        AttributedCharacterIterator attributedCharacterIterator = null;
        if (characterIterator instanceof AttributedCharacterIterator) {
            attributedCharacterIterator = (AttributedCharacterIterator)characterIterator;
        }
        char c2 = characterIterator.setIndex(n);
        int n3 = n;
        while (c2 != '\uffff' && n3 < n2) {
            boolean bl = false;
            for (int i = 0; i < this.glyphUnicodes.length; ++i) {
                if (this.glyphUnicodes[i].indexOf(c2) != 0 || !this.languageMatches(this.glyphLangs[i]) || !this.orientationMatches(this.glyphOrientations[i]) || !this.formMatches(this.glyphUnicodes[i], this.glyphForms[i], attributedCharacterIterator, n3)) continue;
                if (this.glyphUnicodes[i].length() == 1) {
                    bl = true;
                    break;
                }
                boolean bl2 = true;
                for (int j = 1; j < this.glyphUnicodes[i].length(); ++j) {
                    c2 = characterIterator.next();
                    if (this.glyphUnicodes[i].charAt(j) == c2) continue;
                    bl2 = false;
                    break;
                }
                if (bl2) {
                    bl = true;
                    break;
                }
                c2 = characterIterator.setIndex(n3);
            }
            if (!bl) {
                return n3;
            }
            c2 = characterIterator.next();
            n3 = characterIterator.getIndex();
        }
        return -1;
    }

    public int canDisplayUpTo(String string) {
        StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(string);
        return this.canDisplayUpTo(stringCharacterIterator, 0, string.length());
    }

    public GVTGlyphVector createGlyphVector(FontRenderContext fontRenderContext, char[] cArray) {
        StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(new String(cArray));
        return this.createGlyphVector(fontRenderContext, stringCharacterIterator);
    }

    public GVTGlyphVector createGlyphVector(FontRenderContext fontRenderContext, CharacterIterator characterIterator) {
        int n;
        AttributedCharacterIterator attributedCharacterIterator = null;
        if (characterIterator instanceof AttributedCharacterIterator) {
            attributedCharacterIterator = (AttributedCharacterIterator)characterIterator;
        }
        Vector<Object> vector = new Vector<Object>();
        char c2 = characterIterator.first();
        while (c2 != '\uffff') {
            Object object;
            Object object2;
            n = 0;
            for (int i = 0; i < this.glyphUnicodes.length; ++i) {
                Object object3;
                if (this.glyphUnicodes[i].indexOf(c2) != 0 || !this.languageMatches(this.glyphLangs[i]) || !this.orientationMatches(this.glyphOrientations[i]) || !this.formMatches(this.glyphUnicodes[i], this.glyphForms[i], attributedCharacterIterator, characterIterator.getIndex())) continue;
                if (this.glyphUnicodes[i].length() == 1) {
                    object2 = this.glyphElements[i];
                    object = (SVGGlyphElementBridge)this.ctx.getBridge((Element)object2);
                    TextPaintInfo textPaintInfo = null;
                    if (attributedCharacterIterator != null) {
                        textPaintInfo = (TextPaintInfo)attributedCharacterIterator.getAttribute(PAINT_INFO);
                    }
                    object3 = ((SVGGlyphElementBridge)object).createGlyph(this.ctx, (Element)object2, this.textElement, i, this.fontSize, this.fontFace, textPaintInfo);
                    vector.add(object3);
                    n = 1;
                    break;
                }
                int n2 = characterIterator.getIndex();
                boolean bl = true;
                for (int j = 1; j < this.glyphUnicodes[i].length(); ++j) {
                    c2 = characterIterator.next();
                    if (this.glyphUnicodes[i].charAt(j) == c2) continue;
                    bl = false;
                    break;
                }
                if (bl) {
                    Element element = this.glyphElements[i];
                    object3 = (SVGGlyphElementBridge)this.ctx.getBridge(element);
                    TextPaintInfo textPaintInfo = null;
                    if (attributedCharacterIterator != null) {
                        attributedCharacterIterator.setIndex(characterIterator.getIndex());
                        textPaintInfo = (TextPaintInfo)attributedCharacterIterator.getAttribute(PAINT_INFO);
                    }
                    Glyph glyph = ((SVGGlyphElementBridge)object3).createGlyph(this.ctx, element, this.textElement, i, this.fontSize, this.fontFace, textPaintInfo);
                    vector.add(glyph);
                    n = 1;
                    break;
                }
                c2 = characterIterator.setIndex(n2);
            }
            if (n == 0) {
                SVGGlyphElementBridge sVGGlyphElementBridge = (SVGGlyphElementBridge)this.ctx.getBridge(this.missingGlyphElement);
                object2 = null;
                if (attributedCharacterIterator != null) {
                    attributedCharacterIterator.setIndex(characterIterator.getIndex());
                    object2 = (TextPaintInfo)attributedCharacterIterator.getAttribute(PAINT_INFO);
                }
                object = sVGGlyphElementBridge.createGlyph(this.ctx, this.missingGlyphElement, this.textElement, -1, this.fontSize, this.fontFace, (TextPaintInfo)object2);
                vector.add(object);
            }
            c2 = characterIterator.next();
        }
        n = vector.size();
        Glyph[] glyphArray = new Glyph[n];
        for (int i = 0; i < n; ++i) {
            glyphArray[i] = (Glyph)vector.get(i);
        }
        return new SVGGVTGlyphVector(this, glyphArray, fontRenderContext);
    }

    public GVTGlyphVector createGlyphVector(FontRenderContext fontRenderContext, int[] nArray, CharacterIterator characterIterator) {
        String string = "";
        for (int i = 0; i < nArray.length; ++i) {
            string = string + this.glyphUnicodes[nArray[i]];
        }
        StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(string);
        return this.createGlyphVector(fontRenderContext, stringCharacterIterator);
    }

    public GVTGlyphVector createGlyphVector(FontRenderContext fontRenderContext, String string) {
        StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(string);
        return this.createGlyphVector(fontRenderContext, stringCharacterIterator);
    }

    public GVTFont deriveFont(float f2) {
        return new SVGGVTFont(f2, this.fontFace, this.glyphUnicodes, this.glyphNames, this.glyphLangs, this.glyphOrientations, this.glyphForms, this.ctx, this.glyphElements, this.missingGlyphElement, this.hkernElements, this.vkernElements, this.textElement);
    }

    protected GVTLineMetrics getLineMetrics(int n, int n2) {
        if (this.lineMetrics != null) {
            return this.lineMetrics;
        }
        float f2 = this.fontFace.getUnitsPerEm();
        float f3 = this.fontSize / f2;
        float f4 = this.fontFace.getAscent() * f3;
        float f5 = this.fontFace.getDescent() * f3;
        float[] fArray = new float[]{0.0f, (f4 + f5) / 2.0f - f4, -f4};
        float f6 = this.fontFace.getStrikethroughPosition() * -f3;
        float f7 = this.fontFace.getStrikethroughThickness() * f3;
        float f8 = this.fontFace.getUnderlinePosition() * f3;
        float f9 = this.fontFace.getUnderlineThickness() * f3;
        float f10 = this.fontFace.getOverlinePosition() * -f3;
        float f11 = this.fontFace.getOverlineThickness() * f3;
        this.lineMetrics = new GVTLineMetrics(f4, 0, fArray, f5, f2, f2, n2 - n, f6, f7, f8, f9, f10, f11);
        return this.lineMetrics;
    }

    public GVTLineMetrics getLineMetrics(char[] cArray, int n, int n2, FontRenderContext fontRenderContext) {
        return this.getLineMetrics(n, n2);
    }

    public GVTLineMetrics getLineMetrics(CharacterIterator characterIterator, int n, int n2, FontRenderContext fontRenderContext) {
        return this.getLineMetrics(n, n2);
    }

    public GVTLineMetrics getLineMetrics(String string, FontRenderContext fontRenderContext) {
        StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(string);
        return this.getLineMetrics(stringCharacterIterator, 0, string.length(), fontRenderContext);
    }

    public GVTLineMetrics getLineMetrics(String string, int n, int n2, FontRenderContext fontRenderContext) {
        StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(string);
        return this.getLineMetrics(stringCharacterIterator, n, n2, fontRenderContext);
    }

    public float getSize() {
        return this.fontSize;
    }

    public String toString() {
        return this.fontFace.getFamilyName() + " " + this.fontFace.getFontWeight() + " " + this.fontFace.getFontStyle();
    }
}

