/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import org.apache.batik.bridge.Bridge;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.BridgeException;
import org.apache.batik.bridge.SVGShapeElementBridge;
import org.apache.batik.bridge.UnitProcessor;
import org.apache.batik.gvt.ShapeNode;
import org.apache.batik.gvt.ShapePainter;
import org.apache.batik.parser.UnitProcessor;
import org.w3c.dom.Element;
import org.w3c.dom.events.MutationEvent;

public class SVGEllipseElementBridge
extends SVGShapeElementBridge {
    public String getLocalName() {
        return "ellipse";
    }

    public Bridge getInstance() {
        return new SVGEllipseElementBridge();
    }

    protected void buildShape(BridgeContext bridgeContext, Element element, ShapeNode shapeNode) {
        UnitProcessor.Context context = UnitProcessor.createContext(bridgeContext, element);
        String string = element.getAttributeNS(null, "cx");
        float f2 = 0.0f;
        if (string.length() != 0) {
            f2 = UnitProcessor.svgHorizontalCoordinateToUserSpace(string, "cx", context);
        }
        string = element.getAttributeNS(null, "cy");
        float f3 = 0.0f;
        if (string.length() != 0) {
            f3 = UnitProcessor.svgVerticalCoordinateToUserSpace(string, "cy", context);
        }
        if ((string = element.getAttributeNS(null, "rx")).length() == 0) {
            throw new BridgeException(element, "attribute.missing", new Object[]{"rx", string});
        }
        float f4 = UnitProcessor.svgHorizontalLengthToUserSpace(string, "rx", context);
        string = element.getAttributeNS(null, "ry");
        if (string.length() == 0) {
            throw new BridgeException(element, "attribute.missing", new Object[]{"ry", string});
        }
        float f5 = UnitProcessor.svgVerticalLengthToUserSpace(string, "ry", context);
        shapeNode.setShape(new Ellipse2D.Float(f2 - f4, f3 - f5, f4 * 2.0f, f5 * 2.0f));
    }

    public void handleDOMAttrModifiedEvent(MutationEvent mutationEvent) {
        String string = mutationEvent.getAttrName();
        if (string.equals("cx") || string.equals("cy") || string.equals("rx") || string.equals("ry")) {
            this.buildShape(this.ctx, this.e, (ShapeNode)this.node);
            this.handleGeometryChanged();
        } else {
            super.handleDOMAttrModifiedEvent(mutationEvent);
        }
    }

    protected ShapePainter createShapePainter(BridgeContext bridgeContext, Element element, ShapeNode shapeNode) {
        Rectangle2D rectangle2D = shapeNode.getShape().getBounds2D();
        if (rectangle2D.getWidth() == 0.0 || rectangle2D.getHeight() == 0.0) {
            return null;
        }
        return super.createShapePainter(bridgeContext, element, shapeNode);
    }
}

