/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import java.util.regex.Pattern;
import net.sf.saxon.charcode.UTF16;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.FastStringBuffer;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NameChecker;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.UnfailingIterator;
import net.sf.saxon.sort.StringCollator;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ConversionResult;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.AnyURIValue;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Base64BinaryValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.DateTimeValue;
import net.sf.saxon.value.DateValue;
import net.sf.saxon.value.DayTimeDurationValue;
import net.sf.saxon.value.DecimalValue;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.DurationValue;
import net.sf.saxon.value.FloatValue;
import net.sf.saxon.value.GDayValue;
import net.sf.saxon.value.GMonthDayValue;
import net.sf.saxon.value.GMonthValue;
import net.sf.saxon.value.GYearMonthValue;
import net.sf.saxon.value.GYearValue;
import net.sf.saxon.value.HexBinaryValue;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.TimeValue;
import net.sf.saxon.value.UntypedAtomicValue;
import net.sf.saxon.value.Whitespace;
import net.sf.saxon.value.YearMonthDurationValue;

public class StringValue
extends AtomicValue {
    public static final StringValue EMPTY_STRING = new StringValue("");
    public static final StringValue SINGLE_SPACE = new StringValue(" ");
    public static final StringValue TRUE = new StringValue("true");
    public static final StringValue FALSE = new StringValue("false");
    protected CharSequence value;
    protected int length = -1;

    protected StringValue() {
        this.value = "";
        this.typeLabel = BuiltInAtomicType.STRING;
    }

    public StringValue(CharSequence value) {
        this.value = value == null ? "" : value;
        this.typeLabel = BuiltInAtomicType.STRING;
    }

    public AtomicValue copyAsSubType(AtomicType typeLabel) {
        StringValue v = new StringValue(this.value);
        v.length = this.length;
        v.typeLabel = typeLabel;
        return v;
    }

    public BuiltInAtomicType getPrimitiveType() {
        return BuiltInAtomicType.STRING;
    }

    public static StringValue makeStringValue(CharSequence value) {
        if (value == null || value.length() == 0) {
            return EMPTY_STRING;
        }
        return new StringValue(value);
    }

    public final String getStringValue() {
        this.value = ((Object)this.value).toString();
        return this.value;
    }

    public final CharSequence getStringValueCS() {
        return this.value;
    }

    public final void setStringValueCS(CharSequence value) {
        this.value = value;
    }

    public ConversionResult convertPrimitive(BuiltInAtomicType requiredType, boolean validate, XPathContext context) {
        int req = requiredType.getFingerprint();
        if (req == 513 || req == 632) {
            return this;
        }
        return StringValue.convertStringToBuiltInType(this.value, requiredType, validate ? context.getConfiguration().getNameChecker() : null);
    }

    public static ConversionResult convertStringToBuiltInType(CharSequence value, BuiltInAtomicType requiredType, NameChecker checker) {
        try {
            switch (requiredType.getFingerprint()) {
                case 514: {
                    return BooleanValue.fromString(value);
                }
                case 517: 
                case 635: {
                    return new DoubleValue(value);
                }
                case 532: {
                    return Int64Value.stringToInteger(value);
                }
                case 533: 
                case 534: 
                case 535: 
                case 536: 
                case 537: 
                case 538: 
                case 539: 
                case 540: 
                case 541: 
                case 542: 
                case 543: 
                case 544: {
                    ConversionResult iv = IntegerValue.stringToInteger(value);
                    if (iv instanceof ValidationFailure) {
                        return iv;
                    }
                    IntegerValue nv = (IntegerValue)((IntegerValue)iv).copyAsSubType(requiredType);
                    ValidationFailure err = nv.convertToSubType(requiredType, checker != null);
                    return err == null ? nv : err;
                }
                case 515: {
                    return DecimalValue.makeDecimalValue(value, checker != null);
                }
                case 516: {
                    return new FloatValue(value);
                }
                case 521: {
                    return DateValue.makeDateValue(value);
                }
                case 519: {
                    return DateTimeValue.makeDateTimeValue(value);
                }
                case 520: {
                    return TimeValue.makeTimeValue(value);
                }
                case 523: {
                    return GYearValue.makeGYearValue(value);
                }
                case 522: {
                    return GYearMonthValue.makeGYearMonthValue(value);
                }
                case 526: {
                    return GMonthValue.makeGMonthValue(value);
                }
                case 524: {
                    return GMonthDayValue.makeGMonthDayValue(value);
                }
                case 525: {
                    return GDayValue.makeGDayValue(value);
                }
                case 518: {
                    return DurationValue.makeDuration(value);
                }
                case 633: {
                    return YearMonthDurationValue.makeYearMonthDurationValue(value);
                }
                case 634: {
                    return DayTimeDurationValue.makeDayTimeDurationValue(value);
                }
                case 573: 
                case 631: {
                    return new UntypedAtomicValue(value);
                }
                case 513: 
                case 632: {
                    return StringValue.makeStringValue(value);
                }
                case 553: 
                case 554: 
                case 555: 
                case 556: 
                case 558: 
                case 559: 
                case 560: 
                case 561: 
                case 563: {
                    return StringValue.makeRestrictedString(value, requiredType, checker);
                }
                case 529: {
                    if (AnyURIValue.isValidURI(value)) {
                        return new AnyURIValue(value);
                    }
                    ValidationFailure ve = new ValidationFailure("Invalid URI: " + ((Object)value).toString());
                    ve.setErrorCode("FORG0001");
                    return ve;
                }
                case 527: {
                    return new HexBinaryValue(value);
                }
                case 528: {
                    return new Base64BinaryValue(value);
                }
            }
            ValidationFailure ve = new ValidationFailure("Cannot convert string to type " + Err.wrap(requiredType.getDisplayName()));
            ve.setErrorCode("XPTY0004");
            return ve;
        }
        catch (ValidationException err) {
            ValidationFailure vf = new ValidationFailure(err.getMessage());
            vf.setErrorCode(err.getErrorCodeLocalPart());
            if (vf.getErrorCode() == null) {
                vf.setErrorCode("FORG0001");
            }
            return vf;
        }
        catch (XPathException err) {
            if (err.getErrorCodeLocalPart() == null) {
                err.setErrorCode("FORG0001");
            }
            ValidationFailure ve = new ValidationFailure(err.getMessage());
            if (err.getErrorCodeLocalPart() == null) {
                ve.setErrorCode("FORG0001");
            } else {
                ve.setErrorCode(err.getErrorCodeLocalPart());
            }
            return ve;
        }
    }

    public static ConversionResult convertStringToAtomicType(CharSequence value, AtomicType targetType, NameChecker checker) {
        ConversionResult result;
        if (targetType instanceof BuiltInAtomicType) {
            return StringValue.convertStringToBuiltInType(value, (BuiltInAtomicType)targetType, checker);
        }
        BuiltInAtomicType primitiveType = (BuiltInAtomicType)targetType.getPrimitiveItemType();
        if (primitiveType.getFingerprint() == 513) {
            int whitespaceAction = targetType.getWhitespaceAction(null);
            value = Whitespace.applyWhitespaceNormalization(whitespaceAction, value);
        }
        if ((result = StringValue.convertStringToBuiltInType(value, primitiveType, checker)) instanceof ValidationFailure) {
            return result;
        }
        ValidationFailure vf = targetType.validate((AtomicValue)result, value, checker);
        if (vf != null) {
            return vf;
        }
        return ((AtomicValue)result).copyAsSubType(targetType);
    }

    public int getStringLength() {
        if (this.length == -1) {
            this.length = StringValue.getStringLength(this.value);
        }
        return this.length;
    }

    public static int getStringLength(CharSequence s) {
        int n = 0;
        for (int i = 0; i < s.length(); ++i) {
            char c2 = s.charAt(i);
            if (c2 >= '\ud800' && c2 <= '\udbff') continue;
            ++n;
        }
        return n;
    }

    public boolean isZeroLength() {
        return this.value.length() == 0;
    }

    public boolean containsSurrogatePairs() {
        if (this.length == -1) {
            this.getStringLength();
        }
        return this.length != this.value.length();
    }

    public UnfailingIterator iterateCharacters() {
        return new CharacterIterator();
    }

    public int[] expand() {
        int[] array = new int[this.getStringLength()];
        int o = 0;
        int len = this.value.length();
        for (int i = 0; i < len; ++i) {
            int charval;
            int c2 = this.value.charAt(i);
            if (c2 >= 55296 && c2 <= 56319) {
                charval = (c2 - 55296) * 1024 + (this.value.charAt(i + 1) - 56320) + 65536;
                ++i;
            } else {
                charval = c2;
            }
            array[o++] = charval;
        }
        return array;
    }

    public static int[] expand(CharSequence s) {
        int[] array = new int[StringValue.getStringLength(s)];
        int o = 0;
        for (int i = 0; i < s.length(); ++i) {
            int charval;
            int c2 = s.charAt(i);
            if (c2 >= 55296 && c2 <= 56319) {
                charval = (c2 - 55296) * 1024 + (s.charAt(i + 1) - 56320) + 65536;
                ++i;
            } else {
                charval = c2;
            }
            array[o++] = charval;
        }
        return array;
    }

    public static CharSequence contract(int[] codes, int used) {
        FastStringBuffer sb = new FastStringBuffer(codes.length);
        for (int i = 0; i < used; ++i) {
            if (codes[i] < 65536) {
                sb.append((char)codes[i]);
                continue;
            }
            sb.append(UTF16.highSurrogate(codes[i]));
            sb.append(UTF16.lowSurrogate(codes[i]));
        }
        return sb;
    }

    public Object getXPathComparable(boolean ordered, StringCollator collator, XPathContext context) {
        return collator.getCollationKey(((Object)this.value).toString());
    }

    public boolean equals(Object other) {
        throw new ClassCastException("equals on StringValue is not allowed");
    }

    public boolean codepointEquals(StringValue other) {
        return this.value.length() == other.value.length() && ((Object)this.value).toString().equals(((Object)other.value).toString());
    }

    public boolean effectiveBooleanValue() {
        return this.value.length() > 0;
    }

    public String toString() {
        return "\"" + this.value + '\"';
    }

    public static ConversionResult makeRestrictedString(CharSequence value, BuiltInAtomicType typeLabel, NameChecker checker) {
        StringValue rsv = new StringValue();
        int type = typeLabel.getFingerprint();
        rsv.setTypeLabel(typeLabel);
        if (value == null) {
            rsv.value = "";
        } else if (type == 553) {
            rsv.value = Whitespace.normalizeWhitespace(value);
        } else if (type == 554) {
            rsv.value = Whitespace.collapseWhitespace(value);
        } else {
            rsv.value = Whitespace.trimWhitespace(value);
            if (checker != null) {
                ValidationFailure err = StringValue.validate(typeLabel, rsv.value, checker);
                if (err == null) {
                    return rsv;
                }
                return err;
            }
            return rsv;
        }
        return rsv;
    }

    public static ValidationFailure validate(BuiltInAtomicType typeLabel, CharSequence val, NameChecker checker) {
        switch (typeLabel.getFingerprint()) {
            case 554: {
                return null;
            }
            case 553: {
                return null;
            }
            case 555: {
                String regex = "[a-zA-Z]{1,8}(-[a-zA-Z0-9]{1,8})*";
                if (!Pattern.matches(regex, ((Object)val).toString())) {
                    ValidationFailure err = new ValidationFailure("The value '" + val + "' is not a valid xs:language");
                    err.setErrorCode("FORG0001");
                    return err;
                }
                return null;
            }
            case 558: {
                FastStringBuffer buff = new FastStringBuffer(val.length());
                buff.append(val);
                for (int i = 0; i < buff.length(); ++i) {
                    if (buff.charAt(i) != ':') continue;
                    buff.setCharAt(i, '_');
                }
                if (!checker.isValidNCName(buff)) {
                    ValidationFailure err = new ValidationFailure("The value '" + val + "' is not a valid Name");
                    err.setErrorCode("FORG0001");
                    return err;
                }
                return null;
            }
            case 559: 
            case 560: 
            case 561: 
            case 563: {
                if (!checker.isValidNCName(val)) {
                    ValidationFailure err = new ValidationFailure("The value '" + val + "' is not a valid NCName");
                    err.setErrorCode("FORG0001");
                    return err;
                }
                return null;
            }
            case 556: {
                if (!checker.isValidNmtoken(val)) {
                    ValidationFailure err = new ValidationFailure("The value '" + val + "' is not a valid NMTOKEN");
                    err.setErrorCode("FORG0001");
                    return err;
                }
                return null;
            }
        }
        throw new IllegalArgumentException("Unknown string value type " + typeLabel.getFingerprint());
    }

    public Comparable getSchemaComparable() {
        return ((Object)this.value).toString();
    }

    public static String diagnosticDisplay(String s) {
        FastStringBuffer fsb = new FastStringBuffer(s.length());
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            char c2 = s.charAt(i);
            if (c2 >= ' ' && c2 <= '~') {
                fsb.append(c2);
                continue;
            }
            fsb.append("\\u");
            for (int shift = 12; shift >= 0; shift -= 4) {
                fsb.append("0123456789ABCDEF".charAt(c2 >> shift & 0xF));
            }
        }
        return fsb.toString();
    }

    public final class CharacterIterator
    implements UnfailingIterator {
        int inpos = 0;
        int outpos = 0;
        int current = -1;

        public Item next() {
            if (this.inpos < StringValue.this.value.length()) {
                char c2;
                this.current = (c2 = StringValue.this.value.charAt(this.inpos++)) >= '\ud800' && c2 <= '\udbff' ? (c2 - 55296) * 1024 + (StringValue.this.value.charAt(this.inpos++) - 56320) + 65536 : (int)c2;
                ++this.outpos;
                return new Int64Value(this.current);
            }
            this.outpos = -1;
            return null;
        }

        public Item current() {
            if (this.outpos < 1) {
                return null;
            }
            return new Int64Value(this.current);
        }

        public int position() {
            return this.outpos;
        }

        public void close() {
        }

        public SequenceIterator getAnother() {
            return new CharacterIterator();
        }

        public int getProperties() {
            return 0;
        }
    }
}

