/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import java.math.BigDecimal;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.sort.StringCollator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ConversionResult;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.DecimalValue;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.FloatValue;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.IntegerValue;

public abstract class NumericValue
extends AtomicValue
implements Comparable {
    public static NumericValue parseNumber(String in) {
        if (in.indexOf(101) >= 0 || in.indexOf(69) >= 0) {
            try {
                return new DoubleValue(Double.parseDouble(in));
            }
            catch (NumberFormatException e2) {
                return DoubleValue.NaN;
            }
        }
        if (in.indexOf(46) >= 0) {
            ConversionResult v = DecimalValue.makeDecimalValue(in, true);
            if (v instanceof ValidationFailure) {
                return DoubleValue.NaN;
            }
            return (NumericValue)v;
        }
        ConversionResult v = Int64Value.stringToInteger(in);
        if (v instanceof ValidationFailure) {
            return DoubleValue.NaN;
        }
        return (NumericValue)v;
    }

    public double getDoubleValue() {
        try {
            return ((DoubleValue)this.convertPrimitive(BuiltInAtomicType.DOUBLE, true, null).asAtomic()).getDoubleValue();
        }
        catch (XPathException err) {
            return Double.NaN;
        }
    }

    public float getFloatValue() {
        try {
            return ((FloatValue)this.convertPrimitive(BuiltInAtomicType.FLOAT, true, null).asAtomic()).getFloatValue();
        }
        catch (XPathException err) {
            return Float.NaN;
        }
    }

    public BigDecimal getDecimalValue() throws XPathException {
        return ((DecimalValue)this.convertPrimitive(BuiltInAtomicType.DECIMAL, true, null).asAtomic()).getDecimalValue();
    }

    public static boolean isInteger(AtomicValue value) {
        return value instanceof IntegerValue;
    }

    public long longValue() throws XPathException {
        return ((Int64Value)this.convertPrimitive(BuiltInAtomicType.INTEGER, true, null).asAtomic()).longValue();
    }

    public abstract NumericValue negate();

    public abstract NumericValue floor();

    public abstract NumericValue ceiling();

    public abstract NumericValue round();

    public abstract NumericValue roundHalfToEven(int var1);

    public abstract double signum();

    public abstract boolean isWholeNumber();

    public Object getXPathComparable(boolean ordered, StringCollator collator, XPathContext context) {
        return this;
    }

    public int compareTo(Object other) {
        double b2;
        double a2 = this.getDoubleValue();
        if (a2 == (b2 = ((NumericValue)other).getDoubleValue())) {
            return 0;
        }
        if (a2 < b2) {
            return -1;
        }
        return 1;
    }

    public abstract int compareTo(long var1);

    public final boolean equals(Object other) {
        return this.compareTo(other) == 0;
    }

    public static ItemType promote(ItemType v1, ItemType v2, TypeHierarchy typeHierarchy) {
        ItemType t2;
        ItemType t1 = typeHierarchy.isSubType(v1, BuiltInAtomicType.NUMERIC) ? v1 : BuiltInAtomicType.DOUBLE;
        ItemType itemType = t2 = typeHierarchy.isSubType(v2, BuiltInAtomicType.NUMERIC) ? v2 : BuiltInAtomicType.DOUBLE;
        if (t1 == t2) {
            return t1;
        }
        if (t1.equals(BuiltInAtomicType.DOUBLE) || t2.equals(BuiltInAtomicType.DOUBLE)) {
            return BuiltInAtomicType.DOUBLE;
        }
        if (t1.equals(BuiltInAtomicType.FLOAT) || t2.equals(BuiltInAtomicType.FLOAT)) {
            return BuiltInAtomicType.FLOAT;
        }
        if (t1.equals(BuiltInAtomicType.DECIMAL) || t2.equals(BuiltInAtomicType.DECIMAL)) {
            return BuiltInAtomicType.DECIMAL;
        }
        return BuiltInAtomicType.INTEGER;
    }

    public abstract int hashCode();

    public String toString() {
        return this.getStringValue();
    }
}

