/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import java.util.GregorianCalendar;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.FastStringBuffer;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ConversionResult;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.CalendarValue;
import net.sf.saxon.value.DateTimeValue;
import net.sf.saxon.value.DayTimeDurationValue;
import net.sf.saxon.value.DurationValue;
import net.sf.saxon.value.GDateValue;
import net.sf.saxon.value.GDayValue;
import net.sf.saxon.value.GMonthDayValue;
import net.sf.saxon.value.GMonthValue;
import net.sf.saxon.value.GYearMonthValue;
import net.sf.saxon.value.GYearValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.UntypedAtomicValue;
import net.sf.saxon.value.YearMonthDurationValue;

public class DateValue
extends GDateValue
implements Comparable {
    private DateValue() {
    }

    public DateValue(int year, byte month, byte day) {
        this.year = year;
        this.month = month;
        this.day = day;
        this.typeLabel = BuiltInAtomicType.DATE;
    }

    public DateValue(int year, byte month, byte day, int tz) {
        this.year = year;
        this.month = month;
        this.day = day;
        this.setTimezoneInMinutes(tz);
        this.typeLabel = BuiltInAtomicType.DATE;
    }

    public DateValue(int year, byte month, byte day, int tz, AtomicType type) {
        this.year = year;
        this.month = month;
        this.day = day;
        this.setTimezoneInMinutes(tz);
        this.typeLabel = type;
    }

    public DateValue(CharSequence s) throws ValidationException {
        DateValue.setLexicalValue(this, s).asAtomic();
        this.typeLabel = BuiltInAtomicType.DATE;
    }

    public DateValue(GregorianCalendar calendar, int tz) {
        int era = calendar.get(0);
        this.year = calendar.get(1);
        if (era == 0) {
            this.year = 1 - this.year;
        }
        this.month = (byte)(calendar.get(2) + 1);
        this.day = (byte)calendar.get(5);
        this.setTimezoneInMinutes(tz);
        this.typeLabel = BuiltInAtomicType.DATE;
    }

    public static ConversionResult makeDateValue(CharSequence in) {
        DateValue d2 = new DateValue();
        d2.typeLabel = BuiltInAtomicType.DATE;
        return DateValue.setLexicalValue(d2, in);
    }

    public BuiltInAtomicType getPrimitiveType() {
        return BuiltInAtomicType.DATE;
    }

    public static DateValue tomorrow(int year, byte month, byte day) {
        if (DateValue.isValidDate(year, month, day + 1)) {
            return new DateValue(year, month, (byte)(day + 1));
        }
        if (month < 12) {
            return new DateValue(year, (byte)(month + 1), 1);
        }
        return new DateValue(year + 1, 1, 1);
    }

    public static DateValue yesterday(int year, byte month, byte day) {
        if (day > 1) {
            return new DateValue(year, month, (byte)(day - 1));
        }
        if (month > 1) {
            if (month == 3 && DateValue.isLeapYear(year)) {
                return new DateValue(year, 2, 29);
            }
            return new DateValue(year, (byte)(month - 1), daysPerMonth[month - 2]);
        }
        return new DateValue(year - 1, 12, 31);
    }

    public ConversionResult convertPrimitive(BuiltInAtomicType requiredType, boolean validate, XPathContext context) {
        switch (requiredType.getPrimitiveType()) {
            case 521: 
            case 632: {
                return this;
            }
            case 519: {
                return this.toDateTime();
            }
            case 513: {
                return new StringValue(this.getStringValueCS());
            }
            case 631: {
                return new UntypedAtomicValue(this.getStringValueCS());
            }
            case 523: {
                return new GYearValue(this.year, this.getTimezoneInMinutes());
            }
            case 522: {
                return new GYearMonthValue(this.year, this.month, this.getTimezoneInMinutes());
            }
            case 526: {
                return new GMonthValue(this.month, this.getTimezoneInMinutes());
            }
            case 524: {
                return new GMonthDayValue(this.month, this.day, this.getTimezoneInMinutes());
            }
            case 525: {
                return new GDayValue(this.day, this.getTimezoneInMinutes());
            }
        }
        ValidationFailure err = new ValidationFailure("Cannot convert date to " + requiredType.getDisplayName());
        err.setErrorCode("XPTY0004");
        return err;
    }

    public CharSequence getStringValueCS() {
        FastStringBuffer sb = new FastStringBuffer(16);
        int yr = this.year;
        if (this.year <= 0) {
            sb.append('-');
            yr = -yr + 1;
        }
        DateValue.appendString(sb, yr, yr > 9999 ? (yr + "").length() : 4);
        sb.append('-');
        DateValue.appendTwoDigits(sb, this.month);
        sb.append('-');
        DateValue.appendTwoDigits(sb, this.day);
        if (this.hasTimezone()) {
            this.appendTimezone(sb);
        }
        return sb;
    }

    public CharSequence getCanonicalLexicalRepresentation() {
        DateValue target = this;
        if (this.hasTimezone()) {
            if (this.getTimezoneInMinutes() > 720) {
                target = (DateValue)this.adjustTimezone(this.getTimezoneInMinutes() - 1440);
            } else if (this.getTimezoneInMinutes() <= -720) {
                target = (DateValue)this.adjustTimezone(this.getTimezoneInMinutes() + 1440);
            }
        }
        return target.getStringValueCS();
    }

    public AtomicValue copyAsSubType(AtomicType typeLabel) {
        DateValue v = new DateValue(this.year, this.month, this.day, this.getTimezoneInMinutes());
        v.typeLabel = typeLabel;
        return v;
    }

    public CalendarValue adjustTimezone(int timezone) {
        DateTimeValue dt = (DateTimeValue)this.toDateTime().adjustTimezone(timezone);
        return new DateValue(dt.getYear(), dt.getMonth(), dt.getDay(), dt.getTimezoneInMinutes());
    }

    public CalendarValue add(DurationValue duration) throws XPathException {
        if (duration instanceof DayTimeDurationValue) {
            long microseconds = ((DayTimeDurationValue)duration).getLengthInMicroseconds();
            boolean negative = microseconds < 0L;
            microseconds = Math.abs(microseconds);
            int days = (int)Math.floor((double)microseconds / 8.64E10);
            boolean partDay = microseconds % 86400000000L > 0L;
            int julian = DateValue.getJulianDayNumber(this.year, this.month, this.day);
            DateValue d2 = DateValue.dateFromJulianDayNumber(julian + (negative ? -days : days));
            if (partDay && negative) {
                d2 = DateValue.yesterday(d2.year, d2.month, d2.day);
            }
            d2.setTimezoneInMinutes(this.getTimezoneInMinutes());
            return d2;
        }
        if (duration instanceof YearMonthDurationValue) {
            int months = ((YearMonthDurationValue)duration).getLengthInMonths();
            int m = this.month - 1 + months;
            int y = this.year + m / 12;
            if ((m %= 12) < 0) {
                m += 12;
                --y;
            }
            ++m;
            int d3 = this.day;
            while (!DateValue.isValidDate(y, m, d3)) {
                --d3;
            }
            return new DateValue(y, (byte)m, (byte)d3, this.getTimezoneInMinutes());
        }
        XPathException err = new XPathException("Date arithmetic is not supported on xs:duration, only on its subtypes");
        err.setIsTypeError(true);
        err.setErrorCode("XPTY0004");
        throw err;
    }

    public DayTimeDurationValue subtract(CalendarValue other, XPathContext context) throws XPathException {
        if (!(other instanceof DateValue)) {
            XPathException err = new XPathException("First operand of '-' is a date, but the second is not");
            err.setIsTypeError(true);
            err.setErrorCode("XPTY0004");
            throw err;
        }
        return super.subtract(other, context);
    }

    public int compareTo(Object v2) {
        try {
            return this.compareTo((DateValue)v2, null);
        }
        catch (Exception err) {
            throw new ClassCastException("DateTime comparison requires access to implicit timezone");
        }
    }

    public static int getJulianDayNumber(int year, int month, int day) {
        int z = year - (month < 3 ? 1 : 0);
        short f2 = monthData[month - 1];
        if (z >= 0) {
            return day + f2 + 365 * z + z / 4 - z / 100 + z / 400 + 1721118;
        }
        int j = day + f2 + 365 * (z += 12000) + z / 4 - z / 100 + z / 400 + 1721118;
        return j - 4382910;
    }

    public static DateValue dateFromJulianDayNumber(int julianDayNumber) {
        if (julianDayNumber >= 0) {
            int L = julianDayNumber + 68569 + 1;
            int n = 4 * L / 146097;
            int i = 4000 * ((L -= (146097 * n + 3) / 4) + 1) / 1461001;
            L = L - 1461 * i / 4 + 31;
            int j = 80 * L / 2447;
            int d2 = L - 2447 * j / 80;
            L = j / 11;
            int m = j + 2 - 12 * L;
            int y = 100 * (n - 49) + i + L;
            return new DateValue(y, (byte)m, (byte)d2);
        }
        DateValue dt = DateValue.dateFromJulianDayNumber(julianDayNumber + 4382910);
        dt.year -= 12000;
        return dt;
    }

    public static int getDayWithinYear(int year, int month, int day) {
        int j = DateValue.getJulianDayNumber(year, month, day);
        int k = DateValue.getJulianDayNumber(year, 1, 1);
        return j - k + 1;
    }

    public static int getDayOfWeek(int year, int month, int day) {
        int d2 = DateValue.getJulianDayNumber(year, month, day);
        d2 -= 2378500;
        while (d2 <= 0) {
            d2 += 70000000;
        }
        return (d2 - 1) % 7 + 1;
    }

    public static int getWeekNumber(int year, int month, int day) {
        int d2 = DateValue.getDayWithinYear(year, month, day);
        int firstDay = DateValue.getDayOfWeek(year, 1, 1);
        if (firstDay > 4 && firstDay + d2 <= 8) {
            return DateValue.getWeekNumber(year - 1, 12, 31);
        }
        int inc = firstDay < 5 ? 1 : 0;
        return (d2 + firstDay - 2) / 7 + inc;
    }

    public static int getWeekNumberWithinMonth(int year, int month, int day) {
        int firstDay = DateValue.getDayOfWeek(year, month, 1);
        int inc = firstDay < 5 ? 1 : 0;
        return (day + firstDay - 2) / 7 + inc;
    }
}

