/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import java.net.URI;
import java.net.URISyntaxException;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.EscapeURI;
import net.sf.saxon.sort.LRUCache;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ConversionResult;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.UntypedAtomicValue;
import net.sf.saxon.value.Whitespace;

public final class AnyURIValue
extends StringValue {
    public static final AnyURIValue EMPTY_URI = new AnyURIValue("");
    private static LRUCache cache = new LRUCache(20);

    public AnyURIValue(CharSequence value) {
        this.value = value == null ? "" : ((Object)Whitespace.collapseWhitespace(value)).toString();
        this.typeLabel = BuiltInAtomicType.ANY_URI;
    }

    public AnyURIValue(CharSequence value, AtomicType type) {
        this.value = value == null ? "" : ((Object)Whitespace.collapseWhitespace(value)).toString();
        this.typeLabel = type;
    }

    public AtomicValue copyAsSubType(AtomicType typeLabel) {
        AnyURIValue v = new AnyURIValue(this.value);
        v.length = this.length;
        v.typeLabel = typeLabel;
        return v;
    }

    public static boolean isValidURI(CharSequence value) {
        if (cache.get(value) != null) {
            return true;
        }
        String sv = Whitespace.trim(value);
        if (sv.length() == 0) {
            return true;
        }
        try {
            new URI(sv);
            cache.put(value, value);
            return true;
        }
        catch (URISyntaxException e2) {
            sv = ((Object)EscapeURI.iriToUri(sv)).toString();
            try {
                new URI(sv);
                cache.put(value, value);
                return true;
            }
            catch (URISyntaxException e3) {
                return false;
            }
        }
    }

    public BuiltInAtomicType getPrimitiveType() {
        return BuiltInAtomicType.ANY_URI;
    }

    public ConversionResult convertPrimitive(BuiltInAtomicType requiredType, boolean validate, XPathContext context) {
        int req = requiredType.getPrimitiveType();
        switch (req) {
            case 529: 
            case 632: {
                return this;
            }
            case 631: {
                return new UntypedAtomicValue(this.value);
            }
            case 513: {
                return new StringValue(this.value);
            }
            case 553: 
            case 554: 
            case 555: 
            case 556: 
            case 558: 
            case 559: 
            case 560: 
            case 561: 
            case 563: {
                return AnyURIValue.makeRestrictedString(this.value, requiredType, validate ? context.getConfiguration().getNameChecker() : null);
            }
        }
        ValidationFailure err = new ValidationFailure("Cannot convert anyURI to " + requiredType.getDisplayName());
        err.setErrorCode("XPTY0004");
        return err;
    }
}

